/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.client.PolicyEvaluator;
import com.sun.identity.policy.client.PropertiesEnum;
import com.sun.identity.security.DecodeAction;
import java.net.URL;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

class PolicyProperties {
    Set responseAttrs = Collections.EMPTY_SET;
    String namingService = null;
    String appUserName = null;
    String appPassword = null;
    String logName = null;
    String resComparatorClassName = null;
    String trueValue = null;
    String falseValue = null;
    String notificationURL = null;
    int cacheSize = 0;
    int pollInterval = 0;
    boolean useWildcard = false;
    boolean isNotifEnabled = false;
    Map resourceConfig = new HashMap(3);
    static PropertiesEnum policyLoggingStat = PropertiesEnum.NONE;
    static Debug debug = PolicyEvaluator.debug;
    private static String DEFAULT_ALLOW_VALUE = "allow";
    private static String DEFAULT_DENY_VALUE = "deny";
    private static final int DEFAULT_POLL_INTERVAL = 3;

    PolicyProperties() throws PolicyException {
        this.logName = SystemProperties.get((String)"com.sun.identity.agents.server.log.file.name");
        if (this.logName == null || this.logName.length() == 0) {
            throw new PolicyException("amPolicy", "no.log.filename", null, null);
        }
        String string = SystemProperties.get((String)"com.sun.identity.agents.use.wildcard");
        if (string == null || string.length() == 0) {
            throw new PolicyException("amPolicy", "no.use.wild.card", null, null);
        }
        this.useWildcard = string.equalsIgnoreCase("true");
        this.trueValue = SystemProperties.get((String)"com.sun.identity.agents.true.value", (String)DEFAULT_ALLOW_VALUE);
        this.falseValue = DEFAULT_DENY_VALUE;
        this.getCacheSize();
        this.getPollingInterval();
        this.getResponseAttributes();
        this.getNamingServiceURLs();
        this.getAppUserInfo();
        this.getResourceConfigMap();
        this.getNotificationProp();
        this.getLoggingStatus();
    }

    private void getNotificationProp() throws PolicyException {
        String string = SystemProperties.get((String)"com.sun.identity.agents.notification.enabled");
        if (string == null || string.length() == 0) {
            string = "false";
        }
        this.isNotifEnabled = string.equalsIgnoreCase("true");
        if (this.isNotifEnabled) {
            this.notificationURL = SystemProperties.get((String)"com.sun.identity.agents.notification.url");
            if (this.notificationURL == null || this.notificationURL.length() == 0) {
                throw new PolicyException("amPolicy", "invalid.notificationurl", null, null);
            }
        }
    }

    private void getCacheSize() throws PolicyException {
        String string = SystemProperties.get((String)"com.sun.identity.agents.cache.size");
        if (string == null || string.length() == 0) {
            throw new PolicyException("amPolicy", "invalid.cache", null, null);
        }
        try {
            this.cacheSize = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PolicyException(numberFormatException);
        }
    }

    private void getPollingInterval() throws PolicyException {
        String string = SystemProperties.get((String)"com.sun.identity.agents.polling.interval");
        if (string == null || string.length() == 0) {
            throw new PolicyException("amPolicy", "invalid.polling.interval", null, null);
        }
        try {
            this.pollInterval = Integer.parseInt(string);
            if (this.pollInterval <= 0) {
                if (debug.warningEnabled()) {
                    debug.warning("PolicyProperties.getPollingInterval() - invalid/low value of " + this.pollInterval + " minutes " + "specified for polling interval. Defaulting to " + 3 + " minutes.");
                }
                this.pollInterval = 3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PolicyException(numberFormatException);
        }
    }

    private void getLoggingStatus() throws PolicyException {
        String string = SystemProperties.get((String)"com.sun.identity.agents.logging.level");
        if (string == null || string.length() == 0) {
            throw new PolicyException("amPolicy", "no.policy.logging.level", null, null);
        }
        if (string != null) {
            policyLoggingStat = string.equalsIgnoreCase("ALLOW") ? PropertiesEnum.ALLOW : (string.equalsIgnoreCase("DENY") ? PropertiesEnum.DENY : (string.equalsIgnoreCase("BOTH") ? PropertiesEnum.BOTH : (string.equalsIgnoreCase("NONE") ? PropertiesEnum.NONE : PropertiesEnum.NONE)));
        }
    }

    private void getResponseAttributes() {
        String string = SystemProperties.get((String)"com.sun.identity.agents.header.attributes");
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            this.responseAttrs = new HashSet(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                this.responseAttrs.add(stringTokenizer.nextToken());
            }
        }
    }

    private void getNamingServiceURLs() throws PolicyException {
        this.namingService = SystemProperties.get((String)"com.iplanet.am.naming.url");
        if (this.namingService == null || this.namingService.length() == 0) {
            throw new PolicyException("amPolicy", "no.naming.urls", null, null);
        }
    }

    private void getAppUserInfo() throws PolicyException {
        this.appUserName = SystemProperties.get((String)"com.sun.identity.agents.app.username");
        String string = SystemProperties.get((String)"com.iplanet.am.service.secret");
        this.appPassword = (String)AccessController.doPrivileged(new DecodeAction(string));
        if (this.appUserName == null || this.appUserName.length() == 0) {
            throw new PolicyException("amPolicy", "no.app.user.name", null, null);
        }
        if (this.appPassword == null || this.appPassword.length() == 0) {
            throw new PolicyException("amPolicy", "no.app.password", null, null);
        }
    }

    private void getResourceConfigMap() throws PolicyException {
        this.resComparatorClassName = SystemProperties.get((String)"com.sun.identity.agents.resource.comparator.class");
        if (this.resComparatorClassName == null || this.resComparatorClassName.length() == 0) {
            throw new PolicyException("amPolicy", "no.resource.comparator.class", null, null);
        }
        String string = SystemProperties.get((String)"com.sun.identity.agents.resource.delimiter");
        if (string == null || string.length() == 0) {
            throw new PolicyException("amPolicy", "no.resource.delimiter", null, null);
        }
        String string2 = SystemProperties.get((String)"com.sun.identity.agents.resource.wildcard");
        if (string2 == null || string2.length() == 0) {
            throw new PolicyException("amPolicy", "no.resource.wildcard", null, null);
        }
        String string3 = SystemProperties.get((String)"com.sun.identity.agents.resource.caseSensitive");
        if (string3 == null || string3.length() == 0) {
            throw new PolicyException("amPolicy", "no.resource.case.sensitive.flag", null, null);
        }
        this.resourceConfig.put("delimiter", string);
        this.resourceConfig.put("wildcard", string2);
        this.resourceConfig.put("caseSensitive", string3);
    }

    URL getServiceURL(String string) {
        URL uRL;
        block4: {
            uRL = null;
            int n = this.namingService.indexOf("://");
            if (n == -1) break block4;
            String string2 = this.namingService.substring(0, n);
            int n2 = this.namingService.indexOf(58, n + 3);
            if (n2 != -1) {
                String string3 = this.namingService.substring(n + 3, n2);
                n = this.namingService.indexOf(47, n2);
                if (n != -1) {
                    String string4 = this.namingService.substring(n2 + 1, n);
                    try {
                        uRL = WebtopNaming.getServiceURL((String)string, (String)string2, (String)string3, (String)string4);
                    }
                    catch (URLNotFoundException uRLNotFoundException) {
                        debug.error("PolicyProperties.getServiceURL", (Throwable)uRLNotFoundException);
                    }
                }
            }
        }
        return uRL;
    }

    public static PropertiesEnum getPolicyLogging() {
        return policyLoggingStat;
    }

    String getTrueValue() {
        return this.trueValue;
    }

    String getFalseValue() {
        return this.falseValue;
    }
}

