/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.iplanet.am.util.Debug;
import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.share.Notification;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.client.PolicyEvaluator;
import com.sun.identity.policy.client.ResourceResultCache;
import com.sun.identity.policy.remote.PolicyNotification;
import com.sun.identity.policy.remote.PolicyService;
import java.util.Vector;

public class PolicyNotificationHandler
implements NotificationHandler {
    static Debug debug = PolicyEvaluator.debug;

    public void process(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Notification notification = (Notification)vector.elementAt(n);
            if (debug.messageEnabled()) {
                debug.message("PolicyNotificationHandler: got notification : " + notification.getContent());
            }
            try {
                PolicyService policyService = PolicyService.parseXML(notification.getContent());
                PolicyNotification policyNotification = policyService.getPolicyNotification();
                if (policyNotification != null) {
                    this.processNotification(policyNotification);
                }
            }
            catch (PolicyException policyException) {
                debug.error("PolicyNotificationHandler: invalid notifcation format", (Throwable)policyException);
            }
            ++n;
        }
    }

    public void processNotification(PolicyNotification policyNotification) {
        try {
            ResourceResultCache.processNotification(policyNotification);
        }
        catch (Exception exception) {
            debug.error("Error while handling policy notification", (Throwable)exception);
        }
    }
}

