/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.sun.identity.policy.client.ResourceResultCache;
import com.sun.identity.policy.client.SSOEntry;
import com.sun.identity.policy.interfaces.ResourceName;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

class HybridHashtable {
    protected static final int DEFAULT_SIZE_HASHTABLE = 100;
    private List listEntries = null;
    private ResourceResultCache cache = null;

    HybridHashtable(ResourceResultCache resourceResultCache, int n) {
        this.cache = resourceResultCache;
        this.listEntries = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            this.listEntries.add(new Hashtable(100));
            ++n2;
        }
    }

    Object addEntry(int n, String string, Object object) {
        n = Math.abs(n % this.size());
        Hashtable hashtable = (Hashtable)this.listEntries.get(n);
        return hashtable.put(string, object);
    }

    Object getEntry(int n, String string) {
        n = Math.abs(n % this.size());
        Hashtable hashtable = (Hashtable)this.listEntries.get(n);
        return hashtable.get(string);
    }

    Object removeEntry(int n, String string) {
        n = Math.abs(n % this.size());
        Hashtable hashtable = (Hashtable)this.listEntries.get(n);
        return hashtable.remove(string);
    }

    int size() {
        return this.listEntries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markStale(ResourceName resourceName, String string, boolean bl) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            Hashtable hashtable = (Hashtable)this.listEntries.get(n2);
            if (hashtable != null) {
                Hashtable hashtable2 = hashtable;
                synchronized (hashtable2) {
                    Iterator iterator = hashtable.keySet().iterator();
                    while (iterator.hasNext()) {
                        Object v = hashtable.get(iterator.next());
                        if (v == null) continue;
                        this.cache.markResultAsStale(v, resourceName, string, bl);
                    }
                }
            }
            ++n2;
        }
    }

    protected Iterator iterator() {
        return this.listEntries.iterator();
    }

    void printHybridTable() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            Hashtable hashtable = (Hashtable)this.listEntries.get(n2);
            if (hashtable != null) {
                Iterator iterator = hashtable.keySet().iterator();
                while (iterator.hasNext()) {
                    SSOEntry sSOEntry = (SSOEntry)hashtable.get(iterator.next());
                    if (sSOEntry == null) continue;
                    sSOEntry.printSSOEntry();
                }
            }
            ++n2;
        }
    }
}

