/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class Rule
implements Cloneable {
    public static final String EMPTY_RESOURCE_NAME = "";
    private String ruleName;
    private String serviceTypeName;
    private ServiceType serviceType;
    String resourceName = "";
    private Map actions;

    protected Rule() {
    }

    public Rule(String string, String string2, Map map) throws NameNotFoundException, InvalidNameException {
        this(null, string, string2, map);
    }

    public Rule(String string, Map map) throws NameNotFoundException, InvalidNameException {
        this(null, string, null, map);
    }

    public Rule(String string, String string2, String string3, Map map) throws NameNotFoundException, InvalidNameException {
        String string4 = this.ruleName = string != null ? string : "rule" + ServiceTypeManager.generateRandomName();
        if (string3 == null || string3 == EMPTY_RESOURCE_NAME) {
            string3 = EMPTY_RESOURCE_NAME;
        }
        this.resourceName = string3.trim();
        this.checkAndSetServiceType(string2);
        this.serviceTypeName = string2;
        this.serviceType.validateActionValues(map);
        this.actions = new HashMap(map);
        try {
            this.resourceName = this.serviceType.canonicalize(string3);
        }
        catch (PolicyException policyException) {
            throw new InvalidNameException(policyException, string3, 2);
        }
    }

    protected Rule(Node node) throws InvalidFormatException, InvalidNameException, NameNotFoundException {
        Node node2;
        if (!node.getNodeName().equalsIgnoreCase("Rule")) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid rule xml blob given to constructor");
            }
            throw new InvalidFormatException("amPolicy", "invalid_xml_rule_node", null, EMPTY_RESOURCE_NAME, 2);
        }
        this.ruleName = XMLUtils.getNodeAttributeValue((Node)node, (String)"name");
        if (this.ruleName == null) {
            this.ruleName = "rule" + ServiceTypeManager.generateRandomName();
        }
        if ((node2 = XMLUtils.getChildNode((Node)node, (String)"ServiceName")) == null || (this.serviceTypeName = XMLUtils.getNodeAttributeValue((Node)node2, (String)"name")) == null) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid service name in rule xml blob in constructor");
            }
            Object[] objectArray = new String[]{this.serviceTypeName == null ? "null" : this.serviceTypeName};
            throw new InvalidFormatException("amPolicy", "invalid_xml_rule_service_name", objectArray, this.ruleName, 2);
        }
        this.checkAndSetServiceType(this.serviceTypeName);
        Node node3 = XMLUtils.getChildNode((Node)node, (String)"ResourceName");
        if (node3 != null && (this.resourceName = XMLUtils.getNodeAttributeValue((Node)node3, (String)"name")) == null) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid resource name in rule xml blob in constructor");
            }
            Object[] objectArray = new String[]{this.resourceName == null ? "null" : this.resourceName};
            throw new InvalidFormatException("amPolicy", "invalid_xml_rule_resource_name", objectArray, this.ruleName, 2);
        }
        if (this.resourceName != null) {
            this.resourceName = this.resourceName.trim();
            try {
                this.resourceName = this.serviceType.canonicalize(this.resourceName);
            }
            catch (PolicyException policyException) {
                throw new InvalidNameException(policyException, this.resourceName, 2);
            }
        }
        Set set = XMLUtils.getChildNodes((Node)node, (String)"AttributeValuePair");
        this.actions = new HashMap();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = null;
                Set set2 = null;
                Node node4 = (Node)iterator.next();
                Node node5 = XMLUtils.getChildNode((Node)node4, (String)"Attribute");
                if (node5 == null || (string = XMLUtils.getNodeAttributeValue((Node)node5, (String)"name")) == null || (set2 = XMLUtils.getAttributeValuePair((Node)node4)) == null) {
                    Object[] objectArray = new String[]{string == null ? "null" : string};
                    throw new InvalidFormatException("amPolicy", "invalid_xml_rule_action_name", objectArray, this.ruleName, 2);
                }
                this.actions.put(string, set2);
            }
            this.serviceType.validateActionValues(this.actions);
        }
    }

    private void checkAndSetServiceType(String string) throws NameNotFoundException {
        ServiceTypeManager serviceTypeManager = null;
        try {
            serviceTypeManager = ServiceTypeManager.getServiceTypeManager();
            this.serviceType = serviceTypeManager.getServiceType(string);
        }
        catch (SSOException sSOException) {
            PolicyManager.debug.error("Unable to get admin SSO token" + (Object)((Object)sSOException));
            throw new NameNotFoundException(sSOException, string, 3);
        }
    }

    public String getName() {
        return this.ruleName;
    }

    public void setName(String string) throws InvalidNameException {
        this.ruleName = string != null ? string : "rule" + ServiceTypeManager.generateRandomName();
    }

    public String getServiceTypeName() {
        return this.serviceTypeName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Set getActionNames() {
        return new HashSet(this.actions.keySet());
    }

    public Set getActionValues(String string) throws NameNotFoundException {
        Set set = (Set)this.actions.get(string);
        if (set != null) {
            set = (Set)((HashSet)set).clone();
        }
        return set;
    }

    public Map getActionValues() {
        return new HashMap(this.actions);
    }

    public void setActionValues(Map map) throws InvalidNameException {
        this.serviceType.validateActionValues(map);
        this.actions = new HashMap(map);
    }

    public boolean equals(Object object) {
        if (object instanceof Rule) {
            Rule rule = (Rule)object;
            if (this.isResourceMatch(rule.serviceTypeName, rule.resourceName).equals(ResourceMatch.EXACT_MATCH)) {
                return this.actions.equals(rule.actions);
            }
        }
        return false;
    }

    public ResourceMatch isResourceMatch(String string, String string2) {
        ResourceMatch resourceMatch = null;
        resourceMatch = !string.equalsIgnoreCase(this.serviceTypeName) ? ResourceMatch.NO_MATCH : this.serviceType.compare(string2, this.resourceName);
        return resourceMatch;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("\n").append("<Rule");
        if (this.ruleName != null) {
            stringBuffer.append(" name=\"");
            stringBuffer.append(XMLUtils.escapeSpecialCharacters((String)this.ruleName));
            stringBuffer.append("\">");
        } else {
            stringBuffer.append(">");
        }
        stringBuffer.append("\n").append("<ServiceName name=\"");
        stringBuffer.append(XMLUtils.escapeSpecialCharacters((String)this.serviceTypeName));
        stringBuffer.append("\" />");
        if (this.resourceName != null) {
            stringBuffer.append("\n").append("<ResourceName name=\"");
            stringBuffer.append(XMLUtils.escapeSpecialCharacters((String)this.resourceName));
            stringBuffer.append("\" />");
        }
        Iterator iterator = this.actions.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("\n").append("<AttributeValuePair>");
            stringBuffer.append("\n").append("<Attribute name=\"");
            stringBuffer.append(XMLUtils.escapeSpecialCharacters((String)string));
            stringBuffer.append("\" />");
            Set set = (Set)this.actions.get(string);
            if (set.size() > 0) {
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    stringBuffer.append("\n").append("<Value>");
                    stringBuffer.append(XMLUtils.escapeSpecialCharacters((String)((String)iterator2.next())));
                    stringBuffer.append("</Value>");
                }
            }
            stringBuffer.append("\n").append("</AttributeValuePair>");
        }
        stringBuffer.append("\n").append("</Rule>");
        return stringBuffer.toString();
    }

    protected ServiceType getServiceType() {
        return this.serviceType;
    }

    protected String toResourcesXml(String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<").append("PolicyCrossReferences").append(" ").append("name").append("=\"").append(this.serviceTypeName).append("\" ").append("type").append("=\"").append("Resources").append("\">");
        String string2 = this.resourceName;
        if (this.resourceName == null || this.resourceName.equals(EMPTY_RESOURCE_NAME)) {
            string2 = "---EMPTY---";
        }
        String[] stringArray = this.serviceType.split(string2);
        int n = stringArray.length;
        StringBuffer stringBuffer2 = new StringBuffer(100);
        stringBuffer2.append("<").append("Reference").append(" ").append("name").append("=\"").append(stringArray[n - 1]).append("\"><").append("PolicyName").append(" ").append("name").append("=\"").append(string).append("\"/></").append("Reference").append(">");
        String string3 = stringBuffer2.toString();
        int n2 = n - 2;
        while (n2 >= 0) {
            string3 = "<Reference name=\"" + stringArray[n2] + "\">" + string3 + "</" + "Reference" + ">";
            --n2;
        }
        return stringBuffer + string3 + "</" + "PolicyCrossReferences" + ">";
    }

    public String toString() {
        return this.toXML();
    }

    public Object clone() {
        Rule rule = null;
        try {
            rule = (Rule)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            rule = new Rule();
        }
        rule.ruleName = this.ruleName;
        rule.serviceTypeName = this.serviceTypeName;
        rule.serviceType = this.serviceType;
        rule.resourceName = this.resourceName;
        rule.actions = new HashMap();
        Iterator iterator = this.actions.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Set set = (Set)this.actions.get(k);
            HashSet hashSet = new HashSet();
            hashSet.addAll(set);
            rule.actions.put(k, hashSet);
        }
        return rule;
    }

    Map getActionValues(String string, String string2, Set set) throws NameNotFoundException {
        ResourceMatch resourceMatch;
        HashMap<String, Set> hashMap = null;
        String string3 = this.getServiceTypeName();
        if (string3.equals(string) && set != null && (ResourceMatch.EXACT_MATCH.equals(resourceMatch = this.isResourceMatch(string, string2)) || ResourceMatch.WILDCARD_MATCH.equals(resourceMatch))) {
            hashMap = new HashMap<String, Set>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                Set set2 = this.getActionValues(string4);
                if (set2 == null) continue;
                hashMap.put(string4, set2);
            }
        }
        return hashMap;
    }
}

