/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyEvaluatorFactory;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ResBundleUtils;
import com.sun.identity.sm.ServiceManager;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;
import netscape.ldap.util.DN;

public class ProxyPolicyEvaluator {
    private static final String TOP_LEVEL_ADMIN_ROLE = "cn=Top-level Admin Role,";
    private static final String TOP_LEVEL_POLICY_ADMIN_ROLE = "cn=Top-level Policy Admin Role,";
    private static final String ORG_ADMIN_ROLE = "cn=Organization Admin Role,";
    private static final String ORG_POLICY_ADMIN_ROLE = "cn=Organization Policy Admin Role,";
    private SSOToken adminToken;
    private AMUser adminUser;
    private String serviceType;
    private PolicyEvaluator policyEvaluator;
    private static String baseDNString = ServiceManager.getBaseDN();
    private static DN baseDN = new DN(baseDNString);

    ProxyPolicyEvaluator(SSOToken sSOToken, String string) throws NoPermissionException, NameNotFoundException, PolicyException, SSOException {
        SSOTokenManager.getInstance().validateToken(sSOToken);
        this.adminToken = sSOToken;
        this.serviceType = string;
        AMStoreConnection aMStoreConnection = new AMStoreConnection(this.adminToken);
        this.adminUser = aMStoreConnection.getUser(this.adminToken.getPrincipal().getName());
        this.policyEvaluator = PolicyEvaluatorFactory.getInstance().getPolicyEvaluator(sSOToken, string);
    }

    public boolean isAllowed(String string, String string2, String string3, Map map) throws PolicyException, SSOException {
        SSOToken sSOToken = this.getProxyToken(string);
        boolean bl = this.policyEvaluator.isAllowed(sSOToken, string2, string3, map);
        return bl;
    }

    public PolicyDecision getPolicyDecision(String string, String string2, Map map) throws PolicyException, SSOException {
        String string3;
        SSOToken sSOToken = this.getProxyToken(string);
        PolicyDecision policyDecision = this.policyEvaluator.getPolicyDecision(sSOToken, string2, null, map);
        if (PolicyUtils.logStatus && (string3 = policyDecision.toString()) != null && !string3.equals("")) {
            String[] stringArray = new String[]{this.adminToken.getPrincipal().getName(), string, string2, string3};
            PolicyUtils.logAccessMessage(Level.INFO, ResBundleUtils.getString("proxied_policy_evaluation"), this.adminToken);
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message(" Admin: " + this.adminToken.getPrincipal().getName() + " got policy decision " + " for principal: " + sSOToken.getPrincipal().getName() + " for resourceName:" + string2 + " for serviceType :" + this.serviceType + " is " + policyDecision);
        }
        return policyDecision;
    }

    public PolicyDecision getPolicyDecisionIgnoreSubjects(String string, Set set, Map map) throws PolicyException, SSOException {
        String string2;
        PolicyDecision policyDecision = this.policyEvaluator.getPolicyDecisionIgnoreSubjects(string, set, map);
        if (PolicyUtils.logStatus && (string2 = policyDecision.toString()) != null && !string2.equals("")) {
            String[] stringArray = new String[]{this.adminToken.getPrincipal().getName(), string, string2};
            PolicyUtils.logAccessMessage(Level.INFO, ResBundleUtils.getString("proxied_policy_evaluation_ignoring_subjects"), this.adminToken);
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message(" Admin: " + this.adminToken.getPrincipal().getName() + " got policy decision " + " ignoring subjects " + " for resourceName:" + string + " for serviceType :" + this.serviceType + " is " + policyDecision);
        }
        return policyDecision;
    }

    public Set getProtectedResourcesIgnoreConditions(String string, String string2) throws PolicyException, SSOException {
        SSOToken sSOToken = this.getProxyToken(string);
        return this.policyEvaluator.getProtectedResourcesIgnoreConditions(sSOToken, string2);
    }

    private SSOToken getProxyToken(String string) throws PolicyException, SSOException {
        Object object;
        SSOTokenManager.getInstance().validateToken(this.adminToken);
        SSOToken sSOToken = null;
        boolean bl = false;
        try {
            object = AuthUtils.getAuthContext(baseDNString);
            ((AuthContextLocal)object).login(AuthContext.IndexType.USER, string, true);
            sSOToken = ((AuthContextLocal)object).getSSOToken();
        }
        catch (AuthException authException) {
            throw new PolicyException((Throwable)((Object)authException));
        }
        catch (LoginException loginException) {
            throw new PolicyException(loginException);
        }
        if (sSOToken == null) {
            throw new SSOException((Throwable)new PolicyException("amPolicy", "can_not_get_proxy_sso_token", null, null));
        }
        try {
            object = new AMStoreConnection(this.adminToken);
            AMUser aMUser = ((AMStoreConnection)object).getUser(sSOToken.getPrincipal().getName());
            String string2 = aMUser.getOrganizationDN();
            DN dN = new DN(string2);
            Set set = this.adminUser.getRoleDNs();
            String string3 = null;
            DN dN2 = null;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                if (string4.startsWith(TOP_LEVEL_ADMIN_ROLE)) {
                    string3 = string4.substring(TOP_LEVEL_ADMIN_ROLE.length());
                    dN2 = new DN(string3);
                    if (!dN2.equals(baseDN)) continue;
                    bl = true;
                    break;
                }
                if (string4.startsWith(TOP_LEVEL_POLICY_ADMIN_ROLE)) {
                    string3 = string4.substring(TOP_LEVEL_POLICY_ADMIN_ROLE.length());
                    dN2 = new DN(string3);
                    if (!dN2.equals(baseDN)) continue;
                    bl = true;
                    break;
                }
                if (string4.startsWith(ORG_ADMIN_ROLE)) {
                    string3 = string4.substring(ORG_ADMIN_ROLE.length());
                    dN2 = new DN(string3);
                    if (!dN.equals(dN2) && !dN.isDescendantOf(dN2)) continue;
                    bl = true;
                    break;
                }
                if (!string4.startsWith(ORG_POLICY_ADMIN_ROLE) || !dN.equals(dN2 = new DN(string3 = string4.substring(ORG_POLICY_ADMIN_ROLE.length()))) && !dN.isDescendantOf(dN2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                SSOTokenManager.getInstance().destroyToken(sSOToken);
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("Admin : " + this.adminToken.getPrincipal().getName() + " can not create proxy sso token for user " + string);
                }
                throw new PolicyException("amPolicy", "no_permission_to_create_proxy_sso_token", null, null);
            }
        }
        catch (AMException aMException) {
            throw new PolicyException(aMException);
        }
        return sSOToken;
    }
}

