/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.log.Logger;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.Rule;
import com.sun.identity.saml.common.SAMLUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;
import org.w3c.dom.Node;

public class PolicyUtils {
    public static boolean logStatus = false;
    public static final String EMPTY_STRING = "";
    public static final String NULL_STRING = "null";
    static Logger accessLogger;
    static Logger errorLogger;
    static final String ENV_PARAMETERS = "EnvParameters";
    static final String GET_RESPONSE_DECISIONS = "GetResponseDecisions";
    static final String ATTRIBUTE_VALUE_PAIR = "AttributeValuePair";
    static final String ATTRIBUTE = "Attribute";
    static final String ATTRIBUTE_NAME = "name";
    static final String VALUE = "Value";
    static final String CRLF = "\r\n";

    static Map addMapToMap(Map map, Map map2) {
        if (map != null && map2 != null) {
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set2 = (Set)map.get(string);
                PolicyUtils.addElementToMap(string, set2, map2);
            }
        }
        return map2;
    }

    static Map appendMapToMap(Map map, Map map2) {
        if (map != null && map2 != null) {
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set2 = (Set)map.get(string);
                PolicyUtils.appendElementToMap(string, set2, map2);
            }
        }
        return map2;
    }

    static Map addElementToMap(String string, Set set, Map map) {
        if (string != null && map != null) {
            map.put(string, set);
        }
        return map;
    }

    static Map appendElementToMap(String string, Set set, Map map) {
        if (string != null && set != null && !set.isEmpty() && map != null) {
            Set set2 = (Set)map.get(string);
            if (set2 != null && !set2.isEmpty()) {
                set2.addAll(set);
            } else {
                map.put(string, set);
            }
        }
        return map;
    }

    public static String getDisplayName(String string) {
        String[] stringArray = LDAPDN.explodeDN(string, true);
        return stringArray.length > 0 ? stringArray[0] : EMPTY_STRING;
    }

    static PolicyDecision appendPolicyDecisionToPolicyDecision(PolicyDecision policyDecision, PolicyDecision policyDecision2) throws PolicyException {
        Map map = policyDecision.getActionDecisions();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ActionDecision actionDecision = (ActionDecision)map.get(string);
            policyDecision2.addActionDecision(actionDecision);
        }
        return policyDecision2;
    }

    public static Map parseEnvParameters(Node node) throws PolicyException {
        Node node2 = null;
        Set set = XMLUtils.getChildNodes((Node)node, (String)ATTRIBUTE_VALUE_PAIR);
        if (set == null) {
            PolicyManager.debug.error("parseEnvParameters: missing element AttributeValuePair");
            Object[] objectArray = new String[]{ATTRIBUTE_VALUE_PAIR};
            throw new PolicyException("amPolicy", "missing_element", objectArray, null);
        }
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray;
            node2 = (Node)iterator.next();
            String string = PolicyUtils.getAttributeName(node2);
            if (string == null) {
                PolicyManager.debug.error("PolicyUtils.parseEnvParameters(): missing attribute name");
                objectArray = new String[]{ATTRIBUTE_NAME};
                throw new PolicyException("amPolicy", "missing_attribute", objectArray, null);
            }
            objectArray = PolicyUtils.getAttributeValues(node2);
            if (objectArray == null) {
                PolicyManager.debug.error("PolicyUtils.parseEnvParameters(): missing attribute value");
                Object[] objectArray2 = new String[]{VALUE};
                throw new PolicyException("amPolicy", "missing_attribute", objectArray2, null);
            }
            hashMap.put(string, objectArray);
        }
        return hashMap;
    }

    public static Set parseResponseAttributes(Node node) throws PolicyException {
        Set set = XMLUtils.getChildNodes((Node)node, (String)ATTRIBUTE);
        if (set == null) {
            PolicyManager.debug.error("parseResponseAttributes: missing element Attribute");
            Object[] objectArray = new String[]{ATTRIBUTE};
            throw new PolicyException("amPolicy", "missing_element", objectArray, null);
        }
        HashSet<String> hashSet = new HashSet<String>();
        Node node2 = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            String string = XMLUtils.getNodeAttributeValue((Node)node2, (String)ATTRIBUTE_NAME);
            if (string == null) {
                PolicyManager.debug.error("parseResponseAttributes: missing attribute name");
                Object[] objectArray = new String[]{ATTRIBUTE_NAME};
                throw new PolicyException("amPolicy", "missing_attribute", objectArray, null);
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    public static Map parseResponseDecisions(Node node) {
        Node node2 = null;
        Set set = XMLUtils.getChildNodes((Node)node, (String)ATTRIBUTE_VALUE_PAIR);
        if (set == null) {
            PolicyManager.debug.error("parseResponseDecisions: missing element AttributeValuePair");
            return null;
        }
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            String string = PolicyUtils.getAttributeName(node2);
            if (string == null) {
                PolicyManager.debug.error("PolicyUtils.parseResponseDecisions():missing attribute name");
                return null;
            }
            Set set2 = PolicyUtils.getAttributeValues(node2);
            if (set2 == null) {
                PolicyManager.debug.error("PolicyUtils.parseResponseDecisions():missing attribute value");
                return null;
            }
            hashMap.put(string, set2);
        }
        return hashMap;
    }

    public static String getAttributeName(Node node) {
        Node node2 = XMLUtils.getChildNode((Node)node, (String)ATTRIBUTE);
        if (node2 == null) {
            PolicyManager.debug.error("PolicyUtils.getAttributeName(): missing element Attribute");
            return null;
        }
        String string = XMLUtils.getNodeAttributeValue((Node)node2, (String)ATTRIBUTE_NAME);
        if (string == null) {
            PolicyManager.debug.error("PolicyUtils.getAttributeName(): missing attribute name for element Attribute");
            return null;
        }
        return string;
    }

    public static Set getAttributeValues(Node node) {
        Set set = XMLUtils.getChildNodes((Node)node, (String)VALUE);
        if (set == null) {
            PolicyManager.debug.error("PolicyUtils.getAttributeValues() : missing element Value");
            return null;
        }
        Iterator iterator = set.iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            String string = XMLUtils.getValueOfValueNode((Node)node2);
            if (string != null) {
                hashSet.add(string);
                continue;
            }
            hashSet.add(EMPTY_STRING);
        }
        return hashSet;
    }

    public static String envParametersToXMLString(Map map) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<EnvParameters>\r\n");
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set2 = (Set)map.get(string);
            stringBuffer.append(PolicyUtils.attributeValuePairToXMLString(string, set2));
        }
        stringBuffer.append("</EnvParameters>\r\n");
        return stringBuffer.toString();
    }

    public static String responseAttributesToXMLString(Set set) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<GetResponseDecisions>\r\n");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("<Attribute name=\"" + XMLUtils.escapeSpecialCharacters((String)string) + "\"/>" + CRLF);
        }
        stringBuffer.append("</GetResponseDecisions>\r\n");
        return stringBuffer.toString();
    }

    public static String mapToXMLString(Map map) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set2 = (Set)map.get(string);
            stringBuffer.append(PolicyUtils.attributeValuePairToXMLString(string, set2));
        }
        return stringBuffer.toString();
    }

    public static String attributeValuePairToXMLString(String string, Set set) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<AttributeValuePair>\r\n");
        stringBuffer.append("<Attribute name=\"" + XMLUtils.escapeSpecialCharacters((String)string) + "\"/>" + CRLF);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                stringBuffer.append("<Value>");
                stringBuffer.append(XMLUtils.escapeSpecialCharacters((String)string2));
                stringBuffer.append("</Value>\r\n");
            }
        }
        stringBuffer.append("</AttributeValuePair>\r\n");
        return stringBuffer.toString();
    }

    public static String quote(String string) {
        if (string == null) {
            string = EMPTY_STRING;
        }
        return "\"" + string + "\"";
    }

    public static String quote(int n) {
        return PolicyUtils.quote(Integer.toString(n));
    }

    public static String quote(long l) {
        return PolicyUtils.quote(Long.toString(l));
    }

    public static void logAccessMessage(Level level, String string, SSOToken sSOToken) {
        if (accessLogger == null && (accessLogger = (Logger)Logger.getLogger((String)"amPolicy.access")) == null) {
            return;
        }
        com.sun.identity.log.LogRecord logRecord = new com.sun.identity.log.LogRecord(level, string, (Object)sSOToken);
        accessLogger.log((LogRecord)logRecord, (Object)sSOToken);
    }

    public static void logErrorMessage(Level level, String string, SSOToken sSOToken) {
        if (errorLogger == null && (errorLogger = (Logger)Logger.getLogger((String)"amPolicy.error")) == null) {
            return;
        }
        com.sun.identity.log.LogRecord logRecord = new com.sun.identity.log.LogRecord(level, string, (Object)sSOToken);
        errorLogger.log((LogRecord)logRecord, (Object)sSOToken);
    }

    public static Date stringToDate(String string) throws ParseException {
        return SAMLUtils.stringToDate(string);
    }

    public static String getISDSHostName() {
        try {
            DSConfigMgr dSConfigMgr = DSConfigMgr.getDSConfigMgr();
            return dSConfigMgr.getHostName("default");
        }
        catch (LDAPServiceException lDAPServiceException) {
            PolicyManager.debug.error("Unable to get LDAP server host from DSConfigMgr: ", (Throwable)lDAPServiceException);
            return null;
        }
    }

    public static boolean isLocalDS(String string) throws PolicyException {
        if (string == null) {
            throw new PolicyException("amPolicy", "invalid_ldap_server_host", null, null);
        }
        return string.equalsIgnoreCase(PolicyConfig.ISDS_HOST);
    }

    public static String constructUserFilter(SSOToken sSOToken, String string, String string2, boolean bl) throws SSOException {
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl && (string3 = sSOToken.getProperty("Principals")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string4;
                DN dN;
                String[] stringArray;
                String string5 = stringTokenizer.nextToken();
                if (!DN.isDN(string5) || (stringArray = (dN = new DN(string5)).explodeDN(true)) == null || stringArray.length < 1 || (string4 = stringArray[0]).equalsIgnoreCase(string2)) continue;
                stringBuffer.append("(").append(string).append("=").append(string4).append(")");
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("(").append(string).append("=").append(string2).append(")");
        } else {
            stringBuffer.insert(0, "(|");
            stringBuffer.append("(").append(string).append("=").append(string2).append("))");
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("PolicyUtils.constructUserFilter(): filter: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public static void removePolicyRules(SSOToken sSOToken, String string) throws SSOException, AMException {
        try {
            Object object;
            Rule rule;
            Rule rule2;
            String string2;
            Iterator iterator;
            Policy policy;
            String string3;
            Object object2;
            String string4;
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            PolicyManager policyManager = new PolicyManager(sSOToken);
            String string5 = policyManager.getOrganizationDN();
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(string5);
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            DN dN = new DN(SystemProperties.get((String)"com.iplanet.am.rootsuffix"));
            HashMap hashMap3 = new HashMap();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("iPlanetAMPolicyConfigService");
            hashMap3.put("sunRegisteredServiceName", hashSet);
            Set set = null;
            set = aMOrganization.searchSubOrganizations("*", hashMap3, 2);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                string4 = (String)iterator2.next();
                object2 = new PolicyManager(sSOToken, string4);
                Set set2 = ((PolicyManager)object2).getPolicyNames();
                Iterator iterator3 = set2.iterator();
                while (iterator3.hasNext()) {
                    string3 = (String)iterator3.next();
                    policy = ((PolicyManager)object2).getPolicy(string3);
                    if (!policy.isReferralPolicy()) {
                        iterator = policy.getRuleNames().iterator();
                        while (iterator.hasNext()) {
                            string2 = (String)iterator.next();
                            rule2 = policy.getRule(string2);
                            if (!rule2.getServiceTypeName().equalsIgnoreCase(string)) continue;
                            if (PolicyManager.debug.messageEnabled()) {
                                PolicyManager.debug.message("PolicyUtils.removePolicyRules():policy: " + string3 + ",rule: " + string2);
                            }
                            if ((rule = policy.removeRule(string2)) == null) continue;
                            ((PolicyManager)object2).replacePolicy(policy);
                        }
                        continue;
                    }
                    if (hashMap.containsKey(string4)) {
                        ((Vector)hashMap.get(string4)).add(string3);
                    } else {
                        object = new Vector<String>();
                        ((Vector)object).add(string3);
                        hashMap.put(string4, object);
                    }
                    DN dN2 = new DN(string4);
                    object = String.valueOf(dN.countRDNs() - dN2.countRDNs());
                    if (hashMap2.containsKey(object)) {
                        ((Vector)hashMap2.get(object)).add(string4);
                        continue;
                    }
                    Vector<String> vector = new Vector<String>();
                    vector.add(string4);
                    hashMap2.put(object, vector);
                }
            }
            TreeMap treeMap = new TreeMap(hashMap2);
            Iterator iterator4 = treeMap.keySet().iterator();
            while (iterator4.hasNext()) {
                object2 = (String)iterator4.next();
                object = (Vector<String>)treeMap.get(object2);
                int n = 0;
                while (n < ((Vector)object).size()) {
                    string4 = (String)((Vector)object).get(n);
                    PolicyManager policyManager2 = new PolicyManager(sSOToken, string4);
                    Vector vector = (Vector)hashMap.get(string4);
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        string3 = (String)vector.get(n2);
                        policy = policyManager2.getPolicy(string3);
                        iterator = policy.getRuleNames().iterator();
                        while (iterator.hasNext()) {
                            string2 = (String)iterator.next();
                            rule2 = policy.getRule(string2);
                            if (!rule2.getServiceTypeName().equalsIgnoreCase(string)) continue;
                            if (PolicyManager.debug.messageEnabled()) {
                                PolicyManager.debug.message("PolicyUtils.removePolicyRules():referral policy: " + string3 + ",rule: " + string2);
                            }
                            if ((rule = policy.removeRule(string2)) == null) continue;
                            policyManager2.replacePolicy(policy);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        catch (PolicyException policyException) {
            PolicyManager.debug.error("PolicyUtils.removePolicyRules():", (Throwable)policyException);
        }
    }

    static {
        String string = SystemProperties.get((String)"com.iplanet.am.logstatus");
        if (string == null) {
            string = "INACTIVE";
        }
        if (string.equalsIgnoreCase("ACTIVE")) {
            logStatus = true;
        }
        accessLogger = null;
        errorLogger = null;
    }
}

