/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class ActionDecision {
    static final String ACTION_DECISION = "ActionDecision";
    static final String ADVICES = "Advices";
    static final String VALUES = "Values";
    static final String TIME_TO_LIVE = "timeToLive";
    private String actionName;
    private Set values;
    private long timeToLive = Long.MAX_VALUE;
    private Map advices;

    public ActionDecision() {
    }

    public ActionDecision(String string, Set set) {
        this.actionName = string;
        this.values = set;
    }

    public ActionDecision(String string, Set set, Map map, long l) {
        this.actionName = string;
        this.values = set;
        this.advices = map;
        this.timeToLive = l;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setValues(Set set) {
        this.values = set;
    }

    public Set getValues() {
        return this.values;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long l) {
        this.timeToLive = l;
    }

    public void setAdvices(Map map) {
        this.advices = map;
    }

    public Map getAdvices() {
        return this.advices;
    }

    public String toString() {
        return this.actionName + "=" + this.values;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<").append(ACTION_DECISION).append(" ");
        stringBuffer.append(TIME_TO_LIVE).append("=").append(PolicyUtils.quote(this.timeToLive) + ">");
        stringBuffer.append("\r\n");
        stringBuffer.append(PolicyUtils.attributeValuePairToXMLString(this.getActionName(), this.values));
        stringBuffer.append("<").append(ADVICES).append(">").append("\r\n");
        if (this.advices != null) {
            stringBuffer.append(PolicyUtils.mapToXMLString(this.advices));
        }
        stringBuffer.append("</").append(ADVICES).append(">").append("\r\n");
        stringBuffer.append("</").append(ACTION_DECISION).append(">").append("\r\n");
        return stringBuffer.toString();
    }

    public static ActionDecision parseActionDecision(Node node) throws PolicyException {
        ActionDecision actionDecision = null;
        Set set = XMLUtils.getChildNodes((Node)node, (String)"AttributeValuePair");
        if (set == null || set.isEmpty()) {
            PolicyManager.debug.error("parseActionDecision: missing element AttributeValuePair");
            return null;
        }
        Iterator iterator = set.iterator();
        Node node2 = (Node)iterator.next();
        String string = PolicyUtils.getAttributeName(node2);
        Set set2 = PolicyUtils.getAttributeValues(node2);
        actionDecision = new ActionDecision(string, set2);
        long l = Long.MAX_VALUE;
        String string2 = XMLUtils.getNodeAttributeValue((Node)node, (String)TIME_TO_LIVE);
        if (string2 != null) {
            try {
                l = Long.parseLong(string2);
            }
            catch (Exception exception) {
                PolicyManager.debug.error("Error while parsing timeToLive in  ActionDecision:" + string2);
                Object[] objectArray = new Object[]{new Long(l)};
                throw new PolicyException("amPolicy", "invalid_time_to_live", objectArray, exception);
            }
        }
        actionDecision.setTimeToLive(l);
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        set = XMLUtils.getChildNodes((Node)node, (String)ADVICES);
        if (set != null && (set = XMLUtils.getChildNodes((Node)(node2 = (Node)(iterator = set.iterator()).next()), (String)"AttributeValuePair")) != null) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                node2 = (Node)iterator.next();
                String string3 = PolicyUtils.getAttributeName(node2);
                if (string3 == null) continue;
                Set set3 = PolicyUtils.getAttributeValues(node2);
                hashMap.put(string3, set3);
            }
        }
        actionDecision.setAdvices(hashMap);
        return actionDecision;
    }

    public Object clone() {
        Iterator<Object> iterator;
        ActionDecision actionDecision = new ActionDecision();
        actionDecision.actionName = this.actionName;
        actionDecision.timeToLive = this.timeToLive;
        if (this.values != null) {
            iterator = this.values.iterator();
            actionDecision.values = new HashSet(this.values.size());
            while (iterator.hasNext()) {
                actionDecision.values.add(iterator.next());
            }
        }
        if (this.advices != null) {
            iterator = this.advices.keySet().iterator();
            actionDecision.advices = new HashMap(this.advices.size());
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                actionDecision.advices.put(string, this.advices.get(string));
            }
        }
        return actionDecision;
    }
}

