/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.Cache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.liberty.ws.soapbinding.WebServiceAuthenticator;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

class WebServiceAuthenticatorImpl
implements WebServiceAuthenticator {
    private static final String PRINCIPAL_PROP = "Principal";
    private static final String PRINCIPALS_PROP = "Principals";
    private static final String AUTH_TYPE_PROP = "AuthType";
    private static final String AUTH_INSTANT_PROP = "authInstant";
    private static final String ANONYMOUS_PRINCIPAL = "anonymous";
    private static final String SESSION_SERVICE_NAME = "iPlanetAMSessionService";
    private static final String MAX_SESSION_TIME = "iplanet-am-session-max-session-time";
    private static final String IDLE_TIME = "iplanet-am-session-max-idle-time";
    private static final String CACHE_TIME = "iplanet-am-session-max-caching-time";
    private static final int DEFAULT_MAX_SESSION_TIME = 120;
    private static final int DEFAULT_IDLE_TIME = 30;
    private static final int DEFAULT_CACHE_TIME = 3;
    private static Cache ssoTokenCache = new Cache(1000);
    private static SSOTokenManager ssoTokenManager = null;
    private static ServiceSchema sessionSchema = null;
    private static String rootSuffix = SystemProperties.get((String)"com.iplanet.am.rootsuffix");

    WebServiceAuthenticatorImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object authenticate(Message message, HttpServletRequest httpServletRequest) {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        X509Certificate x509Certificate;
        ArrayList<X509Certificate> arrayList = null;
        X509Certificate x509Certificate2 = message.getPeerCertificate();
        if (x509Certificate2 != null) {
            arrayList = new ArrayList<X509Certificate>(2);
            arrayList.add(x509Certificate2);
        }
        if ((x509Certificate = message.getMessageCertificate()) != null) {
            if (arrayList == null) {
                arrayList = new ArrayList(1);
            }
            arrayList.add(x509Certificate);
        }
        String string2 = null;
        StringBuffer stringBuffer = null;
        if (arrayList == null) {
            string2 = ANONYMOUS_PRINCIPAL;
        } else {
            object4 = new HashSet(6);
            object3 = arrayList.iterator();
            while (object3.hasNext()) {
                object2 = (X509Certificate)object3.next();
                if (Utils.debug.messageEnabled()) {
                    Utils.debug.message("WebServiceAuthenticatorImpl.authenticate: cert = " + object2);
                }
                string = ((X509Certificate)object2).getSubjectDN().getName();
                if (string2 == null) {
                    string2 = string;
                } else if (!string2.equals(string)) {
                    object4.add(string);
                }
                object = ((X509Certificate)object2).getIssuerDN().getName();
                object4.add(object);
            }
            stringBuffer = new StringBuffer(50);
            object2 = object4.iterator();
            while (object2.hasNext()) {
                string = (String)object2.next();
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(string);
                    continue;
                }
                stringBuffer.append("|").append(string);
            }
        }
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("WebServiceAuthenticatorImpl.authenticate: principal = " + string2 + ", principals = " + stringBuffer);
        }
        object4 = message.getAuthenticationMechanism();
        object3 = (String)object4 + " " + string2;
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("WebServiceAuthenticatorImpl.authenticate: cacheKey = " + (String)object3);
        }
        object2 = null;
        object2 = (SSOToken)ssoTokenCache.get(object3);
        if (object2 != null) {
            if (ssoTokenManager.isValidToken((SSOToken)object2)) {
                if (Utils.debug.messageEnabled()) {
                    Utils.debug.message("WebServiceAuthenticatorImpl.authenticate: found ssoToken in cache");
                }
                return object2;
            }
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("WebServiceAuthenticatorImpl.authenticate: ssoToken in cache expired");
            }
            string = ssoTokenCache;
            synchronized (string) {
                ssoTokenCache.remove(object3);
            }
            object2 = null;
        }
        try {
            string = SessionService.getSessionService().newInternalSession(null, null);
            string.activate("");
            object = sessionSchema.getAttributeDefaults();
            string.setMaxSessionTime((long)Misc.getIntMapAttr((Map)object, (String)MAX_SESSION_TIME, (int)120, (Debug)Utils.debug));
            string.setMaxIdleTime((long)Misc.getIntMapAttr((Map)object, (String)IDLE_TIME, (int)30, (Debug)Utils.debug));
            string.setMaxCachingTime((long)Misc.getIntMapAttr((Map)object, (String)CACHE_TIME, (int)3, (Debug)Utils.debug));
            object2 = SSOTokenManager.getInstance().createSSOToken(string.getID().toString());
        }
        catch (Exception exception) {
            Utils.debug.error("WebServiceAuthenticatorImpl.authenticate: Unable to get SSOToken", (Throwable)exception);
        }
        if (object2 == null) {
            return null;
        }
        try {
            block29: {
                object2.setProperty(PRINCIPAL_PROP, string2);
                if (stringBuffer != null) {
                    object2.setProperty(PRINCIPALS_PROP, stringBuffer.toString());
                }
                ssoTokenCache.put(object3, object2);
                string = "";
                try {
                    string = SAMLUtils.dateToString(new Date());
                }
                catch (ParseException parseException) {
                    if (!Utils.debug.warningEnabled()) break block29;
                    Utils.debug.warning("WebServiceAuthenticatorImpl.authenticate: Unable to get authInstant", (Throwable)parseException);
                }
            }
            object2.setProperty(AUTH_TYPE_PROP, message.getAuthenticationMechanism());
            object2.setProperty(AUTH_INSTANT_PROP, string);
        }
        catch (Exception exception) {
            Utils.debug.error("WebServiceAuthenticatorImpl.authenticate: Unable to set SSOToken property", (Throwable)exception);
            return null;
        }
        return object2;
    }

    static {
        try {
            ssoTokenManager = SSOTokenManager.getInstance();
        }
        catch (Exception exception) {
            Utils.debug.error("WebServiceAuthenticatorImpl.static: unable to get SSOTokenManager", (Throwable)exception);
        }
        try {
            SSOToken sSOToken = ssoTokenManager.createSSOToken((Principal)new AuthPrincipal(AdminUtils.getAdminDN()), new String(AdminUtils.getAdminPassword()));
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(SESSION_SERVICE_NAME, sSOToken);
            sessionSchema = serviceSchemaManager.getDynamicSchema();
        }
        catch (Exception exception) {
            Utils.debug.error("WebServiceAuthenticatorImpl.static: unable to get session schema", (Throwable)exception);
        }
    }
}

