/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.liberty.ws.soapbinding.WebServiceAuthenticator;
import com.sun.identity.liberty.ws.soapbinding.WebServiceAuthenticatorImpl;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SOAPBindingService
implements ServiceListener {
    static final String SERVICE_NAME = "sunIdentityServerSOAPBinding";
    static final String REQUEST_HANDLER_LIST_ATTR = "RequestHandlerList";
    static final String WEB_SERVICE_AUTHENTICATOR_ATTR = "WebServiceAuthenticator";
    static final String SUPPORTED_AUTHENTICATION_MECHANISMS_ATTR = "SupportedAuthenticationMechanisms";
    private static ServiceSchema serviceSchema = null;
    static HashMap supportedSOAPActionsMap = new HashMap();
    static HashMap handlers = new HashMap();
    static WebServiceAuthenticator wsAuthenticator = null;
    static Set supportedAuthMechs = null;
    static FSAllianceManager fsAllianceManager = null;

    private SOAPBindingService() {
    }

    static WebServiceAuthenticator getWebServiceAuthenticator() {
        return wsAuthenticator;
    }

    static Set getSupportedAuthenticationMechanisms() {
        return supportedAuthMechs;
    }

    public void schemaChanged(String string, String string2) {
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("Utils.schemaChanged");
        }
        SOAPBindingService.setValues();
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("Utils.globalConfigChanged");
        }
        SOAPBindingService.setValues();
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("Utils.organizationConfigChanged");
        }
        SOAPBindingService.setValues();
    }

    private static void setValues() {
        String string;
        Map map = serviceSchema.getAttributeDefaults();
        supportedSOAPActionsMap.clear();
        handlers.clear();
        Set set = (Set)map.get(REQUEST_HANDLER_LIST_ATTR);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            string = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (((String)object).startsWith("key=")) {
                    string2 = ((String)object).substring(4);
                    continue;
                }
                if (((String)object).startsWith("class=")) {
                    string3 = ((String)object).substring(6);
                    continue;
                }
                if (!((String)object).startsWith("soapActions=")) continue;
                string4 = ((String)object).substring(12);
            }
            if (string2 != null && string3 != null) {
                try {
                    handlers.put(string2, Class.forName(string3).newInstance());
                    if (string4 == null) continue;
                    object = new StringTokenizer(string4);
                    ArrayList<String> arrayList = null;
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                        }
                        arrayList.add(((StringTokenizer)object).nextToken());
                    }
                    if (arrayList == null) continue;
                    supportedSOAPActionsMap.put(string2, arrayList);
                }
                catch (Throwable throwable) {
                    Utils.debug.error("Utils.setValues class = " + string3, throwable);
                }
                continue;
            }
            if (!Utils.debug.warningEnabled()) continue;
            Utils.debug.warning("Utils.setValues: Invalid syntax for Request Handler List: " + string);
        }
        set = (Set)map.get(WEB_SERVICE_AUTHENTICATOR_ATTR);
        if (set.isEmpty()) {
            wsAuthenticator = new WebServiceAuthenticatorImpl();
        } else {
            string = (String)set.iterator().next();
            try {
                wsAuthenticator = (WebServiceAuthenticator)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                if (Utils.debug.warningEnabled()) {
                    Utils.debug.warning("Utils.setValues: Unable to instantiate WebServiceAuthenticator", (Throwable)exception);
                }
                wsAuthenticator = new WebServiceAuthenticatorImpl();
            }
        }
        supportedAuthMechs = (Set)map.get(SUPPORTED_AUTHENTICATION_MECHANISMS_ATTR);
    }

    static {
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = AdminUtils.getAdminDN();
            String string2 = new String(AdminUtils.getAdminPassword());
            SSOToken sSOToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(SERVICE_NAME, sSOToken);
            serviceSchema = serviceSchemaManager.getGlobalSchema();
            SOAPBindingService.setValues();
            serviceSchemaManager.addListener(new SOAPBindingService());
            fsAllianceManager = new FSAllianceManager(sSOToken);
        }
        catch (SSOException sSOException) {
            Utils.debug.error("SOAPBindingService.static: Unable to get sso token", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            Utils.debug.error("SOAPBindingService.static: Unable to access service schema", (Throwable)sMSException);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            Utils.debug.error("SOAPBindingService.static: Unable to create FSAllinaceManager", (Throwable)((Object)fSAllianceManagementException));
        }
    }
}

