/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtils;
import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConsentHeader {
    private String uri = null;
    private Date timestamp = null;
    private String id = null;
    private Boolean mustUnderstand = null;
    private String actor = null;

    public ConsentHeader(String string) {
        this.uri = string;
    }

    ConsentHeader(Element element) throws SOAPBindingException {
        this.uri = XMLUtils.getNodeAttributeValue((Node)element, (String)"uri");
        this.id = XMLUtils.getNodeAttributeValue((Node)element, (String)"id");
        String string = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"mustUnderstand");
        if (string != null && string.length() > 0) {
            try {
                this.mustUnderstand = Utils.StringToBoolean(string);
            }
            catch (Exception exception) {
                String string2 = Utils.bundle.getString("invalidMustUnderstand");
                Utils.debug.error("ConsentHeader: " + string2, (Throwable)exception);
                throw new SOAPBindingException(string2);
            }
        }
        if ((string = XMLUtils.getNodeAttributeValue((Node)element, (String)"timestamp")) != null && string.length() > 0) {
            try {
                this.timestamp = SAMLUtils.stringToDate(string);
            }
            catch (ParseException parseException) {
                String string3 = Utils.bundle.getString("invalidTimestamp");
                Utils.debug.error("ConsentHeader: " + string3, (Throwable)parseException);
                throw new SOAPBindingException(string3);
            }
        }
        this.actor = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"actor");
    }

    public String getUri() {
        return this.uri;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getMustUnderstand() {
        return this.mustUnderstand;
    }

    public String getActor() {
        return this.actor;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public void setMustUnderstand(Boolean bl) {
        this.mustUnderstand = bl;
    }

    public void setActor(String string) {
        this.actor = string;
    }

    public void setSignFlag(boolean bl) {
        this.id = bl ? SAMLUtils.generateID() : null;
    }

    void addToParent(Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("urn:liberty:sb:2003-08", "sb:Consent");
        element.appendChild(element2);
        element2.setAttributeNS(null, "uri", this.uri);
        if (this.timestamp != null) {
            try {
                element2.setAttributeNS(null, "timestamp", SAMLUtils.dateToString(this.timestamp));
            }
            catch (ParseException parseException) {
                Utils.debug.error("Unable to convert timestamp to String", (Throwable)parseException);
            }
        }
        if (this.id != null) {
            element2.setAttributeNS(null, "id", this.id);
        }
        if (this.mustUnderstand != null) {
            element2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:mustUnderstand", this.mustUnderstand.toString());
        }
        if (this.actor != null) {
            element2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:actor", this.actor);
        }
    }
}

