/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.liberty.ws.security.SecurityUtils;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.liberty.ws.soapbinding.WSX509KeyManager;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import com.sun.net.ssl.HttpsURLConnection;
import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509KeyManager;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.Security;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class Client {
    private static SOAPConnectionFactory scf;
    private static TransformerFactory tfactory;
    private static KeyManager[] kms;
    private static TrustManager[] tms;
    private static X509KeyManager defaultX509km;
    private static String defaultCertAlias;

    public static Message sendRequest(Message message, String string) throws SOAPBindingException, SOAPFaultException {
        return Client.sendRequest(message, string, null, null);
    }

    public static Message sendRequest(Message message, String string, String string2) throws SOAPBindingException, SOAPFaultException {
        return Client.sendRequest(message, string, string2, null);
    }

    public static Message sendRequest(Message message, String string, String string2, String string3) throws SOAPBindingException, SOAPFaultException {
        Object object;
        Object object2;
        URLConnection uRLConnection = null;
        try {
            uRLConnection = Client.getConnection(string, string2);
        }
        catch (Exception exception) {
            Utils.debug.error("Client:sendRequest", (Throwable)exception);
            throw new SOAPBindingException(exception.getMessage());
        }
        if (string3 != null) {
            uRLConnection.setRequestProperty("SOAPAction", string3);
        }
        Document document = null;
        int n = message.getSecurityProfileType();
        if (n == 0) {
            document = message.toDocument(true);
        } else {
            object2 = SecurityUtils.signMessage(message);
            if (object2 == null) {
                String string4 = Utils.bundle.getString("cannotSignRequest");
                Utils.debug.error("Client.sendRequest: " + string4);
                throw new SOAPBindingException(string4);
            }
            document = object2.getOwnerDocument();
        }
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("Client.sendRequest: signed request\n" + message);
        }
        object2 = null;
        try {
            object2 = uRLConnection.getOutputStream();
            object = tfactory.newTransformer();
            ((Transformer)object).setOutputProperty("omit-xml-declaration", "yes");
            ((Transformer)object).transform(new DOMSource(document.getDocumentElement()), new StreamResult((OutputStream)object2));
        }
        catch (Exception exception) {
            Utils.debug.error("Client:sendRequest", (Throwable)exception);
            throw new SOAPBindingException(exception.getMessage());
        }
        finally {
            if (object2 != null) {
                try {
                    ((OutputStream)object2).close();
                }
                catch (Exception exception) {
                    Utils.debug.error("Client:sendRequest", (Throwable)exception);
                }
            }
        }
        object = null;
        InputStream inputStream = null;
        try {
            inputStream = uRLConnection.getInputStream();
            object = new Message(inputStream);
            Utils.enforceProcessingRules((Message)object, message.getCorrelationHeader().getMessageID(), false);
        }
        catch (IOException iOException) {
            Utils.debug.error("Client:sendRequest", (Throwable)iOException);
            throw new SOAPBindingException(iOException.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    Utils.debug.error("Client:sendRequest", (Throwable)exception);
                }
            }
        }
        ((Message)object).setProtocol(uRLConnection.getURL().getProtocol());
        if (((Message)object).getSecurityProfileType() != 0 && !SecurityUtils.verifyMessage((Message)object)) {
            String string5 = Utils.bundle.getString("cannotVerifySignature");
            Utils.debug.error("Client.sendRequest: " + string5);
            throw new SOAPBindingException(string5);
        }
        return object;
    }

    private static URLConnection getConnection(String string, String string2) throws Exception {
        URLConnection uRLConnection = new URL(string).openConnection();
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("Client.getConnection: con class = " + uRLConnection.getClass());
        }
        if (uRLConnection instanceof HttpsURLConnection) {
            if (kms == null) {
                Client.initializeJSSE();
            }
            Client.kms[0] = string2 != null ? new WSX509KeyManager(defaultX509km, string2) : new WSX509KeyManager(defaultX509km, defaultCertAlias);
            SSLContext sSLContext = SSLContext.getInstance((String)"TLS");
            sSLContext.init(kms, tms, null);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRLConnection;
            httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
        } else if (uRLConnection instanceof com.iplanet.services.comm.https.HttpsURLConnection) {
            com.iplanet.services.comm.https.HttpsURLConnection httpsURLConnection = (com.iplanet.services.comm.https.HttpsURLConnection)uRLConnection;
            if (string2 != null) {
                httpsURLConnection.setClientCertificate(string2);
            } else {
                httpsURLConnection.setClientCertificate(defaultCertAlias);
            }
        }
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setRequestProperty("content-type", "text/xml");
        return uRLConnection;
    }

    private static void initializeJSSE() throws Exception {
        Security.removeProvider("SunJSSE");
        Security.insertProviderAt((java.security.Provider)new Provider(), 1);
        JKSKeyProvider jKSKeyProvider = new JKSKeyProvider();
        KeyStore keyStore = jKSKeyProvider.getKeyStore();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)"SunX509");
        keyManagerFactory.init(keyStore, jKSKeyProvider.getPrivateKeyPass().toCharArray());
        kms = keyManagerFactory.getKeyManagers();
        defaultX509km = (X509KeyManager)kms[0];
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance((String)"SunX509");
        trustManagerFactory.init(keyStore);
        tms = trustManagerFactory.getTrustManagers();
    }

    static {
        tfactory = TransformerFactory.newInstance();
        kms = null;
        tms = null;
        defaultX509km = null;
        defaultCertAlias = null;
        defaultCertAlias = SystemProperties.get((String)"com.sun.identity.liberty.ws.soap.certalias");
        try {
            scf = SOAPConnectionFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            Utils.debug.error("Client:static", (Throwable)sOAPException);
        }
    }
}

