/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SessionSubject
extends FSSubject {
    public SessionSubject(NameIdentifier nameIdentifier, SubjectConfirmation subjectConfirmation, IDPProvidedNameIdentifier iDPProvidedNameIdentifier) throws FSMsgException, SAMLException {
        super(nameIdentifier, subjectConfirmation, iDPProvidedNameIdentifier);
    }

    public SessionSubject(NameIdentifier nameIdentifier, IDPProvidedNameIdentifier iDPProvidedNameIdentifier) throws FSMsgException, SAMLException {
        super(nameIdentifier, iDPProvidedNameIdentifier);
    }

    public SessionSubject(Element element) throws FSMsgException, SAMLException {
        SecurityTokenManager.debug.message("SessionSubject(Element): Called");
        int n = 0;
        Element element2 = element;
        String string = element2.getLocalName();
        String string2 = element2.getNamespaceURI();
        if (string == null) {
            if (SecurityTokenManager.debug.messageEnabled()) {
                SecurityTokenManager.debug.message("SessionSubject: local name missing");
            }
            throw new FSMsgException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!string.equals("SessionSubject")) {
            if (SecurityTokenManager.debug.messageEnabled()) {
                SecurityTokenManager.debug.message("SessionSubject: invalid root element");
            }
            throw new FSMsgException(SAMLUtils.bundle.getString("invalidElement"));
        }
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        if (n2 == 0) {
            if (SecurityTokenManager.debug.messageEnabled()) {
                SecurityTokenManager.debug.message("SessionSubject: No sub elements found");
            }
            throw new FSMsgException(SAMLUtils.bundle.getString("emptyElement"));
        }
        int n3 = 0;
        while (n3 < n2) {
            Node node = nodeList.item(n3);
            if (node.getNodeType() == 1) {
                String string3 = node.getLocalName();
                if (string3.equals("NameIdentifier")) {
                    this.setNameIdentifier(new NameIdentifier((Element)node));
                    ++n;
                } else if (string3.equals("SubjectConfirmation")) {
                    super.setSubjectConfirmation(new SubjectConfirmation((Element)node));
                    ++n;
                } else if (string3.equals("IDPProvidedNameIdentifier")) {
                    this._idpNameIdentifier = new IDPProvidedNameIdentifier((Element)node);
                    ++n;
                } else {
                    if (SecurityTokenManager.debug.messageEnabled()) {
                        SecurityTokenManager.debug.message("SessionSubject: Invalid element encountered.");
                    }
                    throw new FSMsgException(SAMLUtils.bundle.getString("invalidElement"));
                }
            }
            ++n3;
        }
        if (n > 3) {
            if (SecurityTokenManager.debug.messageEnabled()) {
                SecurityTokenManager.debug.message("SessionSubject: more than allowed elements passed");
            }
            throw new FSMsgException(SAMLUtils.bundle.getString("moreElement"));
        }
        if (this._idpNameIdentifier == null) {
            if (SecurityTokenManager.debug.messageEnabled()) {
                SecurityTokenManager.debug.message("SessionSubject: mandatory IDPProvidedNameIdentifier missing");
            }
            throw new FSMsgException(SAMLUtils.bundle.getString("missingElement"));
        }
        SecurityTokenManager.debug.message("SessionSubject(Element): leaving");
    }

    public SessionSubject(SubjectConfirmation subjectConfirmation) throws SAMLException {
        super(subjectConfirmation);
    }

    public String toXMLString() throws FSMsgException {
        String string = this.toXMLString(true, false);
        return string;
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (bl) {
            string = "lib:";
            string2 = "sec:";
        }
        if (bl2) {
            string3 = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            string4 = "urn:liberty:sec:2003-08";
            string5 = " xmlns:sec=\"" + string4 + "\"";
        }
        stringBuffer.append("<").append(string2).append("SessionSubject").append(string5).append(">");
        if (this.getNameIdentifier() != null) {
            stringBuffer.append(this.getNameIdentifier().toString(bl, bl2));
        }
        if (this.getSubjectConfirmation() != null) {
            stringBuffer.append(this.getSubjectConfirmation().toString(bl, bl2));
        }
        if (this._idpNameIdentifier != null) {
            stringBuffer.append(this._idpNameIdentifier.toXMLString(bl, bl2));
        }
        stringBuffer.append("</").append(string2).append("SessionSubject").append(">");
        return stringBuffer.toString();
    }
}

