/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.liberty.ws.security.ProxySubject;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SessionContextStatement
extends SubjectStatement {
    public static final int SESSIONCONTEXT_STATEMENT = 5;
    protected ProxySubject _proxySubject = null;
    protected SessionContext _sessionContext = null;

    public SessionContextStatement(SessionContext sessionContext, Subject subject) throws SAMLException {
        if (sessionContext == null || subject == null) {
            SAMLUtils.debug.message("SessionContextStatement: SessionContext is null!");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this._sessionContext = sessionContext;
        this._subject = subject;
    }

    public SessionContextStatement(SessionContext sessionContext, ProxySubject proxySubject, Subject subject) throws SAMLException {
        if (sessionContext == null || subject == null) {
            SAMLUtils.debug.message("SessionContextStatement: SessionContext is null!");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this._sessionContext = sessionContext;
        this._proxySubject = proxySubject;
        this._subject = subject;
    }

    public SessionContextStatement(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtils.debug.message("AttributeStatement: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        boolean bl = SAMLUtils.checkStatement(element, "SessionContextStatement");
        if (!bl) {
            SAMLUtils.debug.message("SessionContextStatement: Wrong input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    String string = node.getLocalName();
                    String string2 = node.getNamespaceURI();
                    if (string == null || string.equals("") || string2 == null || string2.equals("")) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("SessionContextStatement: The tag name or tag namespace of child element is either null or empty.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
                    }
                    if (string.equals("Subject") && string2.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                        if (this._subject != null) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("SessionContextStatement should only contain one subject");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                        }
                        this._subject = new Subject((Element)node);
                    } else if (string.equals("ProxySubject") && string2.equals("urn:liberty:sec:2003-08")) {
                        if (this._proxySubject != null) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("SessionContextStatement should only contain one ProxySubject");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                        }
                        this._proxySubject = new ProxySubject((Element)node);
                    } else if (string.equals("SessionContext") && string2.equals("urn:liberty:sec:2003-08")) {
                        if (this._sessionContext != null) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("SessionContextStatement should only contain one SessionContext");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                        }
                        this._sessionContext = new SessionContext((Element)node);
                    } else {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("SessionContextStatement:Wrong element " + string + " included.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                    }
                }
                ++n2;
            }
        }
    }

    public ProxySubject getProxySubject() {
        return this._proxySubject;
    }

    public SessionContext getSessionContext() {
        return this._sessionContext;
    }

    public boolean setProxySubject(ProxySubject proxySubject) {
        if (proxySubject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement: setResourceID:Input is null.");
            }
            return false;
        }
        this._proxySubject = proxySubject;
        return true;
    }

    public int getStatementType() {
        return 5;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (bl) {
            string = "saml:";
            string3 = "lib:";
            string2 = "sec:";
        }
        if (bl2) {
            string4 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
            string5 = " xmlns:sec=\"urn:liberty:sec:2003-08\"";
        }
        try {
            stringBuffer.append("<").append(string2).append("SessionContextStatement").append(string5).append(">\n");
            stringBuffer.append(this._subject.toString(bl, true));
            if (this._proxySubject != null) {
                stringBuffer.append(this._proxySubject.toString(bl, bl2));
            }
            stringBuffer.append(this._sessionContext.toXMLString(bl, bl2));
            stringBuffer.append("</").append(string2).append("SessionContextStatement>");
        }
        catch (Exception exception) {
            return null;
        }
        return stringBuffer.toString();
    }
}

