/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.federation.message.common.AuthnContext;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.liberty.ws.security.SessionSubject;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SessionContext {
    protected SessionSubject _sessionSubject = null;
    protected AuthnContext _authnContext = null;
    protected String _providerID = null;
    protected Date _issueInstant = null;
    protected Date _authenticationInstant = null;

    protected SessionContext() {
    }

    public SessionContext(SessionSubject sessionSubject, AuthnContext authnContext, String string) throws SAMLException {
        if (sessionSubject == null || string == null) {
            SAMLUtils.debug.message("SessionContext: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this._sessionSubject = sessionSubject;
        this._authnContext = authnContext;
        this._providerID = string;
        this._issueInstant = new Date();
        this._authenticationInstant = new Date();
    }

    public SessionSubject getSessionSubject() {
        return this._sessionSubject;
    }

    public AuthnContext getAuthnContext() {
        return this._authnContext;
    }

    public String getProviderID() {
        return this._providerID;
    }

    public boolean setAuthnContext(AuthnContext authnContext) {
        if (authnContext == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SessionContext: setAuthnContext: Input is null.");
            }
            return false;
        }
        this._authnContext = authnContext;
        return true;
    }

    public SessionContext(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtils.debug.message("AttributeStatement: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        boolean bl = SAMLUtils.checkStatement(element, "SessionContext");
        if (!bl) {
            SAMLUtils.debug.message("SessionContext: Wrong input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        String string = element.getAttribute("AuthenticationInstant");
        String string2 = element.getAttribute("AssertionIssueInstant");
        if (string == null || string2 == null) {
            SAMLUtils.debug.message("SessionContext: AuthenticationInstant or AssertionIssueInstant is missing!");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        try {
            this._issueInstant = SAMLUtils.stringToDate(string2);
            this._authenticationInstant = SAMLUtils.stringToDate(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    String string3 = node.getLocalName();
                    String string4 = node.getNamespaceURI();
                    if (string3 == null || string3.equals("") || string4 == null || string4.equals("")) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("SessionContext: The tag name or tag namespace of child element is either null or empty.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
                    }
                    if (string3.equals("SessionSubject") && string4.equals("urn:liberty:sec:2003-08")) {
                        if (this._sessionSubject != null) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("SessionContext: should only contain one SessionSubject");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                        }
                        try {
                            this._sessionSubject = new SessionSubject((Element)node);
                        }
                        catch (Exception exception) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("SessionContext:could not new SessionSubject object.");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("SessionSubject"));
                        }
                    } else if (string3.equals("ProviderID") && string4.equals("urn:liberty:sec:2003-08")) {
                        if (this._providerID != null) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("SessionContext: should at most contain one ProviderID.");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                        }
                        this._providerID = node.getChildNodes().item(0).getNodeValue();
                    } else if (string3.equals("AuthnContext") && string4.equals("urn:liberty:iff:2003-08")) {
                        if (this._authnContext != null) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("SessionContext: should at most contain one AuthnContext");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                        }
                        try {
                            this._authnContext = new AuthnContext((Element)node);
                        }
                        catch (Exception exception) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("SessionContext:could not new AuthnContext object.", (Throwable)exception);
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("AuthnContext"));
                        }
                    } else {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("SessionContext: Wrong element " + string3 + " included.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                    }
                }
                ++n2;
            }
        }
        if (this._sessionSubject == null || this._authnContext == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SessionContext should contain one SessionSubject and one  one AuthnContext.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
    }

    public String toXMLString() throws ParseException, FSMsgException {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean bl, boolean bl2) throws ParseException, FSMsgException {
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (bl) {
            string2 = "lib:";
            string = "sec:";
        }
        if (bl2) {
            string3 = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            string4 = " xmlns:sec=\"urn:liberty:sec:2003-08\"";
        }
        stringBuffer.append("<").append(string).append("SessionContext").append(string4).append(" ").append("AuthenticationInstant=").append("\"").append(SAMLUtils.dateToString(this._issueInstant)).append("\" ").append("AssertionIssueInstant=").append("\"").append(SAMLUtils.dateToString(this._authenticationInstant)).append("\"").append(">");
        stringBuffer.append(this._sessionSubject.toXMLString(bl, bl2));
        stringBuffer.append("<").append(string).append("ProviderID").append(">").append(this._providerID).append("</").append(string).append("ProviderID").append(">");
        if (this._authnContext != null) {
            stringBuffer.append(this._authnContext.toXMLString(bl, bl2));
        }
        stringBuffer.append("</").append(string).append("SessionContext").append(">");
        return stringBuffer.toString();
    }
}

