/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.util.Base64;
import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.security.ResourceAccessStatement;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SessionContextStatement;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.AMSignatureProvider;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml.xmlsig.XMLSignatureException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityUtils {
    private static SecurityUtils securityManager = null;
    private static JKSKeyProvider keys = null;
    private static AMSignatureProvider asp = null;
    private static XMLSignatureManager sm = null;
    private static Debug debug = null;
    private static String DEFAULT_TA_CERT_ALIAS_KEY = "com.sun.identity.liberty.ws.ta.certalias";
    private static String DEFAULT_TA_CERT_ALIAS_VALUE = SystemProperties.get((String)DEFAULT_TA_CERT_ALIAS_KEY);
    private static KeyProvider keystore = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Element signMessage(Message message) {
        try {
            Document document = message.toDocument(true);
            int n = message.getSecurityProfileType();
            X509Certificate x509Certificate = null;
            List list = message.getSigningIds();
            if (debug.messageEnabled()) {
                debug.message("Security Type = " + n);
            }
            if (n == 1) {
                x509Certificate = message.getMessageCertificate();
                return sm.signWithWSSX509TokenProfile(document, x509Certificate, "", list);
            }
            if (n == 2) {
                SecurityAssertion securityAssertion = message.getAssertion();
                x509Certificate = message.getMessageCertificate();
                String string = securityAssertion.getAssertionID();
                return sm.signWithWSSSAMLTokenProfile(document, x509Certificate, string, "", list);
            }
            if (n != 0) return null;
        }
        catch (Exception exception) {
            debug.error("Unable to sign Soap message!", (Throwable)exception);
        }
        return null;
        {
            // empty if block
        }
        return null;
    }

    public static boolean verifyMessage(Message message) {
        try {
            X509Certificate x509Certificate;
            String string;
            Document document = message.toDocument(false);
            X509Certificate x509Certificate2 = message.getPeerCertificate();
            X509Certificate x509Certificate3 = message.getMessageCertificate();
            if (message.getSecurityProfileType() == 2 && !(string = keystore.getCertificateAlias(x509Certificate = SecurityUtils.getAssertionSigningCert(message.getAssertion()))).equals(DEFAULT_TA_CERT_ALIAS_VALUE)) {
                debug.error("Assertion not signed with TA cert\nTA = " + DEFAULT_TA_CERT_ALIAS_VALUE + "\n" + "Assertion signing cert = " + string);
                return false;
            }
            if (x509Certificate2 != null && !x509Certificate2.equals(x509Certificate3)) {
                debug.error("Client authentication certificate is not the same as the certificate inside the soap message");
                return false;
            }
            return sm.verifyXMLSignature(document);
        }
        catch (Exception exception) {
            debug.error("Unable to verify Soap Message!", (Throwable)exception);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Certificate getCertificate(BinarySecurityToken var0) {
        block4: {
            var1_1 = null;
            try {
                var2_2 = var0.getTokenValue();
                var3_4 = new StringBuffer(100);
                var3_4.append("-----BEGIN CERTIFICATE-----\n");
                var3_4.append(var2_2);
                var3_4.append("\n-----END CERTIFICATE-----");
                var4_5 = null;
                var4_5 = var3_4.toString().getBytes();
                var5_6 = CertificateFactory.getInstance("X.509");
                var6_7 = new ByteArrayInputStream(var4_5);
                var7_8 = var0.getValueType();
                if (!var7_8.equals(BinarySecurityToken.PKCS7)) ** GOTO lbl24
                var8_9 = var5_6.generateCertificates(var6_7);
                var9_10 = var8_9.iterator();
                while (var9_10.hasNext()) {
                    var1_1 = var9_10.next();
                }
                break block4;
lbl-1000:
                // 1 sources

                {
                    var1_1 = var5_6.generateCertificate(var6_7);
lbl24:
                    // 2 sources

                    ** while (var6_7.available() > 0)
                }
lbl25:
                // 1 sources

            }
            catch (Exception var2_3) {
                SecurityUtils.debug.error("WSSecurityManager:getX509Certificate", (Throwable)var2_3);
            }
        }
        return var1_1;
    }

    private SecurityAssertion getAssertion(Document document) {
        return null;
    }

    public static Certificate getCertificate(SecurityAssertion securityAssertion) {
        X509Certificate x509Certificate = null;
        AuthenticationStatement authenticationStatement = null;
        ResourceAccessStatement resourceAccessStatement = null;
        SessionContextStatement sessionContextStatement = null;
        Subject subject = null;
        if (debug.messageEnabled()) {
            debug.message("SecurityAssertion = " + securityAssertion.toString());
        }
        try {
            Object object;
            Object object2;
            Set set = securityAssertion.getStatement();
            if (set == null) {
                debug.error("Assertion does not contain any Statement.");
            }
            if (!set.isEmpty()) {
                object2 = set.iterator();
                while (object2.hasNext()) {
                    object = (Statement)object2.next();
                    if (((Statement)object).getStatementType() == 1) {
                        authenticationStatement = (AuthenticationStatement)object;
                        subject = authenticationStatement.getSubject();
                        break;
                    }
                    if (((Statement)object).getStatementType() == 4) {
                        resourceAccessStatement = (ResourceAccessStatement)object;
                        subject = resourceAccessStatement.getSubject();
                        break;
                    }
                    if (((Statement)object).getStatementType() != 5) continue;
                    sessionContextStatement = (SessionContextStatement)object;
                    subject = sessionContextStatement.getSubject();
                    break;
                }
            }
            object2 = subject.getSubjectConfirmation();
            object = ((SubjectConfirmation)object2).getKeyInfo();
            x509Certificate = SecurityUtils.getCertificate((Element)object);
        }
        catch (Exception exception) {
            debug.error("getCertificate Exception: ", (Throwable)exception);
        }
        return x509Certificate;
    }

    private static X509Certificate getCertificate(Element element) {
        Element element2;
        X509Certificate x509Certificate = null;
        if (debug.messageEnabled()) {
            debug.message("KeyInfo = " + XMLUtils.print((Node)element));
        }
        if ((element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate").item(0)) == null) {
            try {
                PublicKey publicKey = SecurityUtils.getPublicKey(element);
                x509Certificate = (X509Certificate)keystore.getCertificate(publicKey);
            }
            catch (Exception exception) {
                debug.error("getCertificate Exception: ", (Throwable)exception);
            }
        } else {
            String string = element2.getChildNodes().item(0).getNodeValue();
            x509Certificate = SecurityUtils.getCertificate(string, null);
        }
        return x509Certificate;
    }

    private static PublicKey getPublicKey(Element element) throws XMLSignatureException {
        PublicKey publicKey = null;
        Document document = element.getOwnerDocument();
        Element element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DSAKeyValue").item(0);
        if (element2 != null) {
            NodeList nodeList = element2.getChildNodes();
            int n = nodeList.getLength();
            if (n > 0) {
                Node node;
                BigInteger bigInteger = null;
                BigInteger bigInteger2 = null;
                BigInteger bigInteger3 = null;
                BigInteger bigInteger4 = null;
                int n2 = 0;
                while (n2 < n) {
                    node = nodeList.item(n2);
                    if (node.getNodeType() == 1) {
                        String string = node.getLocalName();
                        Node node2 = node.getChildNodes().item(0);
                        String string2 = node2.getNodeValue();
                        string2 = SecurityUtils.removeNewLineChars(string2);
                        BigInteger bigInteger5 = new BigInteger(Base64.decode((String)string2));
                        if (string.equals("P")) {
                            bigInteger = bigInteger5;
                        } else if (string.equals("Q")) {
                            bigInteger2 = bigInteger5;
                        } else if (string.equals("G")) {
                            bigInteger3 = bigInteger5;
                        } else if (string.equals("Y")) {
                            bigInteger4 = bigInteger5;
                        } else {
                            throw new XMLSignatureException();
                        }
                    }
                    ++n2;
                }
                node = new DSAKeyValue(document, bigInteger, bigInteger2, bigInteger3, bigInteger4);
                try {
                    publicKey = node.getPublicKey();
                }
                catch (XMLSecurityException xMLSecurityException) {
                    SAMLUtils.debug.error("Could not get Public Key from DSA key value.");
                    throw new XMLSignatureException(SAMLUtils.bundle.getString("errorObtainPK"));
                }
            }
        } else {
            Element element3 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "RSAKeyValue").item(0);
            if (element3 != null) {
                NodeList nodeList = element3.getChildNodes();
                int n = nodeList.getLength();
                BigInteger bigInteger = null;
                BigInteger bigInteger6 = null;
                if (n > 0) {
                    int n3 = 0;
                    while (n3 < n) {
                        Node node = nodeList.item(n3);
                        if (node.getNodeType() == 1) {
                            String string = node.getLocalName();
                            Node node3 = node.getChildNodes().item(0);
                            String string3 = node3.getNodeValue();
                            string3 = SecurityUtils.removeNewLineChars(string3);
                            BigInteger bigInteger7 = new BigInteger(Base64.decode((String)string3));
                            if (string.equals("Exponent")) {
                                bigInteger6 = bigInteger7;
                            } else if (string.equals("Modulus")) {
                                bigInteger = bigInteger7;
                            } else {
                                throw new XMLSignatureException();
                            }
                        }
                        ++n3;
                    }
                }
                RSAKeyValue rSAKeyValue = new RSAKeyValue(document, bigInteger, bigInteger6);
                try {
                    publicKey = rSAKeyValue.getPublicKey();
                }
                catch (XMLSecurityException xMLSecurityException) {
                    SAMLUtils.debug.error("Could not get Public Key from RSA key value.");
                    throw new XMLSignatureException(SAMLUtils.bundle.getString("errorObtainPK"));
                }
            }
        }
        return publicKey;
    }

    /*
     * Unable to fully structure code
     */
    private static X509Certificate getCertificate(String var0, String var1_1) {
        block5: {
            var2_2 = null;
            try {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("getCertificate(Assertion) : " + var0);
                }
                var3_3 = new StringBuffer(100);
                var3_3.append("-----BEGIN CERTIFICATE-----\n");
                var3_3.append(var0);
                var3_3.append("\n-----END CERTIFICATE-----");
                var4_5 = null;
                var4_5 = var3_3.toString().getBytes();
                var5_6 = CertificateFactory.getInstance("X.509");
                var6_7 = new ByteArrayInputStream(var4_5);
                if (var1_1 == null || !var1_1.equals("wsse:PKCS7")) ** GOTO lbl24
                var7_8 = var5_6.generateCertificates(var6_7);
                var8_9 = var7_8.iterator();
                while (var8_9.hasNext()) {
                    var2_2 = (X509Certificate)var8_9.next();
                }
                break block5;
lbl-1000:
                // 1 sources

                {
                    var2_2 = (X509Certificate)var5_6.generateCertificate(var6_7);
lbl24:
                    // 2 sources

                    ** while (var6_7.available() > 0)
                }
lbl25:
                // 1 sources

            }
            catch (Exception var3_4) {
                SAMLUtils.debug.error("getCertificate Exception: ", (Throwable)var3_4);
            }
        }
        return var2_2;
    }

    private static String removeNewLineChars(String string) {
        String string2 = null;
        if (string != null && string.length() > 0 && string.indexOf(10) != -1) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c != '\n') {
                    stringBuffer.append(c);
                }
                ++n2;
            }
            string2 = stringBuffer.toString();
        } else {
            string2 = string;
        }
        return string2;
    }

    private static X509Certificate getAssertionSigningCert(SecurityAssertion securityAssertion) {
        Element element = securityAssertion.getSignature();
        Element element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo").item(0);
        return SecurityUtils.getCertificate(element2);
    }

    static {
        debug = Debug.getInstance((String)"amWSSecurity");
        keys = new JKSKeyProvider();
        asp = new AMSignatureProvider();
        sm = XMLSignatureManager.getInstance(keys, asp);
        keystore = sm.getKeyProvider();
    }
}

