/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenException;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.security.SecurityTokenManagerIF;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class SecurityTokenManagerImpl
implements SecurityTokenManagerIF {
    private SecurityTokenManager securityTokenManager;
    private static Object lock = new Object();
    protected static boolean isLocal;

    public void initialization(String string) throws SecurityTokenException {
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(string);
            this.securityTokenManager = new SecurityTokenManager(sSOToken);
        }
        catch (Exception exception) {
            SecurityTokenManager.debug.error("SecurityTokenManagerImpl: Unable to get SecurityTokenManager", (Throwable)exception);
            throw new SecurityTokenException(exception.getMessage());
        }
    }

    public void setCertificate(String string, boolean bl) throws SecurityTokenException {
        if (bl) {
            this.securityTokenManager.setCertAlias(string);
        } else {
            this.securityTokenManager.setCertificate(this.getX509Certificate(string));
        }
    }

    public void checkForLocal() {
        isLocal = true;
    }

    public String getX509CertificateToken() throws SecurityTokenException {
        BinarySecurityToken binarySecurityToken = this.securityTokenManager.getX509CertificateToken();
        return binarySecurityToken.toString();
    }

    public String getSAMLAuthenticationToken(String string) throws SecurityTokenException, SAMLException {
        NameIdentifier nameIdentifier = new NameIdentifier(XMLUtils.toDOMDocument((String)string, (Debug)SecurityTokenManager.debug).getDocumentElement());
        SecurityAssertion securityAssertion = this.securityTokenManager.getSAMLAuthenticationToken(nameIdentifier);
        return securityAssertion.toString(true, true);
    }

    public String getSAMLAuthorizationToken(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) throws SecurityTokenException, SAMLException {
        NameIdentifier nameIdentifier = new NameIdentifier(XMLUtils.toDOMDocument((String)string, (Debug)SecurityTokenManager.debug).getDocumentElement());
        SessionContext sessionContext = new SessionContext(XMLUtils.toDOMDocument((String)string2, (Debug)SecurityTokenManager.debug).getDocumentElement());
        SecurityAssertion securityAssertion = null;
        if (!bl) {
            securityAssertion = this.securityTokenManager.getSAMLAuthorizationToken(nameIdentifier, sessionContext, string3, bl2, bl3);
        }
        return securityAssertion.toString(true, true);
    }

    private X509Certificate getX509Certificate(String string) {
        X509Certificate x509Certificate = null;
        try {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("-----BEGIN CERTIFICATE-----\n");
            stringBuffer.append(string);
            stringBuffer.append("\n-----END CERTIFICATE-----");
            byte[] byArray = null;
            byArray = stringBuffer.toString().getBytes();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            while (byteArrayInputStream.available() > 0) {
                x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            }
        }
        catch (Exception exception) {
            SecurityTokenManager.debug.error("getX509Certificate Exception: ", (Throwable)exception);
        }
        return x509Certificate;
    }
}

