/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.liberty.ws.security.ResourceAccessStatement;
import com.sun.identity.liberty.ws.security.SessionContextStatement;
import com.sun.identity.saml.assertion.Advice;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.AuthorizationDecisionStatement;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SecurityAssertion
extends Assertion {
    public SecurityAssertion(Element element) throws SAMLException {
        Object object;
        Element element2 = element;
        String string = element2.getLocalName();
        if (string == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!string.equals("Assertion")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement") + ":" + string);
        }
        String string2 = element2.getAttribute("Issuer");
        if (string2 == null || string2.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: Issuer missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute") + ":" + "Issuer");
        }
        this._issuer = string2;
        List list = XMLUtils.getElementsByTagNameNS1((Element)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        int n = list.size();
        if (n == 1) {
            Object object2;
            Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
            object = null;
            if (map != null && (object2 = (SAMLServiceManager.SOAPEntry)map.get(this._issuer)) != null) {
                object = ((SAMLServiceManager.SOAPEntry)object2).getCertAlias();
            }
            object2 = XMLSignatureManager.getInstance();
            this.valid = ((XMLSignatureManager)object2).verifyXMLSignature(element, "AssertionID", (String)object);
            if (!this.valid && SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion(Element): couldn't verify Assertion's signature.");
            }
            this.xmlString = XMLUtils.print((Node)element);
            this.signed = true;
        } else if (n != 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion(Element): included more than one Signature element.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
        }
        string2 = element2.getAttribute("MajorVersion");
        if (string2 == null || string2.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: MajorVersion missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute") + ":" + "MajorVersion");
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            SAMLUtils.debug.error("Assertion: invalid integer in MajorVersion", (Throwable)numberFormatException);
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidNumber") + ":" + "MajorVersion");
        }
        if (n2 != 1) {
            if (n2 < 1) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Assertion: MajorVersion too low");
                }
                throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("assertionVersionTooLow") + ":" + "MajorVersion");
            }
            if (n2 > 1) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Assertion: MajorVersion too high");
                }
                throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("assertionVersionTooHigh") + ":" + "MajorVersion");
            }
            this._minorVersion = Integer.parseInt(string2);
        }
        if ((string2 = element2.getAttribute("MinorVersion")) == null || string2.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: MinorVersion missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute") + ":" + "MinorVersion");
        }
        n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            SAMLUtils.debug.error("Assertion: invalid integer in MinorVersion", (Throwable)numberFormatException);
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidNumber") + ":" + "MinorVersion");
        }
        if (n2 != SAMLConstants.ASSERTION_MINOR_VERSION) {
            if (n2 < SAMLConstants.ASSERTION_MINOR_VERSION) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Assertion: MinorVersion too low");
                }
                throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("assertionVersionTooLow"));
            }
            if (n2 > SAMLConstants.ASSERTION_MINOR_VERSION) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Assertion: MinorVersion too high");
                }
                throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("assertionVersionTooHigh") + ":" + "MinorVersion");
            }
            this._minorVersion = Integer.parseInt(string2);
        }
        if ((string2 = element2.getAttribute("AssertionID")) == null || string2.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: AssertionID missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute") + ":" + "AssertionID");
        }
        this._assertionID = new AssertionIDReference(string2);
        string2 = element2.getAttribute("IssueInstant");
        if (string2 == null || string2.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: IssueInstant missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute") + ":" + "IssueInstant");
        }
        try {
            this._issueInstant = SAMLUtils.stringToDate(string2);
        }
        catch (ParseException parseException) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: could not parse IssueInstant");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput" + parseException.getMessage()));
        }
        n2 = 0;
        object = element.getChildNodes();
        int n3 = object.getLength();
        int n4 = 0;
        while (n4 < n3) {
            Node node = object.item(n4);
            if (node.getNodeType() == 1) {
                String string3 = node.getLocalName();
                if (string3.equals("Conditions")) {
                    this._conditions = new Conditions((Element)node);
                } else if (string3.equals("Advice")) {
                    this._advice = new Advice((Element)node);
                } else if (string3.equals("AuthenticationStatement")) {
                    this._statements.add(new AuthenticationStatement((Element)node));
                    n2 = 1;
                } else if (string3.equals("AuthorizationDecisionStatement")) {
                    this._statements.add(new AuthorizationDecisionStatement((Element)node));
                    n2 = 1;
                } else if (string3.equals("AttributeStatement")) {
                    this._statements.add(new AttributeStatement((Element)node));
                    n2 = 1;
                } else if (string3.equals("Signature")) {
                    this.signature = (Element)node;
                } else if (string3.equals("ResourceAccessStatement")) {
                    this._statements.add(new ResourceAccessStatement((Element)node));
                    n2 = 1;
                } else if (string3.equals("SessionContextStatement")) {
                    this._statements.add(new SessionContextStatement((Element)node));
                    n2 = 1;
                } else {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Assertion: invalid element in Assertion");
                    }
                    throw new SAMLRequesterException("invalidElement");
                }
            }
            ++n4;
        }
        if (n2 == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: mandatory statement missing");
            }
            throw new SAMLRequesterException("missingStatement");
        }
    }

    public SecurityAssertion(String string, String string2, Date date, Set set) throws SAMLException {
        super(string, string2, date, set);
    }

    public SecurityAssertion(String string, String string2, Date date, Conditions conditions, Set set) throws SAMLException {
        super(string, string2, date, conditions, set);
    }

    public SecurityAssertion(String string, String string2, Date date, Conditions conditions, Advice advice, Set set) throws SAMLException {
        super(string, string2, date, conditions, advice, set);
    }

    public String toString() {
        String string = this.toString(true, false);
        return string;
    }

    public String toString(boolean bl, boolean bl2) {
        Object object;
        if (this.signed && this.xmlString != null) {
            return this.xmlString;
        }
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = "";
        String string2 = "";
        if (bl2) {
            string = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        if (bl) {
            string2 = "saml:";
        }
        String string3 = null;
        if (this._issueInstant != null) {
            try {
                string3 = SAMLUtils.dateToString(this._issueInstant);
            }
            catch (ParseException parseException) {
                SAMLUtils.debug.error("Assertion: could not dateToString  NotBefore");
            }
        }
        stringBuffer.append("<").append(string2).append("Assertion").append(" ").append(string).append(" ").append("MajorVersion").append("=\"").append(this._majorVersion).append("\"").append(" ").append("MinorVersion").append("=\"").append(this._minorVersion).append("\"").append(" ").append("AssertionID=\"").append(this._assertionID.getAssertionIDReference()).append("\"").append(" ").append("Issuer").append("=\"").append(this._issuer).append("\"").append(" ").append("IssueInstant").append("=\"").append(string3).append("\"").append(" ").append(">").append("\n");
        if (this._conditions != null) {
            stringBuffer.append(this._conditions.toString(bl, false));
        }
        if (this._advice != null) {
            stringBuffer.append(this._advice.toString(bl, false));
        }
        Iterator iterator = this.getStatement().iterator();
        while (iterator.hasNext()) {
            object = (Statement)iterator.next();
            stringBuffer.append(((Statement)object).toString(bl, bl2));
        }
        if (this.signed && this.signatureString != null) {
            stringBuffer.append(this.signatureString);
        }
        object = SAMLUtils.makeEndElementTagXML("Assertion", bl);
        stringBuffer.append((String)object);
        return stringBuffer.toString();
    }
}

