/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.liberty.ws.security.ProxySubject;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceAccessStatement
extends SubjectStatement {
    public static final int RESOURCEACCESS_STATEMENT = 4;
    protected String _resourceID = null;
    protected ProxySubject _proxySubject = null;
    protected SessionContext _sessionContext = null;

    public ResourceAccessStatement(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtils.debug.message("ResourceAccessStatement: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        boolean bl = SAMLUtils.checkStatement(element, "ResourceAccessStatement");
        if (!bl) {
            SAMLUtils.debug.message("ResourceAccessStatement: Wrong input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    String string = node.getLocalName();
                    String string2 = node.getNamespaceURI();
                    if (string == null || string.equals("") || string2 == null || string2.equals("")) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("ResourceAccessStatement: The tag name or tag namespace of child element is either null or empty.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
                    }
                    if (string.equals("Subject") && string2.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                        if (this._subject != null) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("ResourceAccessStatement:should only contain one subject");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                        }
                        this._subject = new Subject((Element)node);
                    } else if (string.equals("ResourceID") && string2.equals("urn:liberty:disco:2003-08")) {
                        if (this._resourceID != null) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("ResourceAccessStatement: should at most contain one ResourceIDGroup.");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                        }
                        this._resourceID = node.getChildNodes().item(0).getNodeValue();
                    } else if (string.equals("ProxySubject") && string2.equals("urn:liberty:sec:2003-08")) {
                        if (this._proxySubject != null) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("ResourceAccessStatement: should at most contain one ProxySubject.");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                        }
                        this._proxySubject = new ProxySubject((Element)node);
                    } else if (string.equals("SessionContext") && string2.equals("urn:liberty:sec:2003-08")) {
                        if (this._sessionContext != null) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("ResourceAccessStatement: should at most contain one SessionContext.");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                        }
                        this._sessionContext = new SessionContext((Element)node);
                    } else {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("ResourceAccessStatement:Wrong element " + string + "included.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                    }
                }
                ++n2;
            }
        }
        if (this._subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
    }

    public ResourceAccessStatement(String string, Subject subject) throws SAMLException {
        if (subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement: should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
        }
        this._subject = subject;
        this._resourceID = string;
    }

    public ResourceAccessStatement(String string, ProxySubject proxySubject, Subject subject) throws SAMLException {
        if (subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement: should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
        }
        this._subject = subject;
        this._resourceID = string;
        this._proxySubject = proxySubject;
    }

    public ResourceAccessStatement(String string, ProxySubject proxySubject, SessionContext sessionContext, Subject subject) throws SAMLException {
        if (subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement: should contain one subject.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
        }
        this._subject = subject;
        this._resourceID = string;
        this._proxySubject = proxySubject;
        this._sessionContext = sessionContext;
    }

    public String getResourceID() {
        return this._resourceID;
    }

    public boolean setResourceID(String string) {
        if (string == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement: setResourceID:Input is null.");
            }
            return false;
        }
        this._resourceID = string;
        return true;
    }

    public int getStatementType() {
        return 4;
    }

    public boolean setSessionContext(SessionContext sessionContext) {
        if (sessionContext == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ResourceAccessStatement: setSessionContext: Input is null.");
            }
            return false;
        }
        this._sessionContext = sessionContext;
        return true;
    }

    public SessionContext getSessionContext() {
        return this._sessionContext;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<").append("sec:").append("ResourceAccessStatement").append(" ").append("xmlns:sec").append("=").append("\"").append("urn:liberty:sec:2003-08").append("\"");
        stringBuffer.append(">\n").append(this._subject.toString(bl, true));
        stringBuffer.append("<").append("disco").append(":").append("ResourceID").append(" ").append("xmlns").append(":").append("disco").append("=\"").append("urn:liberty:disco:2003-08").append("\">").append(this._resourceID).append("</").append("disco").append(":").append("ResourceID").append(">");
        if (this._proxySubject != null) {
            stringBuffer.append(this._proxySubject.toString(bl, true));
            if (this._sessionContext != null) {
                try {
                    stringBuffer.append(this._sessionContext.toXMLString(bl, true));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        stringBuffer.append("</").append("sec:").append("ResourceAccessStatement").append(">\n");
        return stringBuffer.toString();
    }
}

