/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProxySubject
extends Subject {
    public ProxySubject(NameIdentifier nameIdentifier, SubjectConfirmation subjectConfirmation) throws SAMLException {
        super(nameIdentifier, subjectConfirmation);
    }

    public boolean equals(ProxySubject proxySubject) {
        return super.equals(proxySubject);
    }

    public ProxySubject(NameIdentifier nameIdentifier) throws SAMLException {
        super(nameIdentifier);
    }

    public ProxySubject(Element element) throws SAMLException {
        int n = 0;
        Element element2 = element;
        String string = element2.getLocalName();
        if (string == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ProxySubject: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!string.equals("ProxySubject")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("ProxySubject: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement"));
        }
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        if (n2 == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject: No sub elements found");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("emptyElement"));
        }
        int n3 = 0;
        while (n3 < n2) {
            Node node = nodeList.item(n3);
            if (node.getNodeType() == 1) {
                String string2 = node.getLocalName();
                if (string2.equals("NameIdentifier")) {
                    this.setNameIdentifier(new NameIdentifier((Element)node));
                    ++n;
                } else if (string2.equals("SubjectConfirmation")) {
                    this.setSubjectConfirmation(new SubjectConfirmation((Element)node));
                    ++n;
                } else {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Subject: Invalid element encountered.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement"));
                }
            }
            ++n3;
        }
        if (n > 2) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject: more than allowed elements passed");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
        }
    }

    public ProxySubject(SubjectConfirmation subjectConfirmation) throws SAMLException {
        super(subjectConfirmation);
    }

    public String toString() {
        String string = this.toString(true, false);
        return string;
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = "";
        String string2 = "";
        String string3 = "";
        if (bl) {
            string = "sec:";
        }
        if (bl2) {
            string2 = "urn:liberty:sec:2003-08";
            string3 = " xmlns:sec=\"" + string2 + "\"";
        }
        stringBuffer.append("<").append(string).append("ProxySubject").append(string3).append(">");
        if (this.getNameIdentifier() != null) {
            stringBuffer.append(this.getNameIdentifier().toString(bl, bl2));
        }
        if (this.getSubjectConfirmation() != null) {
            stringBuffer.append(this.getSubjectConfirmation().toString(bl, bl2));
        }
        stringBuffer.append("</").append(string).append("ProxySubject").append(">");
        return stringBuffer.toString();
    }
}

