/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.paos;

import com.sun.identity.liberty.ws.paos.PAOSException;
import com.sun.identity.liberty.ws.paos.PAOSRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class PAOSHeader {
    private String paosHeaderStr = null;
    private ArrayList versionList = new ArrayList();
    private ArrayList extensionList = new ArrayList();
    private static final String PAOS_HEADER = "PAOS";
    private HashMap servicesAndOptions = new HashMap();

    public PAOSHeader(HttpServletRequest httpServletRequest) throws PAOSException {
        this.paosHeaderStr = httpServletRequest.getHeader(PAOS_HEADER);
        if (this.paosHeaderStr == null) {
            PAOSRequest.debug.error("PAOSHeader:PAOSHeader: No POAS header.");
            throw new PAOSException("There is no PAOS header.");
        }
        this.paosHeaderStr = this.paosHeaderStr.trim();
        this.parse();
    }

    public PAOSHeader(String string) throws PAOSException {
        if (this.paosHeaderStr == null) {
            PAOSRequest.debug.error("PAOSHeader:PAOSHeader: No POAS header.");
            throw new PAOSException("There is no PAOS header.");
        }
        this.paosHeaderStr = this.paosHeaderStr.trim();
        this.parse();
    }

    private void parse() throws PAOSException {
        StringTokenizer stringTokenizer;
        String string;
        if (this.paosHeaderStr.equals("")) {
            PAOSRequest.debug.error("PAOSHeader:PAOSHeader: Null POAS header.");
            throw new PAOSException("PAOS header value is empty");
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.paosHeaderStr, ";");
        int n = stringTokenizer2.countTokens();
        String string2 = stringTokenizer2.nextToken().trim();
        int n2 = string2.indexOf("ext=");
        String string3 = null;
        string3 = n2 < 0 ? string2 : string2.substring(0, n2).trim();
        String string4 = null;
        string4 = string3.startsWith("ver=") ? string3.substring(4).trim() : string3;
        StringTokenizer stringTokenizer3 = new StringTokenizer(string4, ",");
        while (stringTokenizer3.hasMoreTokens()) {
            this.versionList.add(this.trimQuotes(stringTokenizer3.nextToken().trim()));
        }
        if (n2 >= 0) {
            string = string2.substring(n2 + 4).trim();
            stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.extensionList.add(this.trimQuotes(stringTokenizer.nextToken().trim()));
            }
        }
        string = null;
        stringTokenizer = null;
        String string5 = null;
        HashSet<String> hashSet = null;
        while (stringTokenizer2.hasMoreTokens()) {
            string = stringTokenizer2.nextToken();
            stringTokenizer = new StringTokenizer(string, ",");
            if (stringTokenizer.hasMoreTokens()) {
                string5 = this.trimQuotes(stringTokenizer.nextToken().trim());
            }
            if (stringTokenizer.hasMoreTokens()) {
                hashSet = new HashSet<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    hashSet.add(this.trimQuotes(stringTokenizer.nextToken().trim()));
                }
            }
            this.servicesAndOptions.put(string5, hashSet);
            hashSet = null;
        }
    }

    private String trimQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public Iterator getVersions() {
        return this.versionList.iterator();
    }

    public Iterator getExtensions() {
        return this.extensionList.iterator();
    }

    public HashMap getServicesAndOptions() {
        return this.servicesAndOptions;
    }
}

