/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.meta;

import com.sun.identity.liberty.ws.common.jaxb.xmlsig.KeyInfoType;
import com.sun.identity.liberty.ws.common.jaxb.xmlsig.ObjectFactory;
import com.sun.identity.liberty.ws.common.jaxb.xmlsig.X509DataElement;
import com.sun.identity.liberty.ws.common.jaxb.xmlsig.X509DataType;
import com.sun.identity.liberty.ws.meta.MetaException;
import com.sun.identity.liberty.ws.meta.MetaUtils;
import com.sun.identity.liberty.ws.meta.jaxb.KeyDescriptorType;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyUtils {
    static ObjectFactory xmlsigF = new ObjectFactory();
    static JKSKeyProvider keys = new JKSKeyProvider();
    static XMLSignatureManager sigm = XMLSignatureManager.getInstance();

    private KeyUtils() {
    }

    public static Map storeKeyInfo(List list) {
        HashMap<String, Object> hashMap;
        block15: {
            hashMap = new HashMap<String, Object>();
            String string = null;
            try {
                int n;
                int n2;
                KeyInfoType keyInfoType;
                BigInteger bigInteger;
                if (list == null || list.isEmpty()) {
                    if (!MetaUtils.debug.messageEnabled()) break block15;
                    MetaUtils.debug.message("storeKeyInfo: KeyDescriptor is empty");
                    break block15;
                }
                KeyDescriptorType keyDescriptorType = (KeyDescriptorType)list.get(0);
                string = keyDescriptorType.getEncryptionMethod();
                if (string == null || string.equals("")) {
                    if (MetaUtils.debug.messageEnabled()) {
                        MetaUtils.debug.message("MapToFSProviderDesc: EncryptionMethod isn't defined.");
                    }
                } else {
                    hashMap.put("EncryptionMethod", string);
                }
                if ((bigInteger = keyDescriptorType.getKeySize()) == null || bigInteger == BigInteger.ZERO) {
                    if (MetaUtils.debug.messageEnabled()) {
                        MetaUtils.debug.message("MapToFSProviderDesc: KeySize isn't defined.");
                    }
                } else {
                    hashMap.put("KeySize", bigInteger);
                }
                if ((string = keyDescriptorType.getUse()) == null || string.equals("")) {
                    if (MetaUtils.debug.messageEnabled()) {
                        MetaUtils.debug.message("MapToFSProviderDesc: Use isn't defined.");
                    }
                } else {
                    hashMap.put("KeyUse", string);
                }
                if ((keyInfoType = keyDescriptorType.getKeyInfo()) == null) break block15;
                X509DataElement x509DataElement = (X509DataElement)keyInfoType.getContent().get(0);
                byte[] byArray = ((X509DataType.X509Certificate)x509DataElement.getX509IssuerSerialOrX509SKIOrX509SubjectName().get(0)).getValue();
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                X509Certificate x509Certificate = null;
                while (byteArrayInputStream.available() > 0) {
                    x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                }
                String string2 = null;
                if (x509Certificate == null) {
                    MetaUtils.debug.error("Created Cert is null");
                    break block15;
                }
                String string3 = x509Certificate.getSubjectDN().getName();
                string2 = string3.substring(n2 = string3.indexOf("CN") + 3, n = string3.indexOf(",", n2));
                if (string2 == null) {
                    throw new MetaException("Cert alias name from subjectDN is null");
                }
                keys.setCertificateEntry(string2, x509Certificate);
                keys.store();
                hashMap.put("KeyInfo", string2);
            }
            catch (Exception exception) {
                MetaUtils.debug.error("storeKeyInfo exception" + exception.getMessage());
            }
        }
        return hashMap;
    }

    public static KeyInfoType LoadKeyInfo(String string) {
        block5: {
            try {
                if (string == null) break block5;
                X509DataType.X509Certificate x509Certificate = xmlsigF.createX509DataTypeX509Certificate();
                X509DataElement x509DataElement = xmlsigF.createX509DataElement();
                X509Certificate x509Certificate2 = keys.getX509Certificate(string);
                if (x509Certificate2 != null) {
                    try {
                        x509Certificate.setValue(x509Certificate2.getEncoded());
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new MetaException("KeyInfo: Certificate encoding error." + certificateEncodingException.getMessage());
                    }
                    x509DataElement.getX509IssuerSerialOrX509SKIOrX509SubjectName().add(x509Certificate);
                    KeyInfoType keyInfoType = xmlsigF.createKeyInfoType();
                    keyInfoType.getContent().add(x509DataElement);
                    return keyInfoType;
                }
                MetaUtils.debug.error("Cert is null");
                return null;
            }
            catch (Exception exception) {
                MetaUtils.debug.error("storeKeyInfo exception", (Throwable)exception);
            }
        }
        return null;
    }
}

