/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.meta;

import com.sun.identity.federation.alliance.FSAffiliationDescriptor;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.liberty.ws.common.jaxb.xmlsig.KeyInfoType;
import com.sun.identity.liberty.ws.meta.KeyUtils;
import com.sun.identity.liberty.ws.meta.MetaException;
import com.sun.identity.liberty.ws.meta.MetaUtils;
import com.sun.identity.liberty.ws.meta.jaxb.AffiliationDescriptorType;
import com.sun.identity.liberty.ws.meta.jaxb.KeyDescriptorType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;

public class AffiliationDescriptorManager {
    private static AffiliationDescriptorManager instance = new AffiliationDescriptorManager();

    private AffiliationDescriptorManager() {
    }

    public static AffiliationDescriptorManager getInstance() throws MetaException {
        if (instance == null) {
            throw new MetaException(MetaUtils.bundle.getString("failGetInstance"));
        }
        return instance;
    }

    public FSAffiliationDescriptor mapToFSAffiliationDescriptor(AffiliationDescriptorType affiliationDescriptorType) throws MetaException {
        String string = null;
        List list = new ArrayList();
        Object var4_4 = null;
        boolean bl = false;
        String string2 = affiliationDescriptorType.getAffiliationID();
        if (string2 == null) {
            throw new MetaException("Affiliation id is null");
        }
        if (MetaUtils.debug.messageEnabled()) {
            MetaUtils.debug.message("affiliation id = " + string2);
        }
        FSAffiliationDescriptor fSAffiliationDescriptor = null;
        try {
            fSAffiliationDescriptor = new FSAffiliationDescriptor(string2);
            string = affiliationDescriptorType.getAffiliationOwnerID();
            if (string == null) {
                throw new MetaException("Affiliation ownerid is null");
            }
            fSAffiliationDescriptor.setAffiliationOwnerID(string);
            string = affiliationDescriptorType.getCacheDuration();
            if (string != null) {
                if (MetaUtils.debug.messageEnabled()) {
                    MetaUtils.debug.message("MapToFSAffiliationDescriptor: CacheDuration:" + string);
                }
                fSAffiliationDescriptor.setCacheDuration(string);
            }
            if ((list = affiliationDescriptorType.getKeyDescriptor()) == null || list.isEmpty()) {
                if (MetaUtils.debug.messageEnabled()) {
                    MetaUtils.debug.message("MapToFSProviderDesc: KeyDescriptor is empty");
                }
            } else {
                Map map = KeyUtils.storeKeyInfo(list);
                if (map != null && !map.isEmpty()) {
                    if (map.containsKey("EncryptionMethod")) {
                        fSAffiliationDescriptor.setEncryptionMethod((String)map.get("EncryptionMethod"));
                    }
                    if (map.containsKey("KeySize")) {
                        fSAffiliationDescriptor.setKeySize(((BigInteger)map.get("KeySize")).intValue());
                    }
                    if (map.containsKey("KeyUse")) {
                        fSAffiliationDescriptor.setKeyUse((String)map.get("KeyUse"));
                    }
                    if (map.containsKey("KeyInfo")) {
                        fSAffiliationDescriptor.setKeyInfo((String)map.get("KeyInfo"));
                    }
                }
            }
            if ((list = affiliationDescriptorType.getAffiliateMember()) == null || list.isEmpty()) {
                if (MetaUtils.debug.messageEnabled()) {
                    MetaUtils.debug.message("MapToFSAffiliationDescriptor: affiliation member is null.");
                }
            } else {
                fSAffiliationDescriptor.setAffiliationMember(new HashSet(list));
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            if (MetaUtils.debug.messageEnabled()) {
                MetaUtils.debug.message("MapToFSAffiliationDescriptor FSAllianceManagementException:" + fSAllianceManagementException.getMessage());
            }
            throw new MetaException(fSAllianceManagementException.getMessage());
        }
        catch (Exception exception) {
            throw new MetaException(exception.getMessage());
        }
        return fSAffiliationDescriptor;
    }

    public AffiliationDescriptorType mapToAffiliationDescriptor(FSAffiliationDescriptor fSAffiliationDescriptor) throws MetaException {
        AffiliationDescriptorType affiliationDescriptorType = null;
        String string = null;
        ArrayList arrayList = new ArrayList();
        Set set = null;
        try {
            Object object;
            String string2;
            int n;
            affiliationDescriptorType = MetaUtils.objF.createAffiliationDescriptorType();
            string = fSAffiliationDescriptor.getAffiliationID();
            if (string == null) {
                throw new MetaException("Affiliation id is null");
            }
            affiliationDescriptorType.setAffiliationID(string);
            string = fSAffiliationDescriptor.getAffiliationOwnerID();
            if (string == null) {
                throw new MetaException("Affiliation owner id is null");
            }
            affiliationDescriptorType.setAffiliationOwnerID(string);
            string = fSAffiliationDescriptor.getCacheDuration();
            if (string != null) {
                affiliationDescriptorType.setCacheDuration(string);
            }
            KeyDescriptorType keyDescriptorType = MetaUtils.objF.createKeyDescriptorType();
            string = fSAffiliationDescriptor.getEncryptionMethod();
            if (string != null && !string.equals("")) {
                keyDescriptorType.setEncryptionMethod(string);
            }
            if ((string = fSAffiliationDescriptor.getKeyUse()) != null && !string.equals("")) {
                keyDescriptorType.setUse(string);
            }
            if ((n = fSAffiliationDescriptor.getKeySize()) != -1) {
                keyDescriptorType.setKeySize(new BigInteger(Integer.toString(n), 10));
            }
            if ((string2 = fSAffiliationDescriptor.getKeyInfo()) != null && !string2.equals("")) {
                object = KeyUtils.LoadKeyInfo(string2);
                if (object != null) {
                    keyDescriptorType.setKeyInfo((KeyInfoType)object);
                    affiliationDescriptorType.getKeyDescriptor().add(keyDescriptorType);
                } else {
                    MetaUtils.debug.error("Could not find the certificate " + string2 + " in the keystore");
                }
            }
            if ((set = fSAffiliationDescriptor.getAffiliationMember()) == null || set.isEmpty()) {
                if (MetaUtils.debug.messageEnabled()) {
                    MetaUtils.debug.message("MapToFSAffiliationDescriptor: affiliation member is null.");
                }
            } else {
                object = set.iterator();
                while (object.hasNext()) {
                    affiliationDescriptorType.getAffiliateMember().add((String)object.next());
                }
            }
        }
        catch (JAXBException jAXBException) {
            throw new MetaException(jAXBException.getMessage());
        }
        return affiliationDescriptorType;
    }
}

