/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.interaction;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.liberty.ws.interaction.InteractionManager;
import javax.xml.namespace.QName;

class InteractionConfig {
    static final String WSC_SPECIFIED_INTERACTION_CHOICE = "com.sun.identity.liberty.interaction.wscSpecifiedInteractionChoice";
    static final String INTERACT_IF_NEEDED = "interactIfNeeded";
    static final String DO_NOT_INTERACT = "doNotInteract";
    static final String DO_NOT_INTERACT_FOR_DATA = "doNotInteractForData";
    static final String WSC_WILL_INCLUDE_USER_INTERACTION_HEADER = "com.sun.identity.liberty.interaction.wscWillInlcudeUserInteractionHeader";
    static final String WSC_WILL_REDIRECT = "com.sun.identity.liberty.interaction.wscWillRedirect";
    static final String WSC_SPECIFIED_MAX_INTERACTION_TIME = "com.sun.identity.liberty.interaction.wscSpecifiedMaxInteractionTime";
    static final int DEFAULT_WSC_MAX_INTERACTION_TIME = 60;
    static final String WSC_WILL_ENFORCE_HTTPS_CHECK = "com.sun.identity.liberty.interaction.wscWillEnforceHttpsCheck";
    static final String WSC_SPECIFIED_CONNECT_TO = "com.sun.identity.liberty.interaction.wscSpecifiedConnectTo";
    static final String WSP_WILL_REDIRECT = "com.sun.identity.liberty.interaction.wspWillRedirect";
    static final String WSP_WILL_REDIRECT_FOR_DATA = "com.sun.identity.liberty.interaction.wspWillRedirectForData";
    static final String WSP_REDIRECT_TIME = "com.sun.identity.liberty.interaction.wspRedirectTime";
    static final int DEFAULT_WSP_REDIRECT_TIME = 30;
    static final String WSP_REDIRECT_HANDLER = "com.sun.identity.liberty.interaction.wspRedirectHandler";
    static final String WSP_WILL_ENFORCE_HTTPS_CHECK = "com.sun.identity.liberty.interaction.wspWillEnforceHttpsCheck";
    static final String WSP_WILL_ENFORCE_RETURN_TO_HOST_EQUALS_REQUEST_HOST = "com.sun.identity.liberty.interaction.wspWillEnforceReturnToHostEqualsRequestHost";
    static final String HTML_STYLE_SHEET_LOCATION = "com.sun.identity.liberty.interaction.htmlStyleSheetLocation";
    static final String WML_STYLE_SHEET_LOCATION = "com.sun.identity.liberty.interaction.wmlStyleSheetLocation";
    static final String YES = "yes";
    private static InteractionConfig interactionConfig = null;
    private static Debug debug = Debug.getInstance((String)"amInteraction");
    private QName wscSpecifiedInteractionChoice = InteractionManager.QNAME_INTERACT_IF_NEEDED;
    private boolean wscWillIncludeUserInteractionHeader = true;
    private boolean wscWillRedirect = true;
    private int wscSpecifiedMaxInteractionTime = 60;
    private boolean wscWillEnforceHttpsCheck = false;
    private String wscSpecifiedConnectTo = "null";
    private boolean wspWillRedirect = true;
    private boolean wspWillRedirectForData = true;
    private int wspRedirectTime = 30;
    private String wspRedirectHandler = null;
    private boolean wspWillEnforceHttpsCheck = false;
    private boolean wspWillEnforceReturnToHostEqualsRequestHost = false;
    private String htmlStyleSheetLocation = null;
    private String wmlStyleSheetLocation = null;

    static synchronized InteractionConfig getInstance() {
        if (interactionConfig == null) {
            interactionConfig = new InteractionConfig();
        }
        return interactionConfig;
    }

    private InteractionConfig() {
        this.initialize();
        if (debug.messageEnabled()) {
            debug.message("InteractionConfig():constructed singleton instance:with Values=" + this.toString());
        }
    }

    boolean wscIncludesUserInteractionHeader() {
        return this.wscWillIncludeUserInteractionHeader;
    }

    boolean wscSupportsRedirect() {
        return this.wscWillRedirect;
    }

    QName getWSCSpecifiedInteractionChoice() {
        return this.wscSpecifiedInteractionChoice;
    }

    int getWSCSpecifiedMaxInteractionTime() {
        return this.wscSpecifiedMaxInteractionTime;
    }

    String getWSCSpecifiedConnectTo() {
        return this.wscSpecifiedConnectTo;
    }

    boolean wscEnforcesHttpsCheck() {
        return this.wscWillEnforceHttpsCheck;
    }

    int getWSPRedirectTime() {
        return this.wspRedirectTime;
    }

    String getWSPRedirectHandler() {
        return this.wspRedirectHandler;
    }

    boolean wspSupportsRedirect() {
        return this.wspWillRedirect;
    }

    boolean wspRedirectsForData() {
        return this.wspWillRedirectForData;
    }

    boolean wspEnforcesHttpsCheck() {
        return this.wspWillEnforceHttpsCheck;
    }

    boolean wspEnforcesReturnToHostEqualsRequestHost() {
        return this.wspWillEnforceReturnToHostEqualsRequestHost;
    }

    String getHTMLStyleSheetLocation() {
        return this.htmlStyleSheetLocation;
    }

    String getWMLStyleSheetLocation() {
        return this.wmlStyleSheetLocation;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("InteractionConfig:wscSpecifiedInteractionChoice=" + this.wscSpecifiedInteractionChoice);
        stringBuffer.append(":wscWillIncludeUserInteractionHeader=" + this.wscWillIncludeUserInteractionHeader);
        stringBuffer.append(":wscWillRedirect=" + this.wscWillRedirect);
        stringBuffer.append(":wscSpecifiedMaxInteractionTime=" + this.wscSpecifiedMaxInteractionTime);
        stringBuffer.append(":wscWillEnforceHttpsCheck=" + this.wscWillEnforceHttpsCheck);
        stringBuffer.append(":wscSpecifiedConnectTo=" + this.wscSpecifiedConnectTo);
        stringBuffer.append(":wspWillRedirect=" + this.wspWillRedirect);
        stringBuffer.append(":wspWillRedirectForData=" + this.wspWillRedirectForData);
        stringBuffer.append(":wspRedirectTime=" + this.wspRedirectTime);
        stringBuffer.append(":wspRedirectHandler=" + this.wspRedirectHandler);
        stringBuffer.append(":wspWillEnforceHttpsCheck=" + this.wspWillEnforceHttpsCheck);
        stringBuffer.append(":wspWillEnforceReturnToHostEqualsRequestHost=" + this.wspWillEnforceReturnToHostEqualsRequestHost);
        stringBuffer.append(":htmlStyleSheetLocation=" + this.htmlStyleSheetLocation);
        stringBuffer.append(":wmlStyleSheetLocation=" + this.wmlStyleSheetLocation);
        return stringBuffer.toString();
    }

    private void initialize() {
        String string = null;
        string = SystemProperties.get((String)WSC_SPECIFIED_INTERACTION_CHOICE);
        if (string != null) {
            if (string.equals(INTERACT_IF_NEEDED)) {
                this.wscSpecifiedInteractionChoice = InteractionManager.QNAME_INTERACT_IF_NEEDED;
            } else if (string.equals(DO_NOT_INTERACT)) {
                this.wscSpecifiedInteractionChoice = InteractionManager.QNAME_DO_NOT_INTERACT;
            } else if (string.equals(DO_NOT_INTERACT_FOR_DATA)) {
                this.wscSpecifiedInteractionChoice = InteractionManager.QNAME_DO_NOT_INTERACT_FOR_DATA;
            } else {
                if (debug.warningEnabled()) {
                    debug.warning("InteractionConfig.initialize():invalid wscSpecifiedInteractionChoice=" + string + ":defaulting to = " + INTERACT_IF_NEEDED);
                }
                this.wscSpecifiedInteractionChoice = InteractionManager.QNAME_INTERACT_IF_NEEDED;
            }
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wscSpecifiedInteractionChoice not specified :defaulting to = interactIfNeeded");
            }
            this.wscSpecifiedInteractionChoice = InteractionManager.QNAME_INTERACT_IF_NEEDED;
        }
        string = SystemProperties.get((String)WSC_WILL_INCLUDE_USER_INTERACTION_HEADER);
        if (string != null) {
            this.wscWillIncludeUserInteractionHeader = string.equalsIgnoreCase(YES);
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wscWillIncludeUerInteractionHeader not specified:defaulting to = true");
            }
            this.wscWillIncludeUserInteractionHeader = true;
        }
        string = SystemProperties.get((String)WSC_WILL_REDIRECT);
        if (string != null) {
            this.wscWillRedirect = string.equalsIgnoreCase(YES);
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wscWillRedirect not specified:defaulting to = true");
            }
            this.wscWillRedirect = true;
        }
        string = SystemProperties.get((String)WSC_SPECIFIED_MAX_INTERACTION_TIME);
        if (string != null) {
            try {
                this.wscSpecifiedMaxInteractionTime = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                debug.error("InteractionConfig.initialize():invalid wscSpecifiedMaxInteractionTime=" + string, (Throwable)numberFormatException);
                debug.error("InteractionConfig.initialize():defaulting wscSpecifiedMaxInteractionTimeto=60");
                this.wscSpecifiedMaxInteractionTime = 60;
            }
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wscSpecifiedMaxInteractionTime not specified:defaulting to = 60");
            }
            this.wscSpecifiedMaxInteractionTime = 60;
        }
        if ((string = SystemProperties.get((String)WSC_WILL_ENFORCE_HTTPS_CHECK)) != null) {
            this.wscWillEnforceHttpsCheck = string.equalsIgnoreCase(YES);
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wscWillEnforceHttpsCheck not specified:defaulting to = true");
            }
            this.wscWillEnforceHttpsCheck = true;
        }
        string = SystemProperties.get((String)WSP_WILL_REDIRECT);
        if (string != null) {
            this.wspWillRedirect = string.equalsIgnoreCase(YES);
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wspWillRedirect not specified:defaulting to = true");
            }
            this.wspWillRedirect = true;
        }
        string = SystemProperties.get((String)WSP_WILL_REDIRECT_FOR_DATA);
        if (string != null) {
            this.wspWillRedirectForData = string.equalsIgnoreCase(YES);
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wspWillRedirectForData not specified:defaulting to = true");
            }
            this.wspWillRedirectForData = true;
        }
        string = SystemProperties.get((String)WSP_REDIRECT_TIME);
        if (string != null) {
            try {
                this.wspRedirectTime = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                debug.error("InteractionConfig.initialize():invalid wspRedirectTime=" + string, (Throwable)numberFormatException);
                debug.error("InteractionConfig.initialize():defaulting wspRedirectTime=30");
                this.wspRedirectTime = 30;
            }
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wspRedirectTime not specified:defaulting to = 30");
            }
            this.wspRedirectTime = 30;
        }
        if ((string = SystemProperties.get((String)WSP_WILL_ENFORCE_HTTPS_CHECK)) != null) {
            this.wspWillEnforceHttpsCheck = string.equalsIgnoreCase(YES);
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wspWillEnforceHttpsCheck not specified:defaulting to = true");
            }
            this.wspWillEnforceHttpsCheck = true;
        }
        string = SystemProperties.get((String)WSP_WILL_ENFORCE_RETURN_TO_HOST_EQUALS_REQUEST_HOST);
        if (string != null) {
            this.wspWillEnforceReturnToHostEqualsRequestHost = string.equalsIgnoreCase(YES);
        } else {
            if (debug.warningEnabled()) {
                debug.warning("InteractionConfig.initialize():wspWillEnforceReturnToHostEqualsRequestHost not  specified:defaulting to = true");
            }
            this.wspWillEnforceReturnToHostEqualsRequestHost = true;
        }
        this.wspRedirectHandler = SystemProperties.get((String)WSP_REDIRECT_HANDLER);
        if (this.wspRedirectHandler == null) {
            debug.error("InteractionConfig.initialize():wspRedirectHandler is null");
        }
        this.htmlStyleSheetLocation = SystemProperties.get((String)HTML_STYLE_SHEET_LOCATION);
        if (this.htmlStyleSheetLocation == null) {
            debug.error("InteractionConfig.initialize():htmlStyleSheetLocation is null");
        }
        this.wmlStyleSheetLocation = SystemProperties.get((String)WML_STYLE_SHEET_LOCATION);
        if (this.wmlStyleSheetLocation == null) {
            debug.error("InteractionConfig.initialize():wmlStyleSheetLocation is null");
        }
    }
}

