/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.container;

import com.iplanet.am.util.Misc;
import com.sun.identity.liberty.ws.idpp.IDPPServiceManager;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.container.IDPPContainer;
import com.sun.identity.liberty.ws.idpp.jaxb.AnalyzedNameType;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTDate;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTString;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTURI;
import com.sun.identity.liberty.ws.idpp.plugin.AttributeMapper;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class IDPPBaseContainer
implements IDPPContainer {
    protected static IDPPServiceManager idppServiceManager;
    protected String nameScheme = idppServiceManager.getNameScheme();
    protected AttributeMapper attributeMapper = idppServiceManager.getAttributeMapper();

    public abstract Object getContainerObject(Map var1) throws IDPPException;

    public abstract Set getContainerAttributes();

    public abstract Set getContainerAttributesForSelect(String var1);

    public abstract Map getDataMapForSelect(String var1, List var2) throws IDPPException;

    public abstract boolean isSingleAttributeContainer();

    protected Map getAttributeMap(String string, Object object, Map map) {
        if (string == null || map == null) {
            IDPPUtils.debug.error("IDPPBaseContainer:getAttributeMap:nullval");
            return map;
        }
        String string2 = this.attributeMapper.getDSAttribute(string);
        if (string2 == null) {
            IDPPUtils.debug.error("IDPPBaseContainer:getAttributeMap: There's no DS Attribute mapping for this attr:" + string);
            return map;
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (object != null) {
            DSTDate dSTDate;
            Calendar calendar;
            String string3 = null;
            if (object instanceof DSTString) {
                DSTString dSTString = (DSTString)object;
                string3 = dSTString.getValue();
            } else if (object instanceof DSTURI) {
                DSTURI dSTURI = (DSTURI)object;
                string3 = dSTURI.getValue();
            } else if (object instanceof DSTDate && (calendar = (dSTDate = (DSTDate)object).getValue()) != null) {
                string3 = DateFormat.getDateInstance().format(calendar.getTime());
            }
            if (string3 != null) {
                hashSet.add(string3);
            }
        }
        map.put(string2, hashSet);
        return map;
    }

    protected Set getMapperAttributeSet(Set set) {
        if (set == null) {
            IDPPUtils.debug.error("IDPPBaseContainer:getAttributeSet:nullval");
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.attributeMapper.getDSAttribute(string);
            if (string2 == null) {
                IDPPUtils.debug.error("IDPPBaseContainer:getAttributeSet:no mapping defined for this attrib:" + string);
                continue;
            }
            hashSet.add(string2);
        }
        return hashSet;
    }

    protected DSTString getDSTString(String string) {
        if (string == null) {
            IDPPUtils.debug.message("IDPPBaseContainer:getDSTString:null vals");
            return null;
        }
        try {
            DSTString dSTString = IDPPUtils.getIDPPFactory().createDSTString();
            dSTString.setValue(string);
            return dSTString;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("IDPPBaseContainer:getDSTString:jaxbFail", (Throwable)jAXBException);
            return null;
        }
    }

    protected DSTDate getDSTDate(String string) {
        if (string == null) {
            IDPPUtils.debug.message("IDPPBaseContainer:getDSTDate:null vals");
            return null;
        }
        try {
            DSTDate dSTDate = IDPPUtils.getIDPPFactory().createDSTDate();
            Date date = DateFormat.getDateInstance(2).parse(string);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            dSTDate.setValue(calendar);
            return dSTDate;
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("IDPPBaseContainer:getDSTDate: Exception", (Throwable)exception);
            return null;
        }
    }

    protected DSTURI getDSTURI(String string) {
        if (string == null) {
            IDPPUtils.debug.message("IDPPBaseContainer:getDSTURI:null vals");
            return null;
        }
        try {
            DSTURI dSTURI = IDPPUtils.getIDPPFactory().createDSTURI();
            dSTURI.setValue(string);
            return dSTURI;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("IDPPBaseContainer:getDSTURI: Exception", (Throwable)jAXBException);
            return null;
        }
    }

    protected AnalyzedNameType getAnalyzedName(Map map) throws IDPPException {
        IDPPUtils.debug.message("IDPPContainers:getAnalyzedName:Init");
        AnalyzedNameType analyzedNameType = null;
        try {
            analyzedNameType = IDPPUtils.getIDPPFactory().createAnalyzedNameType();
            String string = Misc.getMapAttr((Map)map, (String)this.attributeMapper.getDSAttribute("SN"));
            if (string != null) {
                analyzedNameType.setSN(this.getDSTString(string));
            }
            if ((string = Misc.getMapAttr((Map)map, (String)this.attributeMapper.getDSAttribute("FN"))) != null) {
                analyzedNameType.setFN(this.getDSTString(string));
            }
            if ((string = Misc.getMapAttr((Map)map, (String)this.attributeMapper.getDSAttribute("PersonalTitle"))) != null) {
                analyzedNameType.setPersonalTitle(this.getDSTString(string));
            }
            string = Misc.getMapAttr((Map)map, (String)this.attributeMapper.getDSAttribute("MN"));
            if (this.nameScheme != null) {
                analyzedNameType.setNameScheme(this.nameScheme);
            }
            if (this.nameScheme != null && this.nameScheme.equals("urn:liberty:id-sis-pp:nameScheme:firstmiddlelast") && string != null) {
                analyzedNameType.setMN(this.getDSTString(string));
            }
            return analyzedNameType;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("IDPPContainers:getAnalyzedName: JAXB failure", (Throwable)jAXBException);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    public Document toXMLDocument(Map map) throws IDPPException {
        IDPPUtils.debug.message("IDPPBaseContainer:toXMLDocument: Init");
        if (map == null) {
            IDPPUtils.debug.error("IDPPBaseContainer:toXMLDocument:Nodata");
            throw new IDPPException(IDPPUtils.bundle.getString("noData"));
        }
        Document document = IDPPUtils.getDocumentBuilder().newDocument();
        try {
            IDPPUtils.getMarshaller().marshal(this.getContainerObject(map), (Node)document);
            return document;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("IDPPBaseContainer:toXMLDocument:JAXB exception while marshalling container .", (Throwable)jAXBException);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
        catch (IDPPException iDPPException) {
            IDPPUtils.debug.error("IDPPBaseContainer:toXMLDocument:Error retrieving common name.", (Throwable)iDPPException);
            throw new IDPPException(iDPPException);
        }
    }

    protected Set getAnalyzedNameAttributes() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("FN");
        hashSet.add("SN");
        hashSet.add("PersonalTitle");
        if (this.nameScheme != null && this.nameScheme.equals("urn:liberty:id-sis-pp:nameScheme:firstmiddlelast")) {
            hashSet.add("MN");
        }
        return this.getMapperAttributeSet(hashSet);
    }

    protected Map getAnalyzedNameMap(Object object, Map map) throws IDPPException {
        IDPPUtils.debug.message("IDPPBaseContainer:getAnalyzedNameMap:Init");
        DSTString dSTString = null;
        DSTString dSTString2 = null;
        DSTString dSTString3 = null;
        DSTString dSTString4 = null;
        if (object != null) {
            if (object instanceof AnalyzedNameType) {
                AnalyzedNameType analyzedNameType = (AnalyzedNameType)object;
                dSTString = analyzedNameType.getFN();
                dSTString2 = analyzedNameType.getSN();
                dSTString3 = analyzedNameType.getMN();
                dSTString4 = analyzedNameType.getPersonalTitle();
            } else {
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
        }
        this.getAttributeMap(this.attributeMapper.getDSAttribute("FN"), dSTString, map);
        this.getAttributeMap(this.attributeMapper.getDSAttribute("SN"), dSTString2, map);
        if (this.nameScheme != null && this.nameScheme.equals("urn:liberty:id-sis-pp:nameScheme:firstmiddlelast")) {
            this.getAttributeMap(this.attributeMapper.getDSAttribute("MN"), dSTString3, map);
        }
        this.getAttributeMap(this.attributeMapper.getDSAttribute("PersonalTitle"), dSTString4, map);
        return map;
    }

    static {
        try {
            idppServiceManager = IDPPServiceManager.getInstance();
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("IDPPBaseContainer:static initialization Failed.", (Throwable)exception);
        }
    }
}

