/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.liberty.ws.common.LogUtil;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTModification;
import com.sun.identity.liberty.ws.dst.DSTQueryItem;
import com.sun.identity.liberty.ws.dst.service.DSTRequestHandler;
import com.sun.identity.liberty.ws.idpp.IDPPServiceManager;
import com.sun.identity.liberty.ws.idpp.PPInteractionHelper;
import com.sun.identity.liberty.ws.idpp.PersonalProfile;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.jaxb.ModifyElement;
import com.sun.identity.liberty.ws.idpp.jaxb.ModifyResponseElement;
import com.sun.identity.liberty.ws.idpp.jaxb.ModifyType;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryElement;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryResponseElement;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryResponseType;
import com.sun.identity.liberty.ws.idpp.jaxb.QueryType;
import com.sun.identity.liberty.ws.idpp.jaxb.StatusType;
import com.sun.identity.liberty.ws.interaction.InteractionManager;
import com.sun.identity.liberty.ws.interaction.InteractionSOAPFaultException;
import com.sun.identity.liberty.ws.interaction.InteractionUtils;
import com.sun.identity.liberty.ws.interaction.JAXBObjectFactory;
import com.sun.identity.liberty.ws.interaction.jaxb.InquiryElement;
import com.sun.identity.liberty.ws.interaction.jaxb.InquiryType;
import com.sun.identity.liberty.ws.interaction.jaxb.InteractionResponseElement;
import com.sun.identity.liberty.ws.interaction.jaxb.TextElement;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.NamespacePrefixMapperImpl;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.log.Level;
import com.sun.identity.saml.common.SAMLUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PPRequestHandler
extends DSTRequestHandler {
    private PersonalProfile pp = new PersonalProfile();
    private Map interactedData = null;
    private String _lang = null;
    private String logMsg = null;

    public PPRequestHandler() {
        this.providerID = IDPPServiceManager.getInstance().getProviderID();
    }

    public Object processDSTRequest(Object object) throws SOAPFaultException, DSTException {
        IDPPUtils.debug.message("PPRequestHandler:processRequest:Init");
        try {
            if (object instanceof QueryElement) {
                QueryElement queryElement = (QueryElement)object;
                Document document = IDPPUtils.getDocumentBuilder().newDocument();
                IDPPUtils.getMarshaller().setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
                IDPPUtils.getMarshaller().marshal((Object)queryElement, (Node)document);
                return this.processQueryRequest(queryElement, document);
            }
            if (object instanceof ModifyElement) {
                ModifyElement modifyElement = (ModifyElement)object;
                Document document = IDPPUtils.getDocumentBuilder().newDocument();
                IDPPUtils.getMarshaller().setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
                IDPPUtils.getMarshaller().marshal((Object)modifyElement, (Node)document);
                return this.processModifyRequest(modifyElement, document);
            }
            IDPPUtils.debug.error("PPRequestHandler:processRequest:invalid Request.");
            throw new DSTException(IDPPUtils.bundle.getString("invalidRequest"));
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("PPRequestHandler:processRequest fail", (Throwable)jAXBException);
            throw new DSTException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
        catch (IDPPException iDPPException) {
            IDPPUtils.debug.error("PPRequestHandler:processRequest fail", (Throwable)iDPPException);
            throw new DSTException(iDPPException);
        }
    }

    public QueryResponseElement processQueryRequest(QueryElement queryElement, Document document) throws IDPPException, SOAPFaultException {
        Map map;
        Object object;
        List list;
        IDPPUtils.debug.message("PPRequestHandler:processQueryRequest:Init");
        if (queryElement == null || document == null) {
            IDPPUtils.debug.error("PPRequestHandler:processQueryRequest:null values ");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler:processQueryRequest:request received:" + XMLUtils.print((Node)document.getDocumentElement()));
        }
        this.interactedData = new HashMap();
        QueryResponseElement queryResponseElement = this.getQueryResponse(queryElement);
        String string = this.getResourceID(queryElement.getResourceID());
        if (string == null || !this.pp.isResourceIDValid(string)) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPRequestHandler:processQueryRequest: resource id is invalid.");
            }
            queryResponseElement.setStatus(this.setStatusType("NoResource", IDPPUtils.bundle.getString("invalidResourceID")));
            return queryResponseElement;
        }
        if (LogUtil.isLogEnabled()) {
            this.logMsg = IDPPUtils.bundle.getString("messageID") + "=" + this.requestMsg.getCorrelationHeader().getMessageID() + " " + IDPPUtils.bundle.getString("providerID") + "=" + this.providerID + " " + IDPPUtils.bundle.getString("resourceID") + "=" + string + " " + IDPPUtils.bundle.getString("securityMechID") + "=" + this.requestMsg.getAuthenticationMechanism() + " ";
        }
        if ((list = queryElement.getQueryItem()).size() == 0) {
            if (IDPPUtils.debug.warningEnabled()) {
                IDPPUtils.debug.warning("PPRequestHandler:processQueryRequest: The request does not have any query items.");
            }
            queryResponseElement.setStatus(this.setStatusType("Failed", IDPPUtils.bundle.getString("nullQueryItems")));
            return queryResponseElement;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<DSTQueryItem> arrayList = new ArrayList<DSTQueryItem>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            boolean bl = true;
            object = (QueryType.QueryItemType)list.get(n2);
            String string2 = object.getSelect();
            if (string2 == null || string2.length() == 0) {
                if (IDPPUtils.debug.warningEnabled()) {
                    IDPPUtils.debug.warning("PPRequestHandler:processQueryRequest: There is no Select in the request.");
                }
                queryResponseElement.setStatus(this.setStatusType("MissingSelect", IDPPUtils.bundle.getString("missingSelect")));
                bl = false;
            }
            if (!this.pp.isSelectDataSupported(string2)) {
                if (IDPPUtils.debug.warningEnabled()) {
                    IDPPUtils.debug.warning("PPRequestHandler:processQueryRequest: Data not supported");
                }
                queryResponseElement.setStatus(this.setStatusType("InvalidSelect", IDPPUtils.bundle.getString("invalidSelect")));
                bl = false;
            }
            String string3 = IDPPUtils.getResourceExpression(string2);
            String string4 = this.pp.getAuthZAction(this.requestMsg.getToken(), "QUERY", string3, this.getPolicyEnvMap(string));
            if (string4 == null || string4.equalsIgnoreCase("deny")) {
                queryResponseElement.setStatus(this.setStatusType("Failed", IDPPUtils.bundle.getString("notAuthorized")));
                if (LogUtil.isLogEnabled()) {
                    LogUtil.error(Level.INFO, this.logMsg + IDPPUtils.bundle.getString("notAuthorized"), "PP_Query_Failure");
                }
            } else {
                if (string4.equalsIgnoreCase("interactForConsent") || string4.equalsIgnoreCase("interactForValue")) {
                    if (this.isInteractionResponseExists(this.requestMsg)) {
                        if (!this.processInteractionResponse(true, this.requestMsg, string2, string4)) {
                            if (LogUtil.isLogEnabled()) {
                                LogUtil.error(Level.INFO, this.logMsg + IDPPUtils.bundle.getString("interactionFailed"), "PP_Interaction_Failure");
                            }
                            queryResponseElement.setStatus(this.setStatusType("Failed", IDPPUtils.bundle.getString("interactionFailed")));
                            bl = false;
                        }
                    } else {
                        hashMap.put(string3, string4);
                    }
                }
                if (bl) {
                    Calendar calendar = object.getChangedSince();
                    Date date = null;
                    if (calendar != null) {
                        date = calendar.getTime();
                    }
                    DSTQueryItem dSTQueryItem = new DSTQueryItem(string2, object.isIncludeCommonAttributes(), date, null);
                    dSTQueryItem.setId(object.getId());
                    dSTQueryItem.setItemID(object.getItemID());
                    arrayList.add(dSTQueryItem);
                }
            }
            ++n2;
        }
        if (hashMap != null && !hashMap.isEmpty()) {
            this.initInteraction(true, hashMap, this.requestMsg);
        }
        if ((object = this.getData(map = this.pp.queryData(this.requestMsg.getToken(), string, arrayList, this.interactedData, document))) != null && !object.isEmpty()) {
            queryResponseElement.getData().addAll(object);
        }
        if (LogUtil.isLogEnabled()) {
            LogUtil.access(Level.INFO, this.logMsg + IDPPUtils.bundle.getString("querySuccess"), "PP_Query_Success");
        }
        return queryResponseElement;
    }

    private List getData(Map map) throws IDPPException {
        IDPPUtils.debug.message("PPRequestHandler:getData:Init");
        ArrayList<QueryResponseType.DataType> arrayList = new ArrayList<QueryResponseType.DataType>();
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            QueryResponseType.DataType dataType = null;
            try {
                dataType = IDPPUtils.getIDPPFactory().createQueryResponseTypeDataType();
            }
            catch (JAXBException jAXBException) {
                IDPPUtils.debug.error("PPRequestHandler:getData:jaxb fail", (Throwable)jAXBException);
                throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
            }
            DSTQueryItem dSTQueryItem = (DSTQueryItem)iterator.next();
            List list = (List)map.get(dSTQueryItem);
            if (list.isEmpty()) continue;
            dataType.getAny().addAll(list);
            dataType.setItemIDRef(dSTQueryItem.getItemID());
            dataType.setId(dSTQueryItem.getId());
            arrayList.add(dataType);
        }
        return arrayList;
    }

    private StatusType setStatusType(String string, String string2) throws IDPPException {
        IDPPUtils.debug.message("PPRequestHandler:setStatusType:Init");
        if (string == null) {
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        try {
            StatusType statusType = IDPPUtils.getIDPPFactory().createStatusType();
            QName qName = new QName("urn:liberty:id-sis-pp:2003-08", string);
            statusType.setCode(qName);
            if (string2 != null) {
                statusType.setComment(string2);
            }
            return statusType;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("PPRequestHandler:setStatusType:jaxb failure:", (Throwable)jAXBException);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    public ModifyResponseElement processModifyRequest(ModifyElement modifyElement, Document document) throws IDPPException, SOAPFaultException {
        List list;
        IDPPUtils.debug.message("PPRequestHandler:processModifyRequest:Init");
        if (modifyElement == null) {
            IDPPUtils.debug.error("PPRequestHandler:processModifyRequest. null values");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler:processModifyRequest:request received:" + XMLUtils.print((Node)document.getDocumentElement()));
        }
        this.interactedData = new HashMap();
        ModifyResponseElement modifyResponseElement = this.getModifyResponse(modifyElement);
        String string = this.getResourceID(modifyElement.getResourceID());
        if (string == null || !this.pp.isResourceIDValid(string)) {
            if (IDPPUtils.debug.warningEnabled()) {
                IDPPUtils.debug.warning("PPRequestHandler:processModifyRequest: resource id is invalid.");
            }
            modifyResponseElement.setStatus(this.setStatusType("NoResource", IDPPUtils.bundle.getString("invalidResourceID")));
            return modifyResponseElement;
        }
        if (LogUtil.isLogEnabled()) {
            this.logMsg = IDPPUtils.bundle.getString("messageID") + "=" + this.requestMsg.getCorrelationHeader().getMessageID() + " " + IDPPUtils.bundle.getString("providerID") + "=" + this.providerID + " " + IDPPUtils.bundle.getString("resourceID") + "=" + string + " " + IDPPUtils.bundle.getString("securityMechID") + "=" + this.requestMsg.getAuthenticationMechanism() + " ";
        }
        if ((list = modifyElement.getModification()).size() == 0) {
            IDPPUtils.debug.error("PPRequestHandler:processModifyRequest: Modification elements are null");
            modifyResponseElement.setStatus(this.setStatusType("Failed", IDPPUtils.bundle.getString("nullModifications")));
            return modifyResponseElement;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<DSTModification> arrayList = new ArrayList<DSTModification>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ModifyType.ModificationType modificationType = (ModifyType.ModificationType)list.get(n2);
            String string2 = modificationType.getSelect();
            if (string2 == null || string2.length() == 0) {
                if (IDPPUtils.debug.warningEnabled()) {
                    IDPPUtils.debug.warning("PersonalProfileService:processModifyRequest: select is null");
                }
                modifyResponseElement.setStatus(this.setStatusType("MissingSelect", IDPPUtils.bundle.getString("missingSelect")));
                return modifyResponseElement;
            }
            if (!this.pp.isSelectDataSupported(string2)) {
                if (IDPPUtils.debug.warningEnabled()) {
                    IDPPUtils.debug.warning("PersonalProfileService:processModifyRequest: Data not supported");
                }
                modifyResponseElement.setStatus(this.setStatusType("InvalidSelect", IDPPUtils.bundle.getString("invalidSelect")));
                return modifyResponseElement;
            }
            String string3 = IDPPUtils.getResourceExpression(string2);
            String string4 = this.pp.getAuthZAction(this.requestMsg.getToken(), "MODIFY", string3, this.getPolicyEnvMap(string));
            if (string4 == null || string4.equalsIgnoreCase("deny")) {
                modifyResponseElement.setStatus(this.setStatusType("Failed", IDPPUtils.bundle.getString("notAuthorized")));
                if (LogUtil.isLogEnabled()) {
                    LogUtil.error(Level.INFO, this.logMsg + IDPPUtils.bundle.getString("notAuthorized"), "PP_Modify_Failure");
                }
                return modifyResponseElement;
            }
            if (string4.equalsIgnoreCase("interactForConsent") || string4.equalsIgnoreCase("interactForValue")) {
                if (this.isInteractionResponseExists(this.requestMsg)) {
                    if (!this.processInteractionResponse(false, this.requestMsg, string2, string4)) {
                        if (LogUtil.isLogEnabled()) {
                            LogUtil.error(Level.INFO, this.logMsg + IDPPUtils.bundle.getString("interactionFailed"), "PP_Interaction_Failure");
                        }
                        modifyResponseElement.setStatus(this.setStatusType("Failed", IDPPUtils.bundle.getString("interactionFailed")));
                        return modifyResponseElement;
                    }
                } else {
                    hashMap.put(string3, string4);
                }
            }
            boolean bl = modificationType.isOverrideAllowed();
            ModifyType.ModificationType.NewDataType newDataType = modificationType.getNewData();
            DSTModification dSTModification = new DSTModification();
            dSTModification.setSelect(string2);
            dSTModification.setOverrideAllowed(bl);
            dSTModification.setId(modificationType.getId());
            arrayList.add(dSTModification);
            if (newDataType != null && newDataType.getAny() != null && newDataType.getAny().size() != 0) {
                dSTModification.setNewDataValue(newDataType.getAny());
            }
            ++n2;
        }
        if (hashMap != null && !hashMap.isEmpty()) {
            this.initInteraction(false, hashMap, this.requestMsg);
        }
        if (this.pp.modifyData(this.requestMsg.getToken(), string, arrayList, this.interactedData, document)) {
            if (LogUtil.isLogEnabled()) {
                LogUtil.access(Level.INFO, this.logMsg + IDPPUtils.bundle.getString("modifySuccess"), "PP_Modify_Success");
            }
            return modifyResponseElement;
        }
        modifyResponseElement.setStatus(this.setStatusType("Failed", IDPPUtils.bundle.getString("modifyFailed")));
        if (LogUtil.isLogEnabled()) {
            LogUtil.error(Level.INFO, this.logMsg + IDPPUtils.bundle.getString("modifyFailed"), "PP_Modify_Failure");
        }
        return modifyResponseElement;
    }

    private Map getPolicyEnvMap(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("message", this.requestMsg);
        hashMap.put("userID", this.pp.getUserDN(string));
        hashMap.put("authType", this.requestMsg.getAuthenticationMechanism());
        return hashMap;
    }

    public QueryResponseElement getQueryResponse(QueryElement queryElement) throws IDPPException {
        if (queryElement == null) {
            IDPPUtils.debug.error("PPRequestHandler:getQueryResponse:Query is null.");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        try {
            QueryResponseElement queryResponseElement = IDPPUtils.getIDPPFactory().createQueryResponseElement();
            queryResponseElement.setStatus(this.setStatusType("ok", null));
            queryResponseElement.setId(SAMLUtils.generateID());
            queryResponseElement.setItemIDRef(queryElement.getItemID());
            return queryResponseElement;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("PPRequestHandler:getQueryResponse:JAXB failure.", (Throwable)jAXBException);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    public ModifyResponseElement getModifyResponse(ModifyElement modifyElement) throws IDPPException {
        if (modifyElement == null) {
            IDPPUtils.debug.error("PPRequestHandler:getModifyResponse:Modify is null.");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        try {
            ModifyResponseElement modifyResponseElement = IDPPUtils.getIDPPFactory().createModifyResponseElement();
            modifyResponseElement.setStatus(this.setStatusType("ok", null));
            modifyResponseElement.setId(SAMLUtils.generateID());
            modifyResponseElement.setItemIDRef(modifyElement.getItemID());
            return modifyResponseElement;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("PPRequestHandler:getModifyResponse:JAXB failure.", (Throwable)jAXBException);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    private boolean isInteractionResponseExists(Message message) {
        try {
            return InteractionManager.getInstance().getInteractionResponseElement(message) != null;
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("PPRequestHandler.isInteractionResponseExists: Exception while getting interaction response.", (Throwable)exception);
            return false;
        }
    }

    private void initInteraction(boolean bl, Map map, Message message) throws SOAPFaultException, IDPPException {
        IDPPUtils.debug.message("PPRequestHandler.initInteraction:Init");
        if (message == null || map == null || map.isEmpty()) {
            IDPPUtils.debug.error("PPRequestHandler.initInteraction:NullInput parameters");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        try {
            InquiryElement inquiryElement = JAXBObjectFactory.getObjectFactory().createInquiryElement();
            inquiryElement.setTitle(IDPPUtils.bundle.getString("interactionTitle"));
            List list = inquiryElement.getSelectOrConfirmOrText();
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                if (string2.equals("interactForConsent")) {
                    list.add(this.getInteractConfirmElement(bl, string));
                    continue;
                }
                if (!string2.equals("interactForValue")) continue;
                list.addAll(this.getInteractTextElements(bl, string));
            }
            this.setLanguage();
            if (LogUtil.isLogEnabled()) {
                LogUtil.access(Level.INFO, this.logMsg + IDPPUtils.bundle.getString("interactionInitiated"), "PP_Interaction_Success");
            }
            InteractionManager.getInstance().handleInteraction(message, inquiryElement, this._lang);
        }
        catch (InteractionSOAPFaultException interactionSOAPFaultException) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPRequestHandler.initInteraction:Interact redirection happened");
            }
            throw interactionSOAPFaultException.getSOAPFaultException();
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("PPRequestHandler.initInteraction:Failed");
            throw new IDPPException(exception);
        }
    }

    private InquiryType.Confirm getInteractConfirmElement(boolean bl, String string) throws IDPPException {
        if (string == null) {
            IDPPUtils.debug.error("PPRequestHandler.getInteractConfirmElement:Null input:");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        string = IDPPUtils.getExpressionContext(string);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler.getInteractConfirm:Resource Context:" + string);
        }
        try {
            InquiryType.Confirm confirm = JAXBObjectFactory.getObjectFactory().createInquiryTypeConfirm();
            PPInteractionHelper pPInteractionHelper = new PPInteractionHelper(this._lang);
            confirm.setName(string);
            confirm.setLabel(pPInteractionHelper.getInteractForConsentQuestion(bl, string));
            confirm.setHint(pPInteractionHelper.getInteractForConsentQuestion(bl, string));
            return confirm;
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("PPRequestHandler.getInteractConfirm:Exception while creating interact select.", (Throwable)exception);
            throw new IDPPException(exception);
        }
    }

    private List getInteractTextElements(boolean bl, String string) throws IDPPException {
        if (string == null) {
            IDPPUtils.debug.error("PPRequestHandler.getInteractText:Null input:");
            throw new IDPPException(IDPPUtils.bundle.getString("nullInputParams"));
        }
        string = IDPPUtils.getExpressionContext(string);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler.getInteractText:Resource Context:" + string);
        }
        try {
            ArrayList<TextElement> arrayList = new ArrayList<TextElement>();
            PPInteractionHelper pPInteractionHelper = new PPInteractionHelper(this._lang);
            Map map = pPInteractionHelper.getInteractForValueQuestions(bl, string);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                TextElement textElement = JAXBObjectFactory.getObjectFactory().createTextElement();
                textElement.setName(string2);
                textElement.setLabel((String)map.get(string2));
                textElement.setMinChars(pPInteractionHelper.getTextMinChars(string2));
                textElement.setMaxChars(pPInteractionHelper.getTextMaxChars(string2));
                arrayList.add(textElement);
            }
            return arrayList;
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("PPRequestHandler.getInteractText:Exception while creating interact text element.", (Throwable)exception);
            throw new IDPPException(exception);
        }
    }

    private boolean processInteractionResponse(boolean bl, Message message, String string, String string2) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler.processInteractionResponse:Init");
        }
        if (message == null || string == null || string2 == null) {
            IDPPUtils.debug.error("PPRequestHandler:processInteractionResponse:null input params");
            return false;
        }
        string = IDPPUtils.getExpressionContext(string);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler:processInteractionPP Element that was trying to access:" + string);
        }
        try {
            InteractionResponseElement interactionResponseElement = InteractionManager.getInstance().getInteractionResponseElement(message);
            if (interactionResponseElement == null) {
                return false;
            }
            Map map = InteractionUtils.getParameters(interactionResponseElement);
            if (map == null || map.isEmpty()) {
                return false;
            }
            this.setLanguage();
            PPInteractionHelper pPInteractionHelper = new PPInteractionHelper(this._lang);
            if (string2.equals("interactForConsent")) {
                String string3 = (String)map.get(string);
                if (string3 == null || string3.equals("false")) {
                    if (IDPPUtils.debug.messageEnabled()) {
                        IDPPUtils.debug.message("PPRequestHandler.processInteraction: response is deny");
                    }
                    return false;
                }
                return true;
            }
            if (string2.equals("interactForValue")) {
                Map map2 = pPInteractionHelper.getInteractForValueQuestions(bl, string);
                Iterator iterator = map2.keySet().iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    String string5 = (String)map.get(string4);
                    if (string5 == null || string5.equals("")) {
                        return false;
                    }
                    this.interactedData.put(pPInteractionHelper.getPPAttribute(string4), string5);
                }
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("PPRequestHandler.processInteractionResponse: Exception occured.", (Throwable)exception);
            return false;
        }
    }

    private void setLanguage() {
        List list = InteractionUtils.getInteractionLangauge(this.requestMsg);
        if (list == null || list.isEmpty()) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPRequestHandler.setLanguage: LanguageHeaders are empty in the interaction message.");
            }
            return;
        }
        this._lang = (String)list.iterator().next();
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("PPRequestHandler.setLanguage:Lang:" + this._lang);
        }
    }
}

