/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst.service;

import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.jaxb.EncryptedResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.RequestHandler;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import java.util.ArrayList;
import java.util.List;

public abstract class DSTRequestHandler
implements RequestHandler {
    protected Message requestMsg;
    protected String providerID;

    public Message processRequest(Message message) throws SOAPFaultException, Exception {
        if (DSTUtils.debug.messageEnabled()) {
            DSTUtils.debug.message("DSTRequestHandler:processRequest:Request received: " + message.toString());
        }
        this.requestMsg = message;
        List list = message.getBodies();
        if ((list = Utils.convertElementToJAXB(list)) == null || list.size() == 0) {
            DSTUtils.debug.error("DSTRequestHandler:processRequest:SOAPBodies are null");
            throw new Exception(DSTUtils.bundle.getString("nullInputParams"));
        }
        List list2 = this.processSOAPBodies(list);
        list2 = Utils.convertJAXBToElement(list2);
        Message message2 = null;
        ProviderHeader providerHeader = new ProviderHeader(this.providerID);
        int n = message.getSecurityProfileType();
        message2 = n == 1 || n == 2 ? new Message(providerHeader, this.generateBinarySecurityToken()) : new Message(providerHeader);
        message2.setCorrelationHeader(message.getCorrelationHeader());
        message2.setSOAPBodies(list2);
        if (DSTUtils.debug.messageEnabled()) {
            DSTUtils.debug.message("DSTRequestHandler:processRequest:returned response: " + message2.toString());
        }
        return message2;
    }

    private List processSOAPBodies(List list) throws SOAPFaultException, DSTException {
        DSTUtils.debug.message("DSTRequestHandler:processSOAPBodies:Init");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = list.get(n2);
            arrayList.add(this.processDSTRequest(e));
            ++n2;
        }
        return arrayList;
    }

    public Message getMessage() {
        return this.requestMsg;
    }

    protected BinarySecurityToken generateBinarySecurityToken() throws DSTException {
        try {
            SecurityTokenManager securityTokenManager = new SecurityTokenManager(this.requestMsg.getToken());
            return securityTokenManager.getX509CertificateToken();
        }
        catch (Exception exception) {
            DSTUtils.debug.error("DSTRequestHandler:generateBinarySecurityToken: Error in generating binary security token.", (Throwable)exception);
            throw new DSTException(exception);
        }
    }

    protected abstract Object processDSTRequest(Object var1) throws SOAPFaultException, DSTException;

    protected String getResourceID(Object object) {
        DSTUtils.debug.message("DSTRequestHandler:getResourceID:Init");
        if (object == null) {
            if (DSTUtils.debug.messageEnabled()) {
                DSTUtils.debug.message("DSTRequestHandler:getResourceID:ResourceIDType is null");
            }
            return null;
        }
        if (object instanceof ResourceIDType) {
            ResourceIDType resourceIDType = (ResourceIDType)object;
            return resourceIDType.getValue();
        }
        if (object instanceof EncryptedResourceIDType) {
            return null;
        }
        DSTUtils.debug.error("DSTRequestHandler:getResourceID:invalidresource ID type.");
        return null;
    }
}

