/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.sun.identity.liberty.ws.common.Status;
import com.sun.identity.liberty.ws.dst.DSTData;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import com.sun.identity.saml.common.SAMLUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSTQueryResponse {
    private Status dstStatus = null;
    private String itemIDRef = null;
    private String id = null;
    private Date dateStamp = null;
    private List data = new ArrayList();
    private List extensions = new ArrayList();
    private String nameSpaceURI = null;
    private String prefix = null;

    public DSTQueryResponse() {
    }

    public DSTQueryResponse(List list, String string) {
        if (list != null) {
            this.data = list;
        }
        this.nameSpaceURI = string;
    }

    public DSTQueryResponse(Element element) throws DSTException {
        NodeList nodeList;
        if (element == null) {
            DSTUtils.debug.error("DSTQueryResponse(element):null input");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        String string = element.getLocalName();
        if (string == null || !string.equals("QueryResponse")) {
            DSTUtils.debug.error("DSTQueryResponse(element):Invalid element name");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        this.nameSpaceURI = element.getNamespaceURI();
        if (this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTQueryResponse(element): NameSpace is not defined");
            throw new DSTException(DSTUtils.bundle.getString("noNameSpace"));
        }
        this.prefix = element.getPrefix();
        this.id = element.getAttribute("id");
        this.itemIDRef = element.getAttribute("itemIDRef");
        String string2 = element.getAttribute("timeStamp");
        if (string2 != null) {
            try {
                this.dateStamp = SAMLUtils.stringToDate(string2);
            }
            catch (Exception exception) {
                DSTUtils.debug.error("DSTQueryResponse(element): can not parse the date", (Throwable)exception);
            }
        }
        if ((nodeList = element.getElementsByTagNameNS(this.nameSpaceURI, "Status")).getLength() == 0) {
            DSTUtils.debug.error("DSTQueryResponse(element): Response doesnot have status element.");
            throw new DSTException(DSTUtils.bundle.getString("noStatus"));
        }
        Node node = nodeList.item(0);
        this.dstStatus = DSTUtils.parseStatus((Element)node);
        NodeList nodeList2 = element.getElementsByTagNameNS(this.nameSpaceURI, "Data");
        int n = nodeList2.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.data.add(new DSTData((Element)nodeList2.item(n2)));
            ++n2;
        }
    }

    public Status getStatus() {
        return this.dstStatus;
    }

    public void setStatus(Status status) {
        this.dstStatus = status;
    }

    public Date getTimeStamp() {
        return this.dateStamp;
    }

    public void setTimeStamp(Date date) {
        this.dateStamp = date;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getItemIDRef() {
        return this.itemIDRef;
    }

    public void setItemIDRef(String string) {
        this.itemIDRef = string;
    }

    public List getData() {
        return this.data;
    }

    public List getExtension() {
        return this.extensions;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String string) {
        this.nameSpaceURI = string;
    }

    public void setNameSpacePrefix(String string) {
        this.prefix = string;
    }

    public String getNameSpacePrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        Object object;
        StringBuffer stringBuffer;
        String string;
        block10: {
            if (this.dstStatus == null) {
                DSTUtils.debug.error("DSTQueryResponse.toString: Status is null");
                return "";
            }
            string = "";
            if (bl) {
                if (this.prefix == null) {
                    this.prefix = "sis";
                }
                string = this.prefix + ":";
            }
            if (bl2 && this.nameSpaceURI == null) {
                DSTUtils.debug.error("DSTQueryResponse.toString: Name Space is not defined");
                return "";
            }
            stringBuffer = new StringBuffer(500);
            stringBuffer.append("<").append(string).append("QueryResponse");
            if (this.id != null) {
                stringBuffer.append(" id=\"").append(this.id).append("\"");
            }
            if (this.itemIDRef != null) {
                stringBuffer.append(" itemIDRef=\"").append(this.itemIDRef).append("\"");
            }
            if (this.dateStamp != null) {
                try {
                    object = SAMLUtils.dateToString(this.dateStamp);
                    stringBuffer.append(" timeStamp=\"").append((String)object).append("\"");
                }
                catch (Exception exception) {
                    if (!DSTUtils.debug.messageEnabled()) break block10;
                    DSTUtils.debug.message("DSTQueryResponse.toString: can not parse the time stamp.");
                }
            }
        }
        stringBuffer.append(">").append("\n").append(this.dstStatus.toString());
        object = this.data.iterator();
        while (object.hasNext()) {
            DSTData dSTData = (DSTData)object.next();
            stringBuffer.append(dSTData.toString());
        }
        stringBuffer.append("</").append(string).append("QueryResponse").append(">");
        return stringBuffer.toString();
    }
}

