/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.sun.identity.liberty.ws.common.Status;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import com.sun.identity.saml.common.SAMLUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSTModifyResponse {
    private Status status;
    private Date timeStamp;
    private String id;
    private String itemIDRef;
    private List extension = new ArrayList();
    private String nameSpaceURI = null;
    private String prefix = null;

    public DSTModifyResponse() {
    }

    public DSTModifyResponse(Element element) throws DSTException {
        NodeList nodeList;
        if (element == null) {
            DSTUtils.debug.error("DSTModifyResponse(element):null input");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        String string = element.getLocalName();
        if (string == null || !string.equals("ModifyResponse")) {
            DSTUtils.debug.error("DSTModifyResponse(element):Invalid element name");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        this.nameSpaceURI = element.getNamespaceURI();
        if (this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTModifyResponse(element): NameSpace is not defined");
            throw new DSTException(DSTUtils.bundle.getString("noNameSpace"));
        }
        this.prefix = element.getPrefix();
        this.id = element.getAttribute("id");
        this.itemIDRef = element.getAttribute("itemIDRef");
        String string2 = element.getAttribute("timeStamp");
        if (string2 != null) {
            try {
                this.timeStamp = SAMLUtils.stringToDate(string2);
            }
            catch (Exception exception) {
                DSTUtils.debug.error("DSTModifyResponse(element): can not parse the date", (Throwable)exception);
            }
        }
        if ((nodeList = element.getElementsByTagNameNS(this.nameSpaceURI, "Status")).getLength() == 0) {
            DSTUtils.debug.error("DSTModifyResponse(element): Response doesnot have status element.");
            throw new DSTException(DSTUtils.bundle.getString("noStatus"));
        }
        Node node = nodeList.item(0);
        this.status = DSTUtils.parseStatus((Element)node);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Date date) {
        this.timeStamp = date;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getItemIDRef() {
        return this.itemIDRef;
    }

    public void setItemIDRef(String string) {
        this.itemIDRef = string;
    }

    List getExtension() {
        return this.extension;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String string) {
        this.nameSpaceURI = string;
    }

    public void setNameSpacePrefix(String string) {
        this.prefix = string;
    }

    public String getNameSpacePrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer;
        String string;
        block9: {
            string = "";
            if (bl) {
                if (this.prefix == null) {
                    this.prefix = "sis";
                }
                string = this.prefix + ":";
            }
            if (bl2 && this.nameSpaceURI == null) {
                DSTUtils.debug.error("DSTModifyResponse.toString: NameSpace is not defined");
                return "";
            }
            stringBuffer = new StringBuffer(300);
            stringBuffer.append("<").append(string).append("ModifyResponse");
            if (this.id != null) {
                stringBuffer.append(" id=\"").append(this.id).append("\"");
            }
            if (this.itemIDRef != null) {
                stringBuffer.append(" itemIDRef=\"").append(this.itemIDRef).append("\"");
            }
            if (this.timeStamp != null) {
                try {
                    String string2 = SAMLUtils.dateToString(this.timeStamp);
                    stringBuffer.append(" timeStamp=\"").append(string2).append("\"");
                }
                catch (Exception exception) {
                    if (!DSTUtils.debug.messageEnabled()) break block9;
                    DSTUtils.debug.message("DSTModifyResponse.toString: timeStamp can not be parsed");
                }
            }
        }
        if (bl2) {
            stringBuffer.append(" xmlns:").append(this.prefix).append("=\"").append(this.nameSpaceURI).append("\"").append(" xmlns=\"").append(this.nameSpaceURI).append("\"");
        }
        stringBuffer.append(">").append(this.status.toString()).append("</").append(string).append("ModifyResponse").append(">");
        return stringBuffer.toString();
    }
}

