/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTModification;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSTModify {
    private String resourceID;
    private EncryptedResourceID encryptedResourceID;
    private List modification = new ArrayList();
    private String itemID;
    private String id;
    private List extension = new ArrayList();
    private String nameSpaceURI = null;
    private String prefix = null;

    public DSTModify() {
    }

    public DSTModify(String string, List list, String string2) {
        this.resourceID = string;
        if (list != null) {
            this.modification.addAll(list);
            DSTModification dSTModification = (DSTModification)list.get(0);
            this.nameSpaceURI = string2 == null ? dSTModification.getNameSpaceURI() : string2;
            this.prefix = dSTModification.getNameSpacePrefix();
        }
    }

    public DSTModify(EncryptedResourceID encryptedResourceID, List list, String string) {
        this.encryptedResourceID = encryptedResourceID;
        if (list != null) {
            this.modification.addAll(list);
            DSTModification dSTModification = (DSTModification)list.get(0);
            this.nameSpaceURI = string == null ? dSTModification.getNameSpaceURI() : string;
            this.prefix = dSTModification.getNameSpacePrefix();
        }
    }

    public DSTModify(Element element) throws DSTException {
        if (element == null) {
            DSTUtils.debug.error("DSTModify(element):null input");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        String string = element.getLocalName();
        if (string == null || !string.equals("Modify")) {
            DSTUtils.debug.error("DSTModify(element):Invalid element name");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        this.nameSpaceURI = element.getNamespaceURI();
        if (this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTModify(element): NameSpace is not defined");
            throw new DSTException(DSTUtils.bundle.getString("noNameSpace"));
        }
        this.prefix = element.getPrefix();
        this.id = element.getAttribute("id");
        this.itemID = element.getAttribute("itemID");
        NodeList nodeList = element.getElementsByTagNameNS(this.nameSpaceURI, "ResourceID");
        if (nodeList.getLength() == 0 || nodeList.getLength() > 1) {
            DSTUtils.debug.error("DSTModify(element): ResourceIDNode is null or more than one resource id is found.");
            throw new DSTException(DSTUtils.bundle.getString("invalidResourceID"));
        }
        Node node = nodeList.item(0);
        this.resourceID = node.getNodeValue();
        if (this.resourceID == null) {
            DSTUtils.debug.error("DSTModify(element): ResourceID is null");
            throw new DSTException(DSTUtils.bundle.getString("invalidResourceID"));
        }
        NodeList nodeList2 = element.getElementsByTagNameNS(this.nameSpaceURI, "Modification");
        if (nodeList2 == null || nodeList2.getLength() == 0) {
            DSTUtils.debug.error("DSTModify(element): Modifications are null");
            throw new DSTException(DSTUtils.bundle.getString("nullModifications"));
        }
        int n = nodeList2.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList2.item(0);
            DSTModification dSTModification = new DSTModification((Element)node2);
            this.modification.add(dSTModification);
            ++n2;
        }
    }

    public List getModification() {
        return this.modification;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public EncryptedResourceID getEncryptedResourceID() {
        return this.encryptedResourceID;
    }

    public void setEncryptedResourceID(EncryptedResourceID encryptedResourceID) {
        this.encryptedResourceID = encryptedResourceID;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(String string) {
        this.resourceID = string;
    }

    public String getItemID() {
        return this.itemID;
    }

    public void setItemID(String string) {
        this.itemID = string;
    }

    public List getExtension() {
        return this.extension;
    }

    public void setExtension(List list) {
        if (list != null) {
            this.extension.addAll(list);
        }
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String string) {
        this.nameSpaceURI = string;
    }

    public void setNameSpacePrefix(String string) {
        this.prefix = string;
    }

    public String getNameSpacePrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        String string = "";
        if (bl) {
            if (this.prefix == null) {
                this.prefix = "sis";
            }
            string = this.prefix + ":";
        }
        if (bl2 && this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTModify.toString: Name Space is not defined");
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<").append(string).append("Modify");
        if (this.id != null) {
            stringBuffer.append(" id=\"").append(this.id).append("\"");
        }
        if (this.itemID != null) {
            stringBuffer.append(" itemID=\"").append(this.itemID).append("\"");
        }
        if (bl2) {
            stringBuffer.append(" xmlns:").append(this.prefix).append("=\"").append(this.nameSpaceURI).append("\"").append(" xmlns=\"").append(this.nameSpaceURI).append("\"");
        }
        stringBuffer.append(">").append("<").append(string).append("ResourceID").append(">").append(this.resourceID).append("</").append(string).append("ResourceID").append(">");
        Iterator iterator = this.modification.iterator();
        while (iterator.hasNext()) {
            DSTModification dSTModification = (DSTModification)iterator.next();
            stringBuffer.append(dSTModification.toString());
        }
        stringBuffer.append("</").append(string).append("Modify").append(">");
        if (DSTUtils.debug.messageEnabled()) {
            DSTUtils.debug.message("DSTModify.toString: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }
}

