/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSTData {
    private List dstData = new ArrayList();
    private String itemIDRef;
    private String id;
    private String nameSpaceURI = null;
    private String prefix = null;

    public DSTData(List list, String string) {
        if (list != null) {
            this.dstData.addAll(list);
        }
        this.nameSpaceURI = string;
    }

    public DSTData(Element element) throws DSTException {
        if (element == null) {
            DSTUtils.debug.error("DSTData(element):null input");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        String string = element.getLocalName();
        if (string == null || !string.equals("Data")) {
            DSTUtils.debug.error("DSTData(element):Invalid element name");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        this.nameSpaceURI = element.getNamespaceURI();
        if (this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTData(element): NameSpace is not defined");
            throw new DSTException(DSTUtils.bundle.getString("noNameSpace"));
        }
        this.prefix = element.getPrefix();
        this.id = element.getAttribute("id");
        this.itemIDRef = element.getAttribute("itemIDRef");
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(0);
            if (node.getNodeType() == 1) {
                this.dstData.add((Element)node);
            }
            ++n2;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getItemIDRef() {
        return this.itemIDRef;
    }

    public void setItemIDRef(String string) {
        this.itemIDRef = string;
    }

    public List getData() {
        return this.dstData;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String string) {
        this.nameSpaceURI = string;
    }

    public void setNameSpacePrefix(String string) {
        this.prefix = string;
    }

    public String getNameSpacePrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        String string = "";
        if (bl) {
            if (this.prefix == null) {
                this.prefix = "sis";
            }
            string = this.prefix + ":";
        }
        if (bl2 && this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTData.toString: Name Space is not defined");
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<").append(string).append("Data");
        if (this.id != null) {
            stringBuffer.append(" id=\"").append(this.id).append("\"");
        }
        if (this.itemIDRef != null) {
            stringBuffer.append(" itemIDRef=\"").append(this.itemIDRef).append("\"");
        }
        if (bl2) {
            stringBuffer.append(" xmlns:").append(this.prefix).append("=\"").append(this.nameSpaceURI).append("\"").append(" xmlns=\"").append(this.nameSpaceURI).append("\"");
        }
        stringBuffer.append(">");
        Iterator iterator = this.dstData.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            stringBuffer.append(XMLUtils.print((Node)node));
        }
        stringBuffer.append("</").append(string).append("Data").append(">");
        return stringBuffer.toString();
    }
}

