/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.iplanet.sso.SSOToken;
import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.Description;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.ServiceInstance;
import com.sun.identity.liberty.ws.disco.jaxb.DescriptionType;
import com.sun.identity.liberty.ws.disco.jaxb.EncryptedResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceOfferingType;
import com.sun.identity.liberty.ws.disco.jaxb.ServiceInstanceType;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTModify;
import com.sun.identity.liberty.ws.dst.DSTModifyResponse;
import com.sun.identity.liberty.ws.dst.DSTQuery;
import com.sun.identity.liberty.ws.dst.DSTQueryResponse;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import com.sun.identity.liberty.ws.interaction.InteractionException;
import com.sun.identity.liberty.ws.interaction.InteractionManager;
import com.sun.identity.liberty.ws.interaction.InteractionRedirectException;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.soapbinding.Client;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Element;

public class DSTClient {
    private String resourceID = null;
    private EncryptedResourceID encryptedResourceID = null;
    private String soapURI = null;
    private String certAlias = null;
    private SecurityAssertion assertion = null;
    private BinarySecurityToken token = null;
    private boolean isEncryptedResourceID = false;
    private int securityProfile = 0;
    private String soapAction = null;
    private String serviceType = null;
    private HttpServletRequest httpRequest = null;
    private HttpServletResponse httpResponse = null;
    private boolean clientAuthEnabled = false;
    private String providerID = null;

    public DSTClient(String string, String string2) {
        this.soapURI = string;
        this.providerID = string2;
        this.securityProfile = 0;
    }

    public DSTClient(SecurityAssertion securityAssertion, String string, String string2) {
        this.assertion = securityAssertion;
        this.soapURI = string;
        this.providerID = string2;
        this.securityProfile = 2;
    }

    public DSTClient(BinarySecurityToken binarySecurityToken, String string, String string2) {
        this.token = binarySecurityToken;
        this.soapURI = string;
        this.securityProfile = 1;
        this.providerID = string2;
    }

    public DSTClient(String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.soapURI = string;
        this.securityProfile = 0;
        this.httpRequest = httpServletRequest;
        this.httpResponse = httpServletResponse;
        this.providerID = string2;
    }

    public DSTClient(SecurityAssertion securityAssertion, String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.httpRequest = httpServletRequest;
        this.httpResponse = httpServletResponse;
        this.assertion = securityAssertion;
        this.soapURI = string;
        this.securityProfile = 2;
        this.providerID = string2;
    }

    public DSTClient(BinarySecurityToken binarySecurityToken, String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.token = binarySecurityToken;
        this.soapURI = string;
        this.securityProfile = 1;
        this.httpRequest = httpServletRequest;
        this.httpResponse = httpServletResponse;
        this.providerID = string2;
    }

    private void parseResourceOffering(ResourceOfferingType resourceOfferingType) throws DSTException {
        if (resourceOfferingType == null) {
            DSTUtils.debug.error("DSTClient:offering is null");
            throw new DSTException("offering is null");
        }
        EncryptedResourceIDType encryptedResourceIDType = resourceOfferingType.getEncryptedResourceID();
        if (encryptedResourceIDType != null) {
            DSTUtils.debug.error("DSTClient: encrypted resource id found.");
            throw new DSTException("DSTClient: unsupported");
        }
        ResourceIDType resourceIDType = resourceOfferingType.getResourceID();
        if (resourceIDType == null) {
            DSTUtils.debug.error("DSTClient: resource id element is null");
            throw new DSTException("null resource id element");
        }
        this.resourceID = resourceIDType.getValue();
        if (this.resourceID == null) {
            DSTUtils.debug.error("DSTClient: resource id value is null");
            throw new DSTException("null resource id value");
        }
        ServiceInstanceType serviceInstanceType = resourceOfferingType.getServiceInstance();
        if (serviceInstanceType == null) {
            throw new DSTException("service instance is null");
        }
        this.providerID = serviceInstanceType.getProviderID();
        List list = serviceInstanceType.getDescription();
        if (list == null || list.size() == 0) {
            throw new DSTException("descriptions are null");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            DescriptionType descriptionType = (DescriptionType)iterator.next();
            this.soapAction = descriptionType.getSoapAction();
            this.soapURI = descriptionType.getEndpoint();
            List list2 = descriptionType.getSecurityMechID();
            if (list2 == null || list2.size() == 0) continue;
            int n = list2.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)list2.get(n2);
                if ((string = string.trim()).equals("urn:liberty:security:2003-08:null:null") || string.equals("urn:liberty:security:2003-08:TLS:null") || string.equals("urn:liberty:security:2003-08:ClientTLS:null")) {
                    this.securityProfile = 0;
                    if (string.equals("urn:liberty:security:2003-08:ClientTLS:null")) {
                        this.clientAuthEnabled = true;
                    }
                    bl = true;
                    break;
                }
                if (string.equals("urn:liberty:security:2003-08:null:X509") || string.equals("urn:liberty:security:2003-08:TLS:X509") || string.equals("urn:liberty:security:2003-08:ClientTLS:X509")) {
                    this.securityProfile = 1;
                    if (string.equals("urn:liberty:security:2003-08:ClientTLS:X509")) {
                        this.clientAuthEnabled = true;
                    }
                    bl = true;
                    break;
                }
                if (string.equals("urn:liberty:security:2003-08:null:SAML") || string.equals("urn:liberty:security:2003-08:TLS:SAML") || string.equals("urn:liberty:security:2003-08:ClientTLS:SAML")) {
                    this.securityProfile = 2;
                    if (string.equals("urn:liberty:security:2003-08:ClientTLS:SAML")) {
                        this.clientAuthEnabled = true;
                    }
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) break;
        }
        if (this.soapURI == null) {
            DSTUtils.debug.error("DSTClient: soapURI is null");
            throw new DSTException("null values");
        }
        if (DSTUtils.debug.messageEnabled()) {
            DSTUtils.debug.message("DSTClient: soapURI=" + this.soapURI);
        }
    }

    public DSTClient(ResourceOffering resourceOffering, String string, SSOToken sSOToken) throws DSTException {
        if (resourceOffering == null) {
            DSTUtils.debug.error("DSTClient: resource offering is null");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        this.parseResourceOffering(resourceOffering);
        if (this.securityProfile == 1) {
            this.generateBinarySecurityToken(sSOToken);
        }
        this.providerID = string;
    }

    private void parseResourceOffering(ResourceOffering resourceOffering) throws DSTException {
        Object object;
        this.encryptedResourceID = resourceOffering.getEncryptedResourceID();
        if (this.encryptedResourceID != null) {
            this.isEncryptedResourceID = true;
        } else {
            object = resourceOffering.getResourceID();
            if (object == null) {
                DSTUtils.debug.error("DSTClient:parseResourceOffering: No ResourceID");
                throw new DSTException(DSTUtils.bundle.getString("noResourceID"));
            }
            this.resourceID = ((ResourceID)object).getResourceID();
        }
        object = resourceOffering.getServiceInstance();
        if (object == null) {
            DSTUtils.debug.error("DSTClient:parseResourceOffering: No service instance.");
            throw new DSTException(DSTUtils.bundle.getString("noServiceInstance"));
        }
        this.serviceType = ((ServiceInstance)object).getServiceType();
        if (this.serviceType == null) {
            DSTUtils.debug.error("DSTClient:parseResourceOffering: service type is null.");
            throw new DSTException(DSTUtils.bundle.getString("noServiceType"));
        }
        List list = ((ServiceInstance)object).getDescription();
        if (list == null || list.isEmpty()) {
            DSTUtils.debug.error("DSTClient:parseResourceOffering: descriptions are null.");
            throw new DSTException(DSTUtils.bundle.getString("noDescriptions"));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2;
            Description description = (Description)iterator.next();
            this.soapAction = description.getSoapAction();
            this.soapURI = description.getEndpoint();
            if (this.soapURI == null || this.soapURI.equals("") || (list2 = description.getSecurityMechID()) == null || list2.isEmpty()) continue;
            boolean bl = false;
            int n = list2.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)list2.get(n2);
                if ((string = string.trim()).equals("urn:liberty:security:2003-08:null:null") || string.equals("urn:liberty:security:2003-08:TLS:null") || string.equals("urn:liberty:security:2003-08:ClientTLS:null")) {
                    this.securityProfile = 0;
                    if (string.equals("urn:liberty:security:2003-08:ClientTLS:null")) {
                        this.clientAuthEnabled = true;
                    }
                    bl = true;
                    break;
                }
                if (string.equals("urn:liberty:security:2003-08:null:X509") || string.equals("urn:liberty:security:2003-08:TLS:X509") || string.equals("urn:liberty:security:2003-08:ClientTLS:X509")) {
                    this.securityProfile = 1;
                    if (string.equals("urn:liberty:security:2003-08:ClientTLS:X509")) {
                        this.clientAuthEnabled = true;
                    }
                    bl = true;
                    break;
                }
                if (string.equals("urn:liberty:security:2003-08:null:SAML") || string.equals("urn:liberty:security:2003-08:TLS:SAML") || string.equals("urn:liberty:security:2003-08:ClientTLS:SAML")) {
                    this.securityProfile = 2;
                    if (string.equals("urn:liberty:security:2003-08:ClientTLS:SAML")) {
                        this.clientAuthEnabled = true;
                    }
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) break;
        }
        if (this.soapURI == null) {
            DSTUtils.debug.error("DSTClient:parseResourceOffering: SOAP Endpoint or security profile is null");
            throw new DSTException(DSTUtils.bundle.getString("invalidResourceOffering"));
        }
        if (DSTUtils.debug.messageEnabled()) {
            DSTUtils.debug.message("DSTClient.parseResourceOffering:soapURI = " + this.soapURI + "soapAction = " + this.soapAction + "securityProfile = " + this.securityProfile);
        }
    }

    private void generateBinarySecurityToken(SSOToken sSOToken) throws DSTException {
        try {
            SecurityTokenManager securityTokenManager = new SecurityTokenManager(sSOToken);
            this.token = securityTokenManager.getX509CertificateToken();
        }
        catch (Exception exception) {
            DSTUtils.debug.error("DSTClient:generateBinarySecurityToken:Error in generating binary security token.", (Throwable)exception);
            throw new DSTException(exception);
        }
    }

    public void setResourceID(String string) {
        this.resourceID = string;
        this.isEncryptedResourceID = false;
    }

    public void setResourceID(EncryptedResourceID encryptedResourceID) {
        this.encryptedResourceID = encryptedResourceID;
        this.isEncryptedResourceID = true;
    }

    public void setProviderID(String string) {
        this.providerID = string;
    }

    public void setClientCert(String string) {
        this.certAlias = string;
    }

    public void setSOAPAction(String string) {
        this.soapAction = string;
    }

    public void setClientAuth(boolean bl) {
        this.clientAuthEnabled = bl;
    }

    public List getData(List list) throws DSTException, InteractionRedirectException {
        DSTUtils.debug.message("DSTClient:getData:Init");
        if (list == null || list.size() == 0) {
            DSTUtils.debug.error("DSTUtils.getData:Query items are null.");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        DSTQuery dSTQuery = null;
        dSTQuery = this.isEncryptedResourceID ? new DSTQuery(this.encryptedResourceID, list, null) : new DSTQuery(this.resourceID, list, null);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(DSTUtils.parseXML(dSTQuery.toString(true, true)));
        List list2 = this.sendMessage(arrayList);
        if (list2 == null || list2.size() == 0) {
            DSTUtils.debug.message("DSTClient:getData: response is null");
            return null;
        }
        DSTQueryResponse dSTQueryResponse = new DSTQueryResponse((Element)list2.get(0));
        return dSTQueryResponse.getData();
    }

    public DSTQueryResponse query(DSTQuery dSTQuery) throws DSTException, InteractionRedirectException {
        DSTUtils.debug.message("DSTClient:query:Init");
        if (dSTQuery == null) {
            DSTUtils.debug.message("DSTClient:query:null value");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(DSTUtils.parseXML(dSTQuery.toString(true, true)));
        List list = this.sendMessage(arrayList);
        Element element = (Element)list.get(0);
        return new DSTQueryResponse(element);
    }

    public DSTModifyResponse modify(List list) throws DSTException, InteractionRedirectException {
        DSTUtils.debug.message("DSTClient:modify:init:");
        if (list == null) {
            DSTUtils.debug.message("DSTClient:modify:null values");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        DSTModify dSTModify = null;
        dSTModify = this.isEncryptedResourceID ? new DSTModify(this.encryptedResourceID, list, null) : new DSTModify(this.resourceID, list, null);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(DSTUtils.parseXML(dSTModify.toString(true, true)));
        List list2 = this.sendMessage(arrayList);
        if (list2 == null || list2.size() == 0) {
            DSTUtils.debug.message("DSTClient:modify: response is null");
            return null;
        }
        return new DSTModifyResponse((Element)list2.get(0));
    }

    public DSTModifyResponse modify(DSTModify dSTModify) throws DSTException, InteractionRedirectException {
        DSTUtils.debug.message("DSTClient:modify:init");
        if (dSTModify == null) {
            DSTUtils.debug.message("DSTClient:modify:null values");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(DSTUtils.parseXML(dSTModify.toString(true, true)));
        List list = this.sendMessage(arrayList);
        return new DSTModifyResponse((Element)list.get(0));
    }

    public List getQueryResponse(List list) throws DSTException, InteractionRedirectException {
        Object object;
        DSTUtils.debug.message("DSTClient.getQueryResponse:Init");
        if (list == null || list.size() == 0) {
            DSTUtils.debug.error("DSTClient.getQueryResponse:null values");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        Iterator iterator = list.iterator();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        while (iterator.hasNext()) {
            object = (DSTQuery)iterator.next();
            arrayList.add(DSTUtils.parseXML(((DSTQuery)object).toString(true, true)));
        }
        object = this.sendMessage(arrayList);
        if (object == null || object.size() == 0) {
            DSTUtils.debug.error("DSTClient.getQueryResponse:null responses");
            throw new DSTException(DSTUtils.bundle.getString("nullResponse"));
        }
        ArrayList<DSTQueryResponse> arrayList2 = new ArrayList<DSTQueryResponse>();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            arrayList2.add(new DSTQueryResponse((Element)iterator2.next()));
        }
        return arrayList2;
    }

    public List getModifyResponse(List list) throws DSTException, InteractionRedirectException {
        Object object;
        DSTUtils.debug.message("DSTClient.getModifyResponse:Init");
        if (list == null || list.size() == 0) {
            DSTUtils.debug.error("DSTClient.getModifyResponse:null values");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        Iterator iterator = list.iterator();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        while (iterator.hasNext()) {
            object = (DSTModify)iterator.next();
            arrayList.add(DSTUtils.parseXML(((DSTModify)object).toString(true, true)));
        }
        object = this.sendMessage(arrayList);
        if (object == null || object.size() == 0) {
            DSTUtils.debug.error("DSTClient.getModifyResponse:null responses");
            throw new DSTException(DSTUtils.bundle.getString("nullResponse"));
        }
        ArrayList<DSTModifyResponse> arrayList2 = new ArrayList<DSTModifyResponse>();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            arrayList2.add(new DSTModifyResponse((Element)iterator2.next()));
        }
        return arrayList2;
    }

    private List sendMessage(List list) throws DSTException, InteractionRedirectException {
        DSTUtils.debug.message("DSTClient:sendMessage:Init");
        if (list == null || list.size() == 0) {
            DSTUtils.debug.message("DSTClient:sendMessage: requestobj are null");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        try {
            Message message = null;
            ProviderHeader providerHeader = new ProviderHeader(this.providerID);
            if (this.securityProfile == 1) {
                if (this.token == null) {
                    throw new DSTException(DSTUtils.bundle.getString("nullToken"));
                }
                DSTUtils.debug.message("DSTClient:sendMessage:using x509");
                message = new Message(providerHeader, this.token);
            } else if (this.securityProfile == 2) {
                DSTUtils.debug.message("DSTClient:sendMessage:using SAML");
                message = new Message(providerHeader, this.assertion);
            } else if (this.securityProfile == 0) {
                DSTUtils.debug.message("DSTClient:sendMessage:using Anonymous");
                message = new Message(providerHeader);
            } else {
                throw new DSTException(DSTUtils.bundle.getString("invalidSecurityProfile"));
            }
            message.setSOAPBodies(list);
            if (this.clientAuthEnabled) {
                message.setClientAuthentication(this.clientAuthEnabled);
            }
            if (DSTUtils.debug.messageEnabled()) {
                DSTUtils.debug.message("DSTClient:sendMessage: request:" + message.toString());
            }
            Message message2 = null;
            message2 = this.httpRequest != null ? this.handleInteraction(message) : Client.sendRequest(message, this.soapURI, this.certAlias, this.soapAction);
            if (DSTUtils.debug.messageEnabled()) {
                DSTUtils.debug.message("DSTClient:sendMessage:response = " + message2.toString());
            }
            return message2.getBodies();
        }
        catch (SOAPBindingException sOAPBindingException) {
            DSTUtils.debug.error("DSTClient:sendMessage:soapbindexception", (Throwable)sOAPBindingException);
            throw new DSTException(sOAPBindingException);
        }
        catch (SOAPFaultException sOAPFaultException) {
            DSTUtils.debug.error("DSTClient:sendMessage:soapfault", (Throwable)sOAPFaultException);
            throw new DSTException(sOAPFaultException);
        }
    }

    private Message handleInteraction(Message message) throws DSTException, SOAPFaultException, SOAPBindingException, InteractionRedirectException {
        if (message == null || this.httpRequest == null || this.httpResponse == null || this.soapURI == null) {
            DSTUtils.debug.error("DSTClient:handeInteraction:null values");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        DSTUtils.debug.message("DSTClient:handleInteraction:init");
        String string = this.httpRequest.getParameter("ResendMessage");
        String string2 = this.httpRequest.getRequestURL().toString();
        try {
            InteractionManager interactionManager = InteractionManager.getInstance();
            Message message2 = string == null ? interactionManager.sendRequest(message, this.soapURI, string2, this.httpRequest, this.httpResponse) : interactionManager.resendRequest(string2, this.httpRequest, this.httpResponse);
            return message2;
        }
        catch (InteractionRedirectException interactionRedirectException) {
            DSTUtils.debug.message("DSTClient:handleInteraction: InteractionRedirection happened.");
            throw interactionRedirectException;
        }
        catch (InteractionException interactionException) {
            DSTUtils.debug.error("DSTClient:handleInteraction: Interaction Error occured.", (Throwable)((Object)interactionException));
            throw new DSTException((Throwable)((Object)interactionException));
        }
    }
}

