/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.plugins;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.plugins.DiscoEntryHandler;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class UserDiscoEntryHandler
implements DiscoEntryHandler {
    private static SSOToken ssoAuthSession = null;
    private static AMStoreConnection amConn = null;
    private static final String USER_ATTR_NAME = "sunIdentityServerDiscoEntries";

    public UserDiscoEntryHandler() {
        DiscoUtils.debug.message("in UserDiscoEntryHandler.constructor");
        try {
            if (amConn == null) {
                amConn = new AMStoreConnection(UserDiscoEntryHandler.getSSOToken());
            }
            DiscoUtils.debug.message("after getting amConn.");
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("UserDiscoEntryHandler.constructor: Exception:", (Throwable)exception);
        }
    }

    private static synchronized SSOToken getSSOToken() throws SSOException, SessionException {
        if (ssoAuthSession == null) {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = AdminUtils.getAdminDN();
            String string2 = new String(AdminUtils.getAdminPassword());
            try {
                ssoAuthSession = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
            }
            catch (SSOException sSOException) {
                DiscoUtils.debug.error("UserDiscoEntryHandler.getSSOToken: SSOException:", (Throwable)sSOException);
                throw new SessionException(sSOException.getMessage());
            }
        }
        return ssoAuthSession;
    }

    public Map getDiscoEntries(String string, List list) {
        DiscoUtils.debug.message("in UserDiscoEntryHandler.getDiscoEntries");
        Map map = new HashMap();
        try {
            AMUser aMUser = amConn.getUser(string);
            if (DiscoUtils.getUserDiscoEntries(aMUser, USER_ATTR_NAME, map) && !DiscoUtils.setUserDiscoEntries(aMUser, USER_ATTR_NAME, map.values())) {
                DiscoUtils.debug.error("UserDiscoEntryHandler.getDiscoEntries: couldn't set missing entryID to entry.");
            }
            map = DiscoUtils.getQueryResults(map, list);
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("UserDiscoEntryHandler.getDiscoEntries: Exception:", (Throwable)exception);
        }
        return map;
    }

    public Map modifyDiscoEntries(String string, List list, List list2) {
        DiscoUtils.debug.message("in UserDiscoEntryHandler.modifyDiscoEntries");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("STATUS_CODE", "Failed");
        HashMap hashMap2 = new HashMap();
        AMUser aMUser = null;
        try {
            aMUser = amConn.getUser(string);
            DiscoUtils.getUserDiscoEntries(aMUser, USER_ATTR_NAME, hashMap2);
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("UserDiscoEntryHandler.modifyDiscoEntries: Exception:", (Throwable)exception);
            return hashMap;
        }
        if (list != null && list.size() != 0) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("UserDiscoEntryHandler.modifyDiscoEntries: handling " + list.size() + " removes.");
            }
            if (!DiscoUtils.handleRemoves(hashMap2, list)) {
                return hashMap;
            }
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(hashMap2.values());
        List list3 = null;
        if (list2 != null && list2.size() != 0) {
            Map map;
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("UserDiscoEntryHandler.modifyDiscoEntries: handling " + list2.size() + " inserts.");
            }
            if (!((String)(map = DiscoUtils.handleInserts(hashSet, list2)).get("STATUS_CODE")).equals("OK")) {
                return hashMap;
            }
            list3 = (List)map.get("newEntryIDs");
        }
        if (!DiscoUtils.setUserDiscoEntries(aMUser, USER_ATTR_NAME, hashSet)) {
            DiscoUtils.debug.error("UserDiscoEntryHandler.modifyDiscoEntries: couldn't set DiscoEntries through DiscoEntryHandler.");
            return hashMap;
        }
        if (DiscoUtils.debug.messageEnabled()) {
            DiscoUtils.debug.message("UserDiscoEntryHandler.modifyDiscoEntries: set DiscoEntries through DiscoEntryHandler successfully.");
        }
        hashMap.put("STATUS_CODE", "OK");
        if (list3 != null && list3.size() != 0) {
            hashMap.put("newEntryIDs", list3);
        }
        return hashMap;
    }
}

