/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.plugins;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.plugins.DiscoEntryHandler;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DynamicDiscoEntryHandler
implements DiscoEntryHandler {
    private static SSOToken ssoAuthSession = null;
    private static AMStoreConnection amConn = null;
    private static final String DYNAMIC_ATTR_NAME = "sunIdentityServerDynamicDiscoEntries";

    public DynamicDiscoEntryHandler() {
        DiscoUtils.debug.message("in DynamicDiscoEntryHandler.constructor");
        try {
            if (amConn == null) {
                amConn = new AMStoreConnection(DynamicDiscoEntryHandler.getSSOToken());
            }
            DiscoUtils.debug.message("after getting amConn.");
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("DynamicDiscoEntryHandler.constructor: Exception:", (Throwable)exception);
        }
    }

    private static synchronized SSOToken getSSOToken() throws SSOException, SessionException {
        if (ssoAuthSession == null) {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = AdminUtils.getAdminDN();
            String string2 = new String(AdminUtils.getAdminPassword());
            try {
                ssoAuthSession = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
            }
            catch (SSOException sSOException) {
                DiscoUtils.debug.error("DynamicDiscoEntryHandler.getSSOToken: SSOException:", (Throwable)sSOException);
                throw new SessionException(sSOException.getMessage());
            }
        }
        return ssoAuthSession;
    }

    public Map getDiscoEntries(String string, List list) {
        DiscoUtils.debug.message("in DynamicDiscoEntryHandler.getDiscoEntries");
        Map map = new HashMap();
        try {
            AMUser aMUser = amConn.getUser(string);
            DiscoUtils.getDynamicDiscoEntries(aMUser, DYNAMIC_ATTR_NAME, map, string);
            map = DiscoUtils.getQueryResults(map, list);
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("DynamicDiscoEntryHandler.getDiscoEntries: Exception:", (Throwable)exception);
        }
        return map;
    }

    public Map modifyDiscoEntries(String string, List list, List list2) {
        if (DiscoUtils.debug.messageEnabled()) {
            DiscoUtils.debug.message("DynamicDiscoEntryHandler.modifyDiscoEntries: this operation is not supported.");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("STATUS_CODE", "Failed");
        return hashMap;
    }
}

