/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.common;

import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.liberty.ws.common.Status;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.liberty.ws.disco.jaxb.AuthenticateRequesterElement;
import com.sun.identity.liberty.ws.disco.jaxb.AuthenticateSessionContextElement;
import com.sun.identity.liberty.ws.disco.jaxb.AuthorizeRequesterElement;
import com.sun.identity.liberty.ws.disco.jaxb.EncryptResourceIDElement;
import com.sun.identity.liberty.ws.disco.jaxb.InsertEntryType;
import com.sun.identity.liberty.ws.disco.jaxb.QueryType;
import com.sun.identity.liberty.ws.disco.jaxb.RemoveEntryType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceOfferingType;
import com.sun.identity.liberty.ws.disco.plugins.jaxb.DiscoEntryElement;
import com.sun.identity.liberty.ws.disco.plugins.jaxb.ObjectFactory;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtils;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DiscoUtils {
    private static com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory discoFac = new com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory();
    private static ObjectFactory entryFac = new ObjectFactory();
    private static Unmarshaller unmarshaller;
    private static Marshaller marshaller;
    public static ResourceBundle bundle;
    public static Debug debug;

    private DiscoUtils() {
    }

    public static com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory getDiscoFactory() {
        return discoFac;
    }

    public static ObjectFactory getDiscoEntryFactory() {
        return entryFac;
    }

    public static Marshaller getDiscoMarshaller() {
        return marshaller;
    }

    public static Unmarshaller getDiscoUnmarshaller() {
        return unmarshaller;
    }

    public static boolean getUserDiscoEntries(AMUser aMUser, String string, Map map) throws Exception {
        boolean bl = false;
        Set set = aMUser.getAttribute(string);
        Iterator iterator = set.iterator();
        DiscoEntryElement discoEntryElement = null;
        String string2 = null;
        String string3 = null;
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            try {
                discoEntryElement = (DiscoEntryElement)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(string3)));
                string2 = discoEntryElement.getResourceOffering().getEntryID();
                if (string2 == null || string2.equals("")) {
                    string2 = SAMLUtils.generateID();
                    discoEntryElement.getResourceOffering().setEntryID(string2);
                    bl = true;
                }
                map.put(string2, discoEntryElement);
            }
            catch (Exception exception) {
                debug.error("DiscoUtils.getUserDiscoEntries: wrong format for entry. Removing it from store: " + string3);
                bl = true;
            }
        }
        return bl;
    }

    public static void getDynamicDiscoEntries(AMUser aMUser, String string, Map map, String string2) throws Exception {
        Set set = aMUser.getAttribute(string);
        Iterator iterator = set.iterator();
        String string3 = null;
        String string4 = null;
        DiscoEntryElement discoEntryElement = null;
        ResourceIDType resourceIDType = null;
        ResourceOfferingType resourceOfferingType = null;
        String string5 = null;
        String string6 = null;
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            try {
                discoEntryElement = (DiscoEntryElement)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(string3)));
                resourceOfferingType = discoEntryElement.getResourceOffering();
                string6 = resourceOfferingType.getServiceInstance().getProviderID();
                ResourceIDMapper resourceIDMapper = DiscoServiceManager.getResourceIDMapper(string6);
                if (resourceIDMapper == null) {
                    debug.error("DiscoUtils.getDynamicDiscoEntries: ResourceIDMapper is null for entry:" + string3);
                    continue;
                }
                string4 = resourceIDMapper.getResourceID(string6, string2);
                if (string4 == null) {
                    debug.error("DiscoUtils.getDynamicDiscoEntries: ResourceID is null for entry:" + string3);
                    continue;
                }
                resourceIDType = discoFac.createResourceIDType();
                resourceIDType.setValue(string4);
                resourceOfferingType.setResourceID(resourceIDType);
                string5 = SAMLUtils.generateID();
                resourceOfferingType.setEntryID(string5);
                map.put(resourceOfferingType, discoEntryElement);
            }
            catch (Exception exception) {
                debug.error("DiscoUtils.getDynamicDiscoEntries: Exception for getting entry: " + string3 + ":", (Throwable)exception);
            }
        }
    }

    public static boolean setUserDiscoEntries(AMUser aMUser, String string, Collection collection) {
        debug.message("in DiscoUtils.setUserDiscoEntries");
        try {
            Iterator iterator = collection.iterator();
            HashSet<String> hashSet = new HashSet<String>();
            Object var5_6 = null;
            StringWriter stringWriter = null;
            while (iterator.hasNext()) {
                stringWriter = new StringWriter(1000);
                marshaller.marshal((Object)((DiscoEntryElement)iterator.next()), (Writer)stringWriter);
                hashSet.add(stringWriter.getBuffer().toString());
            }
            HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
            hashMap.put(string, hashSet);
            aMUser.setAttributes(hashMap);
            aMUser.store();
            return true;
        }
        catch (Exception exception) {
            debug.error("UserDiscoEntryHandler.setDiscoEntries: Exception", (Throwable)exception);
            return false;
        }
    }

    public static Map getQueryResults(Map hashMap, List list) {
        HashMap<String, DiscoEntryElement> hashMap2 = null;
        if (list == null || list.size() == 0) {
            debug.message("DiscoUtils.getQueryResults: no reqServiceTypes");
            hashMap2 = hashMap;
        } else {
            hashMap2 = new HashMap<String, DiscoEntryElement>();
            Iterator iterator = hashMap.keySet().iterator();
            block0: while (iterator.hasNext()) {
                String string = (String)iterator.next();
                DiscoEntryElement discoEntryElement = (DiscoEntryElement)hashMap.get(string);
                ResourceOfferingType resourceOfferingType = discoEntryElement.getResourceOffering();
                String string2 = resourceOfferingType.getServiceInstance().getServiceType();
                List list2 = null;
                if (resourceOfferingType.getOptions() != null) {
                    list2 = resourceOfferingType.getOptions().getOption();
                }
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    QueryType.RequestedServiceTypeType requestedServiceTypeType = (QueryType.RequestedServiceTypeType)iterator2.next();
                    String string3 = requestedServiceTypeType.getServiceType();
                    if (!string3.equals(string2)) continue;
                    List list3 = null;
                    if (requestedServiceTypeType.getOptions() != null) {
                        list3 = requestedServiceTypeType.getOptions().getOption();
                    }
                    if (!DiscoUtils.evaluateOptionsRules(list2, list3)) continue;
                    hashMap2.put(string, discoEntryElement);
                    continue block0;
                }
            }
        }
        return hashMap2;
    }

    private static boolean evaluateOptionsRules(List list, List list2) {
        if (list == null || list2 == null) {
            return true;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!list2.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean handleRemoves(Map map, List list) {
        Iterator iterator = list.iterator();
        RemoveEntryType removeEntryType = null;
        while (iterator.hasNext()) {
            removeEntryType = (RemoveEntryType)iterator.next();
            if (!map.containsKey(removeEntryType.getEntryID())) {
                if (debug.messageEnabled()) {
                    debug.message("DiscoUtils.handleRemoves: can not remove entry: " + removeEntryType.getEntryID());
                }
                return false;
            }
            map.remove(removeEntryType.getEntryID());
        }
        return true;
    }

    public static Map handleInserts(Set set, List list) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("STATUS_CODE", "Failed");
        Set set2 = DiscoServiceManager.getSupportedDirectives();
        if (debug.messageEnabled()) {
            debug.message("DiscoUtils.handleInserts: size of supportedDirective is " + set2.size());
        }
        Iterator iterator = list.iterator();
        InsertEntryType insertEntryType = null;
        DiscoEntryElement discoEntryElement = null;
        ResourceOfferingType resourceOfferingType = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        while (iterator.hasNext()) {
            insertEntryType = (InsertEntryType)iterator.next();
            try {
                discoEntryElement = entryFac.createDiscoEntryElement();
            }
            catch (JAXBException jAXBException) {
                debug.error("DiscoUtils.handleInserts: couldn't create DiscoEntry: ", (Throwable)jAXBException);
                return hashMap;
            }
            resourceOfferingType = insertEntryType.getResourceOffering();
            String string = SAMLUtils.generateID();
            debug.message("DiscoUtils: newEntryID=" + string);
            resourceOfferingType.setEntryID(string);
            linkedList.add(string);
            discoEntryElement.setResourceOffering(resourceOfferingType);
            List list2 = insertEntryType.getAny();
            if (list2 != null && list2.size() != 0) {
                Iterator iterator2 = list2.iterator();
                Object var12_13 = null;
                while (iterator2.hasNext()) {
                    var12_13 = iterator2.next();
                    if (var12_13 instanceof AuthenticateRequesterElement) {
                        if (set2.contains("AuthenticateRequester")) continue;
                        debug.error("Directive AuthenticateRequester is not supported.");
                        return hashMap;
                    }
                    if (var12_13 instanceof AuthorizeRequesterElement) {
                        if (set2.contains("AuthorizeRequester")) continue;
                        debug.error("Directive AuthorizeRequester is not supported.");
                        return hashMap;
                    }
                    if (var12_13 instanceof AuthenticateSessionContextElement) {
                        if (set2.contains("AuthenticateSessionContext")) continue;
                        debug.error("Directive AuthenticateSessionContext is not supported.");
                        return hashMap;
                    }
                    if (var12_13 instanceof EncryptResourceIDElement) {
                        if (set2.contains("EncryptResourceID")) continue;
                        debug.error("Directive EncryptResourceID is not supported.");
                        return hashMap;
                    }
                    debug.error("Directive " + var12_13 + " is not supported.");
                    return hashMap;
                }
                discoEntryElement.getAny().addAll(list2);
            }
            if (set.add(discoEntryElement)) continue;
            debug.error("DiscoUtils.handleInserts: couldn't add DiscoEntry to Set.");
            return hashMap;
        }
        hashMap.put("STATUS_CODE", "OK");
        hashMap.put("newEntryIDs", linkedList);
        return hashMap;
    }

    public static Status parseStatus(Element element) throws DiscoveryException {
        Object object;
        if (element == null) {
            debug.message("DiscoUtils.parseStatus: nullInput");
            throw new DiscoveryException(bundle.getString("nullInput"));
        }
        String string = element.getNamespaceURI();
        String string2 = element.getPrefix();
        Status status = new Status(string, string2);
        String string3 = element.getAttribute("code");
        if (string3 == null || string3.length() == 0) {
            debug.message("DiscoUtils.parseStatus: missing status code.");
            throw new DiscoveryException(bundle.getString("missingStatusCode"));
        }
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        if (string3.indexOf(":") != -1) {
            object = new StringTokenizer(string3, ":");
            if (((StringTokenizer)object).countTokens() != 2) {
                debug.message("DiscoUtils.parseStatus: wrong status code.");
                throw new DiscoveryException(bundle.getString("wrongInput"));
            }
            string5 = ((StringTokenizer)object).nextToken();
            string6 = ((StringTokenizer)object).nextToken();
        }
        if (string5 != null && string2 != null && !string5.equals(string2)) {
            string4 = element.getAttribute("xmlns:" + string5);
        }
        if (string4 != null && string4.length() != 0) {
            if (string5 != null && string5.length() != 0) {
                status.setCode(new QName(string4, string6, string5));
            } else {
                status.setCode(new QName(string4, string6));
            }
        } else {
            status.setCode(new QName(string6));
        }
        status.setComment(element.getAttribute("comment"));
        status.setRef(element.getAttribute("ref"));
        object = XMLUtils.getElementsByTagNameNS1((Element)element, (String)"urn:liberty:disco:2003-08", (String)"Status");
        int n = object.size();
        if (n != 0) {
            if (n == 1) {
                status.setSubStatus(DiscoUtils.parseStatus((Element)object.get(0)));
            } else {
                if (debug.messageEnabled()) {
                    debug.message("DiscoUtils.parseStatus: included more than one sub status.");
                }
                throw new DiscoveryException(bundle.getString("moreElement"));
            }
        }
        return status;
    }

    public static List parseOptions(Element element) throws DiscoveryException {
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node = nodeList.item(n);
            String string = node.getLocalName();
            if (string != null) {
                String string2 = element.getNamespaceURI();
                if (string2 == null || !string2.equals("urn:liberty:disco:2003-08")) {
                    if (debug.messageEnabled()) {
                        debug.message("DiscoUtils.parseOption(Element): invalid namespace for node " + string);
                    }
                    throw new DiscoveryException(bundle.getString("wrongInput"));
                }
                if (string.equals("Option")) {
                    arrayList.add(XMLUtils.getElementValue((Element)((Element)node)));
                } else {
                    if (debug.messageEnabled()) {
                        debug.message("DiscoUtils.parseOption(Element): invalid node" + string);
                    }
                    throw new DiscoveryException(bundle.getString("wrongInput"));
                }
            }
            ++n;
        }
        return arrayList;
    }

    public static Element parseXML(String string) throws DiscoveryException {
        try {
            Document document = XMLUtils.toDOMDocument((String)string, (Debug)debug);
            return document.getDocumentElement();
        }
        catch (Exception exception) {
            debug.error("DiscoUtils.parseXML: Parsing error.", (Throwable)exception);
            throw new DiscoveryException(exception);
        }
    }

    static {
        bundle = Locale.getInstallResourceBundle((String)"amDisco");
        debug = Debug.getInstance((String)"amDisco");
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)Utils.getJAXBPackages());
            unmarshaller = jAXBContext.createUnmarshaller();
            marshaller = jAXBContext.createMarshaller();
        }
        catch (Exception exception) {
            debug.error("DiscoUtils:static: Initialization failed.", (Throwable)exception);
        }
    }
}

