/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.common;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.liberty.ws.disco.plugins.Default64ResourceIDMapper;
import com.sun.identity.liberty.ws.disco.plugins.DefaultDiscoAuthorizer;
import com.sun.identity.liberty.ws.disco.plugins.DiscoEntryHandler;
import com.sun.identity.liberty.ws.disco.plugins.UserDiscoEntryHandler;
import com.sun.identity.liberty.ws.disco.plugins.jaxb.DiscoEntryElement;
import com.sun.identity.liberty.ws.interfaces.Authorizer;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.StringReader;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class DiscoServiceManager
implements ServiceListener {
    private static final String DISCO_SERVICE = "sunIdentityServerDiscoveryService";
    private static final String ATTR_PROVIDER_ID = "sunIdentityServerDiscoProviderID";
    private static final String ATTR_SUPPORTED_AUTHN_MECHS = "sunIdentityServerDiscoSupportedAuthnMechs";
    private static final String ATTR_SUPPORTED_DIRECTIVE = "sunIdentityServerDiscoSupportedDirectives";
    private static final String ATTR_LOOKUP_NEED_POLICY = "sunIdentityServerDiscoLookupNeedPolicyEval";
    private static final String LOOKUP_NEED_POLICY_DEFAULT = "false";
    private static final String ATTR_UPDATE_NEED_POLICY = "sunIdentityServerDiscoUpdateNeedPolicyEval";
    private static final String UPDATE_NEED_POLICY_DEFAULT = "false";
    private static final String ATTR_AUTHORIZER = "sunIdentityServerDiscoAuthorizer";
    private static final String ATTR_ENTRY_HANDLER = "sunIdentityServerDiscoEntryHandler";
    private static final String ATTR_ID_MAPPER = "sunIdentityServerDiscoProviderResourceIDMapper";
    private static final String KEY_PROVIDER_ID = "providerid";
    private static final String KEY_IDMAPPER = "idmapper";
    private static final String ATTR_BOOTSTRAPPING_DISCO_ENTRY = "sunIdentityServerBootstrappingDiscoEntry";
    private static final String ATTR_BOOTSTRAPPING_SESSION_CONTEXT = "sunIdentityServerBootstrappingSessionContext";
    private static final String NEED_SESSION_CONTEXT_DEFAULT = "false";
    private static Debug debug = Debug.getInstance((String)"amDisco");
    private static JAXBContext jc = null;
    private static ServiceSchema serviceSchema = null;
    private static String selfProviderID = null;
    private static Set authnMechs = null;
    private static Set supportedDirectives = null;
    private static boolean policyEvalLookup = false;
    private static boolean policyEvalUpdate = false;
    private static Authorizer authorizer = new DefaultDiscoAuthorizer();
    private static DiscoEntryHandler entryHandler = new UserDiscoEntryHandler();
    private static Map idMappers = null;
    private static DiscoEntryElement bootDiscoEntry = null;
    private static boolean requireSessionContextStmt = false;

    private DiscoServiceManager() {
    }

    public void schemaChanged(String string, String string2) {
        debug.message("DiscoServiceManager.schemaChanged.");
        DiscoServiceManager.setValues();
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
        debug.message("DiscoServiceManager.globalConfigChanged.");
        DiscoServiceManager.setValues();
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
        debug.message("DiscoServiceManager.orgConfigChanged.");
        DiscoServiceManager.setValues();
    }

    public static synchronized String getDiscoProviderID() {
        return selfProviderID;
    }

    public static Set getSupportedAuthenticationMechanisms() {
        return authnMechs;
    }

    public static Set getSupportedDirectives() {
        return supportedDirectives;
    }

    public static boolean needPolicyEvalLookup() {
        return policyEvalLookup;
    }

    public static boolean needPolicyEvalUpdate() {
        return policyEvalUpdate;
    }

    public static Authorizer getAuthorizer() {
        return authorizer;
    }

    public static synchronized DiscoEntryHandler getDiscoEntryHandler() {
        return entryHandler;
    }

    public static synchronized ResourceIDMapper getResourceIDMapper(String string) {
        if (idMappers == null || string == null) {
            return null;
        }
        return (ResourceIDMapper)idMappers.get(string);
    }

    public static ResourceIDMapper getDefaultResourceIDMapper() {
        return new Default64ResourceIDMapper();
    }

    public static synchronized DiscoEntryElement getBootstrappingDiscoEntry() {
        return bootDiscoEntry;
    }

    private static synchronized void setValues() {
        try {
            String string;
            Object object;
            String string2;
            Map map = serviceSchema.getAttributeDefaults();
            selfProviderID = Misc.getMapAttr((Map)map, (String)ATTR_PROVIDER_ID);
            authnMechs = (Set)map.get(ATTR_SUPPORTED_AUTHN_MECHS);
            supportedDirectives = (Set)map.get(ATTR_SUPPORTED_DIRECTIVE);
            policyEvalLookup = Boolean.valueOf(Misc.getMapAttr((Map)map, (String)ATTR_LOOKUP_NEED_POLICY, (String)"false"));
            policyEvalUpdate = Boolean.valueOf(Misc.getMapAttr((Map)map, (String)ATTR_UPDATE_NEED_POLICY, (String)"false"));
            String string3 = Misc.getMapAttr((Map)map, (String)ATTR_AUTHORIZER);
            if (string3 != null && !string3.equals("")) {
                try {
                    authorizer = (Authorizer)Class.forName(string3).newInstance();
                }
                catch (Exception exception) {
                    if (debug.messageEnabled()) {
                        debug.error("DiscoServiceManager.setValues: Exception when instantiating authorizer. Using default Authorizer. Exception", (Throwable)exception);
                    }
                    authorizer = new DefaultDiscoAuthorizer();
                }
            } else {
                authorizer = new DefaultDiscoAuthorizer();
            }
            if ((string2 = Misc.getMapAttr((Map)map, (String)ATTR_ENTRY_HANDLER)) != null && !string2.equals("")) {
                try {
                    entryHandler = (DiscoEntryHandler)Class.forName(string2).newInstance();
                }
                catch (Exception exception) {
                    if (debug.messageEnabled()) {
                        debug.error("DiscoServiceManager.setValues: Exception when instantiating entry handler. Using default DiscoEntryHandler. Exception", (Throwable)exception);
                    }
                    entryHandler = new UserDiscoEntryHandler();
                }
            } else {
                entryHandler = new UserDiscoEntryHandler();
            }
            Set set = (Set)map.get(ATTR_ID_MAPPER);
            HashMap<String, ResourceIDMapper> hashMap = new HashMap<String, ResourceIDMapper>();
            if (set != null) {
                object = set.iterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                    if (stringTokenizer.countTokens() == 2) {
                        String string4 = null;
                        ResourceIDMapper resourceIDMapper = null;
                        while (stringTokenizer.hasMoreTokens()) {
                            String string5 = stringTokenizer.nextToken();
                            int n = -1;
                            n = string5.indexOf("=");
                            if (n == -1) {
                                debug.error("DiscoServiceManager.setValues: illegal format for ResourceIDMapper:" + string5);
                                break;
                            }
                            int n2 = n + 1;
                            if (n2 >= string5.length()) {
                                debug.error("DiscoServiceManager.setValues: illegal format of ResourceIDMapper:" + string5);
                                break;
                            }
                            String string6 = string5.substring(0, n);
                            if (string6.equalsIgnoreCase(KEY_PROVIDER_ID)) {
                                string4 = string5.substring(n2);
                                continue;
                            }
                            if (string6.equalsIgnoreCase(KEY_IDMAPPER)) {
                                try {
                                    resourceIDMapper = (ResourceIDMapper)Class.forName(string5.substring(n2)).newInstance();
                                    continue;
                                }
                                catch (Exception exception) {
                                    debug.error("DiscoServiceManager.setValues: couldn't instantiate ResourceIDMapper: " + string5 + ":", (Throwable)exception);
                                    break;
                                }
                            }
                            debug.error("DiscoServiceManager.setValues: illegal format of ResourceIDMapper:" + string5);
                            break;
                        }
                        if (string4 == null || resourceIDMapper == null) {
                            debug.error("DiscoServiceManager.setValues: Invalid syntax for ResourceIDMapper:" + string);
                            continue;
                        }
                        hashMap.put(string4, resourceIDMapper);
                        continue;
                    }
                    if (!debug.warningEnabled()) continue;
                    debug.warning("DiscoServiceManager.setValues: Invalid syntax for ResourceIDMapper:" + string);
                }
            }
            idMappers = hashMap;
            object = Misc.getMapAttr((Map)map, (String)ATTR_BOOTSTRAPPING_DISCO_ENTRY);
            if (object != null && !((String)object).equals("")) {
                try {
                    string = jc.createUnmarshaller();
                    bootDiscoEntry = (DiscoEntryElement)string.unmarshal((Source)new StreamSource(new StringReader((String)object)));
                }
                catch (Exception exception) {
                    debug.error("DiscoServiceManager.setValues: Exception when creating Disco Resource Offering:", (Throwable)exception);
                    bootDiscoEntry = null;
                }
            } else {
                if (debug.messageEnabled()) {
                    debug.message("DiscoServiceManager.setValues: no Discovery Resource Offering specified.");
                }
                bootDiscoEntry = null;
            }
            requireSessionContextStmt = Boolean.valueOf(Misc.getMapAttr((Map)map, (String)ATTR_BOOTSTRAPPING_SESSION_CONTEXT, (String)"false"));
            if (debug.messageEnabled()) {
                debug.message("DiscoServiceManager.setValues: need Session Context Statement?" + requireSessionContextStmt);
            }
        }
        catch (Exception exception) {
            debug.error("DiscoServiceManager.setValues: Exception", (Throwable)exception);
        }
    }

    public static boolean needSessionContextStatement() {
        return requireSessionContextStmt;
    }

    static {
        try {
            String string = AdminUtils.getAdminDN();
            String string2 = new String(AdminUtils.getAdminPassword());
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(DISCO_SERVICE, sSOToken);
            serviceSchema = serviceSchemaManager.getGlobalSchema();
            jc = JAXBContext.newInstance((String)Utils.getJAXBPackages());
            DiscoServiceManager.setValues();
            serviceSchemaManager.addListener(new DiscoServiceManager());
        }
        catch (SSOException sSOException) {
            debug.error("DiscoServiceManager.static: Unable to get sso token:", (Throwable)sSOException);
        }
        catch (SMSException sMSException) {
            debug.error("DiscoServiceManager.static: Unable to access service schema:", (Throwable)sMSException);
        }
        catch (JAXBException jAXBException) {
            debug.error("DiscoServiceManager.static: Unable to get JAXBContext:", (Throwable)jAXBException);
        }
    }
}

