/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.RequestedService;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Query {
    private String id = null;
    private ResourceID resourceID = null;
    private EncryptedResourceID encryptResID = null;
    private List requestedService = null;

    public Query(ResourceID resourceID, List list) {
        this.resourceID = resourceID;
        this.requestedService = list;
    }

    public Query(EncryptedResourceID encryptedResourceID, List list) {
        this.encryptResID = encryptedResourceID;
        this.requestedService = list;
    }

    public Query(Element element) throws DiscoveryException {
        String string;
        if (element == null) {
            DiscoUtils.debug.message("Query(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String string2 = element.getLocalName();
        if (string2 == null || !string2.equals("Query") || (string = element.getNamespaceURI()) == null || !string.equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.message("Query(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        this.id = element.getAttribute("id");
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node = nodeList.item(n);
            string2 = node.getLocalName();
            if (string2 != null) {
                string = ((Element)node).getNamespaceURI();
                if (string == null || !string.equals("urn:liberty:disco:2003-08")) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("Query(Element): invalid namespace for node " + string2);
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
                }
                if (string2.equals("ResourceID")) {
                    if (this.resourceID != null || this.encryptResID != null) {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("Query(Element): Included more than one ResourceIDGroup element.");
                        }
                        throw new DiscoveryException(DiscoUtils.bundle.getString("moreResourceIDGroup"));
                    }
                    this.resourceID = new ResourceID((Element)node);
                } else if (string2.equals("EncryptedResourceID")) {
                    if (this.resourceID != null || this.encryptResID != null) {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("Query(Element): Included more than one ResourceIDGroup element.");
                        }
                        throw new DiscoveryException(DiscoUtils.bundle.getString("moreResourceIDGroup"));
                    }
                    this.encryptResID = new EncryptedResourceID((Element)node);
                } else if (string2.equals("RequestedService")) {
                    if (this.requestedService == null) {
                        this.requestedService = new ArrayList();
                    }
                    this.requestedService.add(new RequestedService((Element)node));
                } else {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("Query(Element): invalid node" + string2);
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
                }
            }
            ++n;
        }
        if (this.resourceID == null && this.encryptResID == null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Query(Element): missing ResourceID or EncryptedResourceID element.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingResourceIDGroup"));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public EncryptedResourceID getEncryptedResourceID() {
        return this.encryptResID;
    }

    public void setEncryptedResourceID(EncryptedResourceID encryptedResourceID) {
        this.encryptResID = encryptedResourceID;
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(ResourceID resourceID) {
        this.resourceID = resourceID;
    }

    public List getRequestedServiceType() {
        return this.requestedService;
    }

    public void setRequestedServiceType(List list) {
        this.requestedService = list;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<Query xmlns=\"").append("urn:liberty:disco:2003-08").append("\"");
        if (this.id != null && !this.id.equals("")) {
            stringBuffer.append(" id=\"").append(this.id).append("\"");
        }
        stringBuffer.append(">");
        if (this.resourceID != null) {
            stringBuffer.append(this.resourceID.toString());
        } else if (this.encryptResID != null) {
            stringBuffer.append(this.encryptResID.toString());
        }
        if (this.requestedService != null && !this.requestedService.isEmpty()) {
            Iterator iterator = this.requestedService.iterator();
            Object var3_3 = null;
            while (iterator.hasNext()) {
                stringBuffer.append(((RequestedService)iterator.next()).toString());
            }
        }
        stringBuffer.append("</Query>");
        return stringBuffer.toString();
    }
}

