/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.liberty.ws.common.LogUtil;
import com.sun.identity.liberty.ws.common.jaxb.assertion.AssertionType;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.common.DiscoConstants;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.jaxb.AuthenticateRequesterElement;
import com.sun.identity.liberty.ws.disco.jaxb.AuthenticateSessionContextElement;
import com.sun.identity.liberty.ws.disco.jaxb.AuthorizeRequesterElement;
import com.sun.identity.liberty.ws.disco.jaxb.DescriptionType;
import com.sun.identity.liberty.ws.disco.jaxb.DirectiveType;
import com.sun.identity.liberty.ws.disco.jaxb.EncryptResourceIDElement;
import com.sun.identity.liberty.ws.disco.jaxb.EncryptedResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.InsertEntryType;
import com.sun.identity.liberty.ws.disco.jaxb.ModifyResponseElement;
import com.sun.identity.liberty.ws.disco.jaxb.ModifyType;
import com.sun.identity.liberty.ws.disco.jaxb.QueryResponseElement;
import com.sun.identity.liberty.ws.disco.jaxb.QueryResponseType;
import com.sun.identity.liberty.ws.disco.jaxb.QueryType;
import com.sun.identity.liberty.ws.disco.jaxb.RemoveEntryType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceOfferingType;
import com.sun.identity.liberty.ws.disco.jaxb.StatusType;
import com.sun.identity.liberty.ws.disco.plugins.DiscoEntryHandler;
import com.sun.identity.liberty.ws.interfaces.Authorizer;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.RequestHandler;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.assertion.NameIdentifier;
import java.io.StringReader;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DiscoveryService
implements RequestHandler {
    private static final String OFFERINGS = "offerings";
    private static final String CREDENTIALS = "credentials";
    private static final String CREDENTIALS_OBJ = "credentialsObj";
    private static final String RES_STMT = "ResourceAccess";
    private static final String RES_SESSION_STMT = "ResourceAccess_Session";
    private static final String SESSION_STMT = "SessionContext";
    private static SecurityTokenManager stm = null;

    public DiscoveryService() {
        DiscoUtils.debug.message("In DiscoveryService constructor.");
    }

    public Message processRequest(Message message) throws Exception {
        Set set;
        List list = message.getBodies();
        if ((list = Utils.convertElementToJAXB(list)).size() != 1) {
            DiscoUtils.debug.error("DiscoService.processRequest: SOAP message didn't contain one SOAP body.");
            throw new Exception(DiscoUtils.bundle.getString("oneBody"));
        }
        String string = message.getAuthenticationMechanism();
        if (DiscoUtils.debug.messageEnabled()) {
            DiscoUtils.debug.message("DiscoService.processRequest: authentication mechanism =" + string);
        }
        if ((set = DiscoServiceManager.getSupportedAuthenticationMechanisms()) == null || !set.contains(string)) {
            DiscoUtils.debug.error("DiscoService.processRequest: AuthenticationMechanism used is not supported by this service:" + string);
            throw new Exception(DiscoUtils.bundle.getString("authnMechNotSupported"));
        }
        Message message2 = null;
        ProviderHeader providerHeader = null;
        try {
            providerHeader = new ProviderHeader(DiscoServiceManager.getDiscoProviderID());
        }
        catch (SOAPBindingException sOAPBindingException) {
            throw new DiscoveryException(sOAPBindingException.getMessage());
        }
        if (string.equals("urn:liberty:security:2003-08:null:X509") || string.equals("urn:liberty:security:2003-08:null:SAML") || string.equals("urn:liberty:security:2003-08:TLS:X509") || string.equals("urn:liberty:security:2003-08:TLS:SAML") || string.equals("urn:liberty:security:2003-08:ClientTLS:X509") || string.equals("urn:liberty:security:2003-08:ClientTLS:SAML")) {
            try {
                message2 = new Message(providerHeader, stm.getX509CertificateToken());
            }
            catch (Exception exception) {
                DiscoUtils.debug.error("DiscoveryService.processRequest:couldn't generate Message with X509 token: ", (Throwable)exception);
                throw new DiscoveryException(exception.getMessage());
            }
        }
        try {
            message2 = new Message(providerHeader);
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("DiscoveryService.processRequest:couldn't generate Message with X509 token: ", (Throwable)exception);
            throw new DiscoveryException(exception.getMessage());
        }
        Object e = list.iterator().next();
        if (e instanceof QueryType) {
            message2.setSOAPBody(this.lookup((QueryType)e, message));
        } else if (e instanceof ModifyType) {
            message2.setSOAPBody(Utils.convertJAXBToElement(this.update((ModifyType)e, message)));
        } else {
            DiscoUtils.debug.error("DiscoService.processRequest: SOAPBody is not a Disco message.");
            throw new Exception(DiscoUtils.bundle.getString("bodyNotDisco"));
        }
        return message2;
    }

    private Element lookup(QueryType queryType, Message message) throws JAXBException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        DiscoUtils.debug.message("in lookup.");
        QueryResponseElement queryResponseElement = null;
        StatusType statusType = null;
        try {
            queryResponseElement = DiscoUtils.getDiscoFactory().createQueryResponseElement();
            statusType = DiscoUtils.getDiscoFactory().createStatusType();
            queryResponseElement.setStatus(statusType);
        }
        catch (JAXBException jAXBException) {
            DiscoUtils.debug.error("DiscoService.lookup: couldn't form QueryResponse:", (Throwable)jAXBException);
            throw jAXBException;
        }
        String string2 = null;
        ResourceIDType resourceIDType = queryType.getResourceID();
        string2 = resourceIDType == null ? this.getResourceID(queryType.getEncryptedResourceID()) : resourceIDType.getValue();
        String string3 = DiscoServiceManager.getDiscoProviderID();
        ResourceIDMapper resourceIDMapper = DiscoServiceManager.getResourceIDMapper(string3);
        if (resourceIDMapper == null) {
            resourceIDMapper = DiscoServiceManager.getDefaultResourceIDMapper();
        }
        if ((string = resourceIDMapper.getUserID(string3, string2)) == null) {
            DiscoUtils.debug.error("DiscoService.lookup: couldn't find the user associated with the resourceID:" + string2);
            statusType.setCode(DiscoConstants.QNAME_FAILED);
            Document document = null;
            try {
                document = XMLUtils.newDocument();
            }
            catch (Exception exception) {
                DiscoUtils.debug.error("DiscoService.lookup:", (Throwable)exception);
            }
            DiscoUtils.getDiscoMarshaller().marshal((Object)queryResponseElement, (Node)document);
            return document.getDocumentElement();
        }
        if (DiscoUtils.debug.messageEnabled()) {
            DiscoUtils.debug.message("DiscoService.lookup: userDN=" + string);
        }
        DiscoEntryHandler discoEntryHandler = DiscoServiceManager.getDiscoEntryHandler();
        Map map = discoEntryHandler.getDiscoEntries(string, queryType.getRequestedServiceType());
        Collection collection = map.values();
        String string4 = DiscoUtils.bundle.getString("messageID") + "=" + message.getCorrelationHeader().getMessageID() + "." + DiscoUtils.bundle.getString("providerID") + "=" + string3 + "." + DiscoUtils.bundle.getString("securityMechID") + "=" + message.getAuthenticationMechanism() + "." + DiscoUtils.bundle.getString("resourceOfferingID") + "=" + string2 + "." + DiscoUtils.bundle.getString("operation") + "=" + "Lookup";
        Map map2 = null;
        if (collection.size() == 0) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("DiscoService.lookup: lookup NoResults for user:" + string);
            }
            statusType.setCode(DiscoConstants.QNAME_FAILED);
            LogUtil.error(Level.INFO, string4, "DS_Lookup_Failure");
        } else {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("DiscoService.lookup: find " + collection.size() + "ResourceOfferings for userDN:" + string);
            }
            object5 = null;
            if (DiscoServiceManager.needPolicyEvalLookup()) {
                DiscoUtils.debug.message("DiscoService.lookup:needPolicyEval.");
                object5 = DiscoServiceManager.getAuthorizer();
            }
            if ((object4 = (List)(map2 = this.checkPolicyAndHandleDirectives(string, message, collection, (Authorizer)object5)).get(OFFERINGS)).isEmpty()) {
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("DiscoService.lookup: after policy check and directive handling, NoResults for:" + string);
                }
                statusType.setCode(DiscoConstants.QNAME_FAILED);
                LogUtil.error(Level.INFO, string4, "DS_Lookup_Failure");
            } else {
                queryResponseElement.getResourceOffering().addAll(object4);
                DiscoUtils.debug.message("after resp.getresoff.addall");
                object3 = (Collection)map2.get(CREDENTIALS_OBJ);
                if (object3 != null && !object3.isEmpty()) {
                    DiscoUtils.debug.message("DiscoService.lookup: has cred.");
                    object2 = DiscoUtils.getDiscoFactory().createQueryResponseTypeCredentialsType();
                    object = object3.iterator();
                    while (object.hasNext()) {
                        object2.getAny().add((AssertionType)object.next());
                    }
                    queryResponseElement.setCredentials((QueryResponseType.CredentialsType)object2);
                }
                statusType.setCode(DiscoConstants.QNAME_OK);
                LogUtil.access(Level.INFO, string4, "DS_Lookup_Success");
            }
        }
        object5 = null;
        try {
            object5 = XMLUtils.newDocument();
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("DiscoService.lookup:", (Throwable)exception);
        }
        DiscoUtils.getDiscoMarshaller().marshal((Object)queryResponseElement, (Node)object5);
        object4 = object5.getElementsByTagNameNS("*", "Credentials");
        if (object4.getLength() == 1) {
            object3 = object5.getDocumentElement();
            object2 = object5.createElement("Credentials");
            object = (List)map2.get(CREDENTIALS);
            Iterator iterator = object.iterator();
            try {
                while (iterator.hasNext()) {
                    Element element = XMLUtils.toDOMDocument((String)((SecurityAssertion)iterator.next()).toString(true, true), null).getDocumentElement();
                    object2.appendChild(object5.importNode(element, true));
                }
            }
            catch (Exception exception) {
                DiscoUtils.debug.error("lookup: cannot create credential node:", (Throwable)exception);
            }
            object3.replaceChild((Node)object2, object4.item(0));
        }
        return object5.getDocumentElement();
    }

    private Map checkPolicyAndHandleDirectives(String string, Message message, Collection collection, Authorizer authorizer) {
        Object object;
        DiscoUtils.debug.message("DiscoService.checkPolicyAndHandleDirectives");
        LinkedList<ResourceOfferingType> linkedList = new LinkedList<ResourceOfferingType>();
        LinkedList<SecurityAssertion> linkedList2 = new LinkedList<SecurityAssertion>();
        HashMap<String, AssertionType> hashMap = new HashMap<String, AssertionType>();
        HashMap hashMap2 = new HashMap();
        HashMap<String, Object> hashMap3 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            object = (InsertEntryType)iterator.next();
            if (authorizer != null) {
                if (hashMap3 == null) {
                    hashMap3 = new HashMap<String, Object>();
                    hashMap3.put("userID", string);
                    hashMap3.put("authType", message.getAuthenticationMechanism());
                    hashMap3.put("message", message);
                }
                if (!authorizer.isAuthorized(message.getToken(), "LOOKUP", object.getResourceOffering(), hashMap3)) {
                    DiscoUtils.debug.error("DiscoveryService.checkPolicyAndHandleDirectives: WSC is not authorized to do lookup");
                    continue;
                }
            }
            ResourceOfferingType resourceOfferingType = object.getResourceOffering();
            List list = object.getAny();
            if (list == null || list.isEmpty()) {
                DiscoUtils.debug.message("DiscoService: no directives.");
                linkedList.add(resourceOfferingType);
                continue;
            }
            DiscoUtils.debug.message("DiscoService: has directives.");
            boolean bl = false;
            boolean bl2 = false;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                object5 = iterator2.next();
                if (object5 instanceof EncryptResourceIDElement) {
                    DiscoUtils.debug.message("DiscoService: has encrypt D");
                    continue;
                }
                if (object5 instanceof AuthenticateRequesterElement || object5 instanceof AuthorizeRequesterElement) {
                    bl = true;
                    continue;
                }
                if (object5 instanceof AuthenticateSessionContextElement) {
                    bl2 = true;
                    continue;
                }
                DiscoUtils.debug.error("DiscoveryService: directive type is not supported. Skip this offering.");
                resourceOfferingType = null;
                break;
            }
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("DiscoService: includeResStmt=" + bl + " includeSessionStmt=" + bl2);
            }
            if (resourceOfferingType == null) continue;
            if (!bl && !bl2) {
                linkedList.add(resourceOfferingType);
                continue;
            }
            object5 = list.iterator();
            HashMap<String, AssertionType> hashMap4 = new HashMap<String, AssertionType>();
            while (object5.hasNext()) {
                Unmarshaller unmarshaller;
                object4 = object5.next();
                if (object4 instanceof EncryptResourceIDElement) continue;
                object3 = resourceOfferingType.getServiceInstance().getProviderID();
                object2 = (Map)hashMap2.get(object3);
                String string2 = null;
                AssertionType assertionType = null;
                if (object2 != null && !object2.isEmpty()) {
                    if (bl) {
                        if (bl2) {
                            string2 = (String)object2.get(RES_SESSION_STMT);
                            assertionType = (AssertionType)hashMap.get(string2);
                        } else {
                            string2 = (String)object2.get(RES_STMT);
                            assertionType = (AssertionType)hashMap.get(string2);
                        }
                    } else {
                        string2 = (String)object2.get(SESSION_STMT);
                        assertionType = (AssertionType)hashMap.get(string2);
                    }
                }
                SecurityAssertion securityAssertion = null;
                if (string2 == null || string2.equals("")) {
                    securityAssertion = this.getCredential(message, bl, bl2, resourceOfferingType.getResourceID().getValue());
                    if (securityAssertion == null) {
                        DiscoUtils.debug.error("DiscoveryService: cannot generate credential.");
                        resourceOfferingType = null;
                        break;
                    }
                    linkedList2.add(securityAssertion);
                    unmarshaller = DiscoUtils.getDiscoUnmarshaller();
                    try {
                        DiscoUtils.debug.message("lookup: cred=" + securityAssertion.toString(true, true));
                        assertionType = (AssertionType)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(securityAssertion.toString())));
                    }
                    catch (JAXBException jAXBException) {
                        DiscoUtils.debug.error("lookup: cannot add credRef", (Throwable)jAXBException);
                        resourceOfferingType = null;
                        break;
                    }
                    string2 = securityAssertion.getAssertionID();
                    hashMap.put(string2, assertionType);
                    if (object2 == null) {
                        object2 = new HashMap<String, String>();
                    }
                    if (bl) {
                        if (bl2) {
                            if (DiscoUtils.debug.messageEnabled()) {
                                DiscoUtils.debug.message("DiscoService: credential generated for RES_SESSION_STMT and providerID=" + (String)object3);
                            }
                            object2.put(RES_SESSION_STMT, string2);
                        } else {
                            if (DiscoUtils.debug.messageEnabled()) {
                                DiscoUtils.debug.message("DiscoService:credential generated for RES_STMT and providerID=" + (String)object3);
                            }
                            object2.put(RES_STMT, string2);
                        }
                    } else {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("DiscoService: credential generated for SESSION_STMT and providerID=" + (String)object3);
                        }
                        object2.put(SESSION_STMT, string2);
                    }
                    hashMap2.put(object3, object2);
                }
                unmarshaller = ((DirectiveType)object4).getDescriptionIDRefs().iterator();
                while (unmarshaller.hasNext()) {
                    hashMap4.put(((DescriptionType)unmarshaller.next()).getId(), assertionType);
                }
            }
            if (resourceOfferingType == null) continue;
            if (!hashMap4.isEmpty()) {
                object4 = resourceOfferingType.getServiceInstance().getDescription().iterator();
                while (object4.hasNext()) {
                    object3 = (DescriptionType)object4.next();
                    object2 = object3.getId();
                    if (object2 == null || ((String)object2).equals("") || !hashMap4.containsKey(object2)) continue;
                    object3.getCredentialRef().add((AssertionType)hashMap4.get(object2));
                }
            }
            linkedList.add(resourceOfferingType);
        }
        object = new HashMap();
        object.put(OFFERINGS, linkedList);
        object.put(CREDENTIALS_OBJ, hashMap.values());
        object.put(CREDENTIALS, linkedList2);
        return object;
    }

    private SecurityAssertion getCredential(Message message, boolean bl, boolean bl2, Object object) {
        SecurityAssertion securityAssertion;
        block5: {
            securityAssertion = null;
            try {
                X509Certificate x509Certificate = message.getPeerCertificate();
                if (x509Certificate == null && (x509Certificate = message.getMessageCertificate()) == null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("DiscoveryService.getCredential: client cert is null. Cannot generate credential.");
                    }
                    return null;
                }
                NameIdentifier nameIdentifier = new NameIdentifier(message.getProviderHeader().getProviderID(), null, "urn:liberty:iff:nameid:entityID");
                SessionContext sessionContext = null;
                SecurityTokenManager securityTokenManager = new SecurityTokenManager((SSOToken)message.getToken());
                securityTokenManager.setCertificate(x509Certificate);
                if (object instanceof String) {
                    securityAssertion = securityTokenManager.getSAMLAuthorizationToken(nameIdentifier, sessionContext, (String)object, true, bl);
                    break block5;
                }
                securityAssertion = securityTokenManager.getSAMLAuthorizationToken(nameIdentifier, sessionContext, (EncryptedResourceID)object, true, bl);
            }
            catch (Exception exception) {
                DiscoUtils.debug.error("DiscoveryService.getCredential:couldn't generate credential: ", (Throwable)exception);
            }
        }
        return securityAssertion;
    }

    private ModifyResponseElement update(ModifyType modifyType, Message message) throws JAXBException {
        Map map;
        String string;
        DiscoUtils.debug.message("in update.");
        ModifyResponseElement modifyResponseElement = null;
        StatusType statusType = null;
        try {
            modifyResponseElement = DiscoUtils.getDiscoFactory().createModifyResponseElement();
            statusType = DiscoUtils.getDiscoFactory().createStatusType();
            modifyResponseElement.setStatus(statusType);
        }
        catch (JAXBException jAXBException) {
            DiscoUtils.debug.error("DiscoService.update: couldn't form ModifyResponse.");
            throw jAXBException;
        }
        String string2 = null;
        ResourceIDType resourceIDType = modifyType.getResourceID();
        string2 = resourceIDType == null ? this.getResourceID(modifyType.getEncryptedResourceID()) : resourceIDType.getValue();
        String string3 = DiscoServiceManager.getDiscoProviderID();
        ResourceIDMapper resourceIDMapper = DiscoServiceManager.getResourceIDMapper(string3);
        if (resourceIDMapper == null) {
            resourceIDMapper = DiscoServiceManager.getDefaultResourceIDMapper();
        }
        String string4 = resourceIDMapper.getUserID(string3, string2);
        String string5 = DiscoUtils.bundle.getString("messageID") + "=" + message.getCorrelationHeader().getMessageID() + "." + DiscoUtils.bundle.getString("providerID") + "=" + string3 + "." + DiscoUtils.bundle.getString("securityMechID") + "=" + message.getAuthenticationMechanism() + "." + DiscoUtils.bundle.getString("resourceOfferingID") + "=" + string2 + "." + DiscoUtils.bundle.getString("operation") + "=" + "Update";
        if (string4 == null) {
            DiscoUtils.debug.error("DiscoService.update: couldn't find user from resourceID: " + string2);
            statusType.setCode(DiscoConstants.QNAME_FAILED);
            LogUtil.error(Level.INFO, string5, "DS_Update_Failure");
            return modifyResponseElement;
        }
        DiscoEntryHandler discoEntryHandler = DiscoServiceManager.getDiscoEntryHandler();
        if (DiscoServiceManager.needPolicyEvalUpdate()) {
            DiscoUtils.debug.message("DiscoService.lookup: needPolicyEval.");
            if (!this.isUpdateAllowed(string4, message, modifyType.getRemoveEntry(), modifyType.getInsertEntry(), discoEntryHandler, DiscoServiceManager.getAuthorizer())) {
                statusType.setCode(DiscoConstants.QNAME_FAILED);
                LogUtil.error(Level.INFO, string5, "DS_Update_Failure");
                return modifyResponseElement;
            }
        }
        if ((string = (String)(map = discoEntryHandler.modifyDiscoEntries(string4, modifyType.getRemoveEntry(), modifyType.getInsertEntry())).get("STATUS_CODE")).equals("OK")) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("DiscoService.update: modified DiscoEntries through DiscoEntryHandler successfully.");
            }
            statusType.setCode(DiscoConstants.QNAME_OK);
            List list = (List)map.get("newEntryIDs");
            if (list != null && list.size() != 0) {
                modifyResponseElement.getNewEntryIDs().addAll(list);
            }
            LogUtil.access(Level.INFO, string5, "DS_Update_Success");
        } else {
            DiscoUtils.debug.error("DiscoService.update: couldn't modify DiscoEntries through DiscoEntryHandler.");
            statusType.setCode(DiscoConstants.QNAME_FAILED);
            LogUtil.error(Level.INFO, string5, "DS_Update_Failure");
        }
        return modifyResponseElement;
    }

    private boolean isUpdateAllowed(String string, Message message, List list, List list2, DiscoEntryHandler discoEntryHandler, Authorizer authorizer) {
        Object object;
        DiscoUtils.debug.message("DiscoService.isUpdateAllowed.");
        HashMap<String, Object> hashMap = null;
        if (list != null && list.size() != 0) {
            object = discoEntryHandler.getDiscoEntries(string, null);
            Iterator iterator = list.iterator();
            String string2 = null;
            while (iterator.hasNext()) {
                string2 = ((RemoveEntryType)iterator.next()).getEntryID();
                if (!object.containsKey(string2)) {
                    DiscoUtils.debug.error("DiscoveryService.isUpdateAllowed: remove entry not exits: " + string2);
                    return false;
                }
                if (hashMap == null) {
                    hashMap = new HashMap();
                    hashMap.put("userID", string);
                    hashMap.put("authType", message.getAuthenticationMechanism());
                    hashMap.put("message", message);
                }
                if (authorizer.isAuthorized(message.getToken(), "UPDATE", ((InsertEntryType)object.get(string2)).getResourceOffering(), hashMap)) continue;
                DiscoUtils.debug.error("DiscoveryService.isUpdateAllowed: WSC is not authorized to remove entry: " + string2);
                return false;
            }
        }
        if (list2 != null && list2.size() != 0) {
            object = list2.iterator();
            while (object.hasNext()) {
                if (hashMap == null) {
                    hashMap = new HashMap<String, Object>();
                    hashMap.put("userID", string);
                    hashMap.put("authType", message.getAuthenticationMechanism());
                    hashMap.put("message", message);
                }
                if (authorizer.isAuthorized(message.getToken(), "UPDATE", ((InsertEntryType)object.next()).getResourceOffering(), hashMap)) continue;
                DiscoUtils.debug.error("DiscoveryService.isUpdateAllowed: WSC is not authorized to insert entry.");
                return false;
            }
        }
        return true;
    }

    private String getResourceID(EncryptedResourceIDType encryptedResourceIDType) {
        return null;
    }

    static {
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(AdminUtils.getAdminDN()), new String(AdminUtils.getAdminPassword()));
            stm = new SecurityTokenManager(sSOToken);
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("DiscoveryService.static: unable to get SecurityTokenManager: ", (Throwable)exception);
        }
    }
}

