/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.iplanet.sso.SSOToken;
import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.Description;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.Modify;
import com.sun.identity.liberty.ws.disco.ModifyResponse;
import com.sun.identity.liberty.ws.disco.Query;
import com.sun.identity.liberty.ws.disco.QueryResponse;
import com.sun.identity.liberty.ws.disco.RequestedService;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.ServiceInstance;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.soapbinding.Client;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.saml.assertion.NameIdentifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class DiscoveryClient {
    private String connectTo = null;
    private int clientMech = 0;
    private ResourceID resID = null;
    private EncryptedResourceID encResID = null;
    private String certAlias = null;
    private String providerID = null;
    private boolean clientAuth = false;
    private SecurityAssertion assertion = null;
    private BinarySecurityToken token = null;
    private ResourceOffering offering = null;
    private boolean processed = true;
    private String soapAction = null;
    private SSOToken ssoToken = null;

    public DiscoveryClient(String string, String string2) {
        this.connectTo = string;
        this.providerID = string2;
    }

    public DiscoveryClient(SecurityAssertion securityAssertion, String string, String string2) {
        this.connectTo = string;
        this.clientMech = 2;
        this.assertion = securityAssertion;
        this.providerID = string2;
    }

    public DiscoveryClient(BinarySecurityToken binarySecurityToken, String string, String string2) {
        this.connectTo = string;
        this.clientMech = 1;
        this.token = binarySecurityToken;
        this.providerID = string2;
    }

    public DiscoveryClient(ResourceOffering resourceOffering, SSOToken sSOToken, String string) {
        this.offering = resourceOffering;
        this.processed = false;
        this.ssoToken = sSOToken;
        this.providerID = string;
    }

    private void processResourceOffering() throws DiscoveryException {
        ServiceInstance serviceInstance = this.offering.getServiceInstance();
        if (!serviceInstance.getServiceType().equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.error("DiscoveryClient.processResourceOffering: ServiceType in ResourceOffering is not discovery service type.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("notDiscoServiceType"));
        }
        this.resID = this.offering.getResourceID();
        this.encResID = this.offering.getEncryptedResourceID();
        List list = serviceInstance.getDescription();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Description description = (Description)iterator.next();
            this.connectTo = description.getEndpoint();
            this.soapAction = description.getSoapAction();
            Iterator iterator2 = description.getSecurityMechID().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                if (string.equals("urn:liberty:security:2003-08:null:null") || string.equals("urn:liberty:security:2003-08:TLS:null") || string.equals("urn:liberty:security:2003-08:ClientTLS:null")) {
                    this.clientMech = 0;
                    DiscoUtils.debug.message("DiscoClient: null");
                    if (string.equals("urn:liberty:security:2003-08:ClientTLS:null")) {
                        this.clientAuth = true;
                        DiscoUtils.debug.message("DiscoClient: clientAuth on");
                    }
                    return;
                }
                if (string.equals("urn:liberty:security:2003-08:null:X509") || string.equals("urn:liberty:security:2003-08:TLS:X509") || string.equals("urn:liberty:security:2003-08:ClientTLS:X509")) {
                    this.clientMech = 1;
                    DiscoUtils.debug.message("DiscoClient: x509");
                    try {
                        SecurityTokenManager securityTokenManager = new SecurityTokenManager(this.ssoToken);
                        securityTokenManager.setCertAlias(this.certAlias);
                        this.token = securityTokenManager.getX509CertificateToken();
                    }
                    catch (Exception exception) {
                        DiscoUtils.debug.error("DiscoveryClient.processResourceOffering: couldn't generate X509 token: ", (Throwable)exception);
                        throw new DiscoveryException(exception.getMessage());
                    }
                    if (string.equals("urn:liberty:security:2003-08:ClientTLS:X509")) {
                        this.clientAuth = true;
                        DiscoUtils.debug.message("DiscoClient: clientAuth on");
                    }
                    return;
                }
                if (!string.equals("urn:liberty:security:2003-08:null:SAML") && !string.equals("urn:liberty:security:2003-08:TLS:SAML") && !string.equals("urn:liberty:security:2003-08:ClientTLS:SAML")) continue;
                this.clientMech = 2;
                DiscoUtils.debug.message("DiscoClient: saml token");
                try {
                    SecurityTokenManager securityTokenManager = new SecurityTokenManager(this.ssoToken);
                    securityTokenManager.setCertAlias(this.certAlias);
                    NameIdentifier nameIdentifier = new NameIdentifier(this.providerID, null, "urn:liberty:iff:nameid:entityID");
                    this.assertion = securityTokenManager.getSAMLAuthenticationToken(nameIdentifier);
                }
                catch (Exception exception) {
                    DiscoUtils.debug.error("DiscoveryClient.processResourceOffering: couldn't generate SAML token: ", (Throwable)exception);
                    throw new DiscoveryException(exception.getMessage());
                }
                if (string.equals("urn:liberty:security:2003-08:ClientTLS:SAML")) {
                    this.clientAuth = true;
                    DiscoUtils.debug.message("DiscoClient: clientAuth on");
                }
                return;
            }
        }
        DiscoUtils.debug.error("DiscoveryClient.processResourceOffering: Couldn't find supported SecurityMechID from ResourceOffering.");
        throw new DiscoveryException(DiscoUtils.bundle.getString("noSupportedSecuMechID"));
    }

    public void setClientCert(String string) {
        this.certAlias = string;
    }

    public void setClientAuthentication(boolean bl) {
        this.clientAuth = bl;
    }

    public void setResourceID(String string) {
        this.resID = new ResourceID(string);
    }

    public void setResourceID(EncryptedResourceID encryptedResourceID) {
        this.encResID = encryptedResourceID;
    }

    public void setProviderID(String string) {
        this.providerID = string;
    }

    public QueryResponse getResourceOffering(List list) throws DiscoveryException {
        if (!this.processed) {
            this.processResourceOffering();
            this.processed = true;
        }
        Query query = null;
        Iterator iterator = list.iterator();
        ArrayList<RequestedService> arrayList = new ArrayList<RequestedService>();
        while (iterator.hasNext()) {
            arrayList.add(new RequestedService(null, (String)iterator.next()));
        }
        query = this.resID != null ? new Query(this.resID, arrayList) : new Query(this.encResID, arrayList);
        return this.getResourceOffering(query);
    }

    public QueryResponse getResourceOffering(Query query) throws DiscoveryException {
        Message message = this.createRequest();
        message.setSOAPBody(DiscoUtils.parseXML(query.toString()));
        return new QueryResponse(this.getResponse(message));
    }

    private Message createRequest() throws DiscoveryException {
        if (!this.processed) {
            this.processResourceOffering();
            this.processed = true;
        }
        Message message = null;
        ProviderHeader providerHeader = null;
        try {
            providerHeader = new ProviderHeader(this.providerID);
        }
        catch (SOAPBindingException sOAPBindingException) {
            throw new DiscoveryException(sOAPBindingException.getMessage());
        }
        if (this.clientMech == 1) {
            DiscoUtils.debug.message("DiscoveryClient.createRequest: mech=x509");
            try {
                message = new Message(providerHeader, this.token);
            }
            catch (SOAPBindingException sOAPBindingException) {
                throw new DiscoveryException(sOAPBindingException.getMessage());
            }
        }
        if (this.clientMech == 2) {
            DiscoUtils.debug.message("DiscoveryClient.createRequest: mech=saml");
            try {
                message = new Message(providerHeader, this.assertion);
            }
            catch (SOAPBindingException sOAPBindingException) {
                throw new DiscoveryException(sOAPBindingException.getMessage());
            }
        }
        if (DiscoUtils.debug.messageEnabled()) {
            DiscoUtils.debug.message("DiscoveryClient.createRequest: mech=anon");
        }
        try {
            message = new Message(providerHeader);
        }
        catch (SOAPBindingException sOAPBindingException) {
            throw new DiscoveryException(sOAPBindingException.getMessage());
        }
        if (this.clientAuth) {
            message.setClientAuthentication(this.clientAuth);
        }
        return message;
    }

    private Element getResponse(Message message) throws DiscoveryException {
        Message message2 = null;
        try {
            message2 = Client.sendRequest(message, this.connectTo, this.certAlias, this.soapAction);
        }
        catch (Exception exception) {
            DiscoUtils.debug.error("DiscoveryClient.getResponse:", (Throwable)exception);
            throw new DiscoveryException(exception.getMessage());
        }
        List list = message2.getBodies();
        if (list.size() != 1) {
            DiscoUtils.debug.error("DiscoveryClient.getResponse: SOAP Response didn't contain one SOAPBody.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("oneBody"));
        }
        return (Element)list.iterator().next();
    }

    public ModifyResponse modify(Modify modify) throws DiscoveryException {
        Message message = this.createRequest();
        message.setSOAPBody(DiscoUtils.parseXML(modify.toString()));
        return new ModifyResponse(this.getResponse(message));
    }
}

