/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class Directive {
    public static final String AUTHENTICATE_REQUESTER = "AuthenticateRequester";
    public static final String AUTHORIZE_REQUESTER = "AuthorizeRequester";
    public static final String AUTHENTICATE_SESSION_CONTEXT = "AuthenticateSessionContext";
    public static final String ENCRYPT_RESOURCEID = "EncryptResourceID";
    private String type = null;
    private List descIDRefs = null;

    public Directive(String string) {
        this.type = string;
    }

    public Directive(Element element) throws DiscoveryException {
        String string = null;
        if (element == null) {
            DiscoUtils.debug.message("Directive(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        string = element.getLocalName();
        if (string == null) {
            DiscoUtils.debug.message("Directive(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        if (string.equals(AUTHENTICATE_REQUESTER)) {
            this.type = AUTHENTICATE_REQUESTER;
            this.setDescIDRefs(element);
        } else if (string.equals(AUTHORIZE_REQUESTER)) {
            this.type = AUTHORIZE_REQUESTER;
            this.setDescIDRefs(element);
        } else if (string.equals(AUTHENTICATE_SESSION_CONTEXT)) {
            this.type = AUTHENTICATE_SESSION_CONTEXT;
            this.setDescIDRefs(element);
        } else if (string.equals(ENCRYPT_RESOURCEID)) {
            this.type = ENCRYPT_RESOURCEID;
            this.setDescIDRefs(element);
        } else {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Directive(Element): not supported:" + string);
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("directiveNotSupported"));
        }
    }

    private void setDescIDRefs(Element element) {
        StringTokenizer stringTokenizer;
        String string = element.getAttribute("descriptionIDRefs");
        if (string != null && string.length() != 0 && (stringTokenizer = new StringTokenizer(string)).countTokens() > 0) {
            if (this.descIDRefs == null) {
                this.descIDRefs = new ArrayList();
            }
            while (stringTokenizer.hasMoreTokens()) {
                this.descIDRefs.add(stringTokenizer.nextToken());
            }
        }
    }

    public List getDescriptionIDRef() {
        return this.descIDRefs;
    }

    public void setDescriptionIDRef(List list) {
        this.descIDRefs = list;
    }

    public String getDirectiveType() {
        return this.type;
    }

    public void setDirectiveType(String string) {
        this.type = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<").append(this.type).append(" xmlns=\"").append("urn:liberty:disco:2003-08").append("\"");
        if (this.descIDRefs != null) {
            stringBuffer.append(" descriptionIDRefs=\"");
            Iterator iterator = this.descIDRefs.iterator();
            if (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
            while (iterator.hasNext()) {
                stringBuffer.append(" ").append((String)iterator.next());
            }
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append("</").append(this.type).append(">");
        return stringBuffer.toString();
    }
}

