/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Description {
    private String id = null;
    private List mechID = null;
    private List credentialRef = new ArrayList();
    private String soapEndpoint = null;
    private String soapAction = null;
    private QName serviceNameRef = null;
    private String wsdlURI = null;

    public Description() {
    }

    public Description(List list, List list2, String string) {
        this.mechID = list;
        this.credentialRef = list2;
        this.soapEndpoint = string;
    }

    public Description(Element element) throws DiscoveryException {
        String string;
        if (element == null) {
            DiscoUtils.debug.message("Description(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String string2 = element.getLocalName();
        if (string2 == null || !string2.equals("Description") || (string = element.getNamespaceURI()) == null || !string.equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.message("Description(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        this.id = element.getAttribute("id");
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node = nodeList.item(n);
            string2 = node.getLocalName();
            if (string2 != null) {
                String string3;
                string = ((Element)node).getNamespaceURI();
                if (string == null || !string.equals("urn:liberty:disco:2003-08")) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("Description(Element): invalid namespace for node " + string2);
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
                }
                if (string2.equals("SecurityMechID")) {
                    string3 = XMLUtils.getElementValue((Element)((Element)node));
                    if (string3 == null || string3.length() == 0) {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("Description(Element): missing SecurityMechID value.");
                        }
                        throw new DiscoveryException(DiscoUtils.bundle.getString("emptyElement"));
                    }
                    if (this.mechID == null) {
                        this.mechID = new ArrayList();
                    }
                    this.mechID.add(string3);
                } else if (string2.equals("CredentialRef")) {
                    string3 = XMLUtils.getElementValue((Element)((Element)node));
                    if (string3 == null || string3.length() == 0) {
                        if (DiscoUtils.debug.messageEnabled()) {
                            DiscoUtils.debug.message("Description(Element): missing CredentialRef value.");
                        }
                        throw new DiscoveryException(DiscoUtils.bundle.getString("emptyElement"));
                    }
                    if (this.credentialRef == null) {
                        this.credentialRef = new ArrayList();
                    }
                    this.credentialRef.add(string3);
                } else if (string2.equals("Endpoint")) {
                    this.parseEndpoint((Element)node);
                } else if (string2.equals("SoapAction")) {
                    this.parseSoapAction((Element)node);
                } else if (string2.equals("WsdlURI")) {
                    this.parseWsdlURI((Element)node);
                } else if (string2.equals("ServiceNameRef")) {
                    this.parseServiceNameRef((Element)node);
                } else {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("Description(Element): invalid node" + string2);
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
                }
            }
            ++n;
        }
        if (this.mechID == null || this.mechID.size() == 0) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("ServiceInstance(Element): missing SecurityMechID element.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingSecurityMechID"));
        }
        if (this.soapEndpoint == null && this.wsdlURI == null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("ServiceInstance(Element): missing WsdlRef or BriefSoapHttpDescription.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingWsdlOrBrief"));
        }
    }

    private void parseEndpoint(Element element) throws DiscoveryException {
        if (this.soapEndpoint != null || this.wsdlURI != null || this.serviceNameRef != null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): included more Endpoint.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
        }
        this.soapEndpoint = XMLUtils.getElementValue((Element)element);
        if (this.soapEndpoint == null || this.soapEndpoint.length() == 0) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): missing Endpoint value.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("emptyElement"));
        }
    }

    private void parseSoapAction(Element element) throws DiscoveryException {
        if (this.soapAction != null || this.wsdlURI != null || this.serviceNameRef != null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): included more SoapAction.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
        }
        this.soapAction = XMLUtils.getElementValue((Element)element);
        if (this.soapAction == null || this.soapAction.length() == 0) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): missing SoapAction value.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("emptyElement"));
        }
    }

    private void parseWsdlURI(Element element) throws DiscoveryException {
        if (this.soapEndpoint != null || this.wsdlURI != null || this.soapAction != null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): included more WsdlURI.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
        }
        this.wsdlURI = XMLUtils.getElementValue((Element)element);
        if (this.wsdlURI == null || this.wsdlURI.length() == 0) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): missing WsdlURI value.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("emptyElement"));
        }
    }

    private void parseServiceNameRef(Element element) throws DiscoveryException {
        Object object;
        if (this.soapEndpoint != null || this.serviceNameRef != null || this.soapAction != null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): included more WsdlURI.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
        }
        String string = XMLUtils.getElementValue((Element)element);
        if (string == null || string.length() == 0) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Description(Element): missing ServiceNameRef value.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("emptyElement"));
        }
        String string2 = string;
        String string3 = null;
        String string4 = "xmlns";
        if (string.indexOf(":") != -1) {
            object = new StringTokenizer(string2, ":");
            if (((StringTokenizer)object).countTokens() != 2) {
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("Description(Element): wrong ServiceNameRef value.");
                }
                throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
            }
            string3 = ((StringTokenizer)object).nextToken();
            string4 = string4 + ":" + string3;
            string2 = ((StringTokenizer)object).nextToken();
        }
        this.serviceNameRef = (object = element.getAttribute(string4)) != null && ((String)object).length() != 0 ? (string3 != null && string3.length() != 0 ? new QName((String)object, string2, string3) : new QName((String)object, string2)) : new QName(string2);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String string) {
        this.soapAction = string;
    }

    public List getSecurityMechID() {
        return this.mechID;
    }

    public QName getServiceNameRef() {
        return this.serviceNameRef;
    }

    public void setServiceNameRef(QName qName) {
        this.serviceNameRef = qName;
    }

    public String getWsdlURI() {
        return this.wsdlURI;
    }

    public void setWsdlURI(String string) {
        this.wsdlURI = string;
    }

    public List getCredentialRef() {
        return this.credentialRef;
    }

    public String getEndpoint() {
        return this.soapEndpoint;
    }

    public void setEndpoint(String string) {
        this.soapEndpoint = string;
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("<Description xmlns=\"").append("urn:liberty:disco:2003-08").append("\"");
        if (this.id != null && !this.id.equals("")) {
            stringBuffer.append(" id=\"").append(this.id).append("\"");
        }
        stringBuffer.append(">");
        if (this.mechID != null) {
            object = this.mechID.iterator();
            while (object.hasNext()) {
                stringBuffer.append("<SecurityMechID>").append((String)object.next()).append("</SecurityMechID>");
            }
        }
        if (this.credentialRef != null) {
            object = this.credentialRef.iterator();
            while (object.hasNext()) {
                stringBuffer.append("<CredentialRef>").append((String)object.next()).append("</CredentialRef>");
            }
        }
        if (this.soapEndpoint != null) {
            stringBuffer.append("<Endpoint>").append(this.soapEndpoint).append("</Endpoint>");
            if (this.soapAction != null) {
                stringBuffer.append("<SoapAction>").append(this.soapAction).append("</SoapAction>");
            }
        } else {
            stringBuffer.append("<WsdlURI>").append(this.wsdlURI).append("</WsdlURI>");
            stringBuffer.append("<ServiceNameRef");
            object = null;
            String string = this.serviceNameRef.getNamespaceURI();
            if (string != null && !string.equals("")) {
                stringBuffer.append(" xmlns:");
                object = this.serviceNameRef.getPrefix();
                if (object == null || ((String)object).equals("")) {
                    object = "ns1";
                }
                stringBuffer.append((String)object).append("=\"").append(string).append("\"");
            }
            stringBuffer.append(">");
            if (object != null) {
                stringBuffer.append((String)object).append(":");
            }
            stringBuffer.append(this.serviceNameRef.getLocalPart()).append("</ServiceNameRef>");
        }
        stringBuffer.append("</Description>");
        return stringBuffer.toString();
    }
}

