/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.common.wsse;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.sun.identity.saml.common.SAMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BinarySecurityToken {
    private String value = null;
    private QName valueType = null;
    private QName encodingType = null;
    private String id = null;
    private String xmlString = null;
    private static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"amBinarySecurityToken");
    private static Debug debug = Debug.getInstance((String)"amBinarySecurityToken");
    private static final String WSSE_NS = "http://schemas.xmlsoap.org/ws/2003/06/secext";
    private static final String WSU_NS = "http://schemas.xmlsoap.org/ws/2003/06/utility";
    private static final String WSSE = "wsse";
    private static final String WSU = "wsu";
    private static final String BINARY_SECURITY_TOKEN = "BinarySecurityToken";
    private static final String ENCODING_TYPE = "EncodingType";
    private static final String VALUE_TYPE = "ValueType";
    private static final String ID = "Id";
    private static final String XML_NS = "xmlns";
    public static final QName X509V3 = new QName("http://schemas.xmlsoap.org/ws/2003/06/secext", "X509v3", "wsse");
    public static final QName KERBEROSV5TGT = new QName("http://schemas.xmlsoap.org/ws/2003/06/secext", "Kerberosv5TGT", "wsse");
    public static final QName KERBEROSV5ST = new QName("http://schemas.xmlsoap.org/ws/2003/06/secext", "Kerberosv5ST", "wsse");
    public static final QName PKCS7 = new QName("http://schemas.xmlsoap.org/ws/2003/06/secext", "PKCS7", "wsse");
    public static final QName PKIPath = new QName("http://schemas.xmlsoap.org/ws/2003/06/secext", "PKIPath", "wsse");
    static Map valueMap = new HashMap();
    public static final QName BASE64BINARY;
    public static final QName HEXBINARY;
    static Map encodingMap;

    private BinarySecurityToken() {
    }

    public BinarySecurityToken(String string, QName qName, QName qName2) throws Exception {
        if (string == null || qName == null || qName2 == null) {
            debug.error("BinarySecurityToken: null input param");
            throw new Exception(bundle.getString("nullInputParameter"));
        }
        this.value = string;
        this.valueType = qName;
        this.encodingType = qName2;
        this.id = SAMLUtils.generateID();
    }

    public BinarySecurityToken(Element element) throws Exception {
        Object object;
        if (element == null) {
            debug.error("BinarySecurityToken: null input token");
            throw new Exception(bundle.getString("nullInputParameter"));
        }
        String string = element.getLocalName();
        if (string == null) {
            debug.error("BinarySecurityToken: local name missing");
            throw new Exception(bundle.getString("nullInput"));
        }
        if (!string.equals(BINARY_SECURITY_TOKEN)) {
            debug.error("BinarySecurityToken: invalid root element");
            throw new Exception(bundle.getString("invalidElement") + ":" + string);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap == null) {
            debug.error("BinarySecurityToken: missing attr in element");
            throw new Exception(bundle.getString("missingAttribute"));
        }
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            object = (Attr)namedNodeMap.item(n2);
            String string2 = object.getLocalName();
            if (string2 == null) {
                if (debug.messageEnabled()) {
                    debug.message("BST.Elemement, invalid attr " + string2);
                }
            } else if (string2.equals(ID)) {
                this.id = object.getValue();
            } else if (string2.equals(ENCODING_TYPE)) {
                this.encodingType = (QName)encodingMap.get(this.trimPrefix(object.getValue()));
            } else if (string2.equals(VALUE_TYPE)) {
                this.valueType = (QName)valueMap.get(this.trimPrefix(object.getValue()));
            }
            ++n2;
        }
        if (this.id == null || this.id.equals("")) {
            debug.error("BinarySecurityToken: ID missing");
            throw new Exception(bundle.getString("missingAttribute") + " : " + ID);
        }
        if (this.encodingType == null) {
            debug.error("BinarySecurityToken: encoding type missing");
            throw new Exception(bundle.getString("missingAttribute") + " : " + ENCODING_TYPE);
        }
        if (this.valueType == null) {
            debug.error("BinarySecurityToken: valueType missing");
            throw new Exception(bundle.getString("missingAttribute") + " : " + VALUE_TYPE);
        }
        try {
            this.value = element.getFirstChild().getNodeValue().trim();
        }
        catch (Exception exception) {
            debug.error("BinarySecurityToken: unable to get value", (Throwable)exception);
            this.value = null;
        }
        if (this.value == null) {
            debug.error("BinarySecurityToken: value missing");
            throw new Exception(bundle.getString("missingValue"));
        }
        object = new ByteArrayOutputStream(2000);
        XMLUtils.outputDOM((Node)element, (OutputStream)object);
        this.xmlString = ((ByteArrayOutputStream)object).toString();
    }

    private String trimPrefix(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        if (n == string.length()) {
            return "";
        }
        return string.substring(n + 1);
    }

    public QName getEncodingType() {
        return this.encodingType;
    }

    public QName getValueType() {
        return this.valueType;
    }

    public String getId() {
        return this.id;
    }

    public String getTokenValue() {
        return this.value;
    }

    public String toString() {
        if (this.xmlString == null) {
            this.xmlString = "<wsse:BinarySecurityToken xmlns:wsse=\"http://schemas.xmlsoap.org/ws/2003/06/secext\" xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2003/06/utility\" wsu:Id=\"" + this.id + "\" " + VALUE_TYPE + "=\"" + WSSE + ":" + this.valueType.getLocalPart() + "\" " + ENCODING_TYPE + "=\"" + WSSE + ":" + this.encodingType.getLocalPart() + "\">\n" + this.value.toString() + "\n" + "</" + WSSE + ":" + BINARY_SECURITY_TOKEN + ">\n";
        }
        return this.xmlString;
    }

    static {
        valueMap.put(X509V3.getLocalPart(), X509V3);
        valueMap.put(PKIPath.getLocalPart(), PKIPath);
        valueMap.put(PKCS7.getLocalPart(), PKCS7);
        valueMap.put(KERBEROSV5ST.getLocalPart(), KERBEROSV5ST);
        valueMap.put(KERBEROSV5TGT.getLocalPart(), KERBEROSV5TGT);
        BASE64BINARY = new QName(WSSE_NS, "Base64Binary", WSSE);
        HEXBINARY = new QName(WSSE_NS, "HexBinary", WSSE);
        encodingMap = new HashMap();
        encodingMap.put(HEXBINARY.getLocalPart(), HEXBINARY);
        encodingMap.put(BASE64BINARY.getLocalPart(), BASE64BINARY);
    }
}

