/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.common;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.log.Logger;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import java.security.AccessController;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogUtil {
    public static final String WS_SUCCESS = "WS_Success";
    public static final String WS_FAILURE = "WS_Failure";
    public static final String PP_QUERY_SUCCESS = "PP_Query_Success";
    public static final String PP_QUERY_FAILURE = "PP_Query_Failure";
    public static final String PP_MODIFY_SUCCESS = "PP_Modify_Success";
    public static final String PP_MODIFY_FAILURE = "PP_Modify_Failure";
    public static final String PP_INTERACTION_SUCCESS = "PP_Interaction_Success";
    public static final String PP_INTERACTION_FAILURE = "PP_Interaction_Failure";
    public static final String DS_LOOKUP_SUCCESS = "DS_Lookup_Success";
    public static final String DS_LOOKUP_FAILURE = "DS_Lookup_Failure";
    public static final String DS_UPDATE_SUCCESS = "DS_Update_Success";
    public static final String DS_UPDATE_FAILURE = "DS_Update_Failure";
    public static final String IS_SENDING_MESSAGE = "IS_Sending_Message";
    public static final String IS_RESENDING_MESSAGE = "IS_Resending_Message";
    public static final String IS_RETURNING_RESPONSE_MESSAGE = "IS_Returning_Response_Message";
    public static final String IS_REDIRECTED_USER_AGENT = "IS_Redirected_User_Agent";
    public static final String IS_REDIRECTED_USER_AGENT_BACK = "IS_Redirected_User_Agent_Back";
    public static final String IS_PRESENTED_QUERY_TO_USER_AGENT = "IS_Presented_Query_To_User_Agent";
    public static final String IS_COLLECTED_RESPONSE_FROM_USER_AGENT = "IS_Collected_Response_From_User_Agent";
    public static final String IS_RETURNING_RESPONSE_ELEMENT = "IS_Returning_Response_Element";
    private static final String ACCESS_LOG_NAME = "amLiberty.access";
    private static final String ERROR_LOG_NAME = "amLiberty.error";
    private static Debug debug;
    private static Logger accessLogger;
    private static Logger errorLogger;
    private static SSOToken authSSOToken;
    private static boolean logStatus;

    public static void access(Level level, String string, String string2) {
        if (authSSOToken == null) {
            return;
        }
        if (accessLogger.isLoggable(level)) {
            com.sun.identity.log.LogRecord logRecord = new com.sun.identity.log.LogRecord(level, string, (Object)authSSOToken);
            accessLogger.log((LogRecord)logRecord, (Object)authSSOToken);
        }
    }

    public static void error(Level level, String string, String string2) {
        if (authSSOToken == null) {
            return;
        }
        if (errorLogger.isLoggable(level)) {
            com.sun.identity.log.LogRecord logRecord = new com.sun.identity.log.LogRecord(level, string, (Object)authSSOToken);
            errorLogger.log((LogRecord)logRecord, (Object)authSSOToken);
        }
    }

    public static boolean isLogEnabled() {
        return logStatus;
    }

    static {
        Object object;
        debug = Debug.getInstance((String)"amLibertyLogUtil");
        accessLogger = null;
        errorLogger = null;
        authSSOToken = null;
        logStatus = false;
        String string = (String)AccessController.doPrivileged(new AdminDNAction());
        String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
        try {
            object = SSOTokenManager.getInstance();
            authSSOToken = object.createSSOToken((Principal)new AuthPrincipal(string), string2);
        }
        catch (SSOException sSOException) {
            debug.error("LogUtil.static: Unable to create SSOToken", (Throwable)sSOException);
        }
        accessLogger = (Logger)Logger.getLogger((String)ACCESS_LOG_NAME);
        errorLogger = (Logger)Logger.getLogger((String)ERROR_LOG_NAME);
        object = SystemProperties.get((String)"com.iplanet.am.logstatus");
        if (object == null) {
            object = "INACTIVE";
        }
        if (object.equalsIgnoreCase("ACTIVE")) {
            logStatus = true;
        }
    }
}

