/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.util;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.services.util.FSKeyStoreException;
import com.sun.identity.federation.services.util.FSKeyStoreSpi;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class FSKeyStoreProvider
implements FSKeyStoreSpi {
    private KeyStore keyStore = null;
    private static final String JKS = "JKS";
    private String privateKeyPass = null;
    private String keystorePass = "";
    private String keystoreFile = "";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize() throws FSKeyStoreException {
        BufferedReader bufferedReader = null;
        this.keystoreFile = SystemProperties.get((String)"com.sun.identity.saml.xmlsig.keystore");
        FSUtils.debug.message("keystore = " + this.keystoreFile);
        if (this.keystoreFile == null || this.keystoreFile.equals("")) {
            FSUtils.debug.error("XML signature: keystore file name not found");
            throw new FSKeyStoreException("internalError", null);
        }
        String string = SystemProperties.get((String)"com.sun.identity.saml.xmlsig.storepass");
        if (string == null) {
            FSUtils.debug.error("XML signature: keystore password file name not found");
            throw new FSKeyStoreException("internalError", null);
        }
        try {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
                this.keystorePass = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                FSUtils.debug.error("JKSKeyProvider.initialize: Unable to read keystore password file " + string);
                throw new FSKeyStoreException(iOException, FSUtils.bundle.getString("internalError"));
            }
            Object var5_3 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        bufferedReader.close();
        String string2 = SystemProperties.get((String)"com.sun.identity.saml.xmlsig.keypass");
        if (string2 == null) {
            FSUtils.debug.error("XML signature: key password file name not found");
            throw new FSKeyStoreException("internalError", null);
        }
        try {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string2)));
                this.privateKeyPass = bufferedReader.readLine();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                FSUtils.debug.error("FSKeyStoreProvider.initialize: Unable to read privatekey password file " + string);
                throw new FSKeyStoreException(exception, FSUtils.bundle.getString("internalError"));
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        bufferedReader.close();
        return;
    }

    public FSKeyStoreProvider() throws FSKeyStoreException {
        this.initialize();
        try {
            this.keyStore = KeyStore.getInstance(JKS);
            FileInputStream fileInputStream = new FileInputStream(this.keystoreFile);
            FSUtils.debug.message("store pass is " + this.keystorePass);
            this.keyStore.load(fileInputStream, this.keystorePass.toCharArray());
        }
        catch (FileNotFoundException fileNotFoundException) {
            FSUtils.debug.error("KeyStore could not be loaded: " + fileNotFoundException);
            throw new FSKeyStoreException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            FSUtils.debug.error("KeyStore could not be loaded: " + iOException);
            throw new FSKeyStoreException(iOException.getMessage());
        }
        catch (KeyStoreException keyStoreException) {
            FSUtils.debug.error("KeyStore could not be loaded: " + keyStoreException);
            throw new FSKeyStoreException(keyStoreException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            FSUtils.debug.error("KeyStore could not be loaded: " + noSuchAlgorithmException);
            throw new FSKeyStoreException(noSuchAlgorithmException.getMessage());
        }
        catch (CertificateException certificateException) {
            FSUtils.debug.error("KeyStore could not be loaded: " + certificateException);
            throw new FSKeyStoreException(certificateException.getMessage());
        }
    }

    public void setKey(String string, String string2) {
        this.keystorePass = string;
        this.privateKeyPass = string2;
    }

    public X509Certificate getX509Certificate(String string) throws FSKeyStoreException {
        try {
            return (X509Certificate)this.keyStore.getCertificate(string);
        }
        catch (KeyStoreException keyStoreException) {
            FSUtils.debug.error("Exception in getX509Certificate: " + keyStoreException);
            throw new FSKeyStoreException(keyStoreException.getMessage());
        }
    }

    public void addX509Certificate(X509Certificate x509Certificate, String string) throws FSKeyStoreException {
        try {
            this.keyStore.setCertificateEntry(string, x509Certificate);
            this.keyStore.store(new FileOutputStream(this.keystoreFile), this.keystorePass.toCharArray());
        }
        catch (FileNotFoundException fileNotFoundException) {
            FSUtils.debug.error("KeyStore could not be stored: " + fileNotFoundException);
            throw new FSKeyStoreException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            FSUtils.debug.error("KeyStore could not be stored: " + iOException);
            throw new FSKeyStoreException(iOException.getMessage());
        }
        catch (KeyStoreException keyStoreException) {
            FSUtils.debug.error("KeyStore could not be stored: " + keyStoreException);
            throw new FSKeyStoreException(keyStoreException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            FSUtils.debug.error("KeyStore could not be stored: " + noSuchAlgorithmException);
            throw new FSKeyStoreException(noSuchAlgorithmException.getMessage());
        }
        catch (CertificateException certificateException) {
            FSUtils.debug.error("KeyStore could not be stored: " + certificateException);
            throw new FSKeyStoreException(certificateException.getMessage());
        }
    }

    public void removeX509Certificate(String string) throws FSKeyStoreException {
        try {
            this.keyStore.deleteEntry(string);
            this.keyStore.store(new FileOutputStream(this.keystoreFile), this.keystorePass.toCharArray());
        }
        catch (FileNotFoundException fileNotFoundException) {
            FSUtils.debug.error("KeyStore could not be stored: " + fileNotFoundException);
            throw new FSKeyStoreException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            FSUtils.debug.error("KeyStore could not be stored: " + iOException);
            throw new FSKeyStoreException(iOException.getMessage());
        }
        catch (KeyStoreException keyStoreException) {
            FSUtils.debug.error("KeyStore could not be stored: " + keyStoreException);
            throw new FSKeyStoreException(keyStoreException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            FSUtils.debug.error("KeyStore could not be stored: " + noSuchAlgorithmException);
            throw new FSKeyStoreException(noSuchAlgorithmException.getMessage());
        }
        catch (CertificateException certificateException) {
            FSUtils.debug.error("KeyStore could not be stored: " + certificateException);
            throw new FSKeyStoreException(certificateException.getMessage());
        }
    }

    public X509Certificate[] getX509CertificateChain(String string) throws FSKeyStoreException {
        try {
            return (X509Certificate[])this.keyStore.getCertificateChain(string);
        }
        catch (KeyStoreException keyStoreException) {
            FSUtils.debug.error("Exception in getX509CertificateChain: " + keyStoreException);
            throw new FSKeyStoreException(keyStoreException.getMessage());
        }
    }

    public PublicKey getPublicKey(String string) throws FSKeyStoreException {
        try {
            X509Certificate x509Certificate = (X509Certificate)this.keyStore.getCertificate(string);
            return x509Certificate.getPublicKey();
        }
        catch (KeyStoreException keyStoreException) {
            FSUtils.debug.error("Exception in getPublicKey: " + keyStoreException);
            throw new FSKeyStoreException(keyStoreException.getMessage());
        }
    }

    public PrivateKey getPrivateKey(String string) throws FSKeyStoreException {
        try {
            return (PrivateKey)this.keyStore.getKey(string, this.privateKeyPass.toCharArray());
        }
        catch (KeyStoreException keyStoreException) {
            FSUtils.debug.error("Exception in getPublicKey: " + keyStoreException);
            throw new FSKeyStoreException(keyStoreException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            FSUtils.debug.error("Exception in getPublicKey: " + noSuchAlgorithmException);
            throw new FSKeyStoreException(noSuchAlgorithmException.getMessage());
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            FSUtils.debug.error("Exception in getPublicKey: " + unrecoverableKeyException);
            throw new FSKeyStoreException(unrecoverableKeyException.getMessage());
        }
    }

    public boolean containsAlias(String string) throws KeyStoreException {
        return this.keyStore.containsAlias(string);
    }
}

