/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.termination;

import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.services.util.FSServiceUtils;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSTerminationReturnServlet
extends HttpServlet {
    ServletConfig config = null;
    FSAllianceManager allianceInst = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSTerminationReturnServlet Initializing...");
        }
        this.config = servletConfig;
        this.allianceInst = FSServiceUtils.getAllianceInstance();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    private void doGetPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSTerminationReturnServlet doGetPost...");
        }
        String string = "";
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSTerminationReturnServlet: " + FSUtils.bundle.getString("notLibertyEnabled"));
            FSUtils.error("FSTerminationReturnServlet", FSUtils.bundle.getString("notLibertyEnabled"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        string = FSServiceUtils.getMetaAlias(httpServletRequest);
        if (string == null || string.length() < 1) {
            FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = this.allianceInst.getHostedProviderByMetaAlias(string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("Failed to get Hosted Provider");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        stringBuffer.append(fSHostedProviderDescriptor.getLocalConfiguration().getTerminationDonePageURL(httpServletRequest));
        FSUtils.debug.message("Final Done page URL at local end: " + stringBuffer.toString());
        httpServletResponse.sendRedirect(stringBuffer.toString());
    }
}

