/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.termination;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSFederationTerminationNotification;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.sm.CookieUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;

public class FSFedTerminationHandler {
    protected HttpServletResponse response;
    protected HttpServletRequest request;
    protected String locale = null;
    protected SSOToken ssoToken = null;
    protected String userDN = "";
    protected FSAccountFedInfo acctInfo = null;
    protected FSProviderDescriptor remoteDescriptor = null;
    protected FSHostedProviderDescriptor hostedDescriptor = null;
    protected String remoteProviderId = "";
    protected String hostedProviderId = "";
    protected String relayState = "";
    protected boolean isSelfIDP = false;
    protected FSAllianceManager instAlliance = null;
    protected FSAccountManager managerInst = null;
    protected static String TERMINATION_DONE_URL = null;
    protected static final String FEDERATE_COOKIE_NAME = SystemProperties.get((String)"com.sun.identity.federation.fedCookieName");
    protected static final String RELAY_STATE = "RELAYSTATE";

    public FSFedTerminationHandler() {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSFedTerminationHandler Constructor...");
        }
        this.instAlliance = FSServiceUtils.getAllianceInstance();
        try {
            this.managerInst = FSAccountManager.getInstance();
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.error("FSNameRegistrationHandler " + FSUtils.bundle.getString("federation-failed-account-instance"));
            this.managerInst = null;
        }
    }

    protected void setTerminationURL() {
        TERMINATION_DONE_URL = this.hostedDescriptor.getLocalConfiguration().getTerminationDonePageURL(this.request);
    }

    public void setHostedDescriptor(FSHostedProviderDescriptor fSHostedProviderDescriptor) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSSPFedTerminationHandler::setHostedDescriptor");
        }
        this.hostedDescriptor = fSHostedProviderDescriptor;
        this.hostedProviderId = fSHostedProviderDescriptor.getProviderID();
    }

    public void setRemoteDescriptor(FSProviderDescriptor fSProviderDescriptor) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSFedTerminationHandler::setRemoteDescriptor");
        }
        this.remoteDescriptor = fSProviderDescriptor;
        this.remoteProviderId = fSProviderDescriptor.getProviderID();
    }

    public void setUserDN(String string) {
        this.userDN = string;
    }

    public void setAccountInfo(FSAccountFedInfo fSAccountFedInfo) {
        this.acctInfo = fSAccountFedInfo;
    }

    public boolean setUserDN(FSFederationTerminationNotification fSFederationTerminationNotification) {
        try {
            String string = "";
            if (this.managerInst != null) {
                string = fSFederationTerminationNotification.getProviderId();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("sourceProviderId : " + string);
                }
                String string2 = fSFederationTerminationNotification.getNameIdentifier().getName().trim();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("processTerminationRequest Handle : " + string2);
                }
                String string3 = fSFederationTerminationNotification.getNameIdentifier().getNameQualifier().trim();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Name Qualifier : " + string3);
                }
                String string4 = this.hostedDescriptor.getLocalConfiguration().getAssociatedOrgDN();
                FSUtils.debug.message("OrgDN : " + string4);
                FSAccountFedInfoKey fSAccountFedInfoKey = new FSAccountFedInfoKey(this.hostedProviderId, string2);
                this.userDN = this.managerInst.getUserDN(fSAccountFedInfoKey, string4);
                if (this.userDN == null) {
                    fSAccountFedInfoKey = new FSAccountFedInfoKey(this.remoteProviderId, string2);
                    this.userDN = this.managerInst.getUserDN(fSAccountFedInfoKey, string4);
                    if (this.userDN == null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("UserDn is null");
                        }
                        return false;
                    }
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("user dn is " + this.userDN);
                }
                return true;
            }
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.error("In FSAccountMgmtException :: " + fSAccountMgmtException.getMessage());
        }
        this.userDN = null;
        return false;
    }

    public boolean handleFederationTermination(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SSOToken sSOToken) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSFedTerminationHandler::handleFederationTermination");
        }
        this.request = httpServletRequest;
        this.locale = FSServiceUtils.getLocale(httpServletRequest);
        this.response = httpServletResponse;
        this.ssoToken = sSOToken;
        this.setTerminationURL();
        if (this.instAlliance == null) {
            FSUtils.debug.error("FSSPFedTerminationHandler Alliance Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSPFedTerminationHandler::handleFederationTerminationfailed to get Alliance Manager instance");
            }
            this.returnLocallyAfterTermination(httpServletResponse, false);
            return false;
        }
        if (this.managerInst == null) {
            FSUtils.debug.error("FSSPFedTerminationHandler Account Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSPFedTerminationHandler::handleFederationTerminationfailed to get Account Manager instance");
            }
            this.returnLocallyAfterTermination(httpServletResponse, false);
            return false;
        }
        try {
            this.userDN = sSOToken.getPrincipal().toString();
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSFedTerminationHandler Constructor::SSOException" + sSOException.getMessage());
            FSUtils.error("FSFedTerminationHandler::handleFederationTermination", FSUtils.bundle.getString("actmgmt-user-not-found"));
            return false;
        }
        boolean bl = this.updateAccountInformation(null);
        FSUtils.debug.message("After updateAccountInformation");
        if (!bl) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSPFedTerminationHandler::handleFederationTerminationFederation Termination failed locally. Cannot update account");
            }
            FSUtils.error("FSSPFedTerminationHandler", FSUtils.bundle.getString("termination-failed-locally"));
            this.returnLocallyAfterTermination(httpServletResponse, false);
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Status of local update true");
        }
        FSUtils.access("FSIDPFedTerminationHandler", FSUtils.bundle.getString("termination-succeeded-locally"));
        this.resetFederateCookie();
        boolean bl2 = this.doFederationTermination(this.acctInfo);
        return bl2;
    }

    protected boolean updateAccountInformation(NameIdentifier nameIdentifier) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSFedTerminationHandler::updateAccountInformation");
        }
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFedTerminationHandler:: updateAccountInformation deactivate start");
            }
            String string = this.remoteDescriptor.getProviderID();
            String string2 = null;
            String string3 = null;
            if (nameIdentifier != null) {
                string3 = nameIdentifier.getNameQualifier();
                if (string3 != null && !string3.equals(this.remoteProviderId)) {
                    string = string3;
                }
                string2 = nameIdentifier.getName();
            }
            if (string2 == null && this.acctInfo != null) {
                FSUtils.debug.message("FSAccountManager: getnameId in accInfo");
                NameIdentifier nameIdentifier2 = this.acctInfo.getLocalNameIdentifier();
                if (nameIdentifier2 != null) {
                    string2 = nameIdentifier2.getName();
                    string3 = nameIdentifier2.getNameQualifier();
                } else {
                    nameIdentifier2 = this.acctInfo.getRemoteNameIdentifier();
                    if (nameIdentifier2 != null) {
                        string2 = nameIdentifier2.getName();
                        string3 = nameIdentifier2.getNameQualifier();
                    }
                }
            }
            this.managerInst.deActivateFederation(this.userDN, string, string2, string3);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFedTerminationHandler:: updateAccountInformation deactivate successfully completed");
            }
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.error("FSFedTerminationHandler::updateAccountInformation " + FSUtils.bundle.getString("termination-failed-locally"));
            FSUtils.error("FSFedTerminationHandler::updateAccountInformation", FSUtils.bundle.getString("termination-failed-locally"));
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Cleaning Session manager for user : " + this.userDN);
            FSUtils.debug.message("Cleaning Session manager for remote provider: " + this.remoteDescriptor.getProviderID());
            FSUtils.debug.message("Cleaning Session manager for hosted provider: " + this.hostedProviderId);
        }
        FSLogoutUtil.cleanSessionMapPartnerList(this.userDN, this.remoteDescriptor.getProviderID(), this.hostedProviderId);
        return true;
    }

    public void processTerminationRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSFederationTerminationNotification fSFederationTerminationNotification) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSFedTerminationHandler::processTerminationRequest...");
        }
        this.request = httpServletRequest;
        this.locale = FSServiceUtils.getLocale(httpServletRequest);
        this.response = httpServletResponse;
        this.relayState = fSFederationTerminationNotification.getRelayState();
        this.setTerminationURL();
        if (this.instAlliance == null) {
            FSUtils.debug.error("FSSPFedTerminationHandler Alliance manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSPFedTerminationHandler::handleFederationTerminationfailed to get Alliance Manager instance");
            }
            this.returnToSource();
            return;
        }
        if (this.managerInst == null) {
            FSUtils.debug.error("FSSPFedTerminationHandler " + FSUtils.bundle.getString("federation-failed-account-instance"));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSPFedTerminationHandler::handleFederationTerminationfailed to get Account Manager instance");
            }
            this.returnToSource();
            return;
        }
        boolean bl = this.updateAccountInformation(fSFederationTerminationNotification.getNameIdentifier());
        if (!bl) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Termination request processing failed");
            }
            FSUtils.error("FSFedTerminationHandler", FSUtils.bundle.getString("termination-request-processing-failed"));
            this.returnToSource();
            return;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("User sucessfully defederated");
        }
        FSUtils.access("FSFedTerminationHandler", FSUtils.bundle.getString("federation-termination-successful"));
        this.returnToSource();
    }

    public boolean processTerminationRequest(FSFederationTerminationNotification fSFederationTerminationNotification) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSFedTerminationHandler::processTerminationRequest");
        }
        if (this.instAlliance == null) {
            FSUtils.debug.error("FSSPFedTerminationHandler Alliance Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSPFedTerminationHandler::handleFederationTerminationfailed to get Alliance Manager instance");
            }
            return false;
        }
        if (this.managerInst == null) {
            FSUtils.debug.error("FSSPFedTerminationHandler Account Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSPFedTerminationHandler::handleFederationTerminationfailed to get Account Manager instance");
            }
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Begin processTerminationRequest SOAP profile...");
        }
        boolean bl = false;
        if (fSFederationTerminationNotification != null) {
            boolean bl2 = this.setUserDN(fSFederationTerminationNotification);
            if (bl2) {
                bl = this.updateAccountInformation(fSFederationTerminationNotification.getNameIdentifier());
                if (!bl) {
                    FSUtils.debug.error("FSFedTerminationHandler " + FSUtils.bundle.getString("termination-request-processing-failed"));
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("User sucessfully defederated");
                }
                return true;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Failed to get UserDN. Invalid termination request");
            }
            return false;
        }
        FSUtils.debug.error("FSFedTerminationHandler::processTerminationRequest Federation termination request is improper");
        return false;
    }

    public void resetFederateCookie() {
        try {
            String string;
            if (this.userDN == null || this.userDN.length() < 1) {
                return;
            }
            if (this.managerInst.hasAnyActiveFederation(this.userDN)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("User : " + this.userDN + " Federation Exists : " + "yes");
                }
                string = "yes";
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("User : " + this.userDN + " Federation Exists : " + "no");
                }
                string = "no";
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Setting Path to /");
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Setting Age to 31536000 Age");
            }
            List list = FSServiceUtils.getCookieDomainList();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Provider cookie domain list is " + list);
            }
            Iterator iterator = null;
            if (list != null) {
                iterator = list.iterator();
                while (iterator != null && iterator.hasNext()) {
                    Cookie cookie = CookieUtils.newCookie(FEDERATE_COOKIE_NAME, string, 31536000, "/", (String)iterator.next());
                    this.response.addCookie(cookie);
                }
            } else {
                Cookie cookie = CookieUtils.newCookie(FEDERATE_COOKIE_NAME, string, 31536000, "/", null);
                this.response.addCookie(cookie);
            }
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.error("Unable to read user federation information" + fSAccountMgmtException.getMessage());
            return;
        }
    }

    public void returnToSource() {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSFedTerminationHandler::returnToSource");
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.remoteDescriptor.getFederationTerminationServiceReturnURL();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Redirecting to : " + string);
            }
            this.resetFederateCookie();
            FSUtils.debug.message("Checking retURL for null value");
            if (string == null || string.length() < 1) {
                FSUtils.debug.error("Return URL is null");
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(this.hostedDescriptor.getLocalConfiguration().getErrorPageURL(this.request));
                char c = stringBuffer2.toString().indexOf(63) < 0 ? (char)'?' : '&';
                stringBuffer2.append(c);
                stringBuffer2.append("federror");
                stringBuffer2.append('=');
                stringBuffer2.append(URLEncoder.encode(FSUtils.bundle.getString("termination-invalid-redirect-url")));
                stringBuffer2.append('&');
                stringBuffer2.append("fedremark");
                stringBuffer2.append('=');
                stringBuffer2.append(URLEncoder.encode(FSUtils.bundle.getString("metadata-error-check")));
                FSUtils.debug.error("Redirecting to Error page : " + stringBuffer2.toString());
                this.response.sendRedirect(stringBuffer2.toString());
                return;
            }
            stringBuffer.append(string);
            if (this.relayState != null && this.relayState.length() >= 1) {
                char c = string.indexOf(63) < 0 ? (char)'?' : '&';
                stringBuffer.append(c);
                stringBuffer.append(RELAY_STATE);
                stringBuffer.append('=');
                stringBuffer.append(URLEncoder.encode(this.relayState));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Now sendRedirecting to : " + stringBuffer.toString());
            }
            this.response.sendRedirect(stringBuffer.toString());
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Unable to get LRURL. No location to redirect. processing completed");
            try {
                FSUtils.debug.message("After exception calling response.sendError");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.hostedDescriptor.getLocalConfiguration().getErrorPageURL(this.request));
                char c = stringBuffer.toString().indexOf(63) < 0 ? (char)'?' : '&';
                stringBuffer.append(c);
                stringBuffer.append("federror");
                stringBuffer.append('=');
                stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("termination-invalid-redirect-url")));
                stringBuffer.append('&');
                stringBuffer.append("fedremark");
                stringBuffer.append('=');
                stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("metadata-error-check")));
                FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
                this.response.sendRedirect(stringBuffer.toString());
                return;
            }
            catch (IOException iOException2) {
                return;
            }
        }
    }

    public void returnLocallyAfterTermination(HttpServletResponse httpServletResponse, boolean bl) {
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered  returnLocallyAfterTermination with isSuccess set to " + bl);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(TERMINATION_DONE_URL);
            char c = TERMINATION_DONE_URL.indexOf(63) < 0 ? (char)'?' : '&';
            stringBuffer.append(c);
            stringBuffer.append("termStatus");
            stringBuffer.append('=');
            if (bl) {
                stringBuffer.append("termSuccess");
            } else {
                stringBuffer.append("termFailure");
            }
            httpServletResponse.sendRedirect(stringBuffer.toString());
        }
        catch (IOException iOException) {
            FSUtils.debug.message("Exception in  returnLocallyAfterTermination " + iOException.getMessage());
        }
    }

    protected SOAPMessage signTerminationRequest(SOAPMessage sOAPMessage, String string, String string2) throws SAMLException, FSMsgException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSPFedTerminationHandler.signTerminationRequest: Called");
        }
        String string3 = null;
        string3 = this.hostedDescriptor.getKeyInfo();
        if (string3 == null || string3.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSPFedTerminationHandler.signTerminationRequest: couldn'tobtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        FSUtils.debug.message("FSSPFedTerminationHandler.signTerminationRequest: Provider's certAlias is found: " + string3);
        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
        Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
        String string4 = "//*[local-name()='ProviderID']";
        xMLSignatureManager.signXML(document, string3, SAMLUtils.bundle.getString("xmlsigalgorithm"), string, string2, false, string4);
        return FSServiceUtils.convertDOMToSOAP(document);
    }

    private FSFederationTerminationNotification createFederationTerminationRequest(FSAccountFedInfo fSAccountFedInfo) {
        FSFederationTerminationNotification fSFederationTerminationNotification;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSFedTerminationHandler::createFederationTerminationRequest");
        }
        if ((fSFederationTerminationNotification = new FSFederationTerminationNotification()) != null) {
            NameIdentifier nameIdentifier = fSAccountFedInfo.getRemoteNameIdentifier();
            if (nameIdentifier == null) {
                nameIdentifier = fSAccountFedInfo.getLocalNameIdentifier();
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("SP Provider Id : " + this.hostedProviderId);
            }
            fSFederationTerminationNotification.setProviderId(this.hostedProviderId);
            fSFederationTerminationNotification.setNameIdentifier(nameIdentifier);
            return fSFederationTerminationNotification;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("failed to create termination request");
        }
        FSUtils.debug.error("FSFedTerminationHandler::createFederationTerminationRequest " + FSUtils.bundle.getString("termination-request-creation-failed"));
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doFederationTermination(FSAccountFedInfo fSAccountFedInfo) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSFedTerminationHandler::doFederationTermination");
        }
        try {
            CharSequence charSequence;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFedTerminationHandler::doFederationTermination create request start");
            }
            FSFederationTerminationNotification fSFederationTerminationNotification = this.createFederationTerminationRequest(fSAccountFedInfo);
            fSFederationTerminationNotification.setMinorVersion(this.remoteDescriptor.getMinorVersion());
            if (fSFederationTerminationNotification == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSIDPFedTerminationHandler::Termination request could not be formed");
                }
                this.returnLocallyAfterTermination(this.response, true);
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIDPFedTerminationHandler::Termination request formedsuccessfully");
            }
            boolean bl = true;
            if (fSAccountFedInfo.isRoleIDP()) {
                if (this.hostedDescriptor.getFederationTerminationProtocolProfile().equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-sp-soap") || this.hostedDescriptor.getFederationTerminationProtocolProfile().equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-idp-soap")) {
                    bl = true;
                } else {
                    if (!this.hostedDescriptor.getFederationTerminationProtocolProfile().equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-sp-http") && !this.hostedDescriptor.getFederationTerminationProtocolProfile().equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-idp-http")) {
                        FSUtils.debug.error("FSFedTerminationHandler::doFederationTermination Invalid termination profile cannot process request");
                        this.returnLocallyAfterTermination(this.response, true);
                        return false;
                    }
                    bl = false;
                }
            } else if (this.remoteDescriptor.getFederationTerminationProtocolProfile().equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-sp-soap") || this.remoteDescriptor.getFederationTerminationProtocolProfile().equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-idp-soap")) {
                bl = true;
            } else {
                if (!this.remoteDescriptor.getFederationTerminationProtocolProfile().equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-sp-http") && !this.remoteDescriptor.getFederationTerminationProtocolProfile().equalsIgnoreCase("http://projectliberty.org/profiles/fedterm-idp-http")) {
                    FSUtils.debug.error("FSFedTerminationHandler::doFederationTermination Invalid termination profile cannot process request");
                    this.returnLocallyAfterTermination(this.response, true);
                    return false;
                }
                bl = false;
            }
            if (bl) {
                FSSOAPService fSSOAPService = FSSOAPService.getInstance();
                if (fSSOAPService != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Signing suceeded. To call bindTerminationRequest");
                    }
                    fSFederationTerminationNotification.setID("term-Sig-ID");
                    SOAPMessage sOAPMessage = fSSOAPService.bindTerminationRequest(fSFederationTerminationNotification);
                    if (sOAPMessage != null) {
                        try {
                            int n;
                            if (FSServiceUtils.isSigningOn()) {
                                n = fSFederationTerminationNotification.getMinorVersion();
                                if (!n) {
                                    sOAPMessage = this.signTerminationRequest(sOAPMessage, "id", fSFederationTerminationNotification.getID());
                                } else if (n == 2) {
                                    sOAPMessage = this.signTerminationRequest(sOAPMessage, "RequestID", fSFederationTerminationNotification.getRequestID());
                                } else if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("invalid minor version.");
                                }
                            }
                            n = fSSOAPService.sendTerminationMessage(sOAPMessage, this.remoteDescriptor.getSOAPEndPoint()) ? 1 : 0;
                            this.returnLocallyAfterTermination(this.response, true);
                            return n != 0;
                        }
                        catch (Exception exception) {
                            FSUtils.debug.error("FSFedTerminationHandler::doFederationTermination " + FSUtils.bundle.getString("termination-failed-send-remote"));
                            this.returnLocallyAfterTermination(this.response, true);
                            return false;
                        }
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSPFedTerminationHandler::doFederationTermination failed. Error in forming Message");
                    }
                    FSUtils.debug.error("FSSPFedTerminationHandler::doFederationTermination " + FSUtils.bundle.getString("termination-failed-send-remote"));
                    this.returnLocallyAfterTermination(this.response, true);
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSFedTerminationHandler::doFederationTermination failed. Cannot get Service Manager instance");
                }
                FSUtils.debug.error("FSSPFedTerminationHandler::doFederationTermination " + FSUtils.bundle.getString("termination-failed-send-remote"));
                this.returnLocallyAfterTermination(this.response, true);
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFedTerminationHandler::doFederationTermination In Redirect profile");
            }
            String string = fSFederationTerminationNotification.toURLEncodedQueryString();
            if (FSServiceUtils.isSigningOn()) {
                charSequence = this.hostedDescriptor.getKeyInfo();
                if (charSequence == null || ((String)charSequence).equals("")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSBrowserArtifactConsumerHandler:: signSAMLRequest:couldn't obtain this site's cert alias.");
                    }
                    throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
                }
                string = FSSignatureUtil.signAndReturnQueryString(string, (String)charSequence);
            }
            charSequence = new StringBuffer();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request to be sent : " + string);
            }
            String string2 = this.remoteDescriptor.getFederationTerminationServiceURL();
            ((StringBuffer)charSequence).append(string2);
            if (string2.indexOf(63) == -1) {
                ((StringBuffer)charSequence).append('?');
            } else {
                ((StringBuffer)charSequence).append('&');
            }
            ((StringBuffer)charSequence).append(string);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSFedTerminationHandler::Redirect URL is " + ((StringBuffer)charSequence).toString());
            }
            this.response.sendRedirect(((StringBuffer)charSequence).toString());
            return true;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("FSFedTerminationHandler" + FSUtils.bundle.getString("federation-redirection-failed"));
        }
        catch (FSMsgException fSMsgException) {
            FSUtils.debug.error("FSFedTerminationHandler::doFederationTermination " + FSUtils.bundle.getString("termination-failed-send-remote"));
        }
        catch (SAMLResponderException sAMLResponderException) {
            FSUtils.debug.error("FSFedTerminationHandler::doFederationTermination " + FSUtils.bundle.getString("termination-failed-send-remote"));
        }
        this.returnLocallyAfterTermination(this.response, true);
        return false;
    }
}

