/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.registration;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSNameRegistrationRequest;
import com.sun.identity.federation.message.FSNameRegistrationResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.federation.message.common.OldProvidedNameIdentifier;
import com.sun.identity.federation.message.common.SPProvidedNameIdentifier;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.registration.FSRegistrationIdGenerator;
import com.sun.identity.federation.services.registration.FSRegistrationManager;
import com.sun.identity.federation.services.util.FSNameIdentifierHelper;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AbstractRequest;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FSNameRegistrationHandler {
    protected HttpServletResponse response = null;
    protected HttpServletRequest request = null;
    protected HashMap regisMap = new HashMap();
    protected FSNameRegistrationResponse regisResponse = null;
    protected FSNameRegistrationRequest regisRequest = null;
    protected SSOToken ssoToken = null;
    protected String userDN = "";
    protected FSAccountFedInfo acctInfo = null;
    protected FSAccountFedInfo newAcctInfo = null;
    protected FSAccountFedInfoKey newAcctKey = null;
    protected FSAccountFedInfoKey oldAcctKey = null;
    protected FSProviderDescriptor remoteDescriptor = null;
    protected FSHostedProviderDescriptor hostedDescriptor = null;
    protected String remoteProviderId = "";
    protected String hostedProviderId = "";
    protected String relayState = "";
    private IDPProvidedNameIdentifier idpNameIdentifier = null;
    private SPProvidedNameIdentifier spNameIdentifier = null;
    private OldProvidedNameIdentifier oldNameIdentifier = null;
    protected FSAllianceManager instAlliance = null;
    protected FSAccountManager managerInst = null;
    protected static String REGISTRATION_DONE_URL = null;
    protected static final String RELAY_STATE = "RELAYSTATE";
    protected HashMap returnMap = new HashMap();
    protected static String returnURL = "";
    protected static String regisSource = "";

    public FSNameRegistrationHandler() {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSNameRegistrationHandler Constructor...");
        }
        this.instAlliance = FSServiceUtils.getAllianceInstance();
        try {
            this.managerInst = FSAccountManager.getInstance();
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.error("FSNameRegistrationHandler " + FSUtils.bundle.getString("federation-failed-account-instance"));
            this.managerInst = null;
        }
    }

    protected void setRegistrationURL() {
        REGISTRATION_DONE_URL = this.hostedDescriptor.getLocalConfiguration().getNameRegistrationDonePageURL(this.request);
    }

    public void setHostedDescriptor(FSHostedProviderDescriptor fSHostedProviderDescriptor) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler::setHostedDescriptor");
        }
        this.hostedDescriptor = fSHostedProviderDescriptor;
        this.hostedProviderId = fSHostedProviderDescriptor.getProviderID();
    }

    public void setRemoteDescriptor(FSProviderDescriptor fSProviderDescriptor) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler::setRemoteDescriptor");
        }
        this.remoteDescriptor = fSProviderDescriptor;
        this.remoteProviderId = fSProviderDescriptor.getProviderID();
    }

    public void setUserDN(String string) {
        this.userDN = string;
    }

    public void setAccountInfo(FSAccountFedInfo fSAccountFedInfo) {
        this.acctInfo = fSAccountFedInfo;
    }

    public boolean setUserDN(FSNameRegistrationRequest fSNameRegistrationRequest) {
        try {
            OldProvidedNameIdentifier oldProvidedNameIdentifier;
            SPProvidedNameIdentifier sPProvidedNameIdentifier;
            IDPProvidedNameIdentifier iDPProvidedNameIdentifier;
            OldProvidedNameIdentifier oldProvidedNameIdentifier2 = fSNameRegistrationRequest.getOldProvidedNameIdentifier();
            if (oldProvidedNameIdentifier2 != null) {
                FSUtils.debug.message("OldProvidedIdentifier NAme : " + oldProvidedNameIdentifier2.getName());
                FSUtils.debug.message("OldProvidedIdentifier Name format : " + oldProvidedNameIdentifier2.getFormat());
                FSUtils.debug.message("OldProvidedIdentifier Qualifier : " + oldProvidedNameIdentifier2.getNameQualifier());
            }
            if ((iDPProvidedNameIdentifier = fSNameRegistrationRequest.getIDPProvidedNameIdentifier()) != null) {
                FSUtils.debug.message("IDPProvidedIdentifier NAme : " + iDPProvidedNameIdentifier.getName());
                FSUtils.debug.message("IDPProvidedIdentifier Name format : " + iDPProvidedNameIdentifier.getFormat());
                FSUtils.debug.message("IDPProvidedIdentifier Qualifier : " + iDPProvidedNameIdentifier.getNameQualifier());
            }
            if ((sPProvidedNameIdentifier = fSNameRegistrationRequest.getSPProvidedNameIdentifier()) != null) {
                FSUtils.debug.message("SPProvidedIdentifier NAme : " + sPProvidedNameIdentifier.getName());
                FSUtils.debug.message("SPProvidedIdentifier Name format : " + sPProvidedNameIdentifier.getFormat());
                FSUtils.debug.message("SPProvidedIdentifier Qualifier : " + sPProvidedNameIdentifier.getNameQualifier());
            }
            String string = "";
            string = fSNameRegistrationRequest.getProviderId();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("remoteProviderId : " + string);
            }
            if ((oldProvidedNameIdentifier = fSNameRegistrationRequest.getOldProvidedNameIdentifier()) == null) {
                FSUtils.debug.message("oldProvidedNameIdentifier is null :");
                IDPProvidedNameIdentifier iDPProvidedNameIdentifier2 = fSNameRegistrationRequest.getIDPProvidedNameIdentifier();
                SPProvidedNameIdentifier sPProvidedNameIdentifier2 = fSNameRegistrationRequest.getSPProvidedNameIdentifier();
                String string2 = iDPProvidedNameIdentifier2.getName();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("processRegistrationRequest IdPName : " + string2);
                }
                String string3 = this.hostedDescriptor.getLocalConfiguration().getAssociatedOrgDN();
                FSUtils.debug.message("OrgDN : " + string3);
                FSAccountFedInfoKey fSAccountFedInfoKey = new FSAccountFedInfoKey(this.hostedProviderId, string2);
                FSUtils.debug.message("Search based on :" + this.hostedProviderId + " " + string2);
                this.userDN = this.managerInst.getUserDN(fSAccountFedInfoKey, string3);
                if (this.userDN == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("UserDn is null");
                    }
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("user dn is " + this.userDN);
                }
                try {
                    this.acctInfo = this.managerInst.readAccountFedInfo(this.userDN, string);
                }
                catch (FSAccountMgmtException fSAccountMgmtException) {
                    FSUtils.debug.message("Failed to read account information");
                    return false;
                }
                this.newAcctInfo = new FSAccountFedInfo(string, (NameIdentifier)iDPProvidedNameIdentifier2, sPProvidedNameIdentifier2, false);
                this.newAcctKey = new FSAccountFedInfoKey(this.hostedProviderId, iDPProvidedNameIdentifier2.getName());
                return true;
            }
            FSUtils.debug.message("oldProvidedNameIdentifier is not null :");
            IDPProvidedNameIdentifier iDPProvidedNameIdentifier3 = fSNameRegistrationRequest.getIDPProvidedNameIdentifier();
            SPProvidedNameIdentifier sPProvidedNameIdentifier3 = fSNameRegistrationRequest.getSPProvidedNameIdentifier();
            OldProvidedNameIdentifier oldProvidedNameIdentifier3 = fSNameRegistrationRequest.getOldProvidedNameIdentifier();
            String string4 = this.hostedDescriptor.getLocalConfiguration().getAssociatedOrgDN();
            FSUtils.debug.message("OrgDN : " + string4);
            String string5 = "";
            boolean bl = false;
            if (sPProvidedNameIdentifier3 != null && !sPProvidedNameIdentifier3.equals(oldProvidedNameIdentifier3)) {
                string5 = sPProvidedNameIdentifier3.getName();
            } else {
                bl = true;
                string5 = iDPProvidedNameIdentifier3.getName();
            }
            FSAccountFedInfoKey fSAccountFedInfoKey = new FSAccountFedInfoKey(this.hostedProviderId, string5);
            FSUtils.debug.message("Search based on :" + this.hostedProviderId + " " + string5);
            this.userDN = this.managerInst.getUserDN(fSAccountFedInfoKey, string4);
            if (this.userDN == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("UserDn is null in step 3");
                }
                string5 = iDPProvidedNameIdentifier3.getName();
                fSAccountFedInfoKey = new FSAccountFedInfoKey(this.hostedProviderId, string5);
                FSUtils.debug.message("Search based on :" + this.hostedProviderId + " " + string5);
                this.userDN = this.managerInst.getUserDN(fSAccountFedInfoKey, string4);
                if (this.userDN == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("UserDn is null in step 4");
                    }
                    string5 = oldProvidedNameIdentifier3.getName();
                    fSAccountFedInfoKey = new FSAccountFedInfoKey(string, string5);
                    FSUtils.debug.message("Search based on :" + string + " " + string5);
                    this.userDN = this.managerInst.getUserDN(fSAccountFedInfoKey, string4);
                    if (this.userDN == null) {
                        return false;
                    }
                    FSUtils.debug.message("Found user : " + this.userDN);
                    try {
                        this.acctInfo = this.managerInst.readAccountFedInfo(this.userDN, string);
                    }
                    catch (FSAccountMgmtException fSAccountMgmtException) {
                        // empty catch block
                    }
                    if (this.acctInfo.isRoleIDP()) {
                        if (bl) {
                            this.newAcctInfo = new FSAccountFedInfo(string, null, iDPProvidedNameIdentifier3, this.acctInfo.isRoleIDP());
                            this.newAcctKey = new FSAccountFedInfoKey(string, iDPProvidedNameIdentifier3.getName());
                        } else {
                            this.newAcctInfo = new FSAccountFedInfo(string, (NameIdentifier)sPProvidedNameIdentifier3, iDPProvidedNameIdentifier3, this.acctInfo.isRoleIDP());
                            this.newAcctKey = new FSAccountFedInfoKey(this.hostedProviderId, sPProvidedNameIdentifier3.getName());
                        }
                    } else {
                        this.newAcctInfo = new FSAccountFedInfo(string, (NameIdentifier)iDPProvidedNameIdentifier3, sPProvidedNameIdentifier3, this.acctInfo.isRoleIDP());
                        this.newAcctKey = new FSAccountFedInfoKey(this.hostedProviderId, iDPProvidedNameIdentifier3.getName());
                    }
                } else {
                    try {
                        this.acctInfo = this.managerInst.readAccountFedInfo(this.userDN, string);
                    }
                    catch (FSAccountMgmtException fSAccountMgmtException) {
                        // empty catch block
                    }
                    this.newAcctInfo = new FSAccountFedInfo(string, (NameIdentifier)iDPProvidedNameIdentifier3, sPProvidedNameIdentifier3, false);
                    this.newAcctKey = new FSAccountFedInfoKey(this.hostedProviderId, iDPProvidedNameIdentifier3.getName());
                }
            } else {
                try {
                    this.acctInfo = this.managerInst.readAccountFedInfo(this.userDN, string);
                }
                catch (FSAccountMgmtException fSAccountMgmtException) {
                    // empty catch block
                }
                if (this.acctInfo.isRoleIDP()) {
                    if (bl) {
                        this.newAcctInfo = new FSAccountFedInfo(string, null, iDPProvidedNameIdentifier3, this.acctInfo.isRoleIDP());
                        this.newAcctKey = new FSAccountFedInfoKey(string, iDPProvidedNameIdentifier3.getName());
                    } else {
                        this.newAcctInfo = new FSAccountFedInfo(string, (NameIdentifier)sPProvidedNameIdentifier3, iDPProvidedNameIdentifier3, this.acctInfo.isRoleIDP());
                        this.newAcctKey = new FSAccountFedInfoKey(this.hostedProviderId, sPProvidedNameIdentifier3.getName());
                    }
                } else {
                    this.newAcctInfo = new FSAccountFedInfo(string, (NameIdentifier)iDPProvidedNameIdentifier3, sPProvidedNameIdentifier3, this.acctInfo.isRoleIDP());
                    this.newAcctKey = new FSAccountFedInfoKey(this.hostedProviderId, iDPProvidedNameIdentifier3.getName());
                }
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("user dn is " + this.userDN);
            }
            return true;
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.error("In FSAccountMgmtException :: " + fSAccountMgmtException.getMessage());
            this.userDN = null;
            return false;
        }
    }

    public boolean handleNameRegistration(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SSOToken sSOToken) {
        regisSource = "STAND_ALONE";
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler::handleNameRegistration");
        }
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.ssoToken = sSOToken;
        this.setRegistrationURL();
        if (this.instAlliance == null) {
            FSUtils.debug.error("FSNameRegistrationHandler Alliance Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Alliance Manager instance");
            }
            this.returnLocallyAtSource(httpServletResponse, false);
            return false;
        }
        if (this.managerInst == null) {
            FSUtils.debug.error("FSNameRegistrationHandler Account Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
            }
            this.returnLocallyAtSource(httpServletResponse, false);
            return false;
        }
        try {
            this.userDN = sSOToken.getPrincipal().toString();
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSNameRegistrationHandler Constructor::SSOException" + sSOException.getMessage());
            FSUtils.error("FSNameRegistrationHandler::handleNameRegistration", FSUtils.bundle.getString("actmgmt-user-not-found"));
            return false;
        }
        boolean bl = this.doRemoteRegistration();
        return bl;
    }

    public boolean handleNameRegistration(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SSOToken sSOToken, HashMap hashMap) {
        regisSource = "DuringSSO";
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler::handleNameRegistration");
        }
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.ssoToken = sSOToken;
        this.regisMap = hashMap;
        this.setRegistrationURL();
        if (this.instAlliance == null) {
            FSUtils.debug.error("FSNameRegistrationHandler Alliance Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Alliance Manager instance");
            }
            this.returnLocallyAtSource(httpServletResponse, false);
            return false;
        }
        if (this.managerInst == null) {
            FSUtils.debug.error("FSNameRegistrationHandler Account Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
            }
            this.returnLocallyAtSource(httpServletResponse, false);
            return false;
        }
        try {
            this.userDN = sSOToken.getPrincipal().toString();
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSNameRegistrationHandler Constructor::SSOException" + sSOException.getMessage());
            FSUtils.error("FSNameRegistrationHandler::handleNameRegistration", FSUtils.bundle.getString("actmgmt-user-not-found"));
            return false;
        }
        boolean bl = this.doRemoteRegistration();
        FSUtils.debug.message("Returning cntrol to SIngle Sign On with status " + bl);
        return bl;
    }

    public boolean handleRegistrationAfterFederation(String string, HttpServletResponse httpServletResponse) {
        regisSource = "AfterFederation";
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler:: handleNameRegistration");
        }
        returnURL = string;
        this.response = httpServletResponse;
        if (this.instAlliance == null) {
            FSUtils.debug.error("FSNameRegistrationHandler " + FSUtils.bundle.getString("federation-failed-alliance-instance"));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Alliance Manager instance");
            }
            return false;
        }
        if (this.managerInst == null) {
            FSUtils.debug.error("FSNameRegistrationHandler " + FSUtils.bundle.getString("federation-failed-account-instance"));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
            }
            return false;
        }
        boolean bl = this.doRemoteRegistration();
        FSUtils.debug.message("Completed registration after federation with status " + bl);
        return bl;
    }

    public boolean processRegistrationResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSNameRegistrationResponse fSNameRegistrationResponse) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler::handleRegistrationResponse");
        }
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.regisResponse = fSNameRegistrationResponse;
        this.setRegistrationURL();
        if (this.instAlliance == null) {
            FSUtils.debug.error("FSNameRegistrationHandler Alliance Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Alliance Manager instance");
            }
            this.returnLocallyAfterRegistration(httpServletResponse, false);
            return false;
        }
        if (this.managerInst == null) {
            FSUtils.debug.error("FSNameRegistrationHandler Account Manager instance is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
            }
            this.returnLocallyAfterRegistration(httpServletResponse, false);
            return false;
        }
        String string = fSNameRegistrationResponse.getStatus().getStatusCode().getValue();
        if (string.equals("samlp:Success")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Name registration Successful");
            }
            this.relayState = fSNameRegistrationResponse.getRelayState();
            FSUtils.debug.message("Relay State : " + this.relayState);
            if (this.relayState == null) {
                this.returnLocallyAfterRegistration(httpServletResponse, false);
                return true;
            }
            FSRegistrationManager fSRegistrationManager = FSRegistrationManager.getInstance(this.hostedDescriptor.getProviderID());
            HashMap hashMap = new HashMap();
            hashMap = fSRegistrationManager.getRegistrationMap(this.relayState);
            if (hashMap == null) {
                FSUtils.debug.message("Map does not contain request for state = " + this.relayState);
                this.returnLocallyAfterRegistration(httpServletResponse, false);
                return false;
            }
            this.regisMap = (HashMap)hashMap.get("SSODetails");
            HashMap hashMap2 = (HashMap)hashMap.get("ReturnEntry");
            this.oldAcctKey = (FSAccountFedInfoKey)hashMap2.get("OldAccountKey");
            if (this.oldAcctKey != null) {
                FSUtils.debug.message("Get OldAcctKet Name : " + this.oldAcctKey.getName());
                FSUtils.debug.message("Get OldAcctKet Qualifier : " + this.oldAcctKey.getNameSpace());
            } else {
                FSUtils.debug.message("OldAccount Key is null");
            }
            this.newAcctKey = (FSAccountFedInfoKey)hashMap2.get("AccountKey");
            if (this.newAcctKey != null) {
                FSUtils.debug.message("Get newAcctKey Name : " + this.newAcctKey.getName());
                FSUtils.debug.message("Get newAcctKey Qualifier : " + this.newAcctKey.getNameSpace());
            } else {
                FSUtils.debug.message("newAcctKey Key is null");
            }
            this.newAcctInfo = (FSAccountFedInfo)hashMap2.get("AccountInfo");
            this.userDN = (String)hashMap2.get("userDN");
            regisSource = (String)hashMap2.get("RegisSource");
            returnURL = (String)hashMap2.get("RelayState");
            boolean bl = this.doCommonRegistration(false);
            this.returnLocallyAfterRegistration(httpServletResponse, bl);
            return bl;
        }
        if (string.equals("lib:FederationDoesNotExist")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Name registration Failed. Federation does not exist");
            }
            this.returnLocallyAfterRegistration(httpServletResponse, false);
            return false;
        }
        if (string.equals("lib:Failure")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Name registration Failed.");
            }
            this.returnLocallyAfterRegistration(httpServletResponse, false);
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doRemoteRegistration() {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSNameRegistrationHandler::doRemoteRegistration");
        }
        try {
            CharSequence charSequence;
            String string;
            block63: {
                Object object;
                try {
                    object = this.managerInst.readAccountFedInfo(this.userDN, this.remoteProviderId);
                }
                catch (FSAccountMgmtException fSAccountMgmtException) {
                    this.returnLocallyAtSource(this.response, false);
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::doRemoteRegistration create request start");
                }
                if ((object = this.createNameRegistrationRequest(this.acctInfo)) == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::Registration request could not be formed");
                    }
                    this.returnLocallyAtSource(this.response, false);
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::Registration request formedsuccessfully");
                }
                boolean bl = true;
                if (this.acctInfo.isRoleIDP()) {
                    if (this.hostedDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-soap") || this.hostedDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-soap")) {
                        bl = true;
                    } else {
                        if (!this.hostedDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-http") && !this.hostedDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-http")) {
                            FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration Invalid registration profile cannot process request");
                            this.returnLocallyAtSource(this.response, false);
                            return false;
                        }
                        bl = false;
                    }
                } else if (this.remoteDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-soap") || this.remoteDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-soap")) {
                    bl = true;
                } else {
                    if (!this.remoteDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-http") && !this.remoteDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-http")) {
                        FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration Invalid registration profile cannot process request");
                        this.returnLocallyAtSource(this.response, false);
                        return false;
                    }
                    bl = false;
                }
                if (bl) {
                    FSSOAPService fSSOAPService = FSSOAPService.getInstance();
                    if (fSSOAPService != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Signing suceeded. To call bindRegistrationRequest");
                        }
                        ((FSNameRegistrationRequest)object).setID("reg-Sig-ID");
                        SOAPMessage sOAPMessage = fSSOAPService.bindRegistrationRequest((FSNameRegistrationRequest)object);
                        if (sOAPMessage != null) {
                            SOAPMessage sOAPMessage2 = null;
                            try {
                                if (FSServiceUtils.isSigningOn()) {
                                    int n = ((FSNameRegistrationRequest)object).getMinorVersion();
                                    if (n == 0) {
                                        sOAPMessage = this.signRegistrationRequest(sOAPMessage, "id", ((FSNameRegistrationRequest)object).getID());
                                    } else if (n == 2) {
                                        sOAPMessage = this.signRegistrationRequest(sOAPMessage, "RequestID", ((AbstractRequest)object).getRequestID());
                                    } else if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("invalid minor version.");
                                    }
                                }
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("calling sendRegistrationMessage");
                                }
                                sOAPMessage2 = fSSOAPService.sendRegistrationMessage(sOAPMessage, this.remoteDescriptor.getSOAPEndPoint());
                            }
                            catch (SOAPException sOAPException) {
                                FSUtils.debug.error("Error in sending request " + sOAPException.getMessage());
                                this.returnLocallyAtSource(this.response, false);
                                return false;
                            }
                            catch (Exception exception) {
                                FSUtils.debug.error("Error in sending request " + exception.getMessage());
                                this.returnLocallyAtSource(this.response, false);
                                return false;
                            }
                            if (sOAPMessage2 == null) {
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("sendRegistrationMessagereturn response is null");
                                }
                                this.returnLocallyAfterRegistration(this.response, false);
                                return false;
                            }
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("callingparseSOAPMessage after return from IDP");
                            }
                            Element element = fSSOAPService.parseSOAPMessage(sOAPMessage2);
                            if (FSServiceUtils.isSigningOn() && this.regisResponse != null && !this.verifyResponseSignature(sOAPMessage2)) {
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("Response signature verification failed");
                                    FSUtils.debug.message("Name registration failed in doRemoteRegistration");
                                }
                                this.returnLocallyAfterRegistration(this.response, false);
                                return false;
                            }
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("Response signature verification succeeded");
                            }
                            if (element.getLocalName().equalsIgnoreCase("RegisterNameIdentifierResponse")) {
                                FSNameRegistrationResponse fSNameRegistrationResponse = null;
                                try {
                                    fSNameRegistrationResponse = new FSNameRegistrationResponse(element);
                                }
                                catch (SAMLException sAMLException) {
                                    fSNameRegistrationResponse = null;
                                }
                                if (fSNameRegistrationResponse != null) {
                                    String string2 = fSNameRegistrationResponse.getStatus().getStatusCode().getValue();
                                    if (string2.equals("samlp:Success")) {
                                        if (FSUtils.debug.messageEnabled()) {
                                            FSUtils.debug.message("Name registration Successful");
                                        }
                                        this.oldAcctKey = (FSAccountFedInfoKey)this.returnMap.get("OldAccountKey");
                                        if (this.oldAcctKey != null) {
                                            FSUtils.debug.message("Get OldAcctKet Name : " + this.oldAcctKey.getName());
                                            FSUtils.debug.message("Get OldAcctKet Qualifier : " + this.oldAcctKey.getNameSpace());
                                        } else {
                                            FSUtils.debug.message("OldAccount Key is null");
                                        }
                                        this.newAcctKey = (FSAccountFedInfoKey)this.returnMap.get("AccountKey");
                                        if (this.newAcctKey != null) {
                                            FSUtils.debug.message("Get newAcctKey Name : " + this.newAcctKey.getName());
                                            FSUtils.debug.message("Get newAcctKey Qualifier : " + this.newAcctKey.getNameSpace());
                                        } else {
                                            FSUtils.debug.message("newAcctKey Key is null");
                                        }
                                        this.newAcctInfo = (FSAccountFedInfo)this.returnMap.get("AccountInfo");
                                        this.userDN = (String)this.returnMap.get("userDN");
                                        regisSource = (String)this.returnMap.get("RegisSource");
                                        returnURL = (String)this.returnMap.get("RelayState");
                                        boolean bl2 = this.doCommonRegistration(false);
                                        FSUtils.debug.message("doCommonRegistration returns " + bl2);
                                        this.returnLocallyAfterRegistration(this.response, bl2);
                                        return bl2;
                                    }
                                    if (string2.equals("lib:FederationDoesNotExist")) {
                                        if (FSUtils.debug.messageEnabled()) {
                                            FSUtils.debug.message("Name registration Failed. Federation does not exist");
                                        }
                                        this.returnLocallyAfterRegistration(this.response, false);
                                        return false;
                                    }
                                    if (string2.equals("lib:Failure")) {
                                        if (FSUtils.debug.messageEnabled()) {
                                            FSUtils.debug.message("Name registration Failed.");
                                        }
                                        this.returnLocallyAfterRegistration(this.response, false);
                                        return false;
                                    }
                                }
                            }
                        }
                    }
                    this.returnLocallyAtSource(this.response, false);
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::doRemoteRegistration In Redirect profile");
                }
                String string3 = FSRegistrationIdGenerator.generateId();
                FSUtils.debug.message("Registration Id : " + string3);
                ((FSNameRegistrationRequest)object).setRelayState(string3);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("SSODetails", this.regisMap);
                hashMap.put("ReturnEntry", this.returnMap);
                if (returnURL != null) {
                    hashMap.put("RelayState", returnURL);
                }
                FSRegistrationManager fSRegistrationManager = FSRegistrationManager.getInstance(this.hostedProviderId);
                fSRegistrationManager.setRegistrationMapInfo(string3, hashMap);
                Set set = hashMap.keySet();
                Iterator iterator = set.iterator();
                String string4 = null;
                String string5 = null;
                while (true) {
                    if (!iterator.hasNext()) {
                        string = ((FSNameRegistrationRequest)object).toURLEncodedQueryString();
                        if (FSServiceUtils.isSigningOn()) {
                            charSequence = this.hostedDescriptor.getKeyInfo();
                            if (charSequence != null && !((String)charSequence).equals("")) break;
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSBrowserArtifactConsumerHandler:: signSAMLRequest:couldn't obtain this site's cert alias.");
                            }
                            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
                        }
                        break block63;
                    }
                    string4 = (String)iterator.next();
                    string5 = (String)this.regisMap.get(string4);
                    FSUtils.debug.message("Putting in Map Key : " + string4);
                    FSUtils.debug.message("Putting in Map Value : " + string5);
                }
                string = FSSignatureUtil.signAndReturnQueryString(string, (String)charSequence);
            }
            charSequence = new StringBuffer();
            String string6 = this.remoteDescriptor.getNameRegistrationURL();
            ((StringBuffer)charSequence).append(string6);
            if (string6.indexOf(63) == -1) {
                ((StringBuffer)charSequence).append('?');
            } else {
                ((StringBuffer)charSequence).append('&');
            }
            ((StringBuffer)charSequence).append(string);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request to be sent : " + ((StringBuffer)charSequence).toString());
            }
            this.response.sendRedirect(((StringBuffer)charSequence).toString());
            return true;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("FSNameRegistrationHandler" + FSUtils.bundle.getString("federation-redirection-failed"));
        }
        catch (FSMsgException fSMsgException) {
            FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration " + FSUtils.bundle.getString("termination-failed-send-remote"));
        }
        catch (SAMLResponderException sAMLResponderException) {
            FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration " + FSUtils.bundle.getString("termination-failed-send-remote"));
        }
        this.returnLocallyAtSource(this.response, false);
        return false;
    }

    public void processRegistrationRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSNameRegistrationRequest fSNameRegistrationRequest) {
        block19: {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered FSNameRegistrationHandler::processRegistrationRequest...");
            }
            this.request = httpServletRequest;
            this.response = httpServletResponse;
            this.regisRequest = fSNameRegistrationRequest;
            this.relayState = fSNameRegistrationRequest.getRelayState();
            this.setRegistrationURL();
            if (this.instAlliance == null) {
                FSUtils.debug.error("FSNameRegistrationHandler Alliance manager instance is null");
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Alliance Manager instance");
                }
                this.sendRegistrationResponse();
                return;
            }
            if (this.managerInst == null) {
                FSUtils.debug.error("FSNameRegistrationHandler " + FSUtils.bundle.getString("federation-failed-account-instance"));
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
                }
                this.sendRegistrationResponse();
                return;
            }
            boolean bl = this.setUserDN(fSNameRegistrationRequest);
            if (!bl) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Failed to get UserDN. Invalid Name registration request");
                }
                this.sendRegistrationResponse();
                return;
            }
            boolean bl2 = this.doCommonRegistration(true);
            FSUtils.debug.message("doCommonRegistration returns " + bl2);
            if (bl2) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationregistration in DS completed successfully");
                }
                try {
                    StatusCode statusCode = new StatusCode("samlp:Success");
                    this.regisResponse = new FSNameRegistrationResponse(null, fSNameRegistrationRequest.getRequestID(), new Status(statusCode), this.hostedProviderId, this.relayState);
                    this.regisResponse.setMinorVersion(fSNameRegistrationRequest.getMinorVersion());
                }
                catch (FSMsgException fSMsgException) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                    }
                    break block19;
                }
                catch (SAMLException sAMLException) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                    }
                    break block19;
                }
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationregistration in DS failed");
            }
            try {
                StatusCode statusCode = new StatusCode("lib:Failure");
                this.regisResponse = new FSNameRegistrationResponse(null, fSNameRegistrationRequest.getRequestID(), new Status(statusCode), this.hostedProviderId, this.relayState);
                this.regisResponse.setMinorVersion(fSNameRegistrationRequest.getMinorVersion());
            }
            catch (FSMsgException fSMsgException) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                }
            }
            catch (SAMLException sAMLException) {
                if (!FSUtils.debug.messageEnabled()) break block19;
                FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
            }
        }
        this.sendRegistrationResponse();
    }

    public FSNameRegistrationResponse processRegistrationRequest(FSNameRegistrationRequest fSNameRegistrationRequest) {
        this.relayState = fSNameRegistrationRequest.getRelayState();
        try {
            FSNameRegistrationResponse fSNameRegistrationResponse = null;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered FSNameRegistrationHandler::processRegistrationRequest");
            }
            if (this.instAlliance == null) {
                FSUtils.debug.error("FSNameRegistrationHandler Alliance Manager instance is null");
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Alliance Manager instance");
                }
                StatusCode statusCode = new StatusCode("lib:Failure");
                try {
                    fSNameRegistrationResponse = new FSNameRegistrationResponse(null, fSNameRegistrationRequest.getRequestID(), new Status(statusCode), this.hostedProviderId, this.relayState);
                }
                catch (FSMsgException fSMsgException) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                    }
                    return null;
                }
                fSNameRegistrationResponse.setID("reg-Sig-ID");
                fSNameRegistrationResponse.setMinorVersion(fSNameRegistrationRequest.getMinorVersion());
                return fSNameRegistrationResponse;
            }
            if (this.managerInst == null) {
                FSUtils.debug.error("FSNameRegistrationHandler Account Manager instance is null");
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationfailed to get Account Manager instance");
                }
                StatusCode statusCode = new StatusCode("lib:Failure");
                try {
                    fSNameRegistrationResponse = new FSNameRegistrationResponse(null, fSNameRegistrationRequest.getRequestID(), new Status(statusCode), this.hostedProviderId, this.relayState);
                }
                catch (FSMsgException fSMsgException) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                    }
                    return null;
                }
                fSNameRegistrationResponse.setID("reg-Sig-ID");
                fSNameRegistrationResponse.setMinorVersion(fSNameRegistrationRequest.getMinorVersion());
                return fSNameRegistrationResponse;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Begin processRegistrationRequest SOAP profile...");
            }
            if (fSNameRegistrationRequest != null) {
                boolean bl = this.setUserDN(fSNameRegistrationRequest);
                if (bl) {
                    boolean bl2 = this.doCommonRegistration(true);
                    FSUtils.debug.message("doCommonRegistration returns " + bl2);
                    if (bl2) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationregistration in DS completed successfully");
                        }
                        try {
                            StatusCode statusCode = new StatusCode("samlp:Success");
                            fSNameRegistrationResponse = new FSNameRegistrationResponse(null, fSNameRegistrationRequest.getRequestID(), new Status(statusCode), this.hostedProviderId, this.relayState);
                        }
                        catch (FSMsgException fSMsgException) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                            }
                            return null;
                        }
                        catch (SAMLException sAMLException) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                            }
                            return null;
                        }
                    } else {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSNameRegistrationHandler::handleNameRegistrationregistration in DS failed");
                        }
                        try {
                            StatusCode statusCode = new StatusCode("lib:Failure");
                            fSNameRegistrationResponse = new FSNameRegistrationResponse(null, fSNameRegistrationRequest.getRequestID(), new Status(statusCode), this.hostedProviderId, this.relayState);
                        }
                        catch (FSMsgException fSMsgException) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                            }
                            return null;
                        }
                        catch (SAMLException sAMLException) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                            }
                            return null;
                        }
                    }
                } else {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Failed to get UserDN. Invalid termination request");
                    }
                    try {
                        StatusCode statusCode = new StatusCode("lib:FederationDoesNotExist");
                        fSNameRegistrationResponse = new FSNameRegistrationResponse(null, fSNameRegistrationRequest.getRequestID(), new Status(statusCode), this.hostedProviderId, this.relayState);
                    }
                    catch (FSMsgException fSMsgException) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                        }
                        return null;
                    }
                    catch (SAMLException sAMLException) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSNameRegistrationHandler::failed to create registration response");
                        }
                        return null;
                    }
                }
            } else {
                FSUtils.debug.error("FSNameRegistrationHandler::processRegistrationRequest Federation termination request is improper");
                return null;
            }
            fSNameRegistrationResponse.setID("reg-Sig-ID");
            fSNameRegistrationResponse.setMinorVersion(fSNameRegistrationRequest.getMinorVersion());
            return fSNameRegistrationResponse;
        }
        catch (SAMLException sAMLException) {
            FSUtils.debug.message("FSNameRegistrationHandler::SAMLException" + sAMLException.getMessage());
            return null;
        }
    }

    public void returnLocallyAtSource(HttpServletResponse httpServletResponse, boolean bl) {
        block12: {
            if (regisSource.equals("AfterFederation")) {
                try {
                    FSUtils.debug.message("redirecting to Resource : " + returnURL);
                    httpServletResponse.sendRedirect(returnURL);
                }
                catch (IOException iOException) {
                    FSUtils.debug.error("Error when redirecting back to resource");
                    return;
                }
            }
            if (regisSource.equals("DuringSSO")) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(FSServiceUtils.getBaseURL(this.request));
                stringBuffer.append("/SingleSignOnService");
                stringBuffer.append("/");
                stringBuffer.append("metaAlias");
                stringBuffer.append("/");
                stringBuffer.append(FSServiceUtils.getMetaAlias(this.request));
                stringBuffer.append('?');
                Set set = this.regisMap.keySet();
                Iterator iterator = set.iterator();
                String string = null;
                String string2 = null;
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    string2 = (String)this.regisMap.get(string);
                    stringBuffer.append(string).append('=').append(URLEncoder.encode(string2));
                    stringBuffer.append('&');
                }
                stringBuffer.append("Authn");
                stringBuffer.append('=').append("true");
                stringBuffer.append('&');
                stringBuffer.append("nameregis");
                stringBuffer.append('=').append("true");
                try {
                    FSUtils.debug.message("redirecting to SSO : " + stringBuffer.toString());
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                }
                catch (IOException iOException) {
                    FSUtils.debug.error("Error when redirecting back to SSO service");
                    return;
                }
            }
            if (!regisSource.equals("STAND_ALONE")) break block12;
            try {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Entered  returnLocallyAfterRegistration with isSuccess set to " + bl);
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(REGISTRATION_DONE_URL);
                char c = REGISTRATION_DONE_URL.indexOf(63) < 0 ? (char)'?' : '&';
                stringBuffer.append(c);
                stringBuffer.append("regisStatus");
                stringBuffer.append('=');
                if (bl) {
                    stringBuffer.append("regisSuccess");
                } else {
                    stringBuffer.append("regisFailure");
                }
                httpServletResponse.sendRedirect(stringBuffer.toString());
            }
            catch (IOException iOException) {
                FSUtils.debug.message("Exception in  returnLocallyAfterRegistration " + iOException.getMessage());
            }
        }
    }

    public void returnLocallyAfterRegistration(HttpServletResponse httpServletResponse, boolean bl) {
        block12: {
            if (regisSource.equals("AfterFederation")) {
                try {
                    FSUtils.debug.message("redirecting to Resource : " + returnURL);
                    httpServletResponse.sendRedirect(returnURL);
                }
                catch (IOException iOException) {
                    FSUtils.debug.error("Error when redirecting back to resource");
                    return;
                }
            }
            if (regisSource.equals("DuringSSO")) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(FSServiceUtils.getBaseURL(this.request));
                stringBuffer.append("/SingleSignOnService");
                stringBuffer.append("/");
                stringBuffer.append("metaAlias");
                stringBuffer.append("/");
                stringBuffer.append(FSServiceUtils.getMetaAlias(this.request));
                stringBuffer.append('?');
                Set set = this.regisMap.keySet();
                Iterator iterator = set.iterator();
                String string = null;
                String string2 = null;
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    string2 = (String)this.regisMap.get(string);
                    stringBuffer.append(string).append('=').append(URLEncoder.encode(string2));
                    stringBuffer.append('&');
                }
                stringBuffer.append("Authn");
                stringBuffer.append('=').append("true");
                stringBuffer.append('&');
                stringBuffer.append("nameregis");
                stringBuffer.append('=').append("true");
                try {
                    FSUtils.debug.message("redirecting to SSO : " + stringBuffer.toString());
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                }
                catch (IOException iOException) {
                    FSUtils.debug.error("Error when redirecting back to SSO service");
                    return;
                }
            }
            if (!regisSource.equals("STAND_ALONE")) break block12;
            try {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Entered  returnLocallyAfterRegistration with isSuccess set to " + bl);
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(REGISTRATION_DONE_URL);
                char c = REGISTRATION_DONE_URL.indexOf(63) < 0 ? (char)'?' : '&';
                stringBuffer.append(c);
                stringBuffer.append("regisStatus");
                stringBuffer.append('=');
                if (bl) {
                    stringBuffer.append("regisSuccess");
                } else {
                    stringBuffer.append("regisFailure");
                }
                httpServletResponse.sendRedirect(stringBuffer.toString());
            }
            catch (IOException iOException) {
                FSUtils.debug.message("Exception in  returnLocallyAfterRegistration " + iOException.getMessage());
            }
        }
    }

    protected SOAPMessage signRegistrationRequest(SOAPMessage sOAPMessage, String string, String string2) throws SAMLException, FSMsgException {
        FSUtils.debug.message("Entered FSNameRegistrationHandler::signRegistrationRequest");
        String string3 = this.hostedDescriptor.getKeyInfo();
        if (string3 == null || string3.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::signRegistrationRequest: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        FSUtils.debug.message("FSNameRegistrationHandler.signRegistrationRequestProvider's certAlias is found: " + string3);
        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
        Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
        String string4 = "//*[local-name()='ProviderID']";
        xMLSignatureManager.signXML(document, string3, SAMLUtils.bundle.getString("xmlsigalgorithm"), string, string2, false, string4);
        return FSServiceUtils.convertDOMToSOAP(document);
    }

    protected boolean verifyResponseSignature(SOAPMessage sOAPMessage) {
        FSUtils.debug.message("Entered FSNameRegistrationHandler::verifyResponseSignature");
        try {
            String string = this.remoteDescriptor.getKeyInfo();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Registration.verifyResponseSignaturecouldn't obtain this site's cert alias.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
            }
            FSUtils.debug.message("NameRegistration.verifyResponseSignature: Provider's certAlias is found: " + string);
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
            return xMLSignatureManager.verifyXMLSignature(document, string);
        }
        catch (SAMLException sAMLException) {
            FSUtils.debug.error("Error in verifying response " + sAMLException.getMessage());
            return false;
        }
    }

    private FSNameRegistrationRequest createNameRegistrationRequest(FSAccountFedInfo fSAccountFedInfo) {
        block20: {
            try {
                Object object;
                FSNameRegistrationRequest fSNameRegistrationRequest;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("EnteredFSNameRegistrationHandler:: createNameRegistrationRequest");
                }
                if ((fSNameRegistrationRequest = new FSNameRegistrationRequest()) == null) break block20;
                fSNameRegistrationRequest.setProviderId(this.hostedProviderId);
                if (fSAccountFedInfo.isRoleIDP()) {
                    FSUtils.debug.message("calling of generateNameIdentifier Role : IdP ? " + fSAccountFedInfo.isRoleIDP());
                    NameIdentifier nameIdentifier = this.generateNameIdentifier();
                    FSUtils.debug.message("out of generateNameIdentifier *******");
                    FSUtils.debug.message("New SP nameIdentifier Qualifier : ");
                    FSUtils.debug.message(nameIdentifier.getNameQualifier());
                    FSUtils.debug.message("New SP nameIdentifier Name : " + nameIdentifier.getName());
                    SPProvidedNameIdentifier sPProvidedNameIdentifier = new SPProvidedNameIdentifier(nameIdentifier.getName(), nameIdentifier.getNameQualifier(), nameIdentifier.getFormat());
                    NameIdentifier nameIdentifier2 = fSAccountFedInfo.getRemoteNameIdentifier();
                    NameIdentifier nameIdentifier3 = fSAccountFedInfo.getLocalNameIdentifier();
                    fSNameRegistrationRequest.setIDPProvidedNameIdentifier(new IDPProvidedNameIdentifier(nameIdentifier2.getName(), nameIdentifier2.getNameQualifier(), nameIdentifier2.getFormat()));
                    fSNameRegistrationRequest.setSPProvidedNameIdentifier(sPProvidedNameIdentifier);
                    if (nameIdentifier3 != null) {
                        fSNameRegistrationRequest.setOldProvidedNameIdentifier(new OldProvidedNameIdentifier(nameIdentifier3.getName(), nameIdentifier3.getNameQualifier(), nameIdentifier3.getFormat()));
                        try {
                            this.oldAcctKey = new FSAccountFedInfoKey(this.hostedProviderId, nameIdentifier3.getName());
                        }
                        catch (FSAccountMgmtException fSAccountMgmtException) {
                            this.oldAcctKey = null;
                        }
                    } else {
                        fSNameRegistrationRequest.setOldProvidedNameIdentifier(new OldProvidedNameIdentifier(nameIdentifier2.getName(), nameIdentifier2.getNameQualifier(), nameIdentifier2.getFormat()));
                        try {
                            this.oldAcctKey = new FSAccountFedInfoKey(this.remoteProviderId, nameIdentifier2.getName());
                        }
                        catch (FSAccountMgmtException fSAccountMgmtException) {
                            this.oldAcctKey = null;
                        }
                    }
                    try {
                        FSAccountFedInfoKey fSAccountFedInfoKey = new FSAccountFedInfoKey(this.hostedProviderId, nameIdentifier.getName());
                        FSAccountFedInfo fSAccountFedInfo2 = new FSAccountFedInfo(this.remoteProviderId, (NameIdentifier)sPProvidedNameIdentifier, nameIdentifier2, fSAccountFedInfo.isRoleIDP());
                        this.returnMap.put("userDN", this.userDN);
                        this.returnMap.put("OldAccountKey", this.oldAcctKey);
                        if (this.oldAcctKey != null) {
                            FSUtils.debug.message("Get OldAcctKet Name : " + this.oldAcctKey.getName());
                            FSUtils.debug.message("Get OldAcctKet Qualifier : " + this.oldAcctKey.getNameSpace());
                        } else {
                            FSUtils.debug.message("OldAccount Key is null");
                        }
                        this.returnMap.put("AccountKey", fSAccountFedInfoKey);
                        this.returnMap.put("AccountInfo", fSAccountFedInfo2);
                        this.returnMap.put("RegisSource", regisSource);
                        this.returnMap.put("RelayState", returnURL);
                    }
                    catch (FSAccountMgmtException fSAccountMgmtException) {
                        return null;
                    }
                }
                FSUtils.debug.message("calling of generateNameIdentifier Role : IdP ? " + fSAccountFedInfo.isRoleIDP());
                NameIdentifier nameIdentifier = this.generateNameIdentifier();
                FSUtils.debug.message("New IDP nameIdentifier Name : ");
                FSUtils.debug.message(nameIdentifier.getName());
                FSUtils.debug.message("New IDP nameIdentifier Qualifier : " + nameIdentifier.getNameQualifier());
                FSUtils.debug.message("out of generateNameIdentifier *******");
                IDPProvidedNameIdentifier iDPProvidedNameIdentifier = new IDPProvidedNameIdentifier(nameIdentifier.getName(), nameIdentifier.getNameQualifier(), nameIdentifier.getFormat());
                NameIdentifier nameIdentifier4 = fSAccountFedInfo.getRemoteNameIdentifier();
                NameIdentifier nameIdentifier5 = fSAccountFedInfo.getLocalNameIdentifier();
                FSUtils.debug.message("Old IDP nameIdentifier Name : " + nameIdentifier5.getName());
                FSUtils.debug.message("Old IDP nameIdentifier Qualifier : " + nameIdentifier5.getNameQualifier());
                FSUtils.debug.message("To set OldProvidedNameIdentifier");
                fSNameRegistrationRequest.setOldProvidedNameIdentifier(new OldProvidedNameIdentifier(nameIdentifier5.getName(), nameIdentifier5.getNameQualifier(), nameIdentifier5.getFormat()));
                FSUtils.debug.message("To set IdpProvidedNameIdentifier");
                fSNameRegistrationRequest.setIDPProvidedNameIdentifier(iDPProvidedNameIdentifier);
                if (nameIdentifier4 != null) {
                    FSUtils.debug.message("SP nameIdentifier Name : " + nameIdentifier4.getName());
                    FSUtils.debug.message("SP nameIdentifier Qualifier : " + nameIdentifier4.getNameQualifier());
                    object = new SPProvidedNameIdentifier(nameIdentifier4.getName(), nameIdentifier4.getNameQualifier(), nameIdentifier4.getFormat());
                    fSNameRegistrationRequest.setSPProvidedNameIdentifier((SPProvidedNameIdentifier)object);
                } else {
                    object = new SPProvidedNameIdentifier(nameIdentifier5.getName(), nameIdentifier5.getNameQualifier(), nameIdentifier5.getFormat());
                    fSNameRegistrationRequest.setSPProvidedNameIdentifier((SPProvidedNameIdentifier)object);
                }
                try {
                    this.oldAcctKey = new FSAccountFedInfoKey(this.hostedProviderId, nameIdentifier5.getName());
                    object = new FSAccountFedInfoKey(this.hostedProviderId, nameIdentifier.getName());
                    FSAccountFedInfo fSAccountFedInfo3 = new FSAccountFedInfo(this.remoteProviderId, (NameIdentifier)iDPProvidedNameIdentifier, nameIdentifier4, fSAccountFedInfo.isRoleIDP());
                    this.returnMap.put("userDN", this.userDN);
                    this.returnMap.put("OldAccountKey", this.oldAcctKey);
                    this.returnMap.put("AccountKey", object);
                    this.returnMap.put("AccountInfo", fSAccountFedInfo3);
                    this.returnMap.put("RegisSource", regisSource);
                    this.returnMap.put("RelayState", returnURL);
                    if (this.oldAcctKey != null) {
                        FSUtils.debug.message("Get OldAcctKet Name : " + this.oldAcctKey.getName());
                        FSUtils.debug.message("Get OldAcctKet Qualifier : " + this.oldAcctKey.getNameSpace());
                    } else {
                        FSUtils.debug.message("OldAccount Key is null");
                    }
                }
                catch (FSAccountMgmtException fSAccountMgmtException) {
                    return null;
                }
                fSNameRegistrationRequest.setMinorVersion(this.remoteDescriptor.getMinorVersion());
                return fSNameRegistrationRequest;
            }
            catch (SAMLException sAMLException) {}
        }
        return null;
    }

    private boolean doCommonRegistration(boolean bl) {
        try {
            FSUtils.debug.message("user dn is " + this.userDN);
            FSUtils.debug.message("To write account fed info to DS");
            if (this.oldAcctKey != null) {
                FSUtils.debug.message("Old Account Key : " + this.oldAcctKey);
                this.managerInst.writeAccountFedInfo(this.userDN, this.newAcctKey, this.newAcctInfo, this.oldAcctKey);
            } else {
                FSUtils.debug.message("Old Account Key : " + this.oldAcctKey);
                this.managerInst.writeAccountFedInfo(this.userDN, this.newAcctKey, this.newAcctInfo);
            }
            return true;
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Error when writing user information " + fSAccountMgmtException.getMessage());
            }
            return false;
        }
    }

    private NameIdentifier generateNameIdentifier() {
        try {
            FSNameIdentifierHelper fSNameIdentifierHelper;
            String string;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered FSNameRegistrationHandler::generateNameIdentifier");
            }
            if ((string = (fSNameIdentifierHelper = new FSNameIdentifierHelper(this.hostedProviderId)).createNameIdentifier()) == null || string.trim().length() < 1) {
                FSUtils.debug.error("FSHandleGenerator::generateHandle returned null");
                return null;
            }
            FSUtils.debug.message("To set nameIdentifier");
            NameIdentifier nameIdentifier = new NameIdentifier(string, this.hostedProviderId);
            FSUtils.debug.message("completed set nameIdentifier");
            return nameIdentifier;
        }
        catch (SAMLException sAMLException) {
            FSUtils.error("FSNameRegistrationHandler", FSUtils.bundle.getString("registration-failed-sp-name-identifier"));
            return null;
        }
    }

    private void sendRegistrationResponse() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.remoteDescriptor.getNameRegistrationReturnURL();
        stringBuffer.append(string);
        if (this.regisResponse != null) {
            String string2 = null;
            try {
                string2 = this.regisResponse.toURLEncodedQueryString();
            }
            catch (FSMsgException fSMsgException) {
                string2 = null;
            }
            if (string2 != null) {
                if (FSServiceUtils.isSigningOn()) {
                    String string3 = this.hostedDescriptor.getKeyInfo();
                    if (string3 == null || string3.equals("")) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSBrowserArtifactConsumerHandler:: signSAMLRequest:couldn't obtain this site's cert alias.");
                        }
                        string2 = null;
                    }
                    if (string2 != null) {
                        string2 = FSSignatureUtil.signAndReturnQueryString(string2, string3);
                    }
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("URLEncodedRequest to be sent : " + string2);
                }
                if (string2 != null) {
                    if (stringBuffer.toString().indexOf(63) == -1) {
                        stringBuffer.append('?');
                    } else {
                        stringBuffer.append('&');
                    }
                    stringBuffer.append(string2);
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSNameRegistrationHandler::Redirect URL is " + stringBuffer.toString());
                    }
                }
            }
        }
        try {
            this.response.sendRedirect(stringBuffer.toString());
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Error in sending registration response");
            return;
        }
    }
}

