/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSLogoutResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.logout.FSReturnSessionManager;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.protocol.Status;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSReturnLogoutServlet
extends HttpServlet {
    FSAllianceManager allianceInst = null;
    private static String COMMON_ERROR_PAGE = "";
    private String userDN = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSReturnLogoutServlet Initializing...");
        }
        this.allianceInst = FSServiceUtils.getAllianceInstance();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    private void doGetPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        Object object;
        Object object2;
        Object object3;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSReturnLogoutServlet doGetPost...");
        }
        String string2 = "";
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSReturnLogoutServlet: " + FSUtils.bundle.getString("notLibertyEnabled"));
            FSUtils.error("FSReturnLogoutServlet", FSUtils.bundle.getString("notLibertyEnabled"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        string2 = httpServletRequest.getParameter("metaAlias");
        if (string2 == null || string2.length() < 1) {
            string2 = FSServiceUtils.getMetaAlias(httpServletRequest);
        }
        if (string2 == null || string2.length() < 1) {
            FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        try {
            object3 = SSOTokenManager.getInstance();
            object2 = object3.createSSOToken(httpServletRequest);
            object3.validateToken((SSOToken)object2);
            this.userDN = object2.getPrincipal().toString();
        }
        catch (SSOException sSOException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSReturnLogoutRequest: Unable to get principal", (Throwable)sSOException);
            }
            httpServletResponse.sendError(500, FSUtils.bundle.getString("nullSSOToken"));
            return;
        }
        object3 = null;
        try {
            object3 = this.allianceInst.getHostedProviderByMetaAlias(string2);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("Failed to get Hosted Provider");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        this.setLogoutURL(((FSProviderDescriptor)object3).getProviderID(), httpServletRequest);
        object2 = new FSLogoutResponse();
        try {
            object2 = FSLogoutResponse.parseURLEncodedRequest(httpServletRequest);
        }
        catch (FSMsgException fSMsgException) {
            this.showBadRequestErrorPage(httpServletResponse);
            return;
        }
        catch (SAMLException sAMLException) {
            this.showBadRequestErrorPage(httpServletResponse);
            return;
        }
        String string3 = ((FSLogoutResponse)object2).getProviderId();
        FSProviderDescriptor fSProviderDescriptor = null;
        try {
            fSProviderDescriptor = this.allianceInst.getProvider(string3);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            // empty catch block
        }
        if (fSProviderDescriptor == null) {
            this.showBadRequestErrorPage(httpServletResponse);
            return;
        }
        boolean bl = true;
        try {
            if (FSServiceUtils.isSigningOn()) {
                bl = this.verifyResponseSignature(httpServletRequest, fSProviderDescriptor);
            }
        }
        catch (SAMLException sAMLException) {
        }
        catch (FSException fSException) {
            // empty catch block
        }
        if (bl) {
            object = ((FSLogoutResponse)object2).getStatus();
            string = ((Status)object).getStatusCode().getValue();
            if (string.equalsIgnoreCase("samlp:Failure")) {
                FSReturnSessionManager fSReturnSessionManager = FSReturnSessionManager.getInstance(((FSProviderDescriptor)object3).getProviderID());
                if (fSReturnSessionManager != null) {
                    FSUtils.debug.message("update status of logout to failure  in session manager");
                    fSReturnSessionManager.setLogoutStatus(string, this.userDN);
                } else {
                    FSUtils.debug.message("Cannot get FSReturnSessionManager");
                }
            }
        } else {
            FSUtils.debug.error("FSReturnLogoutServlet Signature on logout response is invalidCannot proceed logout");
            FSUtils.error("FSReturnLogoutServlet", FSUtils.bundle.getString("logout-invalid-signature"));
            this.showBadRequestErrorPage(httpServletResponse);
            return;
        }
        object = new StringBuffer();
        httpServletRequest.setAttribute("logoutSource", (Object)"remote");
        ((StringBuffer)object).append("/ProcessLogout");
        ((StringBuffer)object).append("/");
        ((StringBuffer)object).append("metaAlias");
        ((StringBuffer)object).append("/");
        ((StringBuffer)object).append(string2);
        FSUtils.debug.message("About to get RequestDispatcher for " + ((StringBuffer)object).toString());
        string = this.getServletConfig().getServletContext().getRequestDispatcher(((StringBuffer)object).toString());
        if (string == null) {
            FSUtils.debug.message("RequestDispatcher is null");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Unable to find " + object);
            }
            FSUtils.debug.message("calling sendErrorPage ");
            this.sendErrorPage(httpServletRequest, httpServletResponse, string2);
            return;
        }
        string.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private void sendErrorPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        String string2 = FSServiceUtils.getLocale(httpServletRequest);
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            String string3 = "";
            if (this.allianceInst != null) {
                fSHostedProviderDescriptor = this.allianceInst.getHostedProviderByMetaAlias(string);
                string3 = fSHostedProviderDescriptor.getLocalConfiguration().getLogoutDonePageURL(httpServletRequest);
                if (string3 == null || string3.length() < 1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(fSHostedProviderDescriptor.getLocalConfiguration().getErrorPageURL(httpServletRequest));
                    char c = stringBuffer.toString().indexOf(63) < 0 ? (char)'?' : '&';
                    stringBuffer.append(c);
                    stringBuffer.append("federror");
                    stringBuffer.append('=');
                    stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("logout-failed")));
                    stringBuffer.append('&');
                    stringBuffer.append("fedremark");
                    stringBuffer.append('=');
                    stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("metadata-error-check")));
                    FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string3);
                    char c = string3.indexOf(63) < 0 ? (char)'?' : '&';
                    stringBuffer.append(c);
                    stringBuffer.append("logoutStatus");
                    stringBuffer.append('=');
                    stringBuffer.append("logoutFailure");
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                }
                return;
            }
            FSUtils.debug.error("Alliance manager instance is null");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failedToReadDataStore"));
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("IOException caught : FSReturnLogoutServlet " + iOException.getMessage());
            return;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManagementException caught :FSReturnLogoutServlet " + fSAllianceManagementException.getMessage());
            return;
        }
    }

    private void showBadRequestErrorPage(HttpServletResponse httpServletResponse) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COMMON_ERROR_PAGE);
        char c = COMMON_ERROR_PAGE.indexOf(63) < 0 ? (char)'?' : '&';
        stringBuffer.append(c);
        stringBuffer.append("federror");
        stringBuffer.append('=');
        stringBuffer.append(FSUtils.bundle.getString("logout-request-improper"));
        stringBuffer.append('&');
        stringBuffer.append("fedremark");
        stringBuffer.append('=');
        stringBuffer.append(FSUtils.bundle.getString("logout-failed"));
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
        }
        try {
            httpServletResponse.sendRedirect(stringBuffer.toString());
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Failed to redirect to error page");
        }
    }

    private boolean verifyResponseSignature(HttpServletRequest httpServletRequest, FSProviderDescriptor fSProviderDescriptor) throws SAMLException, FSException {
        boolean bl;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSReturnLogoutServlet::verifylogoutSignature");
        }
        String string = "";
        string = fSProviderDescriptor.getKeyInfo();
        if (string == null || string.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSReturnLogoutServlet.verifyRegistrationSignature: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("The certAlias is : " + string);
        }
        if (!(bl = FSSignatureUtil.verifyRequestSignature(httpServletRequest, string))) {
            FSUtils.debug.error("Logout response is not properly signed");
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Logout response is properly signed");
        }
        return true;
    }

    protected void setLogoutURL(String string, HttpServletRequest httpServletRequest) {
        try {
            if (this.allianceInst != null) {
                COMMON_ERROR_PAGE = this.allianceInst.getHostedProvider(string).getLocalConfiguration().getErrorPageURL(httpServletRequest);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManagementException " + fSAllianceManagementException.getMessage());
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("COMMON_ERROR_PAGE : " + COMMON_ERROR_PAGE);
        }
    }
}

