/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.message.FSLogoutResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.logout.FSPreLogoutHandler;
import com.sun.identity.federation.services.logout.FSReturnSessionManager;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSProcessLogoutServlet
extends HttpServlet {
    private FSAllianceManager allianceInst = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSProcessLogoutServlet Initializing...");
        }
        this.allianceInst = FSServiceUtils.getAllianceInstance();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    private void doGetPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSProcessLogoutServlet doGetPost...");
        }
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSProcessLogoutServlet: " + FSUtils.bundle.getString("notLibertyEnabled"));
            FSUtils.error("FSProcessLogoutServlet", FSUtils.bundle.getString("notLibertyEnabled"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        String string2 = FSServiceUtils.getMetaAlias(httpServletRequest);
        if (string2 == null || string2.length() < 1) {
            FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        if (this.allianceInst == null) {
            FSUtils.debug.error("Cannot retrieve hosted descriptor. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = this.allianceInst.getHostedProviderByMetaAlias(string2);
            if (fSHostedProviderDescriptor == null) {
                throw new FSAllianceManagementException(null);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("Unable to find Hosted Provider. not process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        String string3 = "";
        String string4 = "";
        try {
            if (this.allianceInst != null) {
                string = fSHostedProviderDescriptor.getProviderID();
                string3 = this.allianceInst.getHostedProvider(string).getLocalConfiguration().getLogoutDonePageURL(httpServletRequest);
                string4 = this.allianceInst.getHostedProvider(string).getLocalConfiguration().getErrorPageURL(httpServletRequest);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManagementException ", (Throwable)((Object)fSAllianceManagementException));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("logoutDoneURL : " + string3);
            FSUtils.debug.message("commonErrorPage : " + string4);
        }
        if ((string = (String)httpServletRequest.getAttribute("logoutSource")) == null) {
            string = httpServletRequest.getParameter("logoutSource");
        }
        SSOToken sSOToken = this.getValidToken(httpServletRequest);
        String string5 = null;
        if (sSOToken == null) {
            if (string != null) {
                if (string.equalsIgnoreCase("local")) {
                    this.redirectForAuthentication(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor);
                    return;
                }
                if (string.equalsIgnoreCase("remote")) {
                    FSUtils.debug.message("Control where Source is remote - not from applink but from other provider");
                    this.returnLocallyAfterLogout(httpServletResponse, string3, true);
                    return;
                }
                if (string.equalsIgnoreCase("logoutGet")) {
                    FSUtils.debug.message("Control where Source is Http Get action - not from applink ");
                    this.returnLocallyAfterLogout(httpServletResponse, string3, true);
                    return;
                }
            }
        } else {
            try {
                string5 = sSOToken.getPrincipal().toString();
            }
            catch (SSOException sSOException) {
                // empty catch block
            }
            if (string != null) {
                if (string.equalsIgnoreCase("local")) {
                    FSUtils.debug.message("Control where Source is local -  from applink");
                    this.doLogoutInitiation(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor, sSOToken, string3);
                    return;
                }
                if (string.equalsIgnoreCase("remote")) {
                    FSUtils.debug.message("Control where Source is remote - not from applink but from other provider. Token valid");
                    this.doLogoutInitiation(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor, sSOToken, string3);
                    return;
                }
                if (string.equalsIgnoreCase("logoutGet")) {
                    FSUtils.debug.message("Control where Source is Http Get action - not from applink. Initiation will take care in preLogouthandler ");
                    this.doLogoutInitiation(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor, sSOToken, string3);
                    return;
                }
            }
        }
        FSLogoutNotification fSLogoutNotification = new FSLogoutNotification();
        try {
            fSLogoutNotification = FSLogoutNotification.parseURLEncodedRequest(httpServletRequest);
        }
        catch (FSMsgException fSMsgException) {
            FSUtils.debug.message("Bad Logout request. calling showBadRequestErrorPage");
            this.showBadRequestErrorPage(httpServletResponse, string4);
            return;
        }
        if (fSLogoutNotification == null) {
            FSUtils.debug.message("Bad Logout request. calling showBadRequestErrorPage");
            this.showBadRequestErrorPage(httpServletResponse, string4);
        } else {
            this.doRequestProcessing(httpServletRequest, httpServletResponse, fSHostedProviderDescriptor, fSLogoutNotification, string4, string5);
        }
    }

    private SSOToken getValidToken(HttpServletRequest httpServletRequest) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSProcessLogoutServlet::getValidToken");
        }
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (!sSOTokenManager.isValidToken(sSOToken)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("SSOToken is not valid, redirecting for authentication");
                }
                return null;
            }
            return sSOToken;
        }
        catch (SSOException sSOException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("SSOException caught: " + (Object)((Object)sSOException));
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRequestProcessing(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSHostedProviderDescriptor fSHostedProviderDescriptor, FSLogoutNotification fSLogoutNotification, String string, String string2) {
        String string3;
        int n;
        block14: {
            block15: {
                block16: {
                    Object object;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Entered FSProcessLogoutServlet::doRequestProcessing");
                    }
                    n = fSLogoutNotification.getMinorVersion();
                    string3 = fSLogoutNotification.getProviderId();
                    boolean bl = true;
                    if (FSServiceUtils.isSigningOn()) {
                        try {
                            object = this.allianceInst.getProvider(string3);
                            if (object == null) {
                                FSUtils.debug.error("Remote provider metadata not found.");
                                FSUtils.debug.error("Cannot retrieve provider descriptor.");
                                FSUtils.error("FSProcessLogoutServlet::doRequestProcessing", FSUtils.bundle.getString("logout-invalid-provider"));
                                this.returnToSource(httpServletResponse, string3, "samlp:Failure", string, n, fSHostedProviderDescriptor, string2);
                                return;
                            }
                            FSUtils.debug.message("Calling verifyLogoutSignature");
                            bl = this.verifyLogoutSignature(httpServletRequest, (FSProviderDescriptor)object);
                        }
                        catch (FSAllianceManagementException fSAllianceManagementException) {
                            FSUtils.debug.error("Remote provider metadata not found.");
                            FSUtils.debug.error("Cannot retrieve provider descriptor.");
                            FSUtils.error("FSProcessLogoutServlet::doRequestProcessing", FSUtils.bundle.getString("logout-invalid-provider"));
                            this.returnToSource(httpServletResponse, string3, "samlp:Failure", string, n, fSHostedProviderDescriptor, string2);
                            return;
                        }
                        catch (FSException fSException) {
                            FSUtils.debug.error("FSFedTerminationHandler::processTerminationRequest Signature on Logout request is invalidCannot proceed federation Logout");
                            FSUtils.error("FSProcessLogoutServlet", FSUtils.bundle.getString("logout-invalid-signature"));
                            this.returnToSource(httpServletResponse, string3, "samlp:Failure", string, n, fSHostedProviderDescriptor, string2);
                            return;
                        }
                        catch (SAMLException sAMLException) {
                            FSUtils.debug.error("FSFedTerminationHandler::processTerminationRequest Signature on Logout request is invalidCannot proceed federation Logout");
                            FSUtils.error("FSProcessLogoutServlet", FSUtils.bundle.getString("logout-invalid-signature"));
                            this.returnToSource(httpServletResponse, string3, "samlp:Failure", string, n, fSHostedProviderDescriptor, string2);
                            return;
                        }
                    }
                    if (!bl) break block15;
                    object = fSHostedProviderDescriptor.getLocalConfiguration().getActiveTrustedProviders();
                    if (object == null) break block16;
                    if (object.contains(string3)) {
                        SSOToken sSOToken = this.getValidToken(httpServletRequest);
                        if (sSOToken != null) {
                            FSServiceManager fSServiceManager = FSServiceManager.getInstance();
                            if (fSServiceManager == null) {
                                FSUtils.debug.message("FSServiceManager Instance null. Cannot continue logout");
                                FSUtils.error("FSProcessLogoutServlet", FSUtils.bundle.getString("logout-failed-manager"));
                                this.returnToSource(httpServletResponse, string3, "samlp:Failure", string, n, fSHostedProviderDescriptor, string2);
                                return;
                            }
                            FSUtils.debug.message("FSServiceManager Instance not null");
                            FSPreLogoutHandler fSPreLogoutHandler = fSServiceManager.getPreLogoutHandler();
                            if (fSPreLogoutHandler != null) {
                                fSPreLogoutHandler.setLogoutRequest(fSLogoutNotification);
                                fSPreLogoutHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                                fSPreLogoutHandler.processSingleLogoutRequest(httpServletRequest, httpServletResponse, sSOToken);
                                return;
                            }
                            break block14;
                        } else {
                            FSUtils.debug.message("Invalid SSOToken in request processing. Nothing to logout");
                            String string4 = FSLogoutUtil.getUserDN(fSLogoutNotification, fSHostedProviderDescriptor.getProviderID());
                            if (string4 != null) {
                                FSLogoutUtil.destroyPrincipalSession(string4, fSHostedProviderDescriptor.getProviderID());
                                this.returnToSource(httpServletResponse, string3, "samlp:Failure", string, n, fSHostedProviderDescriptor, string2);
                                return;
                            }
                        }
                        break block14;
                    } else {
                        FSUtils.debug.error("Remote provider not in trusted list");
                    }
                    break block14;
                }
                FSUtils.debug.error("Remote provider not in trusted list");
                FSUtils.debug.error("Trusted provider list is empty.");
                break block14;
            }
            FSUtils.debug.error("FSFedTerminationServlet::doRequestProcesing Signature on Logout request is invalidCannot proceed federation Logout");
            FSUtils.error("FSFedTerminationHandler", FSUtils.bundle.getString("logout-invalid-signature"));
        }
        this.returnToSource(httpServletResponse, string3, "samlp:Failure", string, n, fSHostedProviderDescriptor, string2);
    }

    private void doLogoutInitiation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSHostedProviderDescriptor fSHostedProviderDescriptor, SSOToken sSOToken, String string) {
        FSUtils.debug.message("Entered FSProcessLogoutServlet::doLogoutInitiation");
        try {
            FSUtils.debug.message("In FSProcessLogoutServlet:doLogoutInitiation for: " + sSOToken.getPrincipal().toString());
            FSServiceManager fSServiceManager = FSServiceManager.getInstance();
            if (fSServiceManager != null) {
                FSUtils.debug.message("FSServiceManager Instance not null");
                FSPreLogoutHandler fSPreLogoutHandler = fSServiceManager.getPreLogoutHandler();
                if (fSPreLogoutHandler != null) {
                    fSPreLogoutHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                    fSPreLogoutHandler.handleSingleLogout(httpServletRequest, httpServletResponse, sSOToken);
                    return;
                }
                FSUtils.debug.error("FSPreLogoutHandler Object null.Cannot continue logout");
                FSUtils.error("FSProcessLogoutServlet", FSUtils.bundle.getString("logout-invalid-handler"));
            } else {
                FSUtils.debug.message("FSServiceManager Instance null. Cannot continue logout");
                FSUtils.error("FSProcessLogoutServlet", FSUtils.bundle.getString("logout-failed-manager"));
            }
            this.returnLocallyAfterLogout(httpServletResponse, string, false);
            return;
        }
        catch (SSOException sSOException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSProcessLogoutServlet::doLogoutInitiation::SSOExceptionError in Token. Process halted.");
            }
            FSUtils.debug.error("FSProcessLogoutServlet::doLogoutInitiation " + FSUtils.bundle.getString("logout-token-invalid"));
            FSUtils.error("FSProcessLogoutServlet::doLogoutInitiation", FSUtils.bundle.getString("logout-failed"));
            this.returnLocallyAfterLogout(httpServletResponse, string, false);
            return;
        }
    }

    private void redirectForAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSHostedProviderDescriptor fSHostedProviderDescriptor) throws IOException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSProcessLogoutServlet::redirectForAuthentication");
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(FSServiceUtils.getBaseURL(httpServletRequest));
            stringBuffer.append("/preLogin");
            char c = stringBuffer.toString().indexOf(63) < 0 ? (char)'?' : '&';
            stringBuffer.append(c);
            stringBuffer.append("metaAlias");
            stringBuffer.append('=');
            stringBuffer.append(fSHostedProviderDescriptor.getLocalConfiguration().getProviderAlias());
            String string = this.getParameterString(httpServletRequest);
            if (string != null && string.length() > 0) {
                stringBuffer.append('&').append(string);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Redirecting for authentication to: " + stringBuffer.toString());
            }
            httpServletResponse.sendRedirect(stringBuffer.toString());
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Error when redirecting : " + iOException.getMessage());
            return;
        }
    }

    private String getParameterString(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String[] stringArray = httpServletRequest.getParameterValues(string);
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                stringBuffer.append(string).append('=').append(stringArray[n]).append('&');
                ++n;
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Parameter String: " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    private void returnToSource(HttpServletResponse httpServletResponse, String string, String string2, String string3, int n, FSHostedProviderDescriptor fSHostedProviderDescriptor, String string4) {
        try {
            String string5 = "";
            if (this.allianceInst != null) {
                string5 = this.allianceInst.getProvider(string).getSLOServiceReturnURL();
                if (string5 == null || string5.length() < 1) {
                    FSUtils.debug.message("returnToSource returns sendErroras source provider is unknown");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string3);
                    char c = string3.indexOf(63) < 0 ? (char)'?' : '&';
                    stringBuffer.append(c);
                    stringBuffer.append("federror");
                    stringBuffer.append('=');
                    stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("logout-failed")));
                    stringBuffer.append('&');
                    stringBuffer.append("fedremark");
                    stringBuffer.append('=');
                    stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("metadata-error-check")));
                    FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                    return;
                }
                FSUtils.debug.message("returnToSource returns URL : " + string5);
                String string6 = this.buildSignedResponse(string5, string2, n, fSHostedProviderDescriptor, string4);
                httpServletResponse.sendRedirect(string6);
                return;
            }
            FSUtils.debug.message("Alliance Manager instance is null");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("unableToReturnToSource"));
            return;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string3);
                char c = string3.indexOf(63) < 0 ? (char)'?' : '&';
                stringBuffer.append(c);
                stringBuffer.append("federror");
                stringBuffer.append('=');
                stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("logout-failed")));
                stringBuffer.append('&');
                stringBuffer.append("fedremark");
                stringBuffer.append('=');
                stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("metadata-error-check")));
                FSUtils.debug.error("Redirecting to Error page : " + stringBuffer.toString());
                httpServletResponse.sendRedirect(stringBuffer.toString());
                return;
            }
            catch (IOException iOException) {
                FSUtils.debug.error("Redirect/sendError failed. Control halted");
            }
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Redirect/sendError failed. Control halted" + iOException.getMessage());
        }
    }

    public String buildSignedResponse(String string, String string2, int n, FSHostedProviderDescriptor fSHostedProviderDescriptor, String string3) {
        try {
            Object object;
            Object object2;
            String string4 = "";
            String string5 = "";
            String string6 = "";
            FSLogoutResponse fSLogoutResponse = new FSLogoutResponse();
            fSLogoutResponse.setID("logout-sig-ID");
            if (string3 != null) {
                object2 = FSReturnSessionManager.getInstance(fSHostedProviderDescriptor.getProviderID());
                object = new HashMap();
                if (object2 != null) {
                    object = ((FSReturnSessionManager)object2).getUserProviderInfo(string3);
                }
                if (object != null) {
                    string4 = (String)((HashMap)object).get("responseTo");
                    string6 = (String)((HashMap)object).get("RELAYSTATE");
                    string5 = (String)((HashMap)object).get("logoutStatus");
                    string4 = (String)((HashMap)object).get("responseTo");
                    ((FSReturnSessionManager)object2).removeUserProviderInfo(string3);
                    FSUtils.debug.message("Deleted " + string3 + " from return list");
                    fSLogoutResponse.setResponseTo(string4);
                    fSLogoutResponse.setRelayState(string6);
                    fSLogoutResponse.setProviderId(fSHostedProviderDescriptor.getProviderID());
                    fSLogoutResponse.setStatus(string5);
                } else {
                    fSLogoutResponse.setStatus(string2);
                    fSLogoutResponse.setProviderId(fSHostedProviderDescriptor.getProviderID());
                }
            } else {
                fSLogoutResponse.setStatus(string2);
                fSLogoutResponse.setProviderId(fSHostedProviderDescriptor.getProviderID());
            }
            fSLogoutResponse.setMinorVersion(n);
            object2 = fSLogoutResponse.toURLEncodedQueryString();
            if (FSServiceUtils.isSigningOn()) {
                object = fSHostedProviderDescriptor.getKeyInfo();
                if (object == null || ((String)object).equals("")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSBrowserArtifactConsumerHandler:: signSAMLRequest:couldn't obtain this site's cert alias.");
                    }
                    throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
                }
                object2 = FSSignatureUtil.signAndReturnQueryString((String)object2, (String)object);
            }
            object = new StringBuffer();
            ((StringBuffer)object).append(string);
            if (string.indexOf(63) == -1) {
                ((StringBuffer)object).append('?');
            } else {
                ((StringBuffer)object).append('&');
            }
            ((StringBuffer)object).append((String)object2);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Response to be sent : " + ((StringBuffer)object).toString());
            }
            return ((StringBuffer)object).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void returnLocallyAfterLogout(HttpServletResponse httpServletResponse, String string, boolean bl) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            char c = string.indexOf(63) < 0 ? (char)'?' : '&';
            stringBuffer.append(c);
            stringBuffer.append("logoutStatus");
            stringBuffer.append('=');
            if (bl) {
                stringBuffer.append("logoutSuccess");
            } else {
                stringBuffer.append("logoutFailure");
            }
            httpServletResponse.sendRedirect(stringBuffer.toString());
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Redirect failed. Control halted" + iOException.getMessage());
            return;
        }
    }

    private boolean verifyLogoutSignature(HttpServletRequest httpServletRequest, FSProviderDescriptor fSProviderDescriptor) throws SAMLException, FSException {
        boolean bl;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSProcessLogoutServlet::verifyLogoutSignature");
        }
        String string = "";
        string = fSProviderDescriptor.getKeyInfo();
        if (string == null || string.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSProcessLogoutServlet.verifyLogoutSignature: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("The certAlias is : " + string);
        }
        if (!(bl = FSSignatureUtil.verifyRequestSignature(httpServletRequest, string))) {
            FSUtils.debug.error("Logout request is not properly signed");
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Logout request is properly signed");
        }
        return true;
    }

    private void showBadRequestErrorPage(HttpServletResponse httpServletResponse, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        char c = string.indexOf(63) < 0 ? (char)'?' : '&';
        stringBuffer.append(c);
        stringBuffer.append("federror");
        stringBuffer.append('=');
        stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("logout-request-improper")));
        stringBuffer.append('&');
        stringBuffer.append("fedremark");
        stringBuffer.append('=');
        stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("logout-failed")));
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
        }
        try {
            httpServletResponse.sendRedirect(stringBuffer.toString());
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Failed to redirect to error page");
        }
    }
}

