/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.message.FSLogoutResponse;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.logout.FSIDPSingleLogoutHandler;
import com.sun.identity.federation.services.logout.FSLogoutStatus;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.logout.FSReturnSessionManager;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.saml.common.SAMLResponderException;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSPreLogoutHandler {
    protected HttpServletResponse response = null;
    protected HttpServletRequest request = null;
    protected String locale = null;
    protected SSOToken ssoToken = null;
    protected String userDN = "";
    protected FSHostedProviderDescriptor hostedDescriptor = null;
    protected String hostedProviderId = "";
    protected String currentProviderId = "";
    protected boolean isCurrentProviderIDPRole = false;
    protected String sessionIndex = "";
    protected FSLogoutNotification reqLogout = null;
    protected FSAllianceManager allianceInst = null;
    protected FSAccountManager accountInst = null;
    protected boolean isWMLAgent = false;
    protected static String LOGOUT_DONE_URL = null;
    protected static String COMMON_ERROR_URL = null;

    public FSPreLogoutHandler() {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSPreLogoutHandler::FSPreLogoutHandler Constructor");
        }
        this.allianceInst = FSServiceUtils.getAllianceInstance();
        try {
            this.accountInst = FSAccountManager.getInstance();
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.error("FSNameRegistrationHandler " + FSUtils.bundle.getString("federation-failed-account-instance"));
            this.accountInst = null;
        }
    }

    protected void setLogoutURL() {
        LOGOUT_DONE_URL = this.hostedDescriptor.getLocalConfiguration().getLogoutDonePageURL(this.request);
        COMMON_ERROR_URL = this.hostedDescriptor.getLocalConfiguration().getErrorPageURL(this.request);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("LOGOUT_DONE_URL : " + LOGOUT_DONE_URL);
            FSUtils.debug.message("COMMON_ERROR_URL : " + COMMON_ERROR_URL);
        }
    }

    public void setHostedDescriptor(FSHostedProviderDescriptor fSHostedProviderDescriptor) {
        this.hostedDescriptor = fSHostedProviderDescriptor;
        this.hostedProviderId = fSHostedProviderDescriptor.getProviderID();
    }

    public void setLogoutRequest(FSLogoutNotification fSLogoutNotification) {
        this.reqLogout = fSLogoutNotification;
    }

    public FSLogoutStatus handleSingleLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SSOToken sSOToken) {
        this.request = httpServletRequest;
        this.setLogoutURL();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSPreLogoutHandler::handleSingleLogout");
        }
        if (this.allianceInst == null || this.accountInst == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Failed to get Account & Alliance manager.Cannot proceed");
            }
            this.returnLocallyAfterLogout(httpServletResponse, false);
            return new FSLogoutStatus("samlp:Success");
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Successfully got Account & Alliance manager");
        }
        try {
            this.response = httpServletResponse;
            this.ssoToken = sSOToken;
            this.userDN = sSOToken.getPrincipal().toString();
            String string = httpServletRequest.getHeader("Accept");
            if (string != null && string.indexOf("text/vnd.wap.wml") != -1) {
                this.isWMLAgent = true;
            }
            if (FSLogoutUtil.liveConnectionsExist(this.userDN, this.hostedProviderId)) {
                HashMap hashMap = FSLogoutUtil.getCurrentProvider(this.userDN, this.hostedProviderId, sSOToken);
                if (hashMap != null) {
                    FSSessionPartner fSSessionPartner = (FSSessionPartner)hashMap.get("PartnerSession");
                    this.sessionIndex = (String)hashMap.get("SessionIndex");
                    if (fSSessionPartner != null) {
                        FSLogoutStatus fSLogoutStatus = new FSLogoutStatus("samlp:Failure");
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("creating IDP handler");
                        }
                        FSIDPSingleLogoutHandler fSIDPSingleLogoutHandler = new FSIDPSingleLogoutHandler();
                        fSIDPSingleLogoutHandler.setHostedDescriptor(this.hostedDescriptor);
                        fSLogoutStatus = fSIDPSingleLogoutHandler.handleSingleLogout(httpServletResponse, httpServletRequest, fSSessionPartner, this.userDN, this.sessionIndex, this.isWMLAgent);
                        return fSLogoutStatus;
                    }
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("No more providers, nothing to broadcast ");
                    FSUtils.debug.message("destroy user session call destroyPrincipalSession");
                }
                FSLogoutUtil.destroyPrincipalSession(this.userDN, this.hostedProviderId);
                FSLogoutUtil.destroyLocalSession(sSOToken);
                this.returnToPostLogout("samlp:Success");
                return new FSLogoutStatus("samlp:Success");
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("No live connections, destroy user session call destroyPrincipalSession");
            }
            FSLogoutUtil.destroyPrincipalSession(this.userDN, this.hostedProviderId);
            FSLogoutUtil.destroyLocalSession(sSOToken);
            this.returnToPostLogout("samlp:Success");
            return new FSLogoutStatus("samlp:Success");
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("SSOException in liveConnectionsExist So destroy self and exit");
            FSLogoutUtil.destroyPrincipalSession(this.userDN, this.hostedProviderId);
            this.returnToPostLogout("samlp:Success");
            return new FSLogoutStatus("samlp:Success");
        }
    }

    public FSLogoutStatus processSingleLogoutRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SSOToken sSOToken) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSPrelogoutHandler::processSingleLogoutRequest HTTP Redirect");
        }
        this.request = httpServletRequest;
        this.locale = FSServiceUtils.getLocale(httpServletRequest);
        this.setLogoutURL();
        this.response = httpServletResponse;
        this.ssoToken = sSOToken;
        String string = this.reqLogout.getProviderId();
        this.userDN = FSLogoutUtil.getUserDN(this.reqLogout, this.hostedProviderId);
        if (this.userDN == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSPrelogoutHandler::User Not found");
            }
            this.returnToSource(httpServletResponse, string, "samlp:Failure");
            return new FSLogoutStatus("samlp:Failure");
        }
        String string2 = "";
        string2 = FSLogoutUtil.getCurrentProviderRole(this.userDN, string, this.hostedProviderId) ? "yes" : "no";
        String string3 = httpServletRequest.getHeader("Accept");
        if (string3 != null && string3.indexOf("text/vnd.wap.wml") != -1) {
            this.isWMLAgent = true;
        }
        String string4 = this.reqLogout.getRelayState();
        FSLogoutUtil.cleanSessionMapPartnerList(this.userDN, string, this.hostedProviderId);
        FSUtils.debug.message("FSPrelogoutHandler::calling getCurrentProvider");
        boolean bl = false;
        HashMap hashMap = new HashMap();
        FSSessionPartner fSSessionPartner = null;
        hashMap = FSLogoutUtil.getCurrentProvider(this.userDN, this.hostedProviderId);
        if (hashMap != null) {
            fSSessionPartner = (FSSessionPartner)hashMap.get("PartnerSession");
            this.sessionIndex = (String)hashMap.get("SessionIndex");
            if (fSSessionPartner != null) {
                bl = true;
                FSUtils.debug.message("bHasAnyOtherProvider = " + bl);
                this.currentProviderId = fSSessionPartner.getPartner();
            }
        }
        FSUtils.debug.message("bHasAnyOtherProvider other than source : " + bl);
        FSLogoutStatus fSLogoutStatus = new FSLogoutStatus("samlp:Failure");
        FSUtils.debug.message("FSPreLogout::creating FSIDPSingleLogoutHandler");
        FSIDPSingleLogoutHandler fSIDPSingleLogoutHandler = new FSIDPSingleLogoutHandler();
        fSIDPSingleLogoutHandler.setHostedDescriptor(this.hostedDescriptor);
        fSLogoutStatus = fSIDPSingleLogoutHandler.processSingleLogoutRequest(httpServletResponse, httpServletRequest, this.reqLogout, fSSessionPartner, this.userDN, string, this.sessionIndex, this.isWMLAgent, string4, string2);
        return fSLogoutStatus;
    }

    public FSLogoutStatus processSingleLogoutRequest(FSLogoutNotification fSLogoutNotification) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSPreLogoutHandler:: processSingleLogoutRequest SOAP Profile");
        }
        String string = fSLogoutNotification.getProviderId();
        this.userDN = this.getUserFromRequest(fSLogoutNotification, this.hostedProviderId);
        if (this.userDN == null) {
            FSUtils.debug.error("User does not exist. Invalid request");
            return new FSLogoutStatus("samlp:Failure");
        }
        String string2 = "";
        string2 = FSLogoutUtil.getCurrentProviderRole(this.userDN, string, this.hostedProviderId) ? "yes" : "no";
        FSLogoutUtil.cleanSessionMapPartnerList(this.userDN, string, this.hostedProviderId);
        boolean bl = false;
        HashMap hashMap = new HashMap();
        FSSessionPartner fSSessionPartner = null;
        hashMap = FSLogoutUtil.getCurrentProvider(this.userDN, this.hostedProviderId);
        if (hashMap != null) {
            fSSessionPartner = (FSSessionPartner)hashMap.get("PartnerSession");
            this.sessionIndex = (String)hashMap.get("SessionIndex");
            if (fSSessionPartner != null) {
                bl = true;
                FSUtils.debug.message("Partner is not null");
                this.currentProviderId = fSSessionPartner.getPartner();
            }
        }
        FSUtils.debug.message("bHasAnyOtherProvider other than source : " + bl);
        FSLogoutStatus fSLogoutStatus = new FSLogoutStatus("samlp:Failure");
        FSUtils.debug.message("creating FSIDPSingleLogoutHandler");
        FSIDPSingleLogoutHandler fSIDPSingleLogoutHandler = new FSIDPSingleLogoutHandler();
        fSIDPSingleLogoutHandler.setHostedDescriptor(this.hostedDescriptor);
        fSLogoutStatus = fSIDPSingleLogoutHandler.processSingleLogoutRequest(fSLogoutNotification, fSSessionPartner, this.userDN, string, this.sessionIndex, this.isWMLAgent, string2);
        return fSLogoutStatus;
    }

    private void returnToSource(HttpServletResponse httpServletResponse, String string, String string2) {
        try {
            String string3 = "";
            if (this.allianceInst != null) {
                string3 = this.allianceInst.getProvider(string).getSLOServiceReturnURL();
                if (string3 == null || string3.length() < 1) {
                    FSUtils.debug.message("returnToSource returns sendErroras source provider is unknown");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(COMMON_ERROR_URL);
                    char c = COMMON_ERROR_URL.indexOf(63) < 0 ? (char)'?' : '&';
                    stringBuffer.append(c);
                    stringBuffer.append("federror");
                    stringBuffer.append('=');
                    stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("logout-failed")));
                    stringBuffer.append('&');
                    stringBuffer.append("fedremark");
                    stringBuffer.append('=');
                    stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("metadata-error-check")));
                    FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
                    httpServletResponse.sendRedirect(stringBuffer.toString());
                    return;
                }
                FSUtils.debug.message("returnToSource returns URL : " + string3);
                String string4 = this.buildSignedResponse(string3, string2);
                httpServletResponse.sendRedirect(string4);
                return;
            }
            FSUtils.debug.message("Alliance Manager instance is null");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("unableToReturnToSource"));
            return;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(COMMON_ERROR_URL);
                char c = COMMON_ERROR_URL.indexOf(63) < 0 ? (char)'?' : '&';
                stringBuffer.append(c);
                stringBuffer.append("federror");
                stringBuffer.append('=');
                stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("logout-failed")));
                stringBuffer.append('&');
                stringBuffer.append("fedremark");
                stringBuffer.append('=');
                stringBuffer.append(URLEncoder.encode(FSUtils.bundle.getString("metadata-error-check")));
                FSUtils.debug.error("Redirecting to Error page : " + stringBuffer.toString());
                httpServletResponse.sendRedirect(stringBuffer.toString());
                return;
            }
            catch (IOException iOException) {
                FSUtils.debug.error("Redirect/sendError failed. Control halted");
            }
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Redirect/sendError failed. Control halted" + iOException.getMessage());
        }
    }

    public String buildSignedResponse(String string, String string2) {
        try {
            Object object;
            Object object2;
            String string3 = "";
            String string4 = "";
            String string5 = "";
            FSLogoutResponse fSLogoutResponse = new FSLogoutResponse();
            if (this.userDN != null) {
                object2 = FSReturnSessionManager.getInstance(this.hostedDescriptor.getProviderID());
                object = new HashMap();
                if (object2 != null) {
                    object = ((FSReturnSessionManager)object2).getUserProviderInfo(this.userDN);
                }
                if (object != null) {
                    string3 = (String)((HashMap)object).get("responseTo");
                    string5 = (String)((HashMap)object).get("RELAYSTATE");
                    string4 = (String)((HashMap)object).get("logoutStatus");
                    string3 = (String)((HashMap)object).get("responseTo");
                    ((FSReturnSessionManager)object2).removeUserProviderInfo(this.userDN);
                    FSUtils.debug.message("Deleted " + this.userDN + " from return list");
                    fSLogoutResponse.setResponseTo(string3);
                    fSLogoutResponse.setRelayState(string5);
                    fSLogoutResponse.setProviderId(this.hostedDescriptor.getProviderID());
                    fSLogoutResponse.setStatus(string4);
                    fSLogoutResponse.setID("logout-sig-ID");
                } else {
                    fSLogoutResponse.setStatus(string2);
                    fSLogoutResponse.setProviderId(this.hostedDescriptor.getProviderID());
                }
            } else {
                fSLogoutResponse.setStatus(string2);
                fSLogoutResponse.setProviderId(this.hostedDescriptor.getProviderID());
            }
            fSLogoutResponse.setMinorVersion(this.reqLogout.getMinorVersion());
            object2 = fSLogoutResponse.toURLEncodedQueryString();
            if (FSServiceUtils.isSigningOn()) {
                object = this.hostedDescriptor.getKeyInfo();
                if (object == null || ((String)object).equals("")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSBrowserArtifactConsumerHandler:: signSAMLRequest:couldn't obtain this site's cert alias.");
                    }
                    throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
                }
                object2 = FSSignatureUtil.signAndReturnQueryString((String)object2, (String)object);
            }
            object = new StringBuffer();
            ((StringBuffer)object).append(string);
            if (string.indexOf(63) == -1) {
                ((StringBuffer)object).append('?');
            } else {
                ((StringBuffer)object).append('&');
            }
            ((StringBuffer)object).append((String)object2);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Response to be sent : " + ((StringBuffer)object).toString());
            }
            return ((StringBuffer)object).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void returnToPostLogout(String string) {
        FSUtils.debug.message("Entered FSPreLogoutHandler::returnToPostLogout");
        try {
            CharSequence charSequence;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = null;
            FSLogoutResponse fSLogoutResponse = new FSLogoutResponse();
            FSReturnSessionManager fSReturnSessionManager = FSReturnSessionManager.getInstance(this.hostedProviderId);
            HashMap hashMap = new HashMap();
            if (fSReturnSessionManager != null) {
                hashMap = fSReturnSessionManager.getUserProviderInfo(this.userDN);
            }
            if (hashMap == null) {
                FSUtils.debug.message("Return URL based on local postlogout URL");
                FSUtils.debug.message("No Source in ReturnMAP");
                this.returnLocallyAfterLogout(this.response, true);
                return;
            }
            string2 = (String)hashMap.get("Provider");
            string7 = this.allianceInst.getProvider(string2).getSLOServiceReturnURL();
            string3 = (String)hashMap.get("ROLE");
            string4 = (String)hashMap.get("RELAYSTATE");
            string5 = (String)hashMap.get("logoutStatus");
            string6 = (String)hashMap.get("responseTo");
            fSReturnSessionManager.removeUserProviderInfo(this.userDN);
            FSUtils.debug.message("Deleted " + this.userDN + " from return list");
            fSLogoutResponse.setResponseTo(string6);
            fSLogoutResponse.setRelayState(string4);
            fSLogoutResponse.setProviderId(this.hostedProviderId);
            fSLogoutResponse.setStatus(string5);
            if (string5 != null && string5.equalsIgnoreCase("samlp:Success")) {
                fSLogoutResponse.setStatus(string);
            }
            fSLogoutResponse.setID("logout-sig-ID");
            fSLogoutResponse.setMinorVersion(this.allianceInst.getProvider(string2).getMinorVersion());
            String string8 = fSLogoutResponse.toURLEncodedQueryString();
            if (FSServiceUtils.isSigningOn()) {
                charSequence = this.hostedDescriptor.getKeyInfo();
                if (charSequence == null || ((String)charSequence).equals("")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSBrowserArtifactConsumerHandler:: signSAMLRequest:couldn't obtain this site's cert alias.");
                    }
                    throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
                }
                string8 = FSSignatureUtil.signAndReturnQueryString(string8, (String)charSequence);
            }
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(string7);
            if (string7.indexOf(63) == -1) {
                ((StringBuffer)charSequence).append('?');
            } else {
                ((StringBuffer)charSequence).append('&');
            }
            ((StringBuffer)charSequence).append(string8);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Response to be sent : " + ((StringBuffer)charSequence).toString());
            }
            this.response.sendRedirect(((StringBuffer)charSequence).toString());
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Unable to get LRURL. No location to redirect.processing completed");
            FSUtils.error("FSSingleLogoutHandler::returnAfterCompletion", FSUtils.bundle.getString("logout-redirect-failed"));
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("Unable to get LRURL. No location to redirect processing completed");
            FSUtils.error("FSSingleLogoutHandler::returnAfterCompletion", FSUtils.bundle.getString("logout-redirect-failed"));
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSPreLogoutHandler::General exception thrown :");
            FSUtils.error("FSPreLogoutHandler::returnAfterCompletion", FSUtils.bundle.getString("logout-redirect-failed"));
        }
        this.returnLocallyAfterLogout(this.response, true);
    }

    public void returnLocallyAfterLogout(HttpServletResponse httpServletResponse, boolean bl) {
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered  returnLocallyAfterLogout with isSuccess set to " + bl);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(LOGOUT_DONE_URL);
            char c = LOGOUT_DONE_URL.indexOf(63) < 0 ? (char)'?' : '&';
            stringBuffer.append(c);
            stringBuffer.append("logoutStatus");
            stringBuffer.append('=');
            if (bl) {
                stringBuffer.append("logoutSuccess");
            } else {
                stringBuffer.append("logoutFailure");
            }
            httpServletResponse.sendRedirect(stringBuffer.toString());
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.message("IOException in  returnLocallyAfterLogout " + iOException.getMessage());
            return;
        }
    }

    private String getUserFromRequest(FSLogoutNotification fSLogoutNotification, String string) {
        Object object;
        String string2 = "";
        String string3 = "";
        String string4 = fSLogoutNotification.getProviderId();
        try {
            object = this.allianceInst.getHostedProvider(this.hostedProviderId);
            string3 = ((FSHostedProviderDescriptor)object).getLocalConfiguration().getAssociatedOrgDN();
            FSUtils.debug.message("OrgDN : " + string3);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManagementException when retrieving user  Hosted provider invalid ");
            FSUtils.debug.error(fSAllianceManagementException.getMessage());
            return null;
        }
        try {
            object = fSLogoutNotification.getNameIdentifier().getName().trim();
            FSAccountFedInfoKey fSAccountFedInfoKey = new FSAccountFedInfoKey(this.hostedProviderId, (String)object);
            string2 = this.accountInst.getUserDN(fSAccountFedInfoKey, string3);
            if (string2 == null && (string2 = this.accountInst.getUserDN(fSAccountFedInfoKey = new FSAccountFedInfoKey(fSLogoutNotification.getProviderId(), (String)object), string3)) == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("UserDn is null");
                }
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("user dn is " + string2);
            }
            return string2;
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.error("FSAccountMgmtException when retrieving user ");
            FSUtils.debug.error(fSAccountMgmtException.getMessage());
            return null;
        }
    }
}

