/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.message.FSLogoutResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.logout.FSLogoutStatus;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.logout.FSReturnSessionManager;
import com.sun.identity.federation.services.logout.FSSingleLogoutHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FSIDPSingleLogoutHandler
extends FSSingleLogoutHandler {
    private String sourceProviderId = "";
    private boolean logoutStatus = true;
    private boolean isHttpRedirect = false;

    public FSLogoutStatus handleSingleLogout(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, FSSessionPartner fSSessionPartner, String string, String string2, boolean bl) {
        FSUtils.debug.message("Entered FSIDPSingleLogoutHandler::handleSingleLogout");
        super.handleSingleLogout(httpServletResponse, httpServletRequest, fSSessionPartner, string, string2, bl);
        this.remoteDescriptor = this.getRemoteDescriptor(this.currentProviderId);
        String string3 = this.getProfileToCommunicateLogout(this.currentProviderId);
        FSUtils.debug.message("Communicating logout with provider " + this.currentProviderId + " using profile " + string3);
        FSLogoutUtil.cleanSessionMapPartnerList(string, this.currentProviderId, this.hostedProviderId);
        FSUtils.debug.message("Out of cleanSessionMapPartnerList in FSIDPSingleLogoutHandler");
        FSLogoutStatus fSLogoutStatus = new FSLogoutStatus("samlp:Failure");
        if (string3.equals("http://projectliberty.org/profiles/slo-sp-http") || string3.equals("http://projectliberty.org/profiles/slo-idp-http")) {
            FSUtils.debug.message("In redirect profile");
            fSLogoutStatus = this.doHttpRedirect(this.currentProviderId);
        } else if (string3.equals("http://projectliberty.org/profiles/slo-idp-soap") || string3.equals("http://projectliberty.org/profiles/slo-sp-soap")) {
            FSUtils.debug.message("In SOAP profile");
            fSLogoutStatus = this.doIDPSoapProfile(this.currentProviderId);
        } else if (string3.equals("http://projectliberty.org/profiles/slo-idp-http-get") && !this.isCurrentProviderIDPRole) {
            FSUtils.debug.message("In GET profile");
            fSLogoutStatus = this.doHttpGet(this.currentProviderId);
        } else {
            FSUtils.debug.message("Single Logout Profile cannot be processed. Verify profile in metadata");
            FSUtils.error("FSSingleLogoutHandler::handleSingleLogout", FSUtils.bundle.getString("logout-profile-not-supported"));
            this.returnLocallyAfterLogout(httpServletResponse, false);
            return new FSLogoutStatus("samlp:Failure");
        }
        FSUtils.debug.message("Logout completed first round with status : " + fSLogoutStatus);
        if (fSLogoutStatus.getStatus().equalsIgnoreCase("samlp:Failure")) {
            this.returnLocallyAfterLogout(httpServletResponse, false);
        }
        return fSLogoutStatus;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void continueLogout() {
        FSUtils.debug.message("Entered FSIDPSingleLogoutHandler::continueLogout");
        if (!FSLogoutUtil.liveConnectionsExist(this.userDN, this.hostedProviderId)) {
            FSUtils.debug.message("Reached else part in continuelogout");
            FSUtils.debug.message("No live connections, destroy user session call destroyPrincipalSession");
            FSLogoutUtil.destroyPrincipalSession(this.userDN, this.hostedProviderId);
            if (this.response == null) return;
            this.returnAfterCompletion();
            return;
        }
        FSUtils.debug.message("More liveConnectionsExist");
        HashMap hashMap = FSLogoutUtil.getCurrentProvider(this.userDN, this.hostedProviderId);
        if (hashMap == null) {
            FSUtils.debug.message("GetCurrentProvider returns null HashMap Clean session and return");
            FSUtils.debug.message("No live connections, destroy user  session call destroyPrincipalSession");
            FSLogoutUtil.destroyPrincipalSession(this.userDN, this.hostedProviderId);
            if (this.response == null) return;
            this.returnAfterCompletion();
            return;
        }
        FSSessionPartner fSSessionPartner = (FSSessionPartner)hashMap.get("PartnerSession");
        this.sessionIndex = (String)hashMap.get("SessionIndex");
        if (fSSessionPartner == null) {
            FSUtils.debug.message("Reached else part  currentSessionProvider is null. nothing more to broadcast");
            FSUtils.debug.message("No more providers, destroy usersession call destroyPrincipalSession");
            FSLogoutUtil.destroyPrincipalSession(this.userDN, this.hostedProviderId);
            if (this.response == null) return;
            this.returnAfterCompletion();
            return;
        }
        this.currentProviderId = fSSessionPartner.getPartner();
        this.isCurrentProviderIDPRole = fSSessionPartner.getIsRoleIDP();
        this.remoteDescriptor = this.getRemoteDescriptor(this.currentProviderId);
        String string = this.getProfileToCommunicateLogout(this.currentProviderId);
        FSUtils.debug.message("Communicating logout with provider" + this.currentProviderId + " using profile " + string);
        FSLogoutUtil.cleanSessionMapPartnerList(this.userDN, this.currentProviderId, this.hostedProviderId);
        FSLogoutStatus fSLogoutStatus = new FSLogoutStatus("samlp:Failure");
        if (string.equals("http://projectliberty.org/profiles/slo-sp-http") || string.equals("http://projectliberty.org/profiles/slo-idp-http")) {
            FSUtils.debug.message("In redirect profile");
            fSLogoutStatus = this.doHttpRedirect(this.currentProviderId);
            return;
        }
        if (string.equals("http://projectliberty.org/profiles/slo-idp-soap") || string.equals("http://projectliberty.org/profiles/slo-sp-soap")) {
            FSUtils.debug.message("In SOAP profile");
            fSLogoutStatus = this.doIDPSoapProfile(this.currentProviderId);
            return;
        }
        if (string.equals("http://projectliberty.org/profiles/slo-idp-http-get") && !this.isCurrentProviderIDPRole) {
            FSUtils.debug.message("In GET profile");
            fSLogoutStatus = this.doHttpGet(this.currentProviderId);
            return;
        }
        FSUtils.debug.message("Single Logout Profile cannot be processed. Verify profile in metadata");
        FSUtils.error("FSSingleLogoutHandler::handleSingleLogout", FSUtils.bundle.getString("logout-profile-not-supported"));
    }

    private FSLogoutStatus doHttpRedirect(String string) {
        try {
            CharSequence charSequence;
            FSUtils.debug.message("In HTTP Redirect profile");
            this.isHttpRedirect = true;
            FSAccountFedInfo fSAccountFedInfo = FSLogoutUtil.getCurrentWorkingAccount(this.userDN, string);
            FSLogoutNotification fSLogoutNotification = this.createSingleLogoutRequest(fSAccountFedInfo, this.sessionIndex);
            if (fSLogoutNotification == null) {
                FSUtils.debug.message("Logout Request is null");
                return new FSLogoutStatus("samlp:Failure");
            }
            fSLogoutNotification.setMinorVersion(this.getMinorVersion(string));
            FSUtils.debug.message("FSIDPSingleLogoutHandler::doHttpRedirect " + this.remoteDescriptor.getSLOServiceURL());
            String string2 = fSLogoutNotification.toURLEncodedQueryString();
            if (FSServiceUtils.isSigningOn()) {
                charSequence = this.hostedDescriptor.getKeyInfo();
                FSUtils.debug.message("Retrieving self certalias  : " + (String)charSequence);
                if (charSequence == null || ((String)charSequence).equals("")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSIDPSingleLogoutHandler:: doHttpRedirect: couldn't obtain this site's cert alias.");
                    }
                    return new FSLogoutStatus("samlp:Failure");
                }
                string2 = FSSignatureUtil.signAndReturnQueryString(string2, (String)charSequence);
            }
            charSequence = new StringBuffer();
            String string3 = this.remoteDescriptor.getSLOServiceURL();
            FSUtils.debug.message("Encoded Redirect URL " + string2);
            ((StringBuffer)charSequence).append(string3);
            if (string3.indexOf(63) == -1) {
                ((StringBuffer)charSequence).append('?');
            } else {
                ((StringBuffer)charSequence).append('&');
            }
            ((StringBuffer)charSequence).append(string2);
            FSUtils.debug.message("FSIDPSingleLogoutHandler::doHttpRedirect URL is " + ((StringBuffer)charSequence).toString());
            this.response.sendRedirect(((StringBuffer)charSequence).toString());
            return new FSLogoutStatus("samlp:Success");
        }
        catch (FSMsgException fSMsgException) {
            FSUtils.debug.error("FSIDPSingleLogoutHandler:: doHttpRedirect FSMsgException");
        }
        catch (IOException iOException) {
            FSUtils.debug.error("FSIDPSingleLogoutHandler::doHttpRedirect IOException");
        }
        return new FSLogoutStatus("samlp:Failure");
    }

    protected void returnAfterCompletion() {
        block15: {
            FSUtils.debug.message("Entered FSIDPSingleLogoutHandler:: returnAfterCompletion");
            try {
                String string = "";
                String string2 = "";
                String string3 = "";
                String string4 = "";
                String string5 = "";
                FSReturnSessionManager fSReturnSessionManager = FSReturnSessionManager.getInstance(this.hostedProviderId);
                HashMap hashMap = new HashMap();
                if (fSReturnSessionManager != null) {
                    hashMap = fSReturnSessionManager.getUserProviderInfo(this.userDN);
                }
                if (hashMap != null) {
                    string = (String)hashMap.get("Provider");
                    string2 = (String)hashMap.get("ROLE");
                    string3 = (String)hashMap.get("RELAYSTATE");
                    string4 = (String)hashMap.get("logoutStatus");
                    string5 = (String)hashMap.get("responseTo");
                    fSReturnSessionManager.removeUserProviderInfo(this.userDN);
                    FSUtils.debug.message("Deleted " + string + " from return list");
                    FSUtils.debug.message("Getting provider " + string + " IDP Return URL = ");
                    String string6 = this.allianceInst.getProvider(string).getSLOServiceReturnURL();
                    if (string6 != null) {
                        CharSequence charSequence;
                        FSUtils.debug.message(string6);
                        FSLogoutResponse fSLogoutResponse = new FSLogoutResponse();
                        fSLogoutResponse.setResponseTo(string5);
                        fSLogoutResponse.setRelayState(string3);
                        fSLogoutResponse.setProviderId(this.hostedProviderId);
                        fSLogoutResponse.setStatus(string4);
                        fSLogoutResponse.setID("logout-sig-ID");
                        fSLogoutResponse.setMinorVersion(this.getMinorVersion(string));
                        String string7 = fSLogoutResponse.toURLEncodedQueryString();
                        if (FSServiceUtils.isSigningOn()) {
                            charSequence = this.hostedDescriptor.getKeyInfo();
                            if (charSequence == null || ((String)charSequence).equals("")) {
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("FSBrowserArtifactConsumerHandler:: signSAMLRequest:couldn't obtain this site's cert alias.");
                                }
                                throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
                            }
                            string7 = FSSignatureUtil.signAndReturnQueryString(string7, (String)charSequence);
                        }
                        charSequence = new StringBuffer();
                        ((StringBuffer)charSequence).append(string6);
                        if (string6.indexOf(63) == -1) {
                            ((StringBuffer)charSequence).append('?');
                        } else {
                            ((StringBuffer)charSequence).append('&');
                        }
                        ((StringBuffer)charSequence).append(string7);
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Response to be sent : " + ((StringBuffer)charSequence).toString());
                        }
                        this.response.sendRedirect(((StringBuffer)charSequence).toString());
                        return;
                    }
                    break block15;
                }
                FSUtils.debug.message("no source provider. return to local status page");
                this.returnLocallyAfterLogout(this.response, true);
                return;
            }
            catch (IOException iOException) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Unable to get LRURL. No location to redirect. processing completed");
                }
                FSUtils.error("FSSingleLogoutHandler::returnAfterCompletion", FSUtils.bundle.getString("logout-redirect-failed"));
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Unable to get LRURL. No location to redirect. processing completed");
                }
                FSUtils.error("FSSingleLogoutHandler::returnAfterCompletion", FSUtils.bundle.getString("logout-redirect-failed"));
            }
            catch (Exception exception) {
                FSUtils.error("FSSingleLogoutHandler::returnAfterCompletion", FSUtils.bundle.getString("logout-redirect-failed"));
            }
        }
    }

    public void returnLocallyAfterLogout(HttpServletResponse httpServletResponse, boolean bl) {
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Entered  returnLocallyAfterLogout with isSuccess set to " + bl);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(FSSingleLogoutHandler.LOGOUT_DONE_URL);
            char c = FSSingleLogoutHandler.LOGOUT_DONE_URL.indexOf(63) < 0 ? (char)'?' : '&';
            stringBuffer.append(c);
            stringBuffer.append("logoutStatus");
            stringBuffer.append('=');
            if (bl) {
                stringBuffer.append("logoutSuccess");
            } else {
                stringBuffer.append("logoutFailure");
            }
            httpServletResponse.sendRedirect(stringBuffer.toString());
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.message("IOException in  returnLocallyAfterLogout " + iOException.getMessage());
            return;
        }
    }

    private FSLogoutStatus doHttpGet(String string) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("doHttpGet - Entered");
        }
        if (this.isWMLAgent) {
            return this.doWMLGet(string);
        }
        return this.doHTMLGet(string);
    }

    private FSLogoutStatus doWMLGet(String string) {
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("In WML based response");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.hostedDescriptor.getSLOServiceURL());
            if (stringBuffer.toString().indexOf(63) == -1) {
                stringBuffer.append('?');
            } else {
                stringBuffer.append('&');
            }
            stringBuffer.append("logoutSource=logoutGet");
            FSUtils.debug.message("Submit action : " + stringBuffer.toString());
            this.response.setContentType("text/vnd.wap.wml");
            PrintWriter printWriter = this.response.getWriter();
            printWriter.println("<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1");
            printWriter.println("//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">");
            printWriter.println("<wml>");
            printWriter.println("<card id=\"redirect\" title=\"Log Out\">");
            printWriter.println("<onenterforward>");
            printWriter.println("<go method=\"post\" href=\"" + stringBuffer.toString() + "\">");
            FSUtils.debug.message("Calling getLogoutGETProviders");
            HashMap hashMap = FSLogoutUtil.getLogoutGETProviders(this.userDN, string, this.sessionIndex, this.hostedProviderId);
            Vector vector = (Vector)hashMap.get("Provider");
            FSUtils.debug.message("Calling cleanSessionMapProviders");
            FSLogoutUtil.cleanSessionMapProviders(this.userDN, vector, this.hostedProviderId);
            FSUtils.debug.message("Calling getMultiLogoutRequest");
            String string2 = this.getMultiLogoutRequest(hashMap);
            FSUtils.debug.message("Image Statements : " + string2);
            printWriter.println(string2);
            printWriter.println("</go>");
            printWriter.println("</onenterforward>");
            printWriter.println("<onenterbackward>");
            printWriter.println("<prev/>");
            printWriter.println("</onenterbackward>");
            printWriter.println("<onenterbackward>");
            printWriter.println("<p>");
            printWriter.println("logout initiated ...");
            printWriter.println("</p>");
            printWriter.println("</card>");
            printWriter.println("</wml>");
            printWriter.close();
            return new FSLogoutStatus("samlp:Success");
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Error in performing HTTP GET for WML agent");
            return new FSLogoutStatus("samlp:Failure");
        }
    }

    private FSLogoutStatus doHTMLGet(String string) {
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("In HTML based response");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.hostedDescriptor.getSLOServiceURL());
            if (stringBuffer.toString().indexOf(63) == -1) {
                stringBuffer.append('?');
            } else {
                stringBuffer.append('&');
            }
            stringBuffer.append("logoutSource=logoutGet");
            FSUtils.debug.message("Submit action : " + stringBuffer.toString());
            PrintWriter printWriter = this.response.getWriter();
            this.response.setContentType("text/html");
            printWriter.println("<HTML>");
            printWriter.println("<HEAD>");
            printWriter.println("<TITLE>Logout in progress</TITLE></HEAD>");
            printWriter.println("<BODY Onload=\"document.forms[0].submit()\">");
            printWriter.println("<p><b> Logout in progress ...");
            printWriter.println("If you have JavaScript disabled, please press the Continue button.");
            printWriter.println("Otherwise, please wait.</p>");
            printWriter.println("<FORM METHOD=\"POST\" ACTION=\"" + stringBuffer.toString() + "\">");
            printWriter.println("<P>");
            FSUtils.debug.message("Calling getLogoutGETProviders");
            HashMap hashMap = FSLogoutUtil.getLogoutGETProviders(this.userDN, string, this.sessionIndex, this.hostedProviderId);
            Vector vector = (Vector)hashMap.get("Provider");
            FSUtils.debug.message("Calling cleanSessionMapProviders");
            FSLogoutUtil.cleanSessionMapProviders(this.userDN, vector, this.hostedProviderId);
            FSUtils.debug.message("Calling getMultiLogoutRequest");
            String string2 = this.getMultiLogoutRequest(hashMap);
            FSUtils.debug.message("Image Statements : " + string2);
            printWriter.println(string2);
            printWriter.println("<P><BR>");
            printWriter.println("<input type=\"submit\" name=\"Continue\" ");
            printWriter.println("value=\"Continue logout\"/>");
            printWriter.println("</FORM></BODY></HTML>");
            printWriter.close();
            return new FSLogoutStatus("samlp:Success");
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Error in performing HTTP GET for regular agent");
            return new FSLogoutStatus("samlp:Failure");
        }
    }

    private String getMultiLogoutRequest(HashMap hashMap) {
        try {
            Vector vector = (Vector)hashMap.get("Provider");
            HashMap hashMap2 = (HashMap)hashMap.get("SessionIndex");
            StringBuffer stringBuffer = new StringBuffer();
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    String string = (String)vector.elementAt(n);
                    FSAccountFedInfo fSAccountFedInfo = FSLogoutUtil.getCurrentWorkingAccount(this.userDN, string);
                    FSLogoutNotification fSLogoutNotification = this.createSingleLogoutRequest(fSAccountFedInfo, (String)hashMap2.get(string));
                    fSLogoutNotification.setMinorVersion(this.getMinorVersion(string));
                    String string2 = fSLogoutNotification.toURLEncodedQueryString();
                    String string3 = this.hostedDescriptor.getKeyInfo();
                    FSUtils.debug.message("certalias  : " + string3);
                    if (string3 == null || string3.equals("")) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSIDPSingleLogoutHandler getMultiLogoutRequest: couldn't obtain this site's cert alias.");
                        }
                    } else {
                        string2 = FSSignatureUtil.signAndReturnQueryString(string2, string3);
                        StringBuffer stringBuffer2 = new StringBuffer();
                        String string4 = this.allianceInst.getProvider(string).getSLOServiceURL();
                        stringBuffer2.append(string4);
                        if (string4.indexOf(63) == -1) {
                            stringBuffer2.append('?');
                        } else {
                            stringBuffer2.append('&');
                        }
                        stringBuffer2.append(string2);
                        FSUtils.debug.message("FSIDPSingleLogoutHandler::doHttpRedirect URL is " + stringBuffer2.toString());
                        stringBuffer.append("<IMG SRC=\"").append(stringBuffer2.toString()).append("\" </IMG>");
                    }
                    ++n;
                }
                return stringBuffer.toString();
            }
        }
        catch (FSMsgException fSMsgException) {
            FSUtils.debug.error("FSIDPSingleLogoutHandler::getMultiLogoutRequest FSMsgException" + fSMsgException.getMessage());
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSIDPSingleLogoutHandler::getMultiLogoutRequest  FSAllianceManagementException" + fSAllianceManagementException.getMessage());
        }
        FSUtils.debug.error("Returning null from getMultiLogoutRequest");
        return null;
    }

    private FSLogoutStatus doIDPSoapProfile(String string) {
        FSUtils.debug.message("Entered FSIDPSingleLogoutHandler::doIDPSoapProfile");
        FSLogoutStatus fSLogoutStatus = this.doSoapProfile(string);
        if (fSLogoutStatus.getStatus().equalsIgnoreCase("samlp:Success")) {
            FSUtils.debug.message("SOAP first round went fine.  Calling continue logout");
        } else {
            FSUtils.debug.message("SOAP first round false. No continue logout");
            this.logoutStatus = false;
        }
        if (!this.isHttpRedirect) {
            this.continueLogout();
        }
        if (!this.logoutStatus) {
            return new FSLogoutStatus("samlp:Failure");
        }
        return fSLogoutStatus;
    }

    private FSLogoutStatus doSoapProfile(String string) {
        block24: {
            FSUtils.debug.message("Entered IDP's doSoapProfile");
            try {
                FSAccountFedInfo fSAccountFedInfo = FSLogoutUtil.getCurrentWorkingAccount(this.userDN, string);
                FSLogoutNotification fSLogoutNotification = this.createSingleLogoutRequest(fSAccountFedInfo, this.sessionIndex);
                fSLogoutNotification.setMinorVersion(this.getMinorVersion(string));
                if (fSLogoutNotification != null) {
                    FSSOAPService fSSOAPService = FSSOAPService.getInstance();
                    if (fSSOAPService != null) {
                        SOAPMessage sOAPMessage;
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("Signing suceeded. To call bindLogoutRequest");
                        }
                        fSLogoutNotification.setID("logout-sig-ID");
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("logout request before sign: " + fSLogoutNotification.toXMLString(true, true));
                        }
                        if ((sOAPMessage = fSSOAPService.bindLogoutRequest(fSLogoutNotification)) != null) {
                            SOAPMessage sOAPMessage2 = null;
                            try {
                                if (FSServiceUtils.isSigningOn()) {
                                    int n = fSLogoutNotification.getMinorVersion();
                                    switch (n) {
                                        case 0: {
                                            sOAPMessage = this.signLogoutRequest(sOAPMessage, "id", fSLogoutNotification.getID());
                                            break;
                                        }
                                        case 2: {
                                            sOAPMessage = this.signLogoutRequest(sOAPMessage, "RequestID", fSLogoutNotification.getRequestID());
                                            break;
                                        }
                                        default: {
                                            FSUtils.debug.message("invalid minor version.");
                                        }
                                    }
                                }
                                sOAPMessage2 = fSSOAPService.sendLogoutMessage(sOAPMessage, this.remoteDescriptor.getSOAPEndPoint());
                            }
                            catch (Exception exception) {
                                FSUtils.debug.error("FSSOAPException in doSOAPProfile Cannot send request" + exception.getMessage());
                                return new FSLogoutStatus("samlp:Failure");
                            }
                            if (sOAPMessage2 != null) {
                                Element element = fSSOAPService.parseSOAPMessage(sOAPMessage2);
                                if (FSServiceUtils.isSigningOn() && !this.verifyResponseSignature(sOAPMessage2)) {
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("Response signature verification failed");
                                        FSUtils.debug.message("Name registration failed in doRemoteRegistration");
                                    }
                                    this.returnLocallyAfterLogout(this.response, false);
                                    return new FSLogoutStatus("samlp:Failure");
                                }
                                FSLogoutResponse fSLogoutResponse = new FSLogoutResponse(element);
                                Status status = fSLogoutResponse.getStatus();
                                StatusCode statusCode = status.getStatusCode();
                                StatusCode statusCode2 = null;
                                statusCode2 = statusCode.getStatusCode();
                                String string2 = statusCode.getValue();
                                if (string2.equalsIgnoreCase("samlp:Success")) {
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("FSIDPSingleLogoutHandler:  doSoapProfile returning success");
                                    }
                                    return new FSLogoutStatus("samlp:Success");
                                }
                                if (string2.equalsIgnoreCase("samlp:Failure") && statusCode2 == null) {
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("FSIDPSingleLogoutHandler:  doSoapProfile returning failure");
                                    }
                                    return new FSLogoutStatus("samlp:Failure");
                                }
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("FSIDPSingleLogoutHandler:  doSoapProfile in unsupported profile");
                                }
                                return this.doHttpRedirect(this.currentProviderId);
                            }
                        }
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Unable to bindLogoutRequest.");
                        FSUtils.debug.message("Current Provider cannot be processed");
                    }
                    break block24;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Unable to create logout request Current Provider cannot be processed");
                }
            }
            catch (Exception exception) {
                FSUtils.debug.error("In IOException of doSOAPProfile : " + exception.getMessage());
            }
        }
        return new FSLogoutStatus("samlp:Failure");
    }

    private FSLogoutNotification createSingleLogoutRequest(FSAccountFedInfo fSAccountFedInfo, String string) {
        FSUtils.debug.message("Entered FSIDPSingleLogoutHandler:: createSingleLogoutRequest");
        FSLogoutNotification fSLogoutNotification = new FSLogoutNotification();
        if (fSLogoutNotification != null) {
            NameIdentifier nameIdentifier = fSAccountFedInfo.getRemoteNameIdentifier();
            if (nameIdentifier == null) {
                nameIdentifier = fSAccountFedInfo.getLocalNameIdentifier();
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Hosted Provider Id : " + this.hostedProviderId);
            }
            fSLogoutNotification.setProviderId(this.hostedProviderId);
            fSLogoutNotification.setNameIdentifier(nameIdentifier);
            FSUtils.debug.message("Session index is " + string);
            if (string != null) {
                fSLogoutNotification.setSessionIndex(string);
            }
            return fSLogoutNotification;
        }
        return null;
    }

    public FSLogoutStatus processSingleLogoutRequest(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, FSLogoutNotification fSLogoutNotification, FSSessionPartner fSSessionPartner, String string, String string2, String string3, boolean bl, String string4, String string5) {
        FSUtils.debug.message("Entered FSIDPSingleLogoutHandler:: processSingleLogoutRequest - HTTP");
        super.processSingleLogoutRequest(httpServletResponse, httpServletRequest, fSLogoutNotification, fSSessionPartner, string, string3, bl, string4, string5);
        if (fSLogoutNotification != null) {
            FSUtils.debug.message("FSLogoutNotification formed really well");
            string2 = fSLogoutNotification.getProviderId();
            FSReturnSessionManager fSReturnSessionManager = FSReturnSessionManager.getInstance(this.hostedProviderId);
            if (fSReturnSessionManager != null) {
                FSUtils.debug.message("Added " + string2 + " top return list");
                fSReturnSessionManager.setUserProviderInfo(string, string2, string5, string4, fSLogoutNotification.getRequestID());
            } else {
                FSUtils.debug.message("Cannot get FSReturnSessionManager");
            }
            if (fSSessionPartner == null) {
                FSUtils.debug.message("currentSessionProvider is null. destroy and return");
                FSLogoutUtil.destroyPrincipalSession(string, this.hostedProviderId);
                this.returnAfterCompletion();
                return new FSLogoutStatus("samlp:Success");
            }
            String string6 = fSSessionPartner.getPartner();
            this.isCurrentProviderIDPRole = fSSessionPartner.getIsRoleIDP();
            this.remoteDescriptor = this.getRemoteDescriptor(string6);
            FSLogoutUtil.cleanSessionMapPartnerList(string, string6, this.hostedProviderId);
            String string7 = this.getProfileToCommunicateLogout(string6);
            FSUtils.debug.message("Communicate with provider " + string6 + " using profile " + string7);
            FSLogoutStatus fSLogoutStatus = new FSLogoutStatus("samlp:Failure");
            if (string7.equals("http://projectliberty.org/profiles/slo-sp-http") || string7.equals("http://projectliberty.org/profiles/slo-idp-http")) {
                FSUtils.debug.message("In redirect profile");
                fSLogoutStatus = this.doHttpRedirect(string6);
            } else if (string7.equals("http://projectliberty.org/profiles/slo-idp-soap") || string7.equals("http://projectliberty.org/profiles/slo-sp-soap")) {
                FSUtils.debug.message("In SOAP profile");
                fSLogoutStatus = this.doIDPSoapProfile(string6);
            } else if (string7.equals("http://projectliberty.org/profiles/slo-idp-http-get") && !this.isCurrentProviderIDPRole) {
                FSUtils.debug.message("In GET profile");
                fSLogoutStatus = this.doHttpGet(string6);
            } else {
                FSUtils.debug.error("Single Logout Profile cannot be processed. Verify profile in metadata");
                FSUtils.error("FSSingleLogoutHandler::handleSingleLogout", FSUtils.bundle.getString("logout-profile-not-supported"));
                this.returnAfterCompletion();
                new FSLogoutStatus("samlp:Failure");
            }
            FSUtils.debug.message("Logout completed first round with status : " + fSLogoutStatus);
            return fSLogoutStatus;
        }
        FSUtils.error("FSSingleLogoutHandler::processSingleLogoutRequest", FSUtils.bundle.getString("logout-request-improper"));
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Request not proper. Cannot proceed with single logout");
        }
        this.returnAfterCompletion();
        return new FSLogoutStatus("samlp:Failure");
    }

    protected FSLogoutStatus processSingleLogoutRequest(FSLogoutNotification fSLogoutNotification, FSSessionPartner fSSessionPartner, String string, String string2, String string3, boolean bl, String string4) {
        FSUtils.debug.message("Entered FSIDPSingleLogoutHandler:: processSingleLogoutRequest - SOAP");
        super.processSingleLogoutRequest(fSLogoutNotification, fSSessionPartner, string, string3, bl, string4);
        if (fSLogoutNotification != null) {
            FSUtils.debug.message("FSLogoutNotification formed really well");
            string2 = fSLogoutNotification.getProviderId();
            if (fSSessionPartner == null) {
                FSUtils.debug.message("currentSessionProvider is null. destroy and return");
                FSLogoutUtil.destroyPrincipalSession(string, this.hostedProviderId);
                return new FSLogoutStatus("samlp:Success");
            }
            if (this.needToUseHttpProfile(string)) {
                return new FSLogoutStatus("lib:Unsupported");
            }
            String string5 = fSSessionPartner.getPartner();
            this.isCurrentProviderIDPRole = fSSessionPartner.getIsRoleIDP();
            this.remoteDescriptor = this.getRemoteDescriptor(string5);
            FSLogoutUtil.cleanSessionMapPartnerList(string, string5, this.hostedProviderId);
            String string6 = this.getProfileToCommunicateLogout(string5);
            FSUtils.debug.message("Communicate with provider " + string5 + " using profile " + string6);
            FSLogoutStatus fSLogoutStatus = new FSLogoutStatus("samlp:Failure");
            if (!string6.equals("http://projectliberty.org/profiles/slo-idp-soap") && !string6.equals("http://projectliberty.org/profiles/slo-sp-soap")) {
                FSUtils.debug.message("Single Logout Profile cannot  be processed. Verify profile in metadata");
                FSUtils.error("FSSingleLogoutHandler::handleSingleLogout", FSUtils.bundle.getString("logout-profile-not-supported"));
                return new FSLogoutStatus("samlp:Failure");
            }
            FSUtils.debug.message("In SOAP profile");
            fSLogoutStatus = this.doIDPSoapProfile(string5);
            FSUtils.debug.message("Logout completed first round with status : " + fSLogoutStatus);
            return fSLogoutStatus;
        }
        FSUtils.error("FSSingleLogoutHandler::processSingleLogoutRequest", FSUtils.bundle.getString("logout-request-improper"));
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Request not proper Cannot proceed federation termination");
        }
        return new FSLogoutStatus("samlp:Failure");
    }

    protected boolean needToUseHttpProfile(String string) {
        block4: {
            FSUtils.debug.message("Entered FSIDPSingleLogoutHandler::needToUseHttpProfile");
            try {
                FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostedProviderId);
                List list = fSSessionManager.getSessionList(string);
                if (list.isEmpty()) break block4;
                Iterator iterator = list.iterator();
                FSSession fSSession = null;
                while (iterator.hasNext()) {
                    fSSession = (FSSession)iterator.next();
                    List list2 = fSSession.getSessionPartners();
                    if (list2.isEmpty()) continue;
                    Iterator iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        FSSessionPartner fSSessionPartner = (FSSessionPartner)iterator2.next();
                        String string2 = this.allianceInst.getProvider(fSSessionPartner.getPartner()).getSLOProtocolProfile();
                        if (!string2.equals("http://projectliberty.org/profiles/slo-sp-http") && !string2.equals("http://projectliberty.org/profiles/slo-idp-http") && !string2.equals("http://projectliberty.org/profiles/slo-idp-http-get")) continue;
                        FSUtils.debug.message("Returning true from needToUseHttpProfile");
                        return true;
                    }
                }
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("needToUseHttpProfile - FSAllianceManagementException" + fSAllianceManagementException.getMessage());
            }
        }
        return false;
    }

    protected SOAPMessage signLogoutRequest(SOAPMessage sOAPMessage, String string, String string2) throws SAMLException, FSMsgException {
        FSUtils.debug.message("Entered FSIDPSingleLogoutHandler::signLogoutRequest");
        String string3 = this.hostedDescriptor.getKeyInfo();
        if (string3 == null || string3.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIDPFedTerminationHandler:: signLogoutRequest: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        FSUtils.debug.message("FSIDPSingleLogoutHandler::signLogoutRequest Provider's certAlias is found: " + string3);
        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
        Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
        String string4 = "//*[local-name()='ProviderID']";
        xMLSignatureManager.signXML(document, string3, SAMLUtils.bundle.getString("xmlsigalgorithm"), string, string2, false, string4);
        return FSServiceUtils.convertDOMToSOAP(document);
    }

    private boolean responseHasFault(SOAPMessage sOAPMessage) {
        try {
            FSUtils.debug.message("Entered responseHasFault");
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            Iterator iterator = sOAPBody.getChildElements();
            while (iterator.hasNext()) {
                Iterator iterator2;
                SOAPElement sOAPElement;
                SOAPBodyElement sOAPBodyElement = (SOAPBodyElement)iterator.next();
                if (!sOAPBodyElement.getElementName().getLocalName().equalsIgnoreCase("fault") || !(sOAPElement = (SOAPElement)(iterator2 = sOAPBodyElement.getChildElements()).next()).getElementName().getLocalName().equalsIgnoreCase("faultcode") || !sOAPElement.getValue().equalsIgnoreCase("server")) continue;
                Iterator iterator3 = sOAPBodyElement.getChildElements();
                SOAPElement sOAPElement2 = (SOAPElement)iterator2.next();
                if (!sOAPElement2.getElementName().getLocalName().equalsIgnoreCase("faultstring") || !sOAPElement2.getValue().equalsIgnoreCase("Cannot Execute Single LogOut using web service")) continue;
                FSUtils.debug.message("Found proper SOAP fault");
                return true;
            }
            return false;
        }
        catch (SOAPException sOAPException) {
            FSUtils.debug.error("In SOAPException of responseHasFault : " + sOAPException.getMessage());
            return false;
        }
    }

    protected boolean verifyResponseSignature(SOAPMessage sOAPMessage) {
        FSUtils.debug.message("Entered FSLogoutResponse::verifyResponseSignature");
        try {
            String string = this.remoteDescriptor.getKeyInfo();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Logout.verifyResponseSignaturecouldn't obtain this site's cert alias.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
            }
            FSUtils.debug.message("FSLogoutResponse.verifyResponseSignature: Provider's certAlias is found: " + string);
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
            return xMLSignatureManager.verifyXMLSignature(document, string);
        }
        catch (SAMLException sAMLException) {
            FSUtils.debug.error("Error in verifying response " + sAMLException.getMessage());
            return false;
        }
    }

    private int getMinorVersion(String string) {
        try {
            FSProviderDescriptor fSProviderDescriptor = FSServiceUtils.getAllianceInstance().getProvider(string);
            return fSProviderDescriptor.getMinorVersion();
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSIDPSingleLogoutHandler.getMinorVersion:Error in getting in minor ver for providerID:" + string, (Throwable)exception);
            return 0;
        }
    }
}

